/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.networkdiagnose.model.resource.ping;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import com.yy.hiyo.module.networkdiagnose.model.resource.ping.PingBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class Ping {
    private int time;
    private int size;
    private String url;
    private PingBean pingBean;

    public Ping(String url) {
        this(20, 10, url);
    }

    public Ping(int size, String url) {
        this(20, size, url);
    }

    public Ping(int time, int size, String url) {
        this.time = time;
        this.size = size;
        this.url = url;
        this.pingBean = new PingBean();
        this.pingBean.setAddress(url);
    }

    public PingBean getPingInfo() {
        return this.getIPFromUrl();
    }

    private PingBean getIPFromUrl() {
        String domain = this.getDomain(this.url);
        if (TextUtils.isEmpty((CharSequence)domain)) {
            this.pingBean.setError(-1);
            return this.pingBean;
        }
        String pingString = this.ping(this.createSimplePingCommand(this.size, this.time, domain));
        if (null != pingString) {
            try {
                this.pingBean.setError(200);
                this.pingBean.setIp(this.parseIpFromPing(pingString));
                this.parseLossFromPing(pingString, this.pingBean);
                this.parseDelayFromPing(pingString, this.pingBean);
                this.parseTtlFromPing(pingString, this.pingBean);
            }
            catch (Exception e) {
                this.pingBean.setError(-1);
                e.printStackTrace();
            }
        }
        return this.pingBean;
    }

    private String parseIpFromPing(String paramString) {
        try {
            boolean bool = paramString.contains("ping");
            String localObject = null;
            if (bool) {
                int i = paramString.indexOf("(");
                int j = paramString.indexOf(")");
                localObject = paramString.substring(i + 1, j);
            }
            return localObject;
        }
        catch (Exception localException) {
            localException.printStackTrace();
            return null;
        }
    }

    private void parseDelayFromPing(String paramString, PingBean pingBean) {
        try {
            if (paramString.contains("rtt")) {
                String str = paramString.substring(paramString.indexOf("rtt"));
                String[] arrayOfString = str.substring(2 + str.indexOf("=")).split("/");
                pingBean.setRttMin(Float.parseFloat(arrayOfString[0]));
                pingBean.setRttAvg(Float.parseFloat(arrayOfString[1]));
                pingBean.setRttMax(Float.parseFloat(arrayOfString[2]));
                pingBean.setRttMDev(Float.parseFloat(arrayOfString[3].substring(0, arrayOfString[3].indexOf(" ms"))));
            }
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
    }

    private void parseTtlFromPing(String paramString, PingBean pingBean) {
        try {
            if (paramString.contains("ttl")) {
                String str1 = paramString.substring(paramString.indexOf("ttl"), paramString.indexOf("\n", paramString.indexOf("ttl")));
                pingBean.setTtl(Integer.parseInt(str1.substring(4, str1.indexOf(" "))));
            }
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
    }

    private void parseLossFromPing(String paramString, PingBean pingBean) {
        try {
            if (paramString.contains("statistics")) {
                String[] arrayOfString;
                String str1 = paramString.substring(1 + paramString.indexOf("\n", paramString.indexOf("statistics")));
                for (String str : arrayOfString = str1.substring(0, str1.indexOf("\n")).split(", ")) {
                    if (str.contains(" packets transmitted")) {
                        pingBean.setTransmitted(Integer.parseInt(str.substring(0, str.indexOf(" packets transmitted"))));
                    }
                    if (str.contains(" received")) {
                        pingBean.setReceive(Integer.parseInt(str.substring(0, str.indexOf(" received"))));
                    }
                    if (str.contains(" errors")) {
                        pingBean.setError(Integer.parseInt(str.substring(0, str.indexOf(" errors"))));
                    }
                    if (str.contains(" packet loss")) {
                        pingBean.setLossRate(Float.parseFloat(str.substring(0, str.indexOf("%"))));
                    }
                    if (!str.contains("time")) continue;
                    pingBean.setAllTime(Integer.parseInt(str.substring(str.lastIndexOf("e") + 2, str.indexOf("ms"))));
                }
            }
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
    }

    private String getDomain(String url) {
        try {
            URL urlStr = new URL(url);
            return urlStr.getHost();
        }
        catch (Exception e) {
            e.printStackTrace();
            return url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String ping(String command) {
        Process process = null;
        try {
            String line;
            process = Runtime.getRuntime().exec(command);
            InputStream is = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            while (null != (line = reader.readLine())) {
                sb.append(line);
                sb.append("\n");
            }
            reader.close();
            is.close();
            String string2 = sb.toString();
            return string2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != process) {
                process.destroy();
            }
        }
        return null;
    }

    @SuppressLint(value={"DefaultLocale"})
    private String createSimplePingCommand(int count, int timeout, String domain) {
        Object[] arrayOfObject = new Object[]{count, timeout, domain};
        return String.format("/system/bin/ping -c %d -w %d  %s", arrayOfObject);
    }
}

