/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.handlefileIntent.common;

import android.text.TextUtils;
import androidx.annotation.NonNull;

public class ContactsUtils {
    private static int sBegin = 45217;
    private static int sEnd = 63486;
    private static final char[] CHAR_TABLE = new char[]{'\u554a', '\u82ad', '\u64e6', '\u642d', '\u86fe', '\u53d1', '\u5676', '\u54c8', '\u51fb', '\u5580', '\u5783', '\u5988', '\u62ff', '\u54e6', '\u556a', '\u671f', '\u7136', '\u6492', '\u584c', '\u6316', '\u6614', '\u538b', '\u531d'};
    private static char[] INITIAL_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'W', 'X', 'Y', 'Z'};
    private static final int[] BORDER = new int[CHAR_TABLE.length + 1];

    @NonNull
    public static String getAbbreviation(String string2) {
        return ContactsUtils.getAbbreviation(string2, '#');
    }

    @NonNull
    public static String getAbbreviation(String string2, char defaultAbbreviation) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "" + defaultAbbreviation;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string2.length(); ++i) {
            sb.append(ContactsUtils.char2Initial(string2.charAt(i), defaultAbbreviation));
        }
        return sb.toString();
    }

    private static char char2Initial(char ch, char defaultAbbreviation) {
        if (ch >= 'a' && ch <= 'z') {
            return (char)(ch - 97 + 65);
        }
        if (ch >= 'A' && ch <= 'Z') {
            return ch;
        }
        int gb = ContactsUtils.gbValue(ch);
        if (gb < sBegin || gb > sEnd) {
            return defaultAbbreviation;
        }
        return INITIAL_TABLE[ContactsUtils.findIndexOf(gb, BORDER)];
    }

    private static int gbValue(char ch) {
        String str = "" + ch;
        try {
            byte[] bytes = str.getBytes("GB2312");
            if (bytes.length < 2) {
                return 0;
            }
            return (bytes[0] << 8 & 0xFF00) + (bytes[1] & 0xFF);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int findIndexOf(int value, int[] list) {
        return ContactsUtils.findIndexOf(value, list, 0, list.length - 1);
    }

    private static int findIndexOf(int value, int[] list, int start, int end) {
        int cursor = (start + end) / 2;
        if (cursor == start || list[cursor] == value) {
            return cursor;
        }
        if (list[cursor] > value) {
            end = cursor;
        } else {
            start = cursor;
        }
        return ContactsUtils.findIndexOf(value, list, start, end);
    }

    static {
        for (int i = 0; i < CHAR_TABLE.length; ++i) {
            ContactsUtils.BORDER[i] = ContactsUtils.gbValue(CHAR_TABLE[i]);
        }
        ContactsUtils.BORDER[ContactsUtils.CHAR_TABLE.length] = sEnd;
    }
}

