/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.handlefileIntent;

import com.yy.base.utils.StringUtils;
import com.yy.hiyo.module.handlefileIntent.common.Abbreviated;
import com.yy.hiyo.module.handlefileIntent.common.ContactsUtils;

public class ShareContactsBean
implements Abbreviated,
Comparable<ShareContactsBean> {
    private final String mName;
    private final String mImageUrl;
    private String mAbbreviation;
    private String mInitial;
    public final long mUid;

    ShareContactsBean(String name, String imageUrl, long uid, String abbreviation) {
        this.mName = name;
        this.mImageUrl = imageUrl;
        this.mUid = uid;
        if (StringUtils.isEmpty((String)abbreviation)) {
            this.mAbbreviation = ContactsUtils.getAbbreviation(name);
            this.mInitial = this.mAbbreviation.substring(0, 1);
        } else {
            this.mInitial = this.mAbbreviation = abbreviation;
        }
    }

    @Override
    public String getInitial() {
        return this.mInitial;
    }

    public String getName() {
        return this.mName;
    }

    public String getImageUrl() {
        return this.mImageUrl;
    }

    @Override
    public int compareTo(ShareContactsBean r) {
        if (this.mAbbreviation.equals(r.mAbbreviation)) {
            return 0;
        }
        boolean flag = this.mAbbreviation.startsWith("#");
        if (flag ^ r.mAbbreviation.startsWith("#")) {
            return flag ? 1 : -1;
        }
        return this.getInitial().compareTo(r.getInitial());
    }
}

