/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.hagoactivity;

import android.os.Message;
import android.text.TextUtils;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.hiyo.game.GameBaseMsgDef;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;
import com.yy.hiyo.module.hagoactivity.ActivityUtils;
import com.yy.webservice.event.parqam.BaseJsParam;

public class WebActController
extends DefaultController {
    GameLifeWrapper mGameLifeWrapper = new GameLifeWrapper(){

        public void onPreloadGame(GamePlayContext context) {
            super.onPreloadGame(context);
            GameModel gameModel = context.buildGameModel();
            WebActController.this.sendStartGame(gameModel);
            WebActController.this.notifyStartGame(gameModel);
        }

        public void onGameExited(GamePlayContext context, int gameExitType) {
            super.onGameExited(context, gameExitType);
            GameModel gameModel = context.buildGameModel();
            WebActController.this.sendGameOver(gameModel);
            WebActController.this.notifyGameDestroy(gameModel);
        }
    };
    IMatchGameLifecycle iMatchGameLifecycle = new IMatchGameLifecycle(){

        public void prepareGameMatch(GameInfo ginfo, GameMatchContext matchConfig) {
        }

        public void onGameMatchStart(GameInfo info, GameMatchContext matchConfig) {
        }

        public void onMatchFinish(GameInfo gameInfo, GameMatchContext matchContext, int matchType) {
            if (matchType == 2) {
                WebActController.this.notifyCancelMatch(matchContext.update2GameModel(gameInfo));
            }
        }
    };

    public WebActController(Environment baseEnv) {
        super(baseEnv);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle((IGameLifecycle)this.mGameLifeWrapper);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameMatchEvent(this.iMatchGameLifecycle);
    }

    public Object handleMessageSync(Message msg) {
        if (msg == null) {
            return null;
        }
        if (msg.arg1 == GameBaseMsgDef.CallOutSide.IS_ACTIVITY_SYNC) {
            return ActivityUtils.isActivity((GameModel)msg.obj);
        }
        if (msg.arg1 == GameBaseMsgDef.CallOutSide.GET_ACTIVITY_ID_SYNC) {
            return ActivityUtils.getActivityId((GameModel)msg.obj);
        }
        return null;
    }

    public void notify(Notification notification) {
        super.notify(notification);
    }

    private void notifyStartGame(GameModel gameModel) {
        if (ActivityUtils.isActivity(gameModel)) {
            ((IWebService)this.getServiceManager().getService(IWebService.class)).loadPureJs("callWebviewMethod('onStartGame')");
        }
    }

    private void sendStartGame(GameModel gameModel) {
        GameInfo gameInfo;
        if (ActivityUtils.isActivity(gameModel) && (gameInfo = gameModel.getGameInfo()) != null) {
            BaseJsParam cbParam = BaseJsParam.builder().put("gameId", (Object)gameInfo.getGid()).build();
            ((IWebService)this.getServiceManager().getService(IWebService.class)).loadNotifyJs("", JsEventDefine.NOTIFY.startLoadGame, cbParam.toJson());
        }
    }

    private void notifyCancelMatch(GameModel gameModel) {
        if (ActivityUtils.isActivity(gameModel)) {
            ((IWebService)this.getServiceManager().getService(IWebService.class)).loadPureJs("callWebviewMethod('onCancelMatch')");
            GameInfo gameInfo = gameModel.getGameInfo();
            if (gameInfo != null) {
                BaseJsParam.DataBuilder data = BaseJsParam.builder().put("gameId", (Object)gameInfo.getGid());
                ((IWebService)this.getServiceManager().getService(IWebService.class)).loadNotifyJs("", JsEventDefine.NOTIFY.onCancelMatchGame, data.jsonData());
            }
        }
    }

    private void notifyGameDestroy(GameModel gameModel) {
        if (ActivityUtils.isActivity(gameModel)) {
            boolean isForceClose = false;
            if (TextUtils.isEmpty((CharSequence)gameModel.getGameResult())) {
                isForceClose = true;
            }
            String notify = StringUtils.formatWitUSLocal((String)"callWebviewMethod('showOutcomePage', '%s', '%b')", (Object[])new Object[]{gameModel.getRoomid(), isForceClose});
            ((IWebService)this.getServiceManager().getService(IWebService.class)).loadPureJs(notify);
        }
    }

    private void sendGameOver(GameModel gameModel) {
        if (ActivityUtils.isActivity(gameModel)) {
            String roomId = "";
            String result = "";
            String gameId = "";
            roomId = gameModel.getRoomid();
            result = gameModel.getGameResult();
            if (gameModel.getGameInfo() != null) {
                gameId = gameModel.getGameInfo().getGid();
            }
            BaseJsParam cbParam = BaseJsParam.builder().put("gameId", (Object)gameId).put("roomId", (Object)roomId).put("result", (Object)result).build();
            ((IWebService)this.getServiceManager().getService(IWebService.class)).loadNotifyJs("", JsEventDefine.NOTIFY.gameFinished, cbParam.toJson());
        }
    }
}

