/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.floatwindow;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Message;
import android.os.PowerManager;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.push.NotificationManager;
import com.yy.appbase.push.PushNotificationData;
import com.yy.appbase.push.ScreenBroadcastReceiver;
import com.yy.appbase.push.ScreenStateListener;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.hiyo.im.base.MsgData;

public class FloatWindowController
extends DefaultController {
    private static final String TAG = "FloatWindowController";
    private ScreenBroadcastReceiver mScreenReceiver;
    private MsgData msgData;
    private String type;

    public FloatWindowController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == BaseMsgDef.ADD_FLOAT_WINDOW && msg.obj instanceof MsgData) {
            this.msgData = (MsgData)msg.obj;
            if (msg.getData() != null) {
                this.type = msg.getData().getString("type");
            }
            if (this.isScreenOn(this.mContext)) {
                this.addFloatWindow();
            } else {
                this.registerScreenBroadcastReceiver();
            }
        }
        if (msg.what == BaseMsgDef.REMOVE_FLOAT_WINDOW) {
            this.msgData = null;
        }
    }

    private void addFloatWindow() {
        if (this.msgData == null) {
            MLog.info((Object)TAG, (String)"error! MsgItem is null", (Object[])new Object[0]);
            return;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager.Instance.showNotification(this.mContext, new PushNotificationData(this.msgData.getPushid(), "256", this.type, this.msgData.getPushPayload()).withUid(this.msgData.getFromUid()).with(this.msgData.getPushContent(), this.msgData.getPushTitle(), this.msgData.getAvatar()).with(true, false));
        }
    }

    private boolean isScreenOn(Context context) {
        PowerManager pm = (PowerManager)context.getSystemService("power");
        return pm.isScreenOn();
    }

    private void unRegisterScreenBroadcastReceiver() {
        MLog.info((Object)TAG, (String)"unRegisterScreenBroadcastReceiver", (Object[])new Object[0]);
        if (this.mContext != null && this.mScreenReceiver != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mScreenReceiver);
        }
    }

    private void registerScreenBroadcastReceiver() {
        MLog.info((Object)TAG, (String)"registerScreenBroadcastReceiver", (Object[])new Object[0]);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.USER_PRESENT");
        this.mContext.registerReceiver((BroadcastReceiver)this.getScreenReceiver(), filter);
    }

    private ScreenBroadcastReceiver getScreenReceiver() {
        if (this.mScreenReceiver == null) {
            this.mScreenReceiver = new ScreenBroadcastReceiver(new ScreenStateListener(){

                public void screenOnCallBack(Context context) {
                }

                public void screenOffCallBack(Context context) {
                }

                public void screenPresentCallBack(Context context) {
                    FloatWindowController.this.unRegisterScreenBroadcastReceiver();
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            FloatWindowController.this.addFloatWindow();
                        }
                    }, (long)2000L);
                }
            });
        }
        return this.mScreenReceiver;
    }
}

