/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.download;

import android.content.Context;
import com.yy.appbase.dowload.DownloadBussinessGroup;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadUtil;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DownloadStatsHelper {
    private static final String TAG = "DownloadStatsHelper";
    private static String CONTENT_ACT_DYNAMIC_LOAD_DOWNLOAD = "hagodownload";
    private static final String METRIC_URI_DOWNLOAD = "hydl_";
    private static final String METRIC_URI_PATCH = "hydl_patch/";
    private static boolean sStatSwitch = true;

    public static void setCollectDownloadStatSwitch(boolean statSwitch) {
        sStatSwitch = statSwitch;
    }

    static void addDownloadSuccessStats(Context context, DownloadTask task, long uid, boolean remoteProcess) {
        String url;
        if (task == null) {
            return;
        }
        if (!sStatSwitch) {
            return;
        }
        HashMap<String, String> keyAndValues = new HashMap<String, String>(12);
        keyAndValues.put("res", "1");
        keyAndValues.put("net", String.valueOf(NetworkUtils.getNetworkType((Context)context)));
        keyAndValues.put("retry", String.valueOf(task.getInt("crtimes")));
        keyAndValues.put("excex", "0");
        long useTime = System.currentTimeMillis() - task.getLong("ctime");
        keyAndValues.put("tust", String.valueOf((int)useTime));
        if (task.getInt("crtimes") > 0) {
            ArrayList errorInfoList = null;
            Object tempErrorInfoObject = task.getProcessLocalInfo().get("errorinfo");
            if (tempErrorInfoObject instanceof ArrayList) {
                errorInfoList = (ArrayList)tempErrorInfoObject;
                StringBuilder relativeInfo = new StringBuilder();
                HashMap tempErrorInfo = null;
                for (int i = 0; i < errorInfoList.size(); ++i) {
                    tempErrorInfo = (HashMap)errorInfoList.get(i);
                    if (tempErrorInfo == null || !StringUtils.equal((String)"1", (String)((String)tempErrorInfo.get("netc")))) continue;
                    relativeInfo.append(tempErrorInfo.toString());
                }
                if (relativeInfo.length() > 0) {
                    keyAndValues.put("relativeinfo", relativeInfo.toString());
                }
            }
        }
        String netUseTime = task.getExtendString("netusetime");
        String contentLength = task.getExtendString("contentlength");
        long netUseTimeL = StringUtils.parseLong((String)netUseTime, (long)0L);
        int taskGroup = task.getInt("dgroup");
        keyAndValues.put("contentlength", contentLength);
        keyAndValues.put("uid", String.valueOf(uid));
        keyAndValues.put("dgroup", String.valueOf(taskGroup));
        if (StringUtils.isNotEmpty((String)netUseTime)) {
            keyAndValues.put("useuptime", netUseTime);
        }
        keyAndValues.put("subgroup", task.getExtendString("subgroup"));
        keyAndValues.put("remote", remoteProcess ? "1" : "0");
        keyAndValues.put("hynet", String.valueOf(NetworkUtils.getNetworkType((Context)RuntimeContext.sApplicationContext)));
        File taskFile = DownloadUtil.getTaskFile((DownloadTask)task);
        if (taskFile != null && taskFile.exists()) {
            keyAndValues.put("filesize", String.valueOf(taskFile.length()));
        }
        String name = StringUtils.isNotEmpty((String)(url = task.getString("url"))) && url.endsWith(".patch") ? DownloadStatsHelper.proPatchUrlForPath(url, task) : task.getString("filename");
        keyAndValues.put("name", name);
        keyAndValues.put("downloadtype", task.getExtendString("download_type"));
        keyAndValues.put("url", task.getExtendString("real_host"));
        keyAndValues.put("netlib", task.getExtendString("network_type"));
        keyAndValues.put("netc", "1");
        DownloadStatsHelper.addStats(keyAndValues);
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)TAG, (String)("addDownloadSuccessStats :" + ((Object)keyAndValues).toString()), (Object[])new Object[0]);
        }
        if (SettingFlagBaseKeys.isNormalMetricSwitchOn()) {
            if (url != null && url.endsWith(".patch")) {
                HiidoStatis.reportAppMonitorReturnCode((String)METRIC_URI_PATCH, (long)netUseTimeL, (String)"0");
            } else {
                String uri = METRIC_URI_DOWNLOAD + DownloadBussinessGroup.getGroupDesc((int)taskGroup);
                HiidoStatis.reportAppMonitorReturnCode((String)uri, (long)netUseTimeL, (String)"0");
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)TAG, (String)("sucess uri = " + uri), (Object[])new Object[0]);
                }
            }
        }
    }

    public static void addDownloadErrorStats(Context context, DownloadTask task, long uid, boolean remoteProcess) {
        String url;
        File taskFile;
        if (task == null) {
            return;
        }
        if (!sStatSwitch) {
            return;
        }
        HashMap<String, String> keyAndValues = new HashMap<String, String>();
        keyAndValues.put("res", "0");
        keyAndValues.put("retry", String.valueOf(task.getInt("crtimes")));
        keyAndValues.put("excex", "0");
        long useTime = System.currentTimeMillis() - task.getLong("ctime");
        keyAndValues.put("tust", String.valueOf(useTime));
        ArrayList errorInfoList = null;
        Object tempErrorInfoObject = task.getProcessLocalInfo().get("errorinfo");
        if (tempErrorInfoObject instanceof ArrayList) {
            errorInfoList = (ArrayList)tempErrorInfoObject;
        }
        if (errorInfoList != null && errorInfoList.size() > 0) {
            HashMap lastErrorInfo = (HashMap)errorInfoList.get(errorInfoList.size() - 1);
            if (lastErrorInfo != null) {
                keyAndValues.putAll(lastErrorInfo);
            }
            StringBuilder relativeInfo = new StringBuilder();
            HashMap tempErrorInfo = null;
            for (int i = 0; i < errorInfoList.size() - 1; ++i) {
                tempErrorInfo = (HashMap)errorInfoList.get(i);
                if (tempErrorInfo == null) continue;
                relativeInfo.append(tempErrorInfo.toString());
            }
            keyAndValues.put("relativeinfo", relativeInfo.toString());
        }
        keyAndValues.put("uid", String.valueOf(uid));
        int taskGroup = task.getInt("dgroup");
        keyAndValues.put("dgroup", String.valueOf(taskGroup));
        keyAndValues.put("subgroup", task.getExtendString("subgroup"));
        keyAndValues.put("remote", remoteProcess ? "1" : "0");
        keyAndValues.put("hynet", String.valueOf(NetworkUtils.getNetworkType((Context)RuntimeContext.sApplicationContext)));
        if (!keyAndValues.containsKey("filesize") && (taskFile = DownloadUtil.getTaskFile((DownloadTask)task)) != null && taskFile.exists()) {
            keyAndValues.put("filesize", String.valueOf(taskFile.length()));
        }
        String name = StringUtils.isNotEmpty((String)(url = task.getString("url"))) && url.endsWith(".patch") ? DownloadStatsHelper.proPatchUrlForPath(url, task) : task.getString("filename");
        keyAndValues.put("name", name);
        keyAndValues.put("httpcode", String.valueOf(task.getInt("httpcode", 55)));
        keyAndValues.put("errno", String.valueOf(task.getInt("errno", 111)));
        keyAndValues.put("downloadtype", task.getExtendString("download_type"));
        keyAndValues.put("url", task.getExtendString("real_host"));
        keyAndValues.put("netlib", task.getExtendString("network_type"));
        keyAndValues.put("netc", NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) ? "1" : "0");
        DownloadStatsHelper.addStats(keyAndValues);
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)TAG, (String)("addDownloadErrorStats :" + ((Object)keyAndValues).toString()), (Object[])new Object[0]);
        }
        if (SettingFlagBaseKeys.isNormalMetricSwitchOn()) {
            if (url != null && url.endsWith(".patch")) {
                HiidoStatis.reportAppMonitorReturnCode((String)METRIC_URI_PATCH, (long)useTime, (String)String.valueOf(task.getInt("errno", 111)));
            } else {
                String uri = METRIC_URI_DOWNLOAD + DownloadBussinessGroup.getGroupDesc((int)taskGroup);
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)TAG, (String)("error uri = " + uri), (Object[])new Object[0]);
                }
                HiidoStatis.reportAppMonitorReturnCode((String)uri, (long)useTime, (String)String.valueOf(task.getInt("errno", 111)));
            }
        }
    }

    private static String proPatchUrlForPath(String url, DownloadTask task) {
        String path = "";
        try {
            URI uri = new URI(url);
            path = uri.getPath();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        path = StringUtils.isNotEmpty((String)path) ? path : task.getString("filename");
        return path;
    }

    private static void addStats(Map<String, String> keyAndValues) {
        if (keyAndValues == null || keyAndValues.isEmpty()) {
            return;
        }
        StatisContent statContent = new StatisContent();
        for (Map.Entry<String, String> entry : keyAndValues.entrySet()) {
            statContent.put(entry.getKey(), entry.getValue());
        }
        statContent.put("act", CONTENT_ACT_DYNAMIC_LOAD_DOWNLOAD);
        try {
            HiidoStatis.reportContent((StatisContent)statContent);
        }
        catch (Throwable ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
    }
}

