/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.download;

import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.module.download.DownloadStatsHelper;
import com.yy.mobile.backgroundprocess.services.downloadcenter.base.DownloadTask;
import downloader.DownloadClient;
import downloader.client.IBasicParamsProvider;

public class DownloadCenterHelper
implements IBasicParamsProvider,
INotify {
    public static final String TAG_AD_SWITCH = "1";
    public static final String TAG_AD_SWITCH_KEY = "DynamicLoadDataCollecter";
    private boolean mDataCollecterSwitchOn = true;
    private long mUid = -1L;

    public DownloadCenterHelper() {
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_SUCCESS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
    }

    public boolean isDataCollecterSwitchOn() {
        return this.mDataCollecterSwitchOn;
    }

    public long getUid() {
        if (this.mUid == -1L) {
            return AccountUtil.getUid();
        }
        return this.mUid;
    }

    public boolean isDevVer() {
        return RuntimeContext.sIsDebuggable;
    }

    public void onErrorStat(final DownloadTask task, final long uid, final boolean remoteProcess) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                DownloadStatsHelper.addDownloadErrorStats(RuntimeContext.sApplicationContext, task, uid, remoteProcess);
            }
        });
    }

    public void onSucessStat(final DownloadTask task, final long uid, final boolean remoteProcess) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                DownloadStatsHelper.addDownloadSuccessStats(RuntimeContext.sApplicationContext, task, uid, remoteProcess);
            }
        });
    }

    public void onLoginSucceed(long userId) {
        if (this.mUid == userId) {
            return;
        }
        this.mUid = userId;
        this.updateUid();
    }

    public void onLogout() {
        if (this.mUid == 0L) {
            return;
        }
        this.mUid = 0L;
        this.updateUid();
    }

    private void updateUid() {
        DownloadClient.instance().updateUid(this.mUid);
    }

    private void updateCollectDataSwitch(boolean switchOn) {
        DownloadClient.instance().updateCollectDataSwitch(switchOn);
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_LOGIN_SUCCESS) {
            this.onLoginSucceed(AccountUtil.getUid());
        } else if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            this.onLogout();
        }
    }
}

