/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.applicationroute.stat;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.memory.MemoryUtil;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiyo.applicationroute.SignatureCheck;
import com.yy.hiyo.main.R;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class AppProcessStat {
    private static final String TAG = "AppProce";
    private static final String TEMP = "a1b32qwr";
    private static final String APP_PROCESS_STAT_EVENT_ID = "20035569";
    private static final String FUNCTION_ID_WAKE = "app_waked";
    private static final String FUNCTION_ID_ALIVE = "app_alive";
    public static final String WAKE_SOURCE_WHATSAPP = "whatsapp";
    private static final String APP_ENCRYPT_EVENT_ID = "20040169";
    private static final String APP_ENCRYPT_FUNCTION_ID = "app_encrypt";
    private static boolean sOfficialPackage = false;

    public static void statAppProcessWakeSource(String wakeSource) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId(APP_PROCESS_STAT_EVENT_ID).put("function_id", FUNCTION_ID_WAKE).put("channel", wakeSource));
    }

    public static void statAppProcessAlive() {
        AppProcessStat.statAppProcessAlive(false);
    }

    public static void statAppProcessAlive(boolean startProcFirstStat) {
        YYTaskExecutor.execute(() -> AppProcessStat.statAppProcessAliveDetail(startProcFirstStat));
    }

    private static void statAppProcessAliveDetail(boolean startProcFirstStat) {
        HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId(APP_PROCESS_STAT_EVENT_ID).put("function_id", FUNCTION_ID_ALIVE).put("nation", AppProcessStat.countryCode()).put("sysmem", MemoryUtil.availMemory() + "").put("phone_type", RuntimeContext.sPhoneType + "").put("start_app", startProcFirstStat ? "1" : "0").put("foreground", RuntimeContext.sIsForeground ? "1" : "0").put("abi_ver", HardwareUtils.getCpuArch()).put("apk_api_ver", "abi32");
        if (startProcFirstStat) {
            sOfficialPackage = AppProcessStat.checkSign();
            hiidoEvent.put("pn", RuntimeContext.sApplicationContext.getPackageName()).put("is_official", sOfficialPackage ? "1" : "0");
            if (!sOfficialPackage) {
                HiidoStatis.reportEvent((HiidoEvent)AppProcessStat.statSec("599", "resigned"));
            }
        }
        HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
    }

    private static String countryCode() {
        String code = AccountUtil.realCountry();
        if (TextUtils.isEmpty((CharSequence)code)) {
            code = SystemUtils.getHagoCountry();
        }
        if (code == null) {
            return "";
        }
        return code.toUpperCase();
    }

    private static boolean checkSign() {
        String defaultString = RuntimeContext.sApplicationContext.getString(RuntimeContext.isLocalBuild() ? R.string.default_string_d : R.string.default_string);
        String sign = AppProcessStat.getOriginSign();
        sign = MD5Utils.getMD5String((String)sign);
        sOfficialPackage = StringUtils.equalsIgnoreCase((String)sign, (String)defaultString);
        return sOfficialPackage;
    }

    private static String getOriginSign() {
        String sign = "";
        try {
            List<String> stringList = SignatureCheck.getSignaturesFromApk(new File(RuntimeContext.sApplicationContext.getPackageResourcePath()));
            if (stringList != null && stringList.size() > 0) {
                sign = stringList.get(0);
                sign = sign + TEMP;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sign;
    }

    public static void statSecException(int errCode, String errMsg) {
        Log.i((String)TAG, (String)("sec start context = " + RuntimeContext.sApplicationContext));
        SettingFlags.init((Context)RuntimeContext.sApplicationContext);
        YYTaskExecutor.execute(() -> HiidoStatis.reportEvent((HiidoEvent)AppProcessStat.statSec(errCode + "", errMsg)), (long)11000L);
        Log.i((String)TAG, (String)"sec end");
    }

    private static HiidoEvent statSec(String errCode, String errMsg) {
        return HiidoEvent.obtain().eventId(APP_ENCRYPT_EVENT_ID).put("function_id", APP_ENCRYPT_FUNCTION_ID).put("pn", RuntimeContext.sApplicationContext.getPackageName()).put("nation", AppProcessStat.countryCode()).put("err_code", errCode).put("err_msg", errMsg).put("other_hdid", HiidoSDK.instance().getHdid(RuntimeContext.sApplicationContext));
    }
}

