/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.startup;

import androidx.annotation.Keep;
import com.yy.appbase.image.ImageLoadHelper;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Environment;
import com.yy.hiyo.app.ServiceManager;
import com.yy.hiyo.home.base.perforstat.StartupStatHelper;
import com.yy.hiyo.home.base.startup.StartUpBridgeHelper;
import com.yy.hiyo.module.unifyconfig.UnifyConfigController;

public class StepInitBaseEnv {
    private static final String TAG = "StepInitBaseEnv";
    @Keep
    private static UnifyConfigController sUnifyConfigController;
    Environment baseEnv;

    public StepInitBaseEnv(Environment baseEnv) {
        this.baseEnv = baseEnv;
    }

    private static synchronized void initBaseEnv(Environment baseEnv) {
        if (sUnifyConfigController != null) {
            return;
        }
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)"initBaseEnv start", (Object[])new Object[0]);
        }
        sUnifyConfigController = new UnifyConfigController(baseEnv);
        StepInitBaseEnv.initKvoModule(baseEnv);
        ServiceManager.getInstance().registerServices();
        StartupStatHelper.onEnvInited();
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)"initBaseEnv end", (Object[])new Object[0]);
        }
        ImageLoadHelper.beginImageLoadHiidoMonitor();
    }

    public void init() {
        StepInitBaseEnv.initBaseEnv(this.baseEnv);
    }

    private static void initKvoModule(Environment baseEnv) {
        MLog.info((Object)TAG, (String)"init kvo module", (Object[])new Object[0]);
        StartUpBridgeHelper.INSTANCE.getStartUpBridge().onBeforeInitKvoModule();
        KvoModuleManager.init((IServiceManager)ServiceManager.getInstance(), (Environment)baseEnv);
        MLog.info((Object)TAG, (String)"init kvo module finish", (Object[])new Object[0]);
    }
}

