/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.SystemClock;
import android.util.AndroidRuntimeException;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.yy.appbase.DiskCacheChecker;
import com.yy.appbase.abtest.IUserAbTestService;
import com.yy.appbase.abtest.UserAbTestController;
import com.yy.appbase.common.Callback;
import com.yy.appbase.config.BossConfigService;
import com.yy.appbase.core.IAabFakeService;
import com.yy.appbase.db.DataBox;
import com.yy.appbase.service.IBaseEnvService;
import com.yy.appbase.service.IBossConfigService;
import com.yy.appbase.service.IControllerRegistryService;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IHomePlanService;
import com.yy.appbase.service.IService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ISocialMediaService;
import com.yy.appbase.service.IUserAgeLevelService;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.LiveEnv;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.app.IAppService;
import com.yy.appbase.unifyconfig.config.MemRecycleAndCrashOptConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.framework.core.AbstractController;
import com.yy.framework.core.Environment;
import com.yy.framework.core.IControllerCreator;
import com.yy.framework.core.IControllerRegister;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.app.ServiceNotifyCenter;
import com.yy.hiyo.app.serverwrapper.env.EnvService;
import com.yy.hiyo.app.web.WebServiceImpl;
import com.yy.hiyo.app.wrapper.AppServiceImpl;
import com.yy.hiyo.game.audio.PKGameAudioManager;
import com.yy.hiyo.game.service.IGameAudioService;
import com.yy.hiyo.home.base.startup.StartUpBridgeHelper;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.hiyo.module.homeplan.HomePlanService;
import com.yy.hiyo.module.homeplan.UserAgeLevelService;
import com.yy.hiyo.module.socialmedia.SocialMediaService;
import com.yy.hiyo.module.yyuri.IYYUriServiceImpl;
import com.yy.hiyo.wallet.base.IPrivilegeService;
import com.yy.hiyo.wallet.base.privilege.PrivilegeService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceManager
implements IServiceManager,
INotify {
    public static final String TAG = "ServiceManager";
    public static final String DB_TIPS = "\u542f\u52a8\u672a\u5b8c\u6210\u8bf7\u4e0d\u8981\u4f7f\u7528getDbService";
    public static final String EXCEPTION_GETDB = "getDbService";
    private static volatile IDBService sDBservice;
    private LiveEnv mBaseEnv;
    private static IControllerRegister mControllerRegister;
    private final ConcurrentHashMap<Class<?>, IServiceManager.IServiceCreator<?>> mServiceCreatorMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class<?>, IService> mCacheServiceMap = new ConcurrentHashMap();
    @Keep
    private final ServiceNotifyCenter notifyCenter;
    private volatile Class lastNotFindService;
    private Object lastNotFindServiceLock = new Object();
    private final HashMap<Class<? extends IService>, List<Callback<IService>>> serviceObservers = new HashMap();

    private ServiceManager() {
        this.notifyCenter = new ServiceNotifyCenter(this);
    }

    public static ServiceManager getInstance() {
        return SingleHolder.INSTANCE;
    }

    public boolean inited() {
        return RuntimeContext.sIsServicesInited;
    }

    public void setLiveEnv(LiveEnv baseEnv, IControllerRegister controllerRegister) {
        this.mBaseEnv = baseEnv;
        mControllerRegister = controllerRegister;
    }

    public LiveEnv getBaseEnv() {
        return this.mBaseEnv;
    }

    private void check(Class serviceClass) {
        if (this.mBaseEnv == null && RuntimeContext.sIsDebuggable) {
            throw new IllegalStateException("please call setLiveEnv first");
        }
        if (!RuntimeContext.sIsServicesInited && RuntimeContext.sIsDebuggable) {
            throw new IllegalStateException("please call registerServices first");
        }
        if (!RuntimeContext.sIsAppStartFinished && RuntimeContext.sIsDebuggable) {
            MLog.error((Object)TAG, (String)"please wait to app finished:%s", (Object[])new Object[]{serviceClass.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IService> T getService(Class<T> serviceClass) {
        IServiceManager.IServiceCreator<?> creator = null;
        Class<T> clazz = serviceClass;
        synchronized (clazz) {
            Object cacheService;
            if (!RuntimeContext.sIsServicesInited && !RuntimeContext.sIsDebuggable) {
                return null;
            }
            if (this.mCacheServiceMap.containsKey(serviceClass) && (cacheService = this.mCacheServiceMap.get(serviceClass)) != null) {
                return (T)cacheService;
            }
            this.check(serviceClass);
            cacheService = this.mServiceCreatorMap;
            synchronized (cacheService) {
                creator = this.mServiceCreatorMap.get(serviceClass);
            }
            if (creator != null) {
                long time = -1L;
                if (RuntimeContext.sIsDebuggable) {
                    time = SystemClock.uptimeMillis();
                }
                IService service = (IService)creator.createService((Environment)this.mBaseEnv, (IServiceManager)this);
                if (SystemUtils.isShowEnvSetting()) {
                    PerfActionLog.add((String)("ServiceCreate_" + serviceClass.toString()), (Object[])new Object[0]);
                }
                if (RuntimeContext.sIsDebuggable) {
                    long consume = SystemClock.uptimeMillis() - time;
                    MLog.info((Object)"ServiceManager_Create", (String)"%s consumeTime:%s isAppStarupFininsh:%s!", (Object[])new Object[]{serviceClass.toString(), String.valueOf(consume), RuntimeContext.sIsAppStartFinished ? "1" : "0"});
                }
                this.mCacheServiceMap.put(serviceClass, service);
                this.lastNotFindService = null;
                return (T)service;
            }
        }
        T service = null;
        if (MemRecycleAndCrashOptConfig.isServiceLockOptOff()) {
            Class<ServiceManager> time = ServiceManager.class;
            synchronized (ServiceManager.class) {
                if (this.lastNotFindService != serviceClass) {
                    this.lastNotFindService = serviceClass;
                    MsgDispatcher.getInstance().sendMessageSync(MsgDef.ROOT_ON_SERVICE_NOT_FIND, serviceClass);
                    service = this.getService(serviceClass);
                }
                // ** MonitorExit[time] (shouldn't be in output)
            }
        }
        boolean needRetry = false;
        Object object = this.lastNotFindServiceLock;
        synchronized (object) {
            if (this.lastNotFindService != serviceClass) {
                this.lastNotFindService = serviceClass;
                MsgDispatcher.getInstance().sendMessageSync(MsgDef.ROOT_ON_SERVICE_NOT_FIND, serviceClass);
                needRetry = true;
            }
        }
        if (needRetry) {
            service = this.getService(serviceClass);
        }
        {
            if (service == null) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("getService is null:" + serviceClass);
                }
                MLog.error((Object)TAG, (String)"getService creator is null: %s", (Object[])new Object[]{serviceClass});
            }
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends IService> void setService(Class<T> serviceClass, IServiceManager.IServiceCreator<T> implement) {
        ConcurrentHashMap<Class<?>, IServiceManager.IServiceCreator<?>> concurrentHashMap = this.mServiceCreatorMap;
        synchronized (concurrentHashMap) {
            this.mServiceCreatorMap.put(serviceClass, implement);
        }
        this.replaceFakeService(serviceClass, implement);
        if (SystemUtils.isShowEnvSetting()) {
            PerfActionLog.add((String)("ServiceRegister_" + serviceClass.toString()), (Object[])new Object[0]);
        }
        this.notifyObserver(serviceClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends IService> void replaceFakeService(Class<T> serviceClass, IServiceManager.IServiceCreator<T> implement) {
        ConcurrentHashMap<Class<?>, IService> concurrentHashMap = this.mCacheServiceMap;
        synchronized (concurrentHashMap) {
            IService service = this.mCacheServiceMap.get(serviceClass);
            if (service instanceof IAabFakeService) {
                IService realService = (IService)implement.createService((Environment)this.mBaseEnv, (IServiceManager)this);
                MLog.info((Object)TAG, (String)"replaceFakeService service: %s, realService: %s", (Object[])new Object[]{service, realService});
                this.mCacheServiceMap.put(serviceClass, realService);
            }
        }
    }

    public void registerServices() {
        if (!YYTaskExecutor.isMainThread()) {
            throw new CalledFromWrongThreadException("registerServices should call in UI thread");
        }
        if (RuntimeContext.sIsServicesInited) {
            MLog.error((Object)TAG, (String)"service has initial!!!", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"init serviceEnv", (Object[])new Object[0]);
        this.setService(IControllerRegistryService.class, new IServiceManager.IServiceCreator<IControllerRegistryService>(){

            public IControllerRegistryService createService(Environment env, IServiceManager manager) {
                return new IControllerRegistryService(){

                    public <T extends AbstractController> void registerController(int[] msgIds, int[] notificationIds, Class<T> controllerClass, IControllerCreator<T> creator) {
                        mControllerRegister.registerController(msgIds, notificationIds, controllerClass, creator);
                    }

                    public <T extends AbstractController> void unregisterController(List<Class<T>> controllerClassList) {
                        mControllerRegister.unregisterController(controllerClassList);
                    }

                    public boolean hasMsgHandlerRegister(int msgId) {
                        return mControllerRegister.hasMsgHandlerRegister(msgId);
                    }
                };
            }
        });
        StartUpBridgeHelper.INSTANCE.getStartUpBridge().onBeforeRegisterServices((IServiceManager)this);
        this.setService(IUserAgeLevelService.class, (env, manager) -> new UserAgeLevelService());
        this.setService(IHomePlanService.class, (env, manager) -> new HomePlanService(env));
        this.setService(IBossConfigService.class, (env, manager) -> new BossConfigService(env));
        this.setService(IGameAudioService.class, (env, manager) -> new PKGameAudioManager(env));
        this.setService(IUserAbTestService.class, (env, manager) -> new UserAbTestController(env));
        this.setService(IPrivilegeService.class, (env, manager) -> new PrivilegeService());
        this.setService(IWebService.class, (env, manager) -> WebServiceImpl.getInstance());
        this.setService(IYYUriService.class, (env, manager) -> IYYUriServiceImpl.getInstance());
        this.setService(ISocialMediaService.class, (env, manager) -> new SocialMediaService());
        this.setService(IAppService.class, (env, manager) -> new AppServiceImpl());
        this.setService(IBaseEnvService.class, (env, manager) -> new EnvService());
        this.setService(IDBService.class, (env, manager) -> {
            ServiceManager.initDbService(true);
            return sDBservice;
        });
        ServiceManagerProxy.setCreator((ServiceManagerProxy.Creator)new ServiceManagerProxy.Creator(){

            public IServiceManager getServiceManager() {
                return ServiceManager.this;
            }
        });
        RuntimeContext.sIsServicesInited = true;
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_SERVICE_INIT_FINISHED));
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED, (INotify)this);
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.ROOT_ON_SERVICE_START_REGISTER);
        MLog.info((Object)TAG, (String)"init serviceEnv end", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasRegisterService(Class serviceClass) {
        boolean result = false;
        ConcurrentHashMap<Class<?>, IServiceManager.IServiceCreator<?>> concurrentHashMap = this.mServiceCreatorMap;
        synchronized (concurrentHashMap) {
            result = this.mServiceCreatorMap.get(serviceClass) != null;
        }
        return result;
    }

    public static boolean hasDbServiceInited() {
        return sDBservice != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"LogUsage"})
    public static synchronized void initDbService(boolean check) {
        if (sDBservice != null) {
            return;
        }
        MLog.info((Object)TAG, (String)"init dbservice!", (Object[])new Object[0]);
        Log.i((String)TAG, (String)"init dbservice!");
        if (RuntimeContext.sIsDebuggable && !RuntimeContext.isHagoPartySdk() && !RuntimeContext.sIsAppStartFinished && check) {
            if (!DiskCacheChecker.hasStorageCheckFinished()) {
                throw new RuntimeException(DB_TIPS);
            }
            if (YYTaskExecutor.isMainThread()) {
                MLog.error((Object)TAG, (Throwable)new Exception(EXCEPTION_GETDB));
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)DB_TIPS, (int)0);
            }
        }
        Class<ServiceManager> clazz = ServiceManager.class;
        synchronized (ServiceManager.class) {
            try {
                if (sDBservice == null) {
                    sDBservice = new DataBox();
                }
            }
            catch (Throwable e) {
                VersionUtil.Ver ver;
                if (e != null) {
                    String errorInfo = e.toString();
                    if (errorInfo != null && errorInfo.contains("Could not open env for DB (30) (error code 30)")) {
                        SettingFlags.setBoolean((String)"hasstorageper", (boolean)false);
                        Log.e((String)TAG, (String)"init db error:", (Throwable)e);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    if (e instanceof UnsatisfiedLinkError && errorInfo != null && errorInfo.contains("is 64-bit instead of 32-bit")) {
                        RuntimeContext.s64SoInsteadOf32So = true;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
                if (RuntimeContext.sIsDebuggable) {
                    MLog.error((Object)TAG, (Throwable)e);
                    ver = VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext);
                    throw new RuntimeException("sLastDebugVer " + RuntimeContext.sLastDebugVer + " new ver " + ver.aboutDisplayName(RuntimeContext.sApplicationContext), e);
                }
                RuntimeContext.isStartAtFirstInstalled();
                ver = VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext);
                if (ver != null) {
                    MLog.error((Object)TAG, (String)("sLastDebugVer " + RuntimeContext.sLastDebugVer + " new ver " + ver.aboutDisplayName(RuntimeContext.sApplicationContext)), (Object[])new Object[0]);
                }
                MLog.error((Object)TAG, (Throwable)e);
                Log.e((String)TAG, (String)"init db error:", (Throwable)e);
                throw new RuntimeException("sLastDebugVer " + RuntimeContext.sLastDebugVer + " new ver " + ver.aboutDisplayName(RuntimeContext.sApplicationContext), e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends IService> void notifyObserver(Class<T> serviceClass) {
        HashMap<Class<? extends IService>, List<Callback<IService>>> hashMap = this.serviceObservers;
        synchronized (hashMap) {
            List<Callback<IService>> observers;
            if (!this.serviceObservers.isEmpty() && !FP.empty(observers = this.serviceObservers.get(serviceClass))) {
                Object service = this.getService(serviceClass);
                for (Callback<IService> item : observers) {
                    YYTaskExecutor.postToMainThread(() -> item.onResponse(service));
                }
                observers.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CollectionInitUsage"})
    public <T extends IService> void observeService(@NonNull Class<T> klass, @NonNull Callback<T> createdListener) {
        IService cacheService;
        boolean isInited = RuntimeContext.sIsServicesInited && RuntimeContext.sIsAppStartFinished && this.mServiceCreatorMap.containsKey(klass);
        IService iService = cacheService = isInited ? (IService)this.getService(klass) : null;
        if (cacheService != null) {
            YYTaskExecutor.postToMainThread(() -> createdListener.onResponse((Object)cacheService));
        } else {
            HashMap<Class<? extends IService>, List<Callback<IService>>> hashMap = this.serviceObservers;
            synchronized (hashMap) {
                List<Callback<IService>> observers = this.serviceObservers.get(klass);
                if (FP.empty(observers)) {
                    observers = new ArrayList<Callback<IService>>();
                    this.serviceObservers.put(klass, observers);
                }
                if (!observers.contains(createdListener)) {
                    observers.add(createdListener);
                }
            }
        }
    }

    public void notify(Notification notification) {
        if (notification.id == NotificationDef.N_STARTUP_FINISHED) {
            this.onAppStarted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAppStarted() {
        if (this.serviceObservers.isEmpty()) {
            return;
        }
        ArrayList<Class<? extends IService>> services = new ArrayList<Class<? extends IService>>(this.serviceObservers.keySet());
        ArrayList<Class<?>> creators = Collections.list(this.mServiceCreatorMap.keys());
        HashMap<Class<? extends IService>, List<Callback<IService>>> hashMap = this.serviceObservers;
        synchronized (hashMap) {
            for (Class clazz : services) {
                if (!creators.contains(clazz)) continue;
                this.notifyObserver(clazz);
            }
        }
    }

    public static final class CalledFromWrongThreadException
    extends AndroidRuntimeException {
        public CalledFromWrongThreadException(String msg) {
            super(msg);
        }
    }

    private static final class SingleHolder {
        private static final ServiceManager INSTANCE = new ServiceManager();

        private SingleHolder() {
        }
    }
}

