/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import androidx.annotation.Keep;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.abtest.StartABTestUtil;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.deeplink.DeepLinkService;
import com.yy.appbase.deeplink.DeepLinkStatistics;
import com.yy.appbase.deeplink.IUriCombineApi;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.push.NotificationManager;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.useractionstat.UserEnterActionStat;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.sword.SwordHelper;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.timing.TimingTracer;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.CameraMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.app.AppStat;
import com.yy.hiyo.app.MainController;
import com.yy.hiyo.app.ServiceManager;
import com.yy.hiyo.app.handleintent.HandleIntent;
import com.yy.hiyo.app.perf.PerfManager;
import com.yy.hiyo.app.push.PushJumpController;
import com.yy.hiyo.app.serverwrapper.WsServiceWrapper;
import com.yy.hiyo.app.startup.StepInitBaseEnv;
import com.yy.hiyo.app.wrapper.CommonModuleBridger;
import com.yy.hiyo.auto.StartupMonitor;
import com.yy.hiyo.channel.ChannelBaseMsgDef;
import com.yy.hiyo.crashprotect.CrashPreProtecter;
import com.yy.hiyo.game.base.ITeamMatchWindow;
import com.yy.hiyo.home.base.perforstat.StartupStatHelper;
import com.yy.hiyo.home.base.startup.StartUpBridgeHelper;
import com.yy.hiyo.home.base.startup.StartUpManager;
import com.yy.hiyo.home.base.startup.StartUpRequestInfo;
import com.yy.hiyo.im.ImBaseMsgDef;
import com.yy.hiyo.login.LoginMsgDef;
import com.yy.hiyo.login.LoginRequestHelper;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.base.IAutoReloginCallBack;
import com.yy.hiyo.login.base.IGuestAutoLoginCallback;
import com.yy.hiyo.login.base.ILoginController;
import com.yy.hiyo.login.base.ILoginWindowFinish;
import com.yy.hiyo.login.stat.LoginStatistics;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.hiyo.mixmodule.base.whatsappsticker.StickerMsgDef;
import com.yy.hiyo.module.performancemonitor.perfcollect.PerfCollecter;
import com.yy.hiyo.module.yyuri.UriHandleDelegate;
import com.yy.hiyo.partysdk.PartySdkRootWindow;
import com.yy.hiyo.report.base.ReportModuleMsgDef;
import com.yy.hiyo.restart.RestartHelper;
import com.yy.hiyo.voice.base.roomvoice.VoiceRoomMsgDef;
import com.yy.webservice.webwindow.IWebUi;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class AppController
extends DefaultController
implements StartUpManager.IStartUpCallBack {
    private static final String TAG = "AppController";
    private FragmentActivity mActivity;
    private ILoginController mLoginController;
    private PushJumpController mPushJumpController;
    private StartUpManager mStartUpManager;
    @Keep
    private CommonModuleBridger mCommonModuleBridger;
    private PerfCollecter mPerfCollecter;
    private PerfManager mPerfManager = new PerfManager();
    @Keep
    private WsServiceWrapper mWsServiceWrapper;
    private Intent mIntent;
    private boolean mDestroyed = false;
    private boolean afterEnvInitNotify = false;
    private boolean needCreatePartSdkRootWindow = true;
    PartySdkRootWindow mPartySdkRootWindow = null;
    private volatile boolean sNotifyStartEvent = false;

    public AppController(Environment environment) {
        super(environment);
        this.handleWsService();
    }

    public void onCreate(FragmentActivity activity, Intent intent) {
        StartupStatHelper.onAppCreate();
        MLog.info((Object)TAG, (String)"onCreate! extras: %s", (Object[])new Object[]{intent == null ? null : intent.getExtras()});
        StartupStatHelper.getStartPathLogger().add("AppController onCreate", new Object[0]);
        TimingTracer.addSplit((String)"startup", (String)"AppController onCreate");
        if (this.mStartUpManager == null) {
            this.mStartUpManager = new StartUpManager(this);
            StartUpRequestInfo startUpRequestInfo = this.parseExternalRequestInfo(this.mIntent);
            StartupStatHelper.getStartPathLogger().add("StartUpManager start", new Object[0]);
            this.mStartUpManager.start(startUpRequestInfo);
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_APP_START));
        }
        DeepLinkService.INSTANCE.setHandleApi((IUriCombineApi)new UriHandleDelegate());
        this.mStartUpManager.onMainActivityCreate(activity);
        if (ScreenUtils.getScreenOrientation() == 2) {
            ScreenUtils.lockScreen((Activity)activity, (int)3, (boolean)true);
        }
        RuntimeContext.sIsAppStarted = true;
        this.mDestroyed = false;
        this.mActivity = activity;
        this.mIntent = intent;
        if (!this.isPartySdk()) {
            DeepLinkService.INSTANCE.receiveLaunchIntent(intent);
        }
        if (RuntimeContext.isHagoPartySdk()) {
            this.ignoreSplashAndHome();
        }
        MLog.info((Object)TAG, (String)"onCreate end!", (Object[])new Object[0]);
    }

    private boolean isPartySdk() {
        return RuntimeContext.isHagoPartySdk();
    }

    private void parseStartType(Intent intent) {
        RuntimeContext.sStartType = 1;
        if (intent.hasExtra("payload")) {
            RuntimeContext.sStartType = 2;
        } else {
            String scheme = intent.getScheme();
            if (StringUtils.equalsIgnoreCase((String)scheme, (String)"yylitemobile") || StringUtils.equalsIgnoreCase((String)scheme, (String)"hago") || StringUtils.equalsIgnoreCase((String)scheme, (String)"olaparty")) {
                RuntimeContext.sStartType = 3;
            }
        }
    }

    public void onNewIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        MLog.info((Object)TAG, (String)"onNewIntent! extras: %s", (Object[])new Object[]{intent.getExtras()});
        this.mIntent = intent;
        MLog.info((Object)TAG, (String)"onNewIntent!", (Object[])new Object[0]);
        if (!RuntimeContext.isHagoPartySdk()) {
            DeepLinkService.INSTANCE.receiveLaunchIntent(intent);
        }
        MsgDispatcher.getInstance().sendMessage(LoginMsgDef.MSG_ON_NEW_INTENT, (Object)intent);
        if (this.intercept(intent)) {
            MLog.info((Object)TAG, (String)"intercept", (Object[])new Object[0]);
            return;
        }
        if (RuntimeContext.sIsAppStartFinished || this.sNotifyStartEvent) {
            this.handleIntent(this.mIntent);
        }
    }

    private boolean intercept(Intent intent) {
        Object param;
        boolean isUnregisterPushIntent = false;
        if (StringUtils.equal((String)intent.getAction(), (String)"yylitepushinfo") && (param = MsgDispatcher.getInstance().sendMessageSync(GrowthMsgDef.UNREGISTER_PUSH_INTENT, (Object)intent)) instanceof Boolean) {
            isUnregisterPushIntent = (Boolean)param;
        }
        if (isUnregisterPushIntent) {
            this.handlePush(intent);
            return true;
        }
        return false;
    }

    private void handleIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        MLog.info((Object)TAG, (String)"handleIntent! intent: %s, extras: %s", (Object[])new Object[]{intent, intent.getExtras()});
        this.parseStartType(intent);
        String scheme = intent.getScheme();
        if (StringUtils.equalsIgnoreCase((String)scheme, (String)"yylitemobile") || StringUtils.equalsIgnoreCase((String)scheme, (String)"hago")) {
            final Uri uri = intent.getData();
            if (uri != null) {
                MLog.info((Object)TAG, (String)("handle uri:" + uri), (Object[])new Object[0]);
                boolean ignoreGaming = uri.getBooleanQueryParameter("ignoreGaming", false);
                if (ignoreGaming || !this.isOnGaming()) {
                    int code = ((IYYUriService)this.getServiceManager().getService(IYYUriService.class)).handleUri(uri);
                    if (code != -1) {
                        UserEnterActionStat.onSchemeJump((String)uri.toString());
                    }
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            DeepLinkStatistics.reportConsumeDeeplink((Uri)uri, (String)"6");
                        }
                    });
                }
            }
            return;
        }
        if (this.isOnGaming()) {
            return;
        }
        if (intent.hasExtra("notification_intent_back_to_channel") && intent.getBooleanExtra("notification_intent_back_to_channel", false)) {
            this.sendMessage(AppbaseMsgDef.ChannelMsgDef.RESUME_CUR_CHANNEL);
        }
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        this.handlePush(intent);
        HandleIntent.INSTANCE.handleIntent(intent);
    }

    private boolean isOnGaming() {
        int windowType;
        return this.getCurrentWindow() != null && ((windowType = this.getCurrentWindow().getWindowType()) == 101 || windowType == 103);
    }

    private void handlePush(Intent intent) {
        MLog.debug((Object)TAG, (String)"handleIntent! intent: %s, extras: %s", (Object[])new Object[]{intent, intent.getExtras()});
        if (intent.hasExtra("payload")) {
            String payload = intent.getStringExtra("payload");
            String msgId = "";
            if (intent.hasExtra("msgid")) {
                msgId = intent.getStringExtra("msgid");
            }
            if (this.getCurrentWindow() instanceof ITeamMatchWindow) {
                return;
            }
            if (this.mPushJumpController == null) {
                this.mPushJumpController = new PushJumpController(this.mEnvironment);
            }
            UserEnterActionStat.onPushJump((String)payload);
            boolean isFcmType = intent.getBooleanExtra("is_fcm_type", true);
            boolean isPushSdkStyle = intent.getBooleanExtra("is_push_sdk_style", false);
            boolean isOfflineMsg = intent.getBooleanExtra("offline_msg", false);
            this.mPushJumpController.handlePayload(payload, msgId, isFcmType, isPushSdkStyle, isOfflineMsg);
        }
    }

    public void onStop() {
    }

    private boolean webViewWindowAboveChannelWindow() {
        AbstractWindow currentWindow = this.getCurrentWindow();
        if (!(currentWindow instanceof IWebUi)) {
            return false;
        }
        AbstractWindow window = this.getEnvironment().getWindowManager().getWindowBehind(currentWindow);
        if (window == null) {
            return false;
        }
        return window.getName().equals("ChannelWindow");
    }

    public boolean onBackPress() {
        if (RuntimeContext.sIsAppStartFinished) {
            Object handle = this.sendMessageSync(ChannelBaseMsgDef.MSG_CHECK_BACK);
            MLog.info((Object)TAG, (String)"onBack click channel handle:%s", (Object[])new Object[]{handle});
            if (handle instanceof Boolean && ((Boolean)handle).booleanValue()) {
                return true;
            }
        }
        if (this.mWindowMgr != null && this.mWindowMgr.getCurrentWindow() != null) {
            MLog.info((Object)TAG, (String)"onBackPress", (Object[])new Object[0]);
            if (this.mWindowMgr.getCurrentWindow() != this.mWindowMgr.getCurrentRootWindow() && this.mWindowMgr.getCurrentWindow().isCanPopByBackKey()) {
                if (this.webViewWindowAboveChannelWindow()) {
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_WEB_WINDOW_INSTANT_CLOSE));
                }
                this.mWindowMgr.popWindow(true);
                return true;
            }
        }
        return this.mLoginController != null && this.mLoginController.interceptBackEvent();
    }

    public void onAppDestroy() {
        MLog.info((Object)TAG, (String)"onAppDestroy()", (Object[])new Object[0]);
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_APP_DESTROY));
        SingleToastUtil.onAppDestroy();
        if (this.mStartUpManager != null) {
            this.mStartUpManager.onMainActivityDestroy();
        }
        KvoModuleManager.deinit();
        StartupStatHelper.onAppDestroy();
        this.resetNotifyStartEvent();
        LoginRequestHelper.onAppExit();
        this.mDestroyed = true;
        if (SettingFlags.getBoolean((String)"exitkillprocess", (boolean)true)) {
            AppStat.statAppKill();
            this.killProcess();
        } else {
            long runTime = SystemClock.uptimeMillis() - RuntimeContext.sMainActivityStartTime;
            if (RuntimeContext.getPhoneType() == 2) {
                if (runTime > 3600000L) {
                    AppStat.statAppKill();
                    this.killProcess();
                }
            } else if (RuntimeContext.getPhoneType() == 1 && runTime > 1800000L) {
                AppStat.statAppKill();
                this.killProcess();
            }
        }
        SwordHelper.destroy();
        RuntimeContext.onAppExit();
    }

    private void killProcess() {
        System.exit(0);
        Process.killProcess((int)Process.myPid());
    }

    private void finish(boolean autoRestart) {
        if (autoRestart) {
            RestartHelper.restart(this.mActivity);
        } else {
            this.mActivity.finish();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Object[] extras;
        Message msg;
        if (this.mDestroyed || !RuntimeContext.sIsServicesInited) {
            return;
        }
        if (requestCode == 1 || requestCode == 2 || requestCode == 4) {
            msg = Message.obtain();
            msg.what = CameraMsgDef.MSG_PHTOT_RESULT_FOR_WINDOW;
            Bundle bundle = new Bundle();
            bundle.putInt("requestCode", requestCode);
            bundle.putInt("resultCode", resultCode);
            bundle.putParcelable("data", (Parcelable)data);
            msg.setData(bundle);
            this.sendMessageSync(msg);
        } else if (requestCode == 101) {
            msg = Message.obtain();
            msg.what = ReportModuleMsgDef.REQ_IMG_PATH_RESULT;
            Bundle bundle = new Bundle();
            bundle.putInt("requestCode", requestCode);
            bundle.putInt("resultCode", resultCode);
            bundle.putParcelable("data", (Parcelable)data);
            msg.setData(bundle);
            this.sendMessageSync(msg);
        } else if (requestCode == 2001) {
            msg = Message.obtain();
            msg.what = StickerMsgDef.ADD_WHATSAPP_STICKER_RESULT;
            Bundle bundle = new Bundle();
            bundle.putInt("requestCode", requestCode);
            bundle.putInt("resultCode", resultCode);
            bundle.putParcelable("data", (Parcelable)data);
            msg.setData(bundle);
            this.sendMessage(msg);
        } else if (requestCode == 3001) {
            Message message = Message.obtain();
            message.what = VoiceRoomMsgDef.FLOAT_WINDOW_PERMISSION_REQUEST;
            this.sendMessage(message);
        } else if (requestCode == 3002) {
            extras = new Object[]{requestCode, resultCode, data};
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ChannelBaseMsgDef.CAPTURE_SCREEN_PERMISSION_REQUEST, (Object)extras));
        } else if (requestCode == 20000) {
            extras = new Object[]{requestCode, resultCode, data};
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_ACTIVITY_ON_RESULT, (Object)extras));
        }
        if (this.mStartUpManager != null) {
            this.mStartUpManager.onActivityResult(requestCode, resultCode, data);
        }
        extras = new Object[]{requestCode, resultCode, data};
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.MAIN_ACTIVITY_RESULT, (Object)extras));
    }

    private StartUpRequestInfo parseExternalRequestInfo(Intent intent) {
        StartUpRequestInfo requestInfo = new StartUpRequestInfo();
        if (intent == null) {
            return requestInfo;
        }
        if (StringUtils.equals((String)intent.getAction(), (String)"yylitepushinfo")) {
            requestInfo.setStartupFrom(2);
            requestInfo.setToWhere(2);
            requestInfo.setExtra(intent.getExtras());
        } else {
            Uri uri;
            String scheme = intent.getScheme();
            if ((StringUtils.equalsIgnoreCase((String)scheme, (String)"yylitemobile") || StringUtils.equalsIgnoreCase((String)scheme, (String)"hago") || StringUtils.equalsIgnoreCase((String)scheme, (String)"olaparty")) && (uri = intent.getData()) != null) {
                requestInfo.setStartupFrom(3);
                requestInfo.setToWhere(2);
                requestInfo.setExtra(intent.getExtras());
            }
        }
        return requestInfo;
    }

    @Override
    public void initBaseEnv() {
        Environment baseEnv = this.getEnvironment();
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)"initBaseEnv start", (Object[])new Object[0]);
        }
        new StepInitBaseEnv(baseEnv).init();
        this.mPerfCollecter = new PerfCollecter(baseEnv);
        if (!RuntimeContext.isHagoPartySdk()) {
            this.mLoginController = StartUpBridgeHelper.INSTANCE.getStartUpBridge().createLoginController(baseEnv);
        }
        this.mStartUpManager.onMainActivityCreated();
        this.mCommonModuleBridger = new CommonModuleBridger(this.getEnvironment());
        if (ServiceManager.hasDbServiceInited()) {
            this.mStartUpManager.afterEnvInit();
            this.afterEnvInitNotify = true;
        }
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)"initBaseEnv end", (Object[])new Object[0]);
        }
    }

    private void ensureWindow() {
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.HOME_ENSURE_WINDOW);
    }

    @Override
    public void initServicesEnv() {
        if (!this.afterEnvInitNotify) {
            this.mStartUpManager.afterEnvInit();
            this.afterEnvInitNotify = true;
        }
        KvoModuleManager.compat();
    }

    private void showHomePage() {
        RuntimeContext.recordAppLogin();
        StartupStatHelper.getStartPathLogger().add("Show Homepage", new Object[0]);
        TimingTracer.addSplit((String)"startup", (String)"Show Homepage");
        StartupStatHelper.onHomePageStartShow();
        MLog.debug((Object)TAG, (String)"showHomePage", (Object[])new Object[0]);
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.HOMEPAGE_SHOW);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023771").put("function_id", "show"));
        Runnable startFinishCommand = new Runnable(){

            @Override
            public void run() {
                LoginStatistics.onHomeShowEvent();
                StartupStatHelper.getStartPathLogger().add("Show Homepage end", new Object[0]);
                AppController.this.notifyStartFinish();
            }
        };
        if (!this.isPartySdk()) {
            YYTaskExecutor.postToMainThread((Runnable)startFinishCommand);
        } else {
            startFinishCommand.run();
            if (this.isPartySdk()) {
                this.handleIntent(this.mIntent);
            }
        }
    }

    private boolean showLoginWindowIfNeed() {
        AccountInfo info;
        if (this.isPartySdk()) {
            return false;
        }
        if (this.mLoginController != null) {
            this.mLoginController.onSplashHidden();
            this.mLoginController.checkAutoLogin(StartupMonitor.isCmdMonitor());
        }
        if (((info = AccountModel.getInstance().getAccountInfo()) == null || info.uuid <= 0L) && this.mLoginController != null) {
            MLog.info((Object)TAG, (String)"openLoginSelectWindow", (Object[])new Object[0]);
            if (StartABTestUtil.INSTANCE.isStartTest()) {
                YYTaskExecutor.postToMainThread(MainController::registerNonCoreControllers);
            } else {
                MainController.registerNonCoreControllers();
            }
            final ILoginWindowFinish loginWindowFinish = new ILoginWindowFinish(){

                public void onLoginWindowFinish() {
                    AppController.this.loginWindowFinished();
                }

                public void onLoginWindowClosed() {
                }

                public void preloadHomeData() {
                    StartUpBridgeHelper.INSTANCE.getStartUpBridge().onRequestHomepageData();
                }
            };
            this.mLoginController.startAutoReLogin(new IAutoReloginCallBack(){

                public void onReloginStart() {
                    loginWindowFinish.onLoginWindowFinish();
                }

                public void onReloginSuccess() {
                }

                public void onReloginError() {
                    AppController.this.mLoginController.openLoginSelectWindow(0, false, null);
                }

                public void onReloginTimeout() {
                    AppController.this.mLoginController.openLoginSelectWindow(0, false, null);
                }

                public void onNoAccountToRelogin() {
                    AppController.this.mLoginController.openLoginSelectWindow(0, false, loginWindowFinish);
                }
            });
            return true;
        }
        return false;
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == MsgDef.ROOT_SPLASH_HIHHEN) {
            StartupStatHelper.onStartUpProgressFinish();
            if (!this.showLoginWindowIfNeed()) {
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_SHOW_HOME_PAGE));
            }
        } else if (msg.what == BaseMsgDef.MIC_NOTIFYCATION_SHOW) {
            if (msg.obj != null && msg.obj instanceof String) {
                NotificationManager.Instance.showMicNotification(this.mContext);
            }
        } else if (msg.what == BaseMsgDef.GOTO_HOMEPAGE) {
            if (this.mWindowMgr != null && this.mWindowMgr.getCurrentWindow() != null) {
                MLog.info((Object)TAG, (String)"onBackPress", (Object[])new Object[0]);
                if (this.mWindowMgr.getCurrentWindow() != this.mWindowMgr.getCurrentRootWindow() && this.mWindowMgr.getCurrentWindow().isCanPopByBackKey()) {
                    this.mWindowMgr.popToRootWindow(false);
                    this.sendMessage(ImBaseMsgDef.CLOSE_CHAT_SESSION_PAGE);
                }
            }
        } else if (msg.what == BaseMsgDef.GOTO_SESSION_PAGE) {
            if (this.mWindowMgr != null && this.mWindowMgr.getCurrentWindow() != null) {
                MLog.info((Object)TAG, (String)"\u63a8\u9001\u8fdb\u5165\u4f1a\u8bdd\u9875", (Object[])new Object[0]);
                if (this.mWindowMgr.getCurrentWindow() != this.mWindowMgr.getCurrentRootWindow() && this.mWindowMgr.getCurrentWindow().isCanPopByBackKey()) {
                    this.mWindowMgr.popToRootWindow(false);
                }
                this.sendMessage(ImBaseMsgDef.OPEN_CHAT_SESSION_PAGE);
            }
        } else if (MsgDef.ROOT_MOVE_TASK_TO_BACK == msg.what) {
            this.handleExit(msg.obj);
        }
    }

    private void loginWindowFinished() {
        MLog.debug((Object)TAG, (String)"login window finish", (Object[])new Object[0]);
        this.showHomePage();
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_SHOW_HOME_PAGE));
    }

    public Object handleMessageSync(Message msg) {
        Object result = null;
        if (msg.what == MsgDef.ROOT_SPLASH_FINISH) {
            MLog.debug((Object)TAG, (String)"ROOT_SPLASH_FINISH", (Object[])new Object[0]);
            RuntimeContext.resetAppStartedFlag();
            this.ensureWindow();
            if (!this.isPartySdk()) {
                AccountInfo info = AccountModel.getInstance().getAccountInfo();
                if (info != null && info.uuid > 0L) {
                    if (StartABTestUtil.INSTANCE.isStartTest()) {
                        YYTaskExecutor.execute(() -> {
                            if (!AccountUtil.isLoginByGuest()) {
                                this.mLoginController.checkProfileUpdatedAfterStartupFinished();
                            }
                        });
                    } else if (!AccountUtil.isLoginByGuest()) {
                        this.mLoginController.checkProfileUpdatedAfterStartupFinished();
                    }
                    this.showHomePage();
                }
            } else {
                this.showHomePage();
            }
            if (this.mStartUpManager != null) {
                this.mStartUpManager.onSplashHidden();
            }
        } else if (msg.what == BaseMsgDef.APP_EXIT) {
            this.finish(Boolean.TRUE.equals(msg.obj));
        } else if (MsgDef.ROOT_ONCREATE == msg.what) {
            Object[] objects;
            if (msg.obj instanceof Object[] && (objects = (Object[])msg.obj).length == 2) {
                this.onCreate((FragmentActivity)objects[0], (Intent)objects[1]);
            }
        } else if (MsgDef.ROOT_ONSTOP == msg.what) {
            this.onStop();
        } else {
            if (MsgDef.ROOT_ONBACKPRESS == msg.what) {
                return this.onBackPress();
            }
            if (MsgDef.ROOT_ONNEWINTENT == msg.what) {
                if (msg.obj instanceof Intent) {
                    this.onNewIntent((Intent)msg.obj);
                }
            } else if (AppbaseMsgDef.ROOT_ON_APP_DESTROY == msg.what) {
                this.onAppDestroy();
            } else if (MsgDef.PARTY_SDK_ACTIVITY_DESTROY == msg.what) {
                this.needCreatePartSdkRootWindow = true;
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_PARTY_SDK__DESTROY));
            } else if (MsgDef.ROOT_ONACTIVITYRESULT == msg.what) {
                Object[] objects;
                if (msg.obj instanceof Object[] && (objects = (Object[])msg.obj).length == 3) {
                    this.onActivityResult((Integer)objects[0], (Integer)objects[1], (Intent)objects[2]);
                }
            } else if (MsgDef.ROOT_START_GUEST_LOGIN == msg.what) {
                if (msg.obj instanceof IGuestAutoLoginCallback && this.mLoginController != null) {
                    this.mLoginController.loginByGuestType((IGuestAutoLoginCallback)msg.obj);
                }
            } else if (MsgDef.ROOT_MOVE_TASK_TO_BACK == msg.what) {
                this.handleExit(msg.obj);
            }
        }
        return result;
    }

    @Override
    public void showSplash() {
        if (this.isPartySdk()) {
            this.mStartUpManager.onSplashFinished();
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean shouldShowSplash = (Boolean)MsgDispatcher.getInstance().sendMessageSync(MsgDef.SPLASH_SHOULD_SHOW, (Object)false);
                MLog.debug((Object)AppController.TAG, (String)("showSplash shouldShowSplash: " + shouldShowSplash), (Object[])new Object[0]);
                if (shouldShowSplash) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MLog.debug((Object)AppController.TAG, (String)"ensure window and show splash", (Object[])new Object[0]);
                            AppController.this.ensureWindow();
                            MsgDispatcher.getInstance().sendMessageSync(MsgDef.SPLASH_SHOW);
                            AppController.this.mStartUpManager.onSplashFinished();
                        }
                    });
                } else {
                    YYTaskExecutor.postIdleRunnableToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AppController.this.mStartUpManager.onSplashFinished();
                        }
                    });
                }
            }
        });
    }

    @Override
    public void onFinished() {
        this.mPerfCollecter.start();
        LoginStatistics.onStartUpWorksFinish();
        MLog.debug((Object)TAG, (String)"call SPLASH_HIDE", (Object[])new Object[0]);
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.SPLASH_HIDE);
    }

    public FragmentActivity getActivity() {
        return this.mActivity;
    }

    public void notify(Notification notification) {
        if (notification == null) {
            return;
        }
        if (notification.id == NotificationDef.N_STARTUP_FINISHED) {
            StartupStatHelper.getStartPathLogger().end("start up finish!", new Object[0]);
            TimingTracer.stopTrace((String)"startup");
            long duration = SystemClock.uptimeMillis() - RuntimeContext.sMainActivityStartTime + RuntimeContext.sProcessStartConsumeTime;
            MLog.info((Object)"AppStart", (String)"consume time:%d", (Object[])new Object[]{duration});
            if (SettingFlags.getBoolean((String)"key_show_birth_dialog", (boolean)false)) {
                MLog.info((Object)TAG, (String)"user isAgeInValid ", (Object[])new Object[0]);
                MsgDispatcher.getInstance().sendMessage(BaseMsgDef.SHOW_AGE_INVALID);
            }
        } else if (notification.id == NotificationDef.N_LOGIN_SUCCESS) {
            MLog.debug((Object)TAG, (String)"receive N_LOGIN_SUCCESS", (Object[])new Object[0]);
            KvoModuleManager.initEnv();
        } else if (notification.id == NotificationDef.N_PARTY_SDK_LOCALE_CHANGED) {
            this.needCreatePartSdkRootWindow = true;
        }
    }

    private void ignoreSplashAndHome() {
        if (!this.sNotifyStartEvent) {
            this.mStartUpManager.onSplashHidden();
            this.notifyStartFinish();
        }
        if (this.mPartySdkRootWindow != null) {
            if (this.mPartySdkRootWindow.getContext() instanceof Activity) {
                if (((Activity)this.mPartySdkRootWindow.getContext()).isDestroyed()) {
                    this.needCreatePartSdkRootWindow = true;
                }
            } else {
                this.needCreatePartSdkRootWindow = true;
            }
        }
        if (this.needCreatePartSdkRootWindow || this.mPartySdkRootWindow == null) {
            this.createPartySdkRootWindow();
            this.needCreatePartSdkRootWindow = false;
        }
        this.handleIntent(this.mIntent);
    }

    private void createPartySdkRootWindow() {
        this.mPartySdkRootWindow = new PartySdkRootWindow((Context)this.mActivity, this.mWindowMgr, (UICallBacks)this);
        this.mWindowMgr.createWindowStack((AbstractWindow)this.mPartySdkRootWindow);
    }

    private void handleWsService() {
        this.mWsServiceWrapper = new WsServiceWrapper(new WsServiceWrapper.ICallBack(){

            @Override
            public DialogLinkManager getDialogmanager() {
                return AppController.this.mDialogLinkManager;
            }

            @Override
            public IServiceManager getServiceManager() {
                return AppController.this.mServiceManager;
            }

            @Override
            public Activity getActivity() {
                return AppController.this.mActivity;
            }
        });
    }

    private void resetNotifyStartEvent() {
        this.sNotifyStartEvent = false;
    }

    private void notifyStartFinish() {
        if (this.mDestroyed) {
            return;
        }
        if (!this.sNotifyStartEvent) {
            this.sNotifyStartEvent = true;
            long notifyStartTime = 0L;
            if (RuntimeContext.sIsDebuggable) {
                notifyStartTime = System.currentTimeMillis();
                MLog.debug((Object)"StartUpFinish", (String)" current consume time:%d, startNotify!", (Object[])new Object[]{notifyStartTime - RuntimeContext.sMainActivityStartTime + RuntimeContext.sProcessStartConsumeTime});
            }
            UserEnterActionStat.onStartupFinish();
            KvoModuleManager.initEnv();
            MainController.registerNonCoreControllers();
            if (!RuntimeContext.isHagoPartySdk()) {
                this.handleIntent(this.mIntent);
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)"StartUpFinish", (String)" current comsume time:%d, notify!", (Object[])new Object[]{SystemClock.uptimeMillis() - RuntimeContext.sMainActivityStartTime + RuntimeContext.sProcessStartConsumeTime});
                    }
                    RuntimeContext.sIsAppStartFinished = true;
                    AppController.this.mStartUpManager.afterStartup();
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_STARTUP_FINISHED));
                    if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)"StartUpFinish", (String)" current comsume time:%d, end notify!", (Object[])new Object[]{SystemClock.uptimeMillis() - RuntimeContext.sMainActivityStartTime + RuntimeContext.sProcessStartConsumeTime});
                    }
                }
            }, (long)600L);
            this.postStartupEvent(new Runnable(){

                @Override
                public void run() {
                    AppController.this.handleStartupOneSecond();
                }
            }, 1500L);
            this.postStartupEvent(new Runnable(){

                @Override
                public void run() {
                    AppController.this.handleStartupThreeSecond();
                }
            }, 3000L);
            this.postStartupEvent(new Runnable(){

                @Override
                public void run() {
                    AppController.this.handleStartupFiveSecond();
                }
            }, 5000L);
            this.postStartupEvent(new Runnable(){

                @Override
                public void run() {
                    AppController.this.handleStartupTenSecond();
                }
            }, 10000L);
        }
    }

    private boolean needPostStartupEventToIdleQueue() {
        return SettingFlags.getBoolean((String)"starupidlequeue", (boolean)true);
    }

    private void postStartupEvent(Runnable event) {
        if (this.needPostStartupEventToIdleQueue()) {
            YYTaskExecutor.postIdleRunnableToMainThread((Runnable)event);
        } else {
            event.run();
        }
    }

    private void postStartupEvent(final Runnable event, long delay) {
        if (delay > 0L) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    AppController.this.postStartupEvent(event);
                }
            }, (long)delay);
        } else {
            this.postStartupEvent(event);
        }
    }

    private void handleStartupOneSecond() {
        RuntimeContext.sIsAppStartFinishAfterOneSecond = true;
        this.mStartUpManager.afterStartupOneSecond();
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS));
    }

    private void handleStartupThreeSecond() {
        RuntimeContext.sIsAppStartFinishAfterThreeSecond = true;
        this.mStartUpManager.afterStartupThreeSecond();
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS));
        this.mPerfManager.onAppStarted();
    }

    private void handleStartupFiveSecond() {
        RuntimeContext.sIsAppStartFinishAfterFiveSecond = true;
        MLog.handleStartupFiveSecond();
        CrashPreProtecter.afterStartupFiveSecond();
        this.mStartUpManager.afterStartupFiveSecond();
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_STARTUP_FINISHED_AFTER_5_SECONDS));
        PerfActionLog.end((String)"StarupPerfActionLog", (String)"End!", (Object[])new Object[0]);
    }

    private void handleStartupTenSecond() {
        RuntimeContext.sIsAppStartFinishAfterTenSecond = true;
        this.mStartUpManager.afterStartupTenSecond();
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_STARTUP_FINISHED_AFTER_10_SECONDS));
    }

    private void handleExit(Object obj) {
        if (obj instanceof Boolean && ((Boolean)obj).booleanValue() && this.getActivity() != null && this.getEnvironment().getActivity() != null) {
            this.mWindowMgr.popToRootWindow(false);
        }
        if (this.getActivity() != null) {
            this.getActivity().moveTaskToBack(true);
        }
    }
}

