/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.yyuri;

import android.content.Context;
import android.net.Uri;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.deeplink.DeepLinkReportManager;
import com.yy.appbase.deeplink.DeepLinkService;
import com.yy.appbase.deeplink.data.DeepLinkAction;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.span.UrlGotoSpan;
import com.yy.appbase.yyuri.YYUriCode;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.NavigationUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.home.base.startup.StartUpBridgeHelper;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.hiyo.mixmodule.base.MixBaseMsgDef;
import com.yy.tjgsdk.TjgSDK;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class YYUriHandlerController
extends DefaultController {
    private static final String TAG = "FTUriHandle";
    private String mGameInviteLink = "";
    private final GameLifeWrapper mGameLifeWrapper = new GameLifeWrapper(){

        public void onGameExited(GamePlayContext context, int gameExitType) {
            YYUriHandlerController.this.mGameInviteLink = "";
        }
    };
    private final List<Integer> mGuestCheckList = Arrays.asList(YYUriCode.openVoiceRoom, YYUriCode.openVoiceRoomList, YYUriCode.toChannelList, YYUriCode.openVoiceRoomNoMatchGame, YYUriCode.enterSelfRoom, YYUriCode.openVoiceRoomSubList, YYUriCode.openChannelList, YYUriCode.openChannelSubList, YYUriCode.toLiveRoomWithIndex, YYUriCode.openMyChannel, YYUriCode.openExactlyChannel);
    private volatile boolean mIsLoginCompleted;
    private ConcurrentHashMap<Uri, InnerPendingData> mPendingUriList;
    private boolean mIsBlocked = false;
    private final Function1<DeepLinkAction, Unit> mConsumeCallback = new Function1<DeepLinkAction, Unit>(){

        public Unit invoke(DeepLinkAction action) {
            FeatureLog.i((String)YYUriHandlerController.TAG, (String)"handle action: %s, is login: %b", (Object[])new Object[]{action, YYUriHandlerController.this.mIsLoginCompleted});
            if (action != null) {
                Uri uri = action.getUri();
                final String uriString = uri.toString();
                YYUriHandlerController.this.mGameInviteLink = uri.toString();
                YYUriHandlerController.this.hiidoReport(uri);
                TjgSDK.Companion.getInstance().getTigService().fireState("app_state", 3000, "", null);
                if (SystemUtils.isShowEnvSetting()) {
                    EnvSettings.instance().setEnterSchemeUri(uriString);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("handle uri: " + uriString), (int)1);
                        }
                    }, (long)6000L);
                }
                if (!YYUriHandlerController.this.mIsLoginCompleted) {
                    YYUriHandlerController.this.pendingUri(uri, action.getExtendParam());
                } else {
                    if (YYUriHandlerController.this.mIsBlocked) {
                        YYUriHandlerController.this.pendingUri(uri, action.getExtendParam());
                        return null;
                    }
                    YYUriHandlerController.this.interceptUri(uri);
                    boolean reqHome = uri.getBooleanQueryParameter("reqHome", false);
                    if (reqHome) {
                        StartUpBridgeHelper.INSTANCE.getStartUpBridge().getHomeMainModel().reqWithUri(uriString);
                    }
                    YYUriHandlerController.this.checkGuestAction(action);
                    Runnable task = action.getTask();
                    if (task != null) {
                        MLog.debug((Object)YYUriHandlerController.TAG, (String)"post deeplink task", (Object[])new Object[0]);
                        if (YYTaskExecutor.isMainThread()) {
                            task.run();
                        } else {
                            YYTaskExecutor.postToMainThread((Runnable)task);
                        }
                    }
                }
            }
            return null;
        }
    };

    public YYUriHandlerController(Environment env) {
        super(env);
        UrlGotoSpan.ICallBack urlGotoSpan = new UrlGotoSpan.ICallBack(){

            public void onUrlGotoSpanClick(String url, View widget) {
                FeatureLog.i((String)YYUriHandlerController.TAG, (String)"onUrlGotoSpanClick : %s", (Object[])new Object[]{url});
                if (StringUtils.isEmpty((String)url)) {
                    return;
                }
                if (url.startsWith("http://") || url.startsWith("https://")) {
                    NavigationUtils.navToBrower((Context)YYUriHandlerController.this.mContext, (String)url);
                }
            }
        };
        UrlGotoSpan.setCallBack((UrlGotoSpan.ICallBack)urlGotoSpan);
        this.getServiceManager().observeService(IGameCenterService.class, data -> ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle((IGameLifecycle)this.mGameLifeWrapper));
    }

    private boolean checkLoginComplete(Uri uri, String uriString, Object extendParam) {
        Uri targetUri = uri;
        String targetUriString = uriString;
        if (targetUri == null && StringUtils.isNotEmpty((String)targetUriString)) {
            targetUri = Uri.parse((String)targetUriString);
        }
        if (targetUri != null && StringUtils.isEmpty((String)targetUriString)) {
            targetUriString = targetUri.toString();
        }
        if (targetUri == null || StringUtils.isEmpty((String)targetUriString)) {
            return this.mIsLoginCompleted;
        }
        this.hiidoReport(targetUri);
        if (RuntimeContext.isStartAtFirstInstalled()) {
            boolean showGuide = targetUri.getBooleanQueryParameter("show_guide", false);
            if (Boolean.valueOf(true).equals(MsgDispatcher.getInstance().sendMessageSync(GrowthMsgDef.IS_MATCH_SHOW_GAME_GUIDE))) {
                showGuide = true;
            }
            this.setHomeGuideView(showGuide);
        }
        if (!this.mIsLoginCompleted) {
            this.pendingUri(targetUri, extendParam);
        }
        return this.mIsLoginCompleted;
    }

    private void pendingUri(Uri uri, Object extendPram) {
        MLog.info((Object)TAG, (String)"pendingUri, uri : %s, extendPram : %s", (Object[])new Object[]{uri, extendPram});
        if (uri == null) {
            return;
        }
        if (this.mPendingUriList == null) {
            this.mPendingUriList = new ConcurrentHashMap();
        }
        this.mPendingUriList.put(uri, new InnerPendingData(extendPram));
    }

    private int handleUri(Uri uri) {
        return this.handleUri(uri, null);
    }

    public int handleUri(Uri uri, Object extendPram) {
        FeatureLog.i((String)TAG, (String)"handleUri : %s, extendPram : %s", (Object[])new Object[]{uri, extendPram});
        if (this.checkLoginComplete(uri, null, extendPram)) {
            return DeepLinkService.INSTANCE.consumeDeepLink(uri, extendPram, this.mConsumeCallback);
        }
        return -2;
    }

    private int handleUriString(String uriString) {
        return this.handleUriString(uriString, null);
    }

    private int handleUriString(String uriString, Object extendPram) {
        FeatureLog.i((String)TAG, (String)"handleUriString : %s, extendPram : %s", (Object[])new Object[]{uriString, extendPram});
        if (this.checkLoginComplete(null, uriString, extendPram)) {
            return DeepLinkService.INSTANCE.consumeDeepLinkString(uriString, extendPram, this.mConsumeCallback);
        }
        return -2;
    }

    private void checkGuestAction(DeepLinkAction action) {
        if (action == null) {
            return;
        }
        if (AccountUtil.isLoginByGuest() && this.mGuestCheckList.contains(action.getCode())) {
            this.pendingUri(action.getUri(), action.getExtendParam());
        }
    }

    private int matchCode(Uri uri) {
        return DeepLinkService.INSTANCE.match(uri);
    }

    private int matchCode(String uriString) {
        Uri uri = null;
        if (uriString != null) {
            uri = Uri.parse((String)uriString);
        }
        return this.matchCode(uri);
    }

    private void handleForLoginFinish() {
        if (!this.mIsLoginCompleted) {
            this.mIsLoginCompleted = AccountUtil.getUid() > 0L;
            this.handlePendingUri();
        }
    }

    public void notify(Notification notification) {
        if (notification == null) {
            return;
        }
        if (notification.id == NotificationDef.N_PARTY_SDK_BASE_INIT) {
            YYTaskExecutor.postIdleRunnableToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    FeatureLog.i((String)YYUriHandlerController.TAG, (String)"N_PARTY_SDK_BASE_INIT, mIsLoginCompleted = %b", (Object[])new Object[]{YYUriHandlerController.this.mIsLoginCompleted});
                    if (!YYUriHandlerController.this.mIsLoginCompleted) {
                        YYUriHandlerController.this.handlePendingUri();
                    }
                    if (AccountUtil.getUid() > 0L) {
                        YYUriHandlerController.this.mIsLoginCompleted = true;
                    }
                }
            });
        } else if (notification.id == NotificationDef.N_LOGIN_SUCCESS) {
            this.mIsLoginCompleted = RuntimeContext.sIsAppStartFinishAfterOneSecond;
            FeatureLog.i((String)TAG, (String)"N_LOGIN_SUCCESS, mIsLoginCompleted = %b", (Object[])new Object[]{this.mIsLoginCompleted});
            this.handlePendingUri();
        } else if (notification.id == NotificationDef.N_SHOW_HOME_PAGE) {
            FeatureLog.i((String)TAG, (String)"N_SHOW_HOME_PAGE, mIsLoginCompleted = %b", (Object[])new Object[]{this.mIsLoginCompleted});
            this.handleForLoginFinish();
        } else if (notification.id == NotificationDef.N_LOGIN_PROCESS_COMPLETED) {
            FeatureLog.i((String)TAG, (String)"N_LOGIN_PROCESS_COMPLETED, mIsLoginCompleted = %b", (Object[])new Object[]{this.mIsLoginCompleted});
            this.handleForLoginFinish();
        } else if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            FeatureLog.i((String)TAG, (String)"N_LOGIN_LOGIN_OUT", (Object[])new Object[0]);
            this.mIsLoginCompleted = false;
            this.mPendingUriList = null;
        } else if (notification.id == NotificationDef.N_PERMISSION_REQUEST_SHOW) {
            FeatureLog.i((String)TAG, (String)"N_PERMISSION_REQUEST_SHOW", (Object[])new Object[0]);
            this.mIsBlocked = true;
        } else if (notification.id == NotificationDef.N_PERMISSION_REQUEST_ANSWERED) {
            FeatureLog.i((String)TAG, (String)"N_PERMISSION_REQUEST_ANSWERED", (Object[])new Object[0]);
            this.mIsBlocked = false;
            this.handlePendingUri();
        }
    }

    public Object handleMessageSync(Message msg) {
        if (MsgDef.MSG_YYURIHANDLER_HANDLEURI == msg.what) {
            Object[] objects;
            if (msg.obj instanceof Uri) {
                return this.handleUri((Uri)msg.obj);
            }
            if (msg.obj instanceof Object[] && (objects = (Object[])msg.obj).length == 2 && objects[0] instanceof Uri) {
                return this.handleUri((Uri)objects[0], objects[1]);
            }
        } else if (MsgDef.MSG_YYURIHANDLER_HANDLEURISTRING == msg.what) {
            Object[] objects;
            if (msg.obj instanceof String) {
                return this.handleUriString((String)msg.obj);
            }
            if (msg.obj instanceof Object[] && (objects = (Object[])msg.obj).length == 2 && objects[0] instanceof String) {
                return this.handleUriString((String)objects[0], objects[1]);
            }
        } else if (MsgDef.MSG_YYURIHANDLER_MATCHCODE == msg.what) {
            if (msg.obj instanceof Uri) {
                return this.matchCode((Uri)msg.obj);
            }
            if (msg.obj instanceof String) {
                return this.matchCode((String)msg.obj);
            }
        } else {
            if (BaseMsgDef.MSG_GET_GAME_INVITE_LINK == msg.what) {
                return this.mGameInviteLink;
            }
            if (msg.what == MixBaseMsgDef.HOME_WIN_CREATE) {
                MLog.debug((Object)TAG, (String)"receive HOME_WIN_CREATE", (Object[])new Object[0]);
                this.handleForLoginFinish();
            }
        }
        return super.handleMessageSync(msg);
    }

    private void handlePendingUri() {
        if (!this.mIsLoginCompleted) {
            MLog.warn((Object)TAG, (String)"handle pending uri fail, is not login", (Object[])new Object[0]);
            return;
        }
        if (FP.empty(this.mPendingUriList)) {
            MLog.warn((Object)TAG, (String)"handle pending uri fail, pending is empty", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"handlePendingUri size: %d", (Object[])new Object[]{FP.size(this.mPendingUriList)});
        for (final Map.Entry<Uri, InnerPendingData> entry : this.mPendingUriList.entrySet()) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    YYUriHandlerController.this.handleUri((Uri)entry.getKey(), ((InnerPendingData)entry.getValue()).extend);
                }
            });
        }
        this.mPendingUriList = null;
    }

    private void setHomeGuideView(boolean isShow) {
        MLog.info((Object)TAG, (String)"setHomeGuideView isShow: %b", (Object[])new Object[]{isShow});
        SettingFlags.setBoolean((String)"game_guide_", (boolean)isShow);
    }

    private void interceptUri(Uri uri) {
        String startPageGid = uri.getQueryParameter("start_page_gid");
        if (!TextUtils.isEmpty((CharSequence)startPageGid)) {
            SettingFlags.setStringValue((String)("key_deeplink_to_start_page_gid" + AccountUtil.getUid()), (String)startPageGid);
            String startPageType = uri.getQueryParameter("start_page_type");
            SettingFlags.setStringValue((String)("key_deeplink_to_start_page_type" + AccountUtil.getUid()), (String)startPageType);
        }
    }

    private void hiidoReport(Uri uri) {
        if (uri == null) {
            return;
        }
        boolean noReport = uri.getBooleanQueryParameter("noReportHiido", false);
        if (!noReport) {
            String adId = uri.getQueryParameter("adId");
            String urlEncode = URLEncoder.encode(uri.toString());
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028473").put("adid", adId).put("deeplink", urlEncode).put("function_id", "1001").put("uid", String.valueOf(AccountUtil.getUid())));
        }
        if (AccountUtil.getUid() > 0L) {
            String activeId;
            String uriString = uri.toString();
            DeepLinkReportManager.INSTANCE.reportDeeplink(uriString);
            String inviteUid = uri.getQueryParameter("invite_uid");
            String inviteCode = uri.getQueryParameter("invite_code");
            if (!TextUtils.isEmpty((CharSequence)inviteUid)) {
                FeatureLog.i((String)"FTUriHandleDeepLink", (String)("report uid : " + inviteUid), (Object[])new Object[0]);
                boolean old = true;
                AccountInfo info = AccountModel.getInstance().getAccountInfo();
                if (info != null && info.resultType == 2) {
                    old = false;
                }
                DeepLinkReportManager.INSTANCE.reportRelationship(inviteUid, uri.toString(), old);
            }
            if (!TextUtils.isEmpty((CharSequence)inviteCode)) {
                DeepLinkReportManager.INSTANCE.reportInviteCode(inviteCode);
            }
            if (!TextUtils.isEmpty((CharSequence)(activeId = uri.getQueryParameter("activeId")))) {
                DeepLinkReportManager.INSTANCE.reportSpecialActive(activeId, inviteUid, inviteCode);
            }
        }
    }

    private static class InnerPendingData {
        public Object extend;

        InnerPendingData(Object extend) {
            this.extend = extend;
        }
    }
}

