/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.yy;

import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.webservice.IJsTitleBarAction;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.IJsParam;
import com.yy.webservice.webwindow.webview.WebBusinessHandlerCallback;
import org.json.JSONException;
import org.json.JSONObject;

public class YYSetNavigationBarJsEvent
implements JsEvent {
    private static final String TAG = "FTCustomerServiceBaseYYSetNavigationBarJsEvent";
    private IWebBusinessHandler mWebHandler;
    private IJsEventCallback mJsEventCallback;
    private NarBarParam mNarBarParam;
    private WebBusinessHandlerCallback mHandlerCallback = new WebBusinessHandlerCallback(){

        public void onWebViewDestroy() {
            YYSetNavigationBarJsEvent.this.mWebHandler = null;
            YYSetNavigationBarJsEvent.this.mJsEventCallback = null;
            YYSetNavigationBarJsEvent.this.mNarBarParam = null;
        }

        public void onInterceptBack(int type2) {
            if (YYSetNavigationBarJsEvent.this.mWebHandler != null && YYSetNavigationBarJsEvent.this.mJsEventCallback != null && YYSetNavigationBarJsEvent.this.mNarBarParam != null) {
                int id2 = 0;
                if (type2 == 1) {
                    if (((YYSetNavigationBarJsEvent)YYSetNavigationBarJsEvent.this).mNarBarParam.leftItem != null) {
                        id2 = ((YYSetNavigationBarJsEvent)YYSetNavigationBarJsEvent.this).mNarBarParam.leftItem.id;
                    }
                } else if (type2 == 2 && ((YYSetNavigationBarJsEvent)YYSetNavigationBarJsEvent.this).mNarBarParam.androidBackBtn != null) {
                    id2 = ((YYSetNavigationBarJsEvent)YYSetNavigationBarJsEvent.this).mNarBarParam.androidBackBtn.id;
                }
                final JSONObject jo = JsonParser.obtainJSONObject();
                try {
                    jo.put("id", id2);
                    YYSetNavigationBarJsEvent.this.mJsEventCallback.callJs(new IJsParam(){

                        public String toJson() {
                            return jo.toString();
                        }
                    });
                }
                catch (JSONException e) {
                    MLog.error((Object)YYSetNavigationBarJsEvent.TAG, (Throwable)e);
                }
            }
        }
    };

    @NonNull
    public JsMethod method() {
        return JsEventDefine.YY.UI.setNavigationBar;
    }

    public void jsCall(final @NonNull IWebBusinessHandler webHandler, final @NonNull String param, @Nullable IJsEventCallback callback) {
        FeatureLog.i((String)"FTCustomerServiceBase", (String)"Js setNavigationBar and param: %s", (Object[])new Object[]{param});
        if (TextUtils.isEmpty((CharSequence)param)) {
            if (callback != null) {
                callback.callJs(this.errorMsg("illegal param"));
            }
            return;
        }
        this.mWebHandler = webHandler;
        this.mJsEventCallback = callback;
        this.mWebHandler.addWebViewListener(this.mHandlerCallback);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                YYSetNavigationBarJsEvent.this.handleParam(webHandler, param);
            }
        });
    }

    private void handleParam(@NonNull IWebBusinessHandler webHandler, @NonNull String param) {
        block4: {
            try {
                NarBarParam barParam = (NarBarParam)JsonParser.parseJsonObject((String)param, NarBarParam.class);
                if (barParam == null) {
                    if (this.mJsEventCallback != null) {
                        this.mJsEventCallback.callJs(this.errorMsg("illegal param! "));
                    }
                    return;
                }
                this.handleBar(webHandler, barParam);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
                if (this.mJsEventCallback == null) break block4;
                this.mJsEventCallback.callJs(this.errorMsg("illegal param! " + e.getMessage()));
            }
        }
    }

    private void handleBar(@NonNull IWebBusinessHandler webHandler, final @NonNull NarBarParam param) {
        this.mNarBarParam = param;
        final IJsTitleBarAction titleBarAction = webHandler.getJsChangeTitleBarAction();
        if (titleBarAction != null && !TextUtils.isEmpty((CharSequence)param.getTitle())) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    titleBarAction.setNavigationBarTitle(param.getTitle());
                }
            });
        }
        webHandler.interceptBack(param.interceptBack());
    }

    private IJsParam errorMsg(final String msg) {
        return new IJsParam(){

            public String toJson() {
                return StringUtils.formatWitUSLocal((String)"{\"errorMsg\": %s}", (Object[])new Object[]{msg});
            }
        };
    }

    @Keep
    class NarBarParam {
        Title title;
        Item leftItem;
        Item rightItem;
        BackBtn androidBackBtn;

        NarBarParam() {
        }

        String getTitle() {
            if (this.title != null) {
                return this.title.title == null ? "" : this.title.title;
            }
            return "";
        }

        int interceptBack() {
            int intercept = 0;
            if (this.leftItem != null) {
                intercept |= this.leftItem.enabled ? 1 : 0;
            }
            return intercept |= this.androidBackBtn != null ? 2 : 0;
        }

        @Keep
        class BackBtn {
            int id;

            BackBtn() {
            }
        }

        @Keep
        class Item {
            String title;
            int id;
            boolean enabled;

            Item() {
            }
        }

        @Keep
        class Title {
            String title;

            Title() {
            }
        }
    }
}

