/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.yy;

import android.os.Bundle;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.wallet.base.feedback.FeedbackCallBack;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;

public class YYReportFeedbackJsEvent
implements JsEvent {
    private static String TAG = "FTCustomerServiceBaseYYReportFeedbackJsEvent";

    @NonNull
    public JsMethod method() {
        return JsEventDefine.YY.UI.reportFeedback;
    }

    public void jsCall(final @NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    YYReportFeedbackJsEvent.this.handleParam(webHandler, param, callback);
                }
            });
        } else {
            this.handleParam(webHandler, param, callback);
        }
    }

    private void handleParam(@NonNull IWebBusinessHandler webHandler, @NonNull String param, final @Nullable IJsEventCallback callback) {
        block4: {
            MLog.info((Object)TAG, (String)"handleParam param: %s", (Object[])new Object[]{param});
            try {
                FeedbackParam fp = (FeedbackParam)JsonParser.parseJsonObject((String)param, FeedbackParam.class);
                if (fp == null) {
                    MLog.error((Object)TAG, (String)"param is illegal", (Object[])new Object[0]);
                    if (callback != null) {
                        callback.callJs((IJsParam)BaseJsParam.errorParam((int)0, (String)"param is illegal"));
                    }
                    return;
                }
                Message message = new Message();
                Bundle bundle = new Bundle();
                bundle.putString("feedback_content", fp.feedbackMsg);
                bundle.putString("feedback_image_path", fp.imgPath);
                bundle.putString("feedback_contact", fp.contact);
                bundle.putBoolean("feedback_silent", fp.silent);
                bundle.putString("feedback_video_path", fp.videoPath);
                message.what = BaseMsgDef.REPORT_FEEDBACK;
                message.arg1 = fp.feedbackType;
                message.setData(bundle);
                message.obj = new FeedbackCallBack(){

                    public void onSuccess() {
                        if (callback != null) {
                            callback.callJs((IJsParam)BaseJsParam.errorParam((int)1, (String)"success"));
                        }
                    }

                    public void onError(int code, String msg) {
                        String error = StringUtils.formatWitUSLocal((String)"report error code: %d, errorInfo: %s", (Object[])new Object[]{code, msg});
                        MLog.error((Object)TAG, (String)error, (Object[])new Object[0]);
                        if (callback != null) {
                            callback.callJs((IJsParam)BaseJsParam.errorParam((int)0, (String)error));
                        }
                    }
                };
                MsgDispatcher.getInstance().sendMessage(message);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
                if (callback == null) break block4;
                callback.callJs((IJsParam)BaseJsParam.errorParam((int)0, (String)"param is illegal"));
            }
        }
    }

    private static class FeedbackParam {
        @SerializedName(value="feedbackType")
        int feedbackType;
        @SerializedName(value="imgPath")
        String imgPath;
        @SerializedName(value="feedbackMsg")
        String feedbackMsg;
        @SerializedName(value="contact")
        String contact;
        @SerializedName(value="silent")
        boolean silent;
        @SerializedName(value="videoPath")
        String videoPath;

        private FeedbackParam() {
        }
    }
}

