/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.ui;

import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.ui.country.CountryHelper;
import com.yy.appbase.ui.country.ICountrySelectSimpleCallback;
import com.yy.appbase.web.JsEventControllerCallback;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;

public class SelectCountryJsEvent
implements JsEvent {
    private static final String TAG = "SelectCountryJsEvent";
    private final JsEventControllerCallback mControllerCallback;

    public SelectCountryJsEvent(JsEventControllerCallback controllerCallback) {
        this.mControllerCallback = controllerCallback;
    }

    @NonNull
    public JsMethod method() {
        return JsEventDefine.UI.openSelectCountryWindow;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (callback == null) {
            MLog.error((Object)TAG, (String)"callback is null", (Object[])new Object[0]);
        }
        Message msg = Message.obtain();
        msg.what = AppbaseMsgDef.OPEN_COUNTRY_SELECT_WINDOW;
        msg.obj = new ICountrySelectSimpleCallback(){

            public void onBackIconClicked() {
                SelectCountryJsEvent.this.onCallback(callback, 2, "cancel", null);
            }

            public void onCountrySelected(CountryHelper.CountryInfo info) {
                SelectCountryJsEvent.this.onCallback(callback, 1, "success", info);
            }
        };
        this.mControllerCallback.sendMsg(msg);
    }

    private void onCallback(IJsEventCallback callback, int code, String msg, CountryHelper.CountryInfo info) {
        if (callback == null) {
            return;
        }
        String data = "";
        if (info != null) {
            data = BaseJsParam.builder().put("countryName", (Object)info.englishName).put("countryCode", (Object)info.code).put("phoneCode", (Object)info.numberCode).jsonData();
        }
        BaseJsParam result = TextUtils.isEmpty((CharSequence)data) ? BaseJsParam.errorParam((int)code, (String)msg) : BaseJsParam.codeParam((int)code, (String)data);
        callback.callJs((IJsParam)result);
    }
}

