/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.ui;

import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.login.base.LoginGuideCallbackSimple;
import com.yy.hiyo.login.base.LoginGuideDialogCallback;
import com.yy.hiyo.login.base.utils.GuestLoginUtils;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;

public class OpenLoginDialogJsEvent
implements JsEvent {
    @NonNull
    public JsMethod method() {
        return JsEventDefine.UI.openLoginDialog;
    }

    public void jsCall(final @NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            this.onError(callback, 0, "paramJson is null");
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                OpenLoginDialogJsEvent.this.handleEvent(webHandler, param, callback);
            }
        });
    }

    private void handleEvent(@NonNull IWebBusinessHandler webHandler, @NonNull String param, final @Nullable IJsEventCallback callback) {
        try {
            final Param p = (Param)JsonParser.parseJsonObject((String)param, Param.class);
            if (p == null) {
                this.onError(callback, 0, "paramJson is illegal");
                return;
            }
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    OpenLoginDialogJsEvent.this.showLoginDialog(p, callback);
                }
            });
        }
        catch (Exception e) {
            this.onError(callback, 0, "paramJson error");
        }
    }

    private void showLoginDialog(Param param, final @Nullable IJsEventCallback callback) {
        Bundle bundle = new Bundle();
        if (param.showStyle != -1) {
            bundle.putInt("type_from_key", param.showStyle);
        } else {
            bundle.putString("login_tips", param.tips);
            bundle.putString("login_icon_url", param.iconUrl);
        }
        bundle.putInt("type_from_key", 14);
        if (!TextUtils.isEmpty((CharSequence)param.from)) {
            bundle.putString("h5_type_from_key", param.from);
        }
        LoginGuideCallbackSimple callbackSimple = new LoginGuideCallbackSimple(){

            public void onSuccess() {
                super.onSuccess();
                if (callback != null) {
                    callback.callJs((IJsParam)BaseJsParam.codeParam((int)1, (String)"success"));
                }
            }

            public void onCancel() {
                super.onCancel();
                if (callback != null) {
                    callback.callJs((IJsParam)BaseJsParam.codeParam((int)2, (String)"cancel"));
                }
            }

            public void onError(String errorCode, String des) {
                super.onError(errorCode, des);
                if (callback != null) {
                    callback.callJs((IJsParam)BaseJsParam.codeParam((int)0, (String)("fail errorCode: " + errorCode + "; des" + des)));
                }
            }
        };
        GuestLoginUtils.showLoginGuide((Bundle)bundle, (LoginGuideDialogCallback)callbackSimple);
    }

    private void onError(@Nullable IJsEventCallback callback, int code, String msg) {
        if (callback != null) {
            BaseJsParam err = BaseJsParam.errorParam((int)code, (String)msg);
            callback.callJs((IJsParam)err);
        }
    }

    private static class Param {
        @SerializedName(value="showStyle")
        int showStyle;
        @SerializedName(value="tips")
        String tips;
        @SerializedName(value="iconUrl")
        String iconUrl;
        @SerializedName(value="from")
        String from;

        private Param() {
        }
    }
}

