/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.ui;

import android.graphics.Color;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.web.JsEventControllerCallback;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.utils.json.JsonParser;
import com.yy.webservice.WebEnvSettings;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import org.json.JSONObject;

public class OpenFullScreenWebViewJsEvent
implements JsEvent {
    private JsEventControllerCallback mCallback;

    public OpenFullScreenWebViewJsEvent(JsEventControllerCallback callback) {
        this.mCallback = callback;
    }

    @NonNull
    public JsMethod method() {
        return JsEventDefine.UI.openFullScreenWebView;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, @NonNull String param, @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        this.handleEvent(webHandler, param, callback);
    }

    private void handleEvent(@NonNull IWebBusinessHandler webHandler, @NonNull String param, @Nullable IJsEventCallback callback) {
        block3: {
            try {
                JSONObject jsonObject = JsonParser.obtainJSONObject((String)param);
                String url = jsonObject.optString("url", "");
                int alpha = jsonObject.optInt("backgroundAlpha", 100);
                String colorStr = jsonObject.optString("backgroundColor", "#ffffff");
                int color2 = Color.parseColor((String)colorStr);
                color2 = (int)((float)alpha / 100.0f * 255.0f + 0.5f) << 24 | 0xFFFFFF & color2;
                MLog.info((Object)"OpenFullScreenWebViewJsEvent", (String)" color: %s, url: %s", (Object[])new Object[]{Integer.toHexString(color2), url});
                WebEnvSettings settings = new WebEnvSettings();
                settings.url = url;
                settings.isShowBackBtn = true;
                settings.isFullScreen = true;
                settings.disablePullRefresh = true;
                settings.usePageTitle = false;
                settings.webViewBackgroundColor = color2;
                settings.webWindowAnimator = false;
                settings.hideLastWindow = false;
                ((IWebService)this.mCallback.getService().getService(IWebService.class)).loadUrl(settings);
                if (callback != null) {
                    callback.callJs((IJsParam)BaseJsParam.successParam((String)"open full screen web view successfully"));
                }
            }
            catch (Exception e) {
                MLog.error((Object)"ShowBackBtnJsEvent", (Throwable)e);
                if (callback == null) break block3;
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
                callback.callJs((IJsParam)err);
            }
        }
    }
}

