/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.base;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.json.JsonParser;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class IsUserGuestJsEvent
implements JsEvent {
    private static final String TAG = "IsUserGuestJsEvent";

    @NonNull
    public JsMethod method() {
        return JsEventDefine.BASE.isUserGuest;
    }

    public void jsCall(final @NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        MLog.info((Object)TAG, (String)"param: %s", (Object[])new Object[]{param});
        if (TextUtils.isEmpty((CharSequence)param)) {
            this.onError(callback, 0, "paramJson is null");
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                IsUserGuestJsEvent.this.handleEvent(webHandler, param, callback);
            }
        });
    }

    private void handleEvent(@NonNull IWebBusinessHandler webHandler, @NonNull String param, final @Nullable IJsEventCallback callback) {
        try {
            final Param p = (Param)JsonParser.parseJsonObject((String)param, Param.class);
            if (p == null || FP.empty(p.uids)) {
                this.onError(callback, 0, "paramJson is illegal");
                return;
            }
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(p.uids, new OnProfileCallback(){

                public void onSuccess(int id2, final List<UserInfoKS> userInfoKSList) {
                    if (FP.empty(userInfoKSList)) {
                        IsUserGuestJsEvent.this.onError(callback, -1, "request user info error");
                    } else {
                        YYTaskExecutor.execute((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                IsUserGuestJsEvent.this.handleSuccess(p.uids, userInfoKSList, callback);
                            }
                        });
                    }
                }

                public void onFail(int id2, String msg, String response) {
                    IsUserGuestJsEvent.this.onError(callback, -1, "request user info error, msg: " + msg + "; response: " + response);
                }

                public int id() {
                    return 0;
                }
            });
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            this.onError(callback, 0, "paramJson is illegal, exception: " + e.getMessage());
            return;
        }
    }

    private void handleSuccess(List<Long> uids, List<UserInfoKS> userInfoKSList, @Nullable IJsEventCallback callback) {
        ArrayList<Long> copy = new ArrayList<Long>(uids);
        try {
            JSONObject jo;
            JSONArray ja = new JSONArray();
            for (UserInfoKS info : userInfoKSList) {
                if (!copy.remove(info.uid)) continue;
                jo = JsonParser.obtainJSONObject();
                jo.put("uid", info.uid);
                jo.put("result", 1);
                jo.put("resultMsg", (Object)"success");
                jo.put("isGuest", info.uid == AccountUtil.getUid() ? AccountUtil.isLoginByGuest() : info.atype == 2L);
                ja.put((Object)jo);
            }
            for (Long uid : copy) {
                jo = JsonParser.obtainJSONObject();
                jo.put("uid", (Object)uid);
                jo.put("result", 0);
                jo.put("resultMsg", (Object)"query user info fail!");
                ja.put((Object)jo);
            }
            if (callback != null) {
                callback.callJs((IJsParam)BaseJsParam.codeParam((int)1, (String)ja.toString()));
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            this.onError(callback, 0, "exception: " + e.getMessage());
        }
    }

    private void onError(@Nullable IJsEventCallback callback, int code, String msg) {
        if (callback != null) {
            BaseJsParam err = BaseJsParam.errorParam((int)code, (String)msg);
            callback.callJs((IJsParam)err);
        }
    }

    private static class Param {
        @SerializedName(value="uids")
        List<Long> uids;

        private Param() {
        }
    }
}

