/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.base;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.module.webbussiness.base.WebStorage;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import org.json.JSONException;
import org.json.JSONObject;

public class GetLocalStorageJsEvent
implements JsEvent {
    private static final String TAG = "GetLocalStorageJsEvent";

    @NonNull
    public JsMethod method() {
        return JsEventDefine.BASE.getLocalStorage;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
        if (callback == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
            callback.callJs((IJsParam)err);
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                GetLocalStorageJsEvent.this.getLocalStorage(param, callback);
            }
        });
    }

    private void getLocalStorage(@NonNull String param, IJsEventCallback callback) {
        try {
            JSONObject jo = JsonParser.obtainJSONObject((String)param);
            String key = jo.optString("key");
            String defaultValue = jo.optString("defaultValue");
            if (TextUtils.isEmpty((CharSequence)key)) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"key is empty");
                callback.callJs((IJsParam)err);
                return;
            }
            String value = WebStorage.getStorage(key, defaultValue);
            BaseJsParam.DataBuilder data = BaseJsParam.builder();
            data.put("key", (Object)key).put("value", (Object)value);
            callback.callJs((IJsParam)data.build());
        }
        catch (JSONException e) {
            MLog.error((Object)TAG, (Throwable)e);
            BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"param is illegal");
            callback.callJs((IJsParam)err);
        }
    }
}

