/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.base;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.web.JsEventControllerCallback;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.singlegame.indie.IndieGamePlayContext;
import com.yy.hiyo.game.base.teamgame.utils.GameModeSP;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.GameSelectContext;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.hiyo.game.service.bean.SameScreenPlayContext;
import com.yy.hiyo.game.service.bean.singlegame.SingleGamePlayContext;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import com.yy.webservice.webwindow.webview.WebBusinessHandlerCallback;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class DownloadGameJsEvent
implements JsEvent {
    private static final String TAG = "DownloadGameJsEvent";
    private static final int START_GAME_VALID = 1;
    private static final int START_GAME_NEED_DOWNLOAD = 2;
    private static final int START_GAME_UNFOUND = 3;
    private static final int START_GAME_UNKON_MODEL = 4;
    private final JsMethod mJsMethod;
    private final JsEventControllerCallback mControllerCallback;
    private final boolean isStartAuto;
    private IWebBusinessHandler mWebHandler;
    private GameParam mGameParam;
    private GameModel mDownLoadingGameModel;
    private WebBusinessHandlerCallback mListenerAdapter = new WebBusinessHandlerCallback(){

        public void onWebViewDestroy() {
            super.onWebViewDestroy();
            MLog.info((Object)DownloadGameJsEvent.TAG, (String)"onWebViewDestroy", (Object[])new Object[0]);
            if (DownloadGameJsEvent.this.mDownLoadingGameModel != null && DownloadGameJsEvent.this.mDownLoadingGameModel.getGameInfo() != null) {
                DownloadGameJsEvent.this.unWatchGameInfo(((DownloadGameJsEvent)DownloadGameJsEvent.this).mDownLoadingGameModel.getGameInfo().downloadInfo);
            }
            DownloadGameJsEvent.this.mDownLoadingGameModel = null;
            if (DownloadGameJsEvent.this.mWebHandler != null) {
                DownloadGameJsEvent.this.mWebHandler.addWebViewListener(null);
            }
            DownloadGameJsEvent.this.mWebHandler = null;
            DownloadGameJsEvent.this.mGameParam = null;
        }
    };

    DownloadGameJsEvent(@NonNull JsMethod method, boolean startAuto, @NonNull JsEventControllerCallback callback) {
        this.mJsMethod = method;
        this.mControllerCallback = callback;
        this.isStartAuto = startAuto;
    }

    @NonNull
    public JsMethod method() {
        return this.mJsMethod;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        this.mWebHandler = webHandler;
        this.mWebHandler.addWebViewListener(this.mListenerAdapter);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                DownloadGameJsEvent.this.downloadGameAsync(param, callback);
            }
        });
    }

    private void downloadGameAsync(String paramJson, @Nullable IJsEventCallback callback) {
        GameParam param = (GameParam)JsonParser.parseJsonObject((String)paramJson, GameParam.class);
        if (param == null) {
            MLog.error((Object)TAG, (String)"startGameAsync parse param json failed", (Object[])new Object[0]);
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"parse param json failed");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        this.downloadGame(param, callback);
    }

    private void downloadGame(GameParam param, @Nullable IJsEventCallback callback) {
        this.mGameParam = param;
        GameInfo info = ((IGameInfoService)this.mControllerCallback.getService().getService(IGameInfoService.class)).getGameInfoByGid(param.gameId);
        if (info == null) {
            MLog.error((Object)TAG, (String)"startGame can not found game info with gameId: %s", (Object[])new Object[]{param.gameId});
            this.resultCallback(callback, param.gameId, param.activityId, 3);
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if ("nativeStartGame".equals(param.oldMethod) && TextUtils.isEmpty((CharSequence)param.showResultMode) && TextUtils.isEmpty((CharSequence)param.activityId)) {
            map.put("key_show_result_mode", "2");
            map.put("key_activity", "1");
        } else {
            map.put("key_show_result_mode", param.showResultMode);
            map.put("key_activity", param.activityId);
        }
        if (!TextUtils.isEmpty((CharSequence)param.payload)) {
            map.put("js_paylod", param.payload);
        }
        if (!TextUtils.isEmpty((CharSequence)param.extra)) {
            map.put("extend_from_h5", param.extra);
        }
        map.put("h5_detail", param.openGameSource);
        map.put("game_from", GameContextDef.GameFrom.ACTIVITY_PAGE_GAME.getId());
        GameModel.Builder builder = GameModel.newBuilder().gameInfo(info).ext(map);
        this.checkForMpl(param.extend, builder, info.gid);
        GameModel gameModel = builder.build();
        if (((IGameService)this.mControllerCallback.getService().getService(IGameService.class)).isGameValid(info)) {
            this.resultCallback(callback, param.gameId, param.activityId, 1);
            if (this.isStartAuto) {
                this.internalStart(gameModel);
            }
            return;
        }
        this.resultCallback(callback, param.gameId, param.activityId, 2);
        this.mDownLoadingGameModel = gameModel;
        this.downloadGame(info);
    }

    private void resultCallback(@Nullable IJsEventCallback callback, String gameId, String activityId, int result) {
        if (callback != null) {
            BaseJsParam.DataBuilder builder = BaseJsParam.builder().put("gameId", (Object)gameId).put("result", (Object)result);
            if (!TextUtils.isEmpty((CharSequence)activityId)) {
                builder.put("activityId", (Object)activityId);
            }
            BaseJsParam param = builder.build();
            callback.callJs((IJsParam)param);
        }
    }

    private void downloadGame(GameInfo info) {
        Kvo.autoBindingTo((KvoSource)info.downloadInfo, (Object)this);
        ((IGameService)this.mControllerCallback.getService().getService(IGameService.class)).downloadGame(info, GameDownloadInfo.DownloadType.no_pause);
    }

    @KvoMethodAnnotation(name="state", sourceClass=GameDownloadInfo.class, thread=2)
    public void onState(KvoEventIntent event) {
        GameDownloadInfo info = (GameDownloadInfo)event.source();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onState gid: %s,  state: %s, type: %s", (Object[])new Object[]{info.gameId, info.getState(), info.downloadType});
        }
        if (info.getState() == GameDownloadInfo.DownloadState.download_finish) {
            if (this.mDownLoadingGameModel != null) {
                GameInfo downloadGameInfo = this.mDownLoadingGameModel.getGameInfo();
                if (this.isStartAuto && downloadGameInfo != null && StringUtils.equal((String)info.gameId, (String)downloadGameInfo.getGid())) {
                    this.internalStart(this.mDownLoadingGameModel);
                }
                this.unWatchGameInfo(info);
            }
            this.onDownloadStatus(info.gameId, info.getState().getValue(), "");
        } else if (info.getState() == GameDownloadInfo.DownloadState.download_fail) {
            String msg = StringUtils.formatWitUSLocal((String)"{\"errorCode\": %d, \"errorInfo\": %s}", (Object[])new Object[]{info.downloadErrCode, info.downloadErrInfo});
            this.onDownloadStatus(info.gameId, info.getState().getValue(), msg);
        } else if (info.getState() == GameDownloadInfo.DownloadState.downloading) {
            String msg = StringUtils.formatWitUSLocal((String)"{\"totalSize\": %d, \"curSize\": %d}", (Object[])new Object[]{info.getTotalBytes(), info.getProgress()});
            this.onDownloadStatus(info.gameId, info.getState().getValue(), msg);
        }
    }

    @KvoMethodAnnotation(name="progress", sourceClass=GameDownloadInfo.class, thread=2)
    public void onUpdateProgress(KvoEventIntent event) {
        GameDownloadInfo info = (GameDownloadInfo)event.source();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onUpdateProgress gid: %s, state: %s, cur: %s, total: %s", (Object[])new Object[]{info.gameId, info.getState(), info.getProgress(), info.getTotalBytes()});
        }
        if (info.getState() != GameDownloadInfo.DownloadState.downloading || info.downloadType == GameDownloadInfo.DownloadType.silent || info.getTotalBytes() == 0L) {
            return;
        }
        String msg = StringUtils.formatWitUSLocal((String)"{\"totalSize\": %d, \"curSize\": %d}", (Object[])new Object[]{info.getTotalBytes(), info.getProgress()});
        this.onDownloadStatus(info.gameId, info.getState().getValue(), msg);
        this.updateProgress(info);
    }

    private void onDownloadStatus(String gameId, int status, String msg) {
        if (this.mWebHandler != null) {
            BaseJsParam.DataBuilder builder = BaseJsParam.builder().put("gameId", (Object)gameId);
            if (this.mGameParam != null && !TextUtils.isEmpty((CharSequence)this.mGameParam.activityId)) {
                builder.put("activityId", (Object)this.mGameParam.activityId);
            }
            builder.put("status", (Object)status).put("msg", (Object)msg);
            this.mWebHandler.loadNotifyJs(JsEventDefine.NOTIFY.onDownloadStatus.notifyName(), builder.jsonData());
        }
    }

    private void updateProgress(GameDownloadInfo info) {
        float progress = (float)info.getProgress() / ((float)info.getTotalBytes() * 1.0f);
        if (this.mWebHandler != null) {
            BaseJsParam.DataBuilder builder = BaseJsParam.builder().put("gameId", (Object)info.gameId).put("progress", (Object)String.valueOf(progress));
            if (this.mGameParam != null && !TextUtils.isEmpty((CharSequence)this.mGameParam.activityId)) {
                builder.put("activityId", (Object)this.mGameParam.activityId);
            }
            BaseJsParam param = builder.build();
            this.mWebHandler.loadNotifyJs(JsEventDefine.NOTIFY.updateDownloadProgress.notifyName(), param.toJson());
            this.mWebHandler.loadPureJs(StringUtils.formatWitUSLocal((String)"callWebviewMethod('updateProgress', '%s')", (Object[])new Object[]{String.valueOf(progress)}));
        }
    }

    private void unWatchGameInfo(GameDownloadInfo info) {
        if (info != null) {
            Kvo.autoUnbindingFrom((KvoSource)info, (Object)this);
        }
    }

    private void internalStart(final @Nonnull GameModel gameModel) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (gameModel.getGameInfo() != null) {
                    switch (gameModel.getGameInfo().getGameMode()) {
                        case 1: {
                            DownloadGameJsEvent.this.startPk(gameModel);
                            break;
                        }
                        case 3: {
                            DownloadGameJsEvent.this.starSingle(gameModel);
                            break;
                        }
                        case 2: {
                            DownloadGameJsEvent.this.startSameScreen(gameModel);
                            break;
                        }
                        case 5: {
                            DownloadGameJsEvent.this.startPk(gameModel);
                            break;
                        }
                        case 4: {
                            DownloadGameJsEvent.this.startTeam(gameModel);
                            break;
                        }
                        case 6: {
                            DownloadGameJsEvent.this.startIndie(gameModel);
                            break;
                        }
                        case 7: {
                            DownloadGameJsEvent.this.startPk(gameModel);
                            break;
                        }
                        case 9: {
                            DownloadGameJsEvent.this.startWeGame(gameModel);
                            break;
                        }
                        default: {
                            MLog.error((Object)DownloadGameJsEvent.TAG, (String)"unknown game mode %d", (Object[])new Object[]{gameModel});
                        }
                    }
                }
            }
        });
    }

    private void startPk(GameModel gameModel) {
        if (gameModel == null) {
            MLog.error((Object)TAG, (String)"startPk gameModel == null", (Object[])new Object[0]);
            return;
        }
        GameMatchContext gameMatchContext = new GameMatchContext(GameContextDef.JoinFrom.FROM_H5);
        if (gameModel.getExt() != null) {
            gameMatchContext.addAllExtendValue(gameModel.getExt());
        }
        ((IGameCenterService)this.mControllerCallback.getService().getService(IGameCenterService.class)).matchGame(gameModel.getGameInfo(), gameMatchContext, null);
    }

    private void startTeam(GameModel gameModel) {
        if (gameModel == null || gameModel.getGameInfo() == null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalArgumentException("game info can not be null.");
            }
            return;
        }
        int multiMode = GameModeSP.getGameSelectedMode((String)gameModel.getGameInfo().gid);
        if (this.mGameParam != null && this.mGameParam.multiModelId != 0) {
            multiMode = this.mGameParam.multiModelId;
        }
        GameTeamMatchContext teamMatchContext = new GameTeamMatchContext(GameContextDef.JoinFrom.FROM_HOME);
        if (gameModel.getExt() != null) {
            teamMatchContext.addAllExtendValue(gameModel.getExt());
        }
        teamMatchContext.setGameInfo(gameModel.getGameInfo());
        teamMatchContext.setMultiModeCode(multiMode);
        ((IGameCenterService)this.mControllerCallback.getService().getService(IGameCenterService.class)).teamMatchGame(gameModel.getGameInfo(), teamMatchContext);
    }

    private void starSingle(GameModel gameModel) {
        if (gameModel == null || gameModel.getGameInfo() == null) {
            return;
        }
        GameContextDef.JoinFrom joinFrom = GameContextDef.JoinFrom.FROM_H5;
        SingleGamePlayContext playContext = new SingleGamePlayContext.Builder(joinFrom).roomId("").build();
        playContext.addAllExtendValue(gameModel.getExt());
        if (this.mGameParam.extend != null && this.mGameParam.extend.get("mpl_id") != null) {
            GameSelectContext selectContext = new GameSelectContext(GameContextDef.JoinFrom.FROM_H5);
            selectContext.addAllExtendValue(gameModel.getExt());
            ((IGameCenterService)this.mControllerCallback.getService().getService(IGameCenterService.class)).toSelectPage(selectContext, 3);
        } else {
            ((IGameCenterService)this.mControllerCallback.getService().getService(IGameCenterService.class)).joinGame(gameModel.getGameInfo(), (GamePlayContext)playContext);
        }
    }

    private void startSameScreen(GameModel gameModel) {
        if (gameModel == null || gameModel.getGameInfo() == null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalArgumentException("game info can not be null.");
            }
            return;
        }
        SameScreenPlayContext playContext = new SameScreenPlayContext(GameContextDef.JoinFrom.FROM_H5);
        if (gameModel.getExt() != null) {
            playContext.addAllExtendValue(gameModel.getExt());
        }
        ((IGameCenterService)this.mControllerCallback.getService().getService(IGameCenterService.class)).joinGame(gameModel.getGameInfo(), (GamePlayContext)playContext);
    }

    private void startIndie(GameModel gameModel) {
        if (gameModel == null || gameModel.getGameInfo() == null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalArgumentException("game info can not be null.");
            }
            return;
        }
        IndieGamePlayContext playContext = new IndieGamePlayContext.Builder(GameContextDef.JoinFrom.FROM_H5).roomId("").payload("").build();
        if (gameModel.getExt() != null) {
            playContext.addAllExtendValue(gameModel.getExt());
        }
        ((IGameCenterService)this.mControllerCallback.getService().getService(IGameCenterService.class)).joinGame(gameModel.getGameInfo(), (GamePlayContext)playContext);
    }

    private void startWeGame(GameModel gameModel) {
        GamePlayContext context = new GamePlayContext(GameContextDef.JoinFrom.FROM_H5);
        if (gameModel.getExt() != null) {
            context.addAllExtendValue(gameModel.getExt());
        }
        context.setGameInfo(gameModel.getGameInfo());
        ((IGameCenterService)this.mControllerCallback.getService().getService(IGameCenterService.class)).joinGame(gameModel.getGameInfo(), context);
    }

    private void checkForMpl(Map<String, Object> extendInfo, GameModel.Builder gameModel, String gid) {
        if (extendInfo != null) {
            String mplId = (String)extendInfo.get("mpl_id");
            Double mplPlayType = (Double)extendInfo.get("mpl_playType");
            Double awardType = (Double)extendInfo.get("mpl_award_type");
            Double awardCount = (Double)extendInfo.get("mpl_award_cost");
            if (StringUtils.isNotEmpty((String)mplId)) {
                gameModel.addExt("mpl_id", (Object)mplId);
            }
            if (mplPlayType != null) {
                gameModel.addExt("mpl_playType", (Object)mplPlayType.intValue());
            }
            if (awardCount != null) {
                gameModel.addExt("mpl_award_cost", (Object)awardCount.intValue());
            }
            if (awardType != null) {
                gameModel.addExt("mpl_award_type", (Object)awardType.intValue());
            }
            gameModel.addExt("mpl_game_id", (Object)this.mGameParam.gameId);
            if (StringUtils.isNotEmpty((String)gid) && StringUtils.isNotEmpty((String)mplId) && mplPlayType != null) {
                this.enterGame(gid, mplId, mplPlayType.intValue());
            }
        }
    }

    void enterGame(String gid, String gameRoundId, int gidType) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20033843").put("function_id", "game_in_up").put("gid", gid).put("game_round_id", gameRoundId).put("gid_type", String.valueOf(gidType)));
    }

    static class GameParam {
        @SerializedName(value="oldMethod")
        String oldMethod = "";
        @SerializedName(value="gameId")
        String gameId = "";
        @SerializedName(value="gameModel")
        int gameModel;
        @SerializedName(value="showResultMode")
        String showResultMode = "";
        @SerializedName(value="activityId")
        String activityId = "";
        @SerializedName(value="extra")
        String extra = "";
        @SerializedName(value="multiModelId")
        int multiModelId = 0;
        @SerializedName(value="extend")
        Map<String, Object> extend = new HashMap<String, Object>();
        @SerializedName(value="payload")
        String payload = "";
        @SerializedName(value="openGameSource")
        String openGameSource = "";

        GameParam() {
        }
    }
}

