/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.splash;

import android.os.Build;
import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.resource.file.ResPersistUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import downloader.Downloader;
import downloader.IDownloadCallback;
import java.io.File;
import java.lang.ref.WeakReference;

public class ConfigureSplashData {
    private static final String TAG = "ConfigureSplashData";
    @SerializedName(value="id")
    public String mId;
    @SerializedName(value="splash_id")
    public String splashId;
    @SerializedName(value="start_time")
    public long mStartTime = 0L;
    @SerializedName(value="end_time")
    public long mEndTime = 0L;
    @SerializedName(value="duration")
    public int mDuration = 0;
    @SerializedName(value="type")
    public int mType = 1;
    @SerializedName(value="can_skip")
    public int mCanSkip = 0;
    @SerializedName(value="resource_url")
    public String mResourceUrl = null;
    @SerializedName(value="action_url")
    public String mActionUrl = null;
    @SerializedName(value="game_id")
    public String gameId;
    private String mLocalFilePath;
    private WeakReference<IIconComeBack> mIconComeBack;

    public String toString() {
        return "ConfigureSplashData{mId='" + this.mId + '\'' + ", splashId='" + this.splashId + '\'' + ", mStartTime=" + this.mStartTime + ", mEndTime=" + this.mEndTime + ", mDuration=" + this.mDuration + ", mType=" + this.mType + ", mCanSkip=" + this.mCanSkip + ", mResourceUrl='" + this.mResourceUrl + '\'' + ", mActionUrl='" + this.mActionUrl + '\'' + ", gameId='" + this.gameId + '\'' + ", mLocalFilePath='" + this.mLocalFilePath + '\'' + '}';
    }

    public void setIconCallBack(IIconComeBack callBack) {
        this.mIconComeBack = new WeakReference<IIconComeBack>(callBack);
    }

    public boolean getCanSkip() {
        return this.mCanSkip == 1;
    }

    public String getLocalFilePath() {
        return this.mLocalFilePath;
    }

    public void setLocalFilePath(String mLocalFilePath) {
        if (TextUtils.isEmpty((CharSequence)mLocalFilePath)) {
            return;
        }
        this.mLocalFilePath = mLocalFilePath;
        Runnable command = new Runnable(){

            @Override
            public void run() {
                IIconComeBack comeBack;
                if (ConfigureSplashData.this.mIconComeBack != null && (comeBack = (IIconComeBack)ConfigureSplashData.this.mIconComeBack.get()) != null) {
                    comeBack.onIconComeBack(ConfigureSplashData.this);
                }
            }
        };
        if (YYTaskExecutor.isMainThread()) {
            command.run();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)command);
        }
    }

    public boolean checkSplashValid() {
        if (this.mStartTime > System.currentTimeMillis()) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"\u8d77\u59cb\u65f6\u95f4\u4e0d\u6ee1\u8db3", (Object[])new Object[0]);
            }
            return false;
        }
        if (this.mEndTime < System.currentTimeMillis()) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u6ee1\u8db3", (Object[])new Object[0]);
            }
            return false;
        }
        if (this.mDuration <= 0) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"\u95ea\u5c4f\u9875\u505c\u7559\u65f6\u95f4\u6709\u95ee\u9898", (Object[])new Object[0]);
            }
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mResourceUrl)) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"\u8d44\u6e90\u94fe\u63a5\u6709\u95ee\u9898", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    public boolean isResourceHadDownloaded() {
        if (FP.empty((CharSequence)this.mResourceUrl)) {
            return false;
        }
        String path = ResPersistUtils.fetchFilePath((ResPersistUtils.Dir)ResPersistUtils.Dir.SPLASH, (String)this.mResourceUrl);
        if (!TextUtils.isEmpty((CharSequence)path)) {
            return true;
        }
        File resourceFile = this.getSaveFile(this.mId, this.mResourceUrl);
        return resourceFile != null && resourceFile.exists() && resourceFile.length() > 0L;
    }

    public void downloadResFile() {
        if (TextUtils.isEmpty((CharSequence)this.mResourceUrl)) {
            return;
        }
        this.tryDownloadResFileIfNotExist(this.mId, this.mResourceUrl);
    }

    private void tryDownloadResFileIfNotExist(String id2, String resourceUrl) {
        MLog.info((Object)TAG, (String)"tryDownloadResFileIfNotExist id: %s, resourceUrl: %s", (Object[])new Object[]{id2, resourceUrl});
        File saveFile = this.getSaveFile(id2, resourceUrl);
        if (saveFile == null) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"get save file null", (Object[])new Object[0]);
            }
            return;
        }
        if (saveFile.exists()) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"save file exists", (Object[])new Object[0]);
            }
            return;
        }
        Downloader.Builder builder = new Downloader.Builder(resourceUrl, saveFile);
        builder.setPriority(50);
        builder.setCallBack(new IDownloadCallback(){

            public void onComplete(Downloader downloader) {
                MLog.info((Object)ConfigureSplashData.TAG, (String)"DownloadResFile success!", (Object[])new Object[0]);
            }

            public void onError(Downloader downloader, int errorType, String errorInfo) {
                MLog.error((Object)ConfigureSplashData.TAG, (String)errorInfo, (Object[])new Object[0]);
            }

            public void onProgressChange(Downloader downloader, long totalSize, long curSize) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)ConfigureSplashData.TAG, (String)"onProgressChange %d %d", (Object[])new Object[]{curSize, totalSize});
                }
            }

            public void onStart(Downloader downloader) {
                MLog.info((Object)ConfigureSplashData.TAG, (String)"DownloadResFile start!", (Object[])new Object[0]);
            }
        });
        builder.setSupportContinueTransfer(true);
        builder.build().start();
    }

    private File getSaveFile(String id2, String resourceUrl) {
        File tempDir;
        File ret = null;
        if (Build.VERSION.SDK_INT <= 21 && SettingFlags.getBoolean((String)"md5string", (boolean)true)) {
            if (StringUtils.isNotEmpty((String)id2)) {
                String file = "splashfile" + id2;
                file = FileUtils.fixFileName((String)file);
                File tempDir2 = FileStorageUtils.getInstance().getDir(false, "tmp");
                if (tempDir2 != null) {
                    if (!tempDir2.exists()) {
                        tempDir2.mkdirs();
                    }
                    ret = new File(tempDir2, file);
                }
            } else {
                String urlFixed = FileUtils.fixFileName((String)resourceUrl);
                String file = "splashfile" + urlFixed;
                File tempDir3 = FileStorageUtils.getInstance().getDir(false, "tmp");
                if (tempDir3 != null) {
                    if (!tempDir3.exists()) {
                        tempDir3.mkdirs();
                    }
                    ret = new File(tempDir3, file);
                }
            }
        } else if (!TextUtils.isEmpty((CharSequence)resourceUrl) && (tempDir = FileStorageUtils.getInstance().getDir(false, "tmp")) != null) {
            String fileName;
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
            if (!(ret = new File(tempDir, fileName = MD5Utils.getMD5String((String)resourceUrl))).exists()) {
                ret = new File(tempDir, "splashfile" + fileName);
            }
        }
        return ret;
    }

    public String getResourceFilePath() {
        String path = ResPersistUtils.fetchFilePath((ResPersistUtils.Dir)ResPersistUtils.Dir.SPLASH, (String)this.mResourceUrl);
        if (!TextUtils.isEmpty((CharSequence)path)) {
            return path;
        }
        File file = this.getSaveFile(this.mId, this.mResourceUrl);
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public static interface IIconComeBack {
        public void onIconComeBack(ConfigureSplashData var1);
    }
}

