/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.setting.privacy;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.main.R;
import com.yy.hiyo.module.setting.privacy.IPrivacyCallback;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class PrivacyWindow
extends DefaultWindow
implements View.OnClickListener {
    static final int SWITCH_ON = 1;
    static final int SWITCH_OFF = 0;
    private Context mContext;
    private IPrivacyCallback mCallback;
    private YYImageView mIvRecommendSwitch;
    private YYImageView mIvLocationSwitch;
    private YYImageView mIvRecommendDiscoverySwitch;
    private YYImageView mIvNotifyFollowed;
    private YYImageView mIvAlterPermissionWindow;
    private SimpleTitleBar mStbTitle;
    private YYLinearLayout mLlLocation;
    private YYLinearLayout mLlPermission;
    private YYLinearLayout mLlRecommendation;
    private YYLinearLayout mLlRecommendDicovery;
    private YYLinearLayout mLlNotifyFollow;
    private YYLinearLayout mLlAlterWindow;
    private View mRedPoint;
    private long mLocationStatus;
    private long mRecommendationStatus;
    private long mRecommendDiscoveryStatus;
    private long mNotifyFollowedStatus;
    private long mAlterPermissionWindowStatus;

    public PrivacyWindow(Context context, IPrivacyCallback callback) {
        super(context, (UICallBacks)callback, "Privacy");
        this.mContext = context;
        this.mCallback = callback;
        this.createView();
    }

    private void createView() {
        View rootView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.window_privacy, null);
        this.mStbTitle = (SimpleTitleBar)rootView.findViewById(R.id.stb_title);
        this.mLlLocation = (YYLinearLayout)rootView.findViewById(R.id.ll_location);
        this.mLlPermission = (YYLinearLayout)rootView.findViewById(R.id.ll_permission);
        this.mIvRecommendSwitch = (YYImageView)rootView.findViewById(R.id.recommendation_switch);
        this.mIvLocationSwitch = (YYImageView)rootView.findViewById(R.id.location_switch);
        this.mLlRecommendation = (YYLinearLayout)rootView.findViewById(R.id.ll_recommendation);
        this.mLlRecommendDicovery = (YYLinearLayout)rootView.findViewById(R.id.ll_recommendation_discover);
        this.mLlNotifyFollow = (YYLinearLayout)rootView.findViewById(R.id.ll_notify_followed);
        this.mIvNotifyFollowed = (YYImageView)rootView.findViewById(R.id.iv_notify_follow_switch);
        this.mIvAlterPermissionWindow = (YYImageView)rootView.findViewById(R.id.iv_alter_window_permission);
        this.mIvRecommendDiscoverySwitch = (YYImageView)rootView.findViewById(R.id.recommendation_discover_switch);
        this.mLlAlterWindow = (YYLinearLayout)rootView.findViewById(R.id.ll_alter_window_permission);
        this.mRedPoint = rootView.findViewById(R.id.privacy_red_point);
        this.getBaseLayer().addView(rootView);
        this.mStbTitle.setLeftTitle(ResourceUtils.getString((int)R.string.privacy));
        this.mStbTitle.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                PrivacyWindow.this.mCallback.onFinish();
            }
        });
        this.mLlLocation.setOnClickListener((View.OnClickListener)this);
        this.mLlPermission.setOnClickListener((View.OnClickListener)this);
        this.mLlRecommendation.setOnClickListener((View.OnClickListener)this);
        this.mLlRecommendDicovery.setOnClickListener((View.OnClickListener)this);
        this.mLlNotifyFollow.setOnClickListener((View.OnClickListener)this);
        this.mLlAlterWindow.setOnClickListener((View.OnClickListener)this);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026523").put("function_id", "show"));
        this.mAlterPermissionWindowStatus = SettingFlags.getBoolean((String)"key_alter_permission_window", (boolean)false) ? 1L : 0L;
        this.updateAlterWindowPermission(this.mAlterPermissionWindowStatus);
    }

    public void updateSwitchStatus(UserInfoKS userInfo) {
        if (userInfo != null) {
            this.updateLocationSwitch(userInfo.hideLocation);
            this.updateRecommendSwitch(userInfo.hideRecomm);
            this.updateRecommendDiscoverySwitch(userInfo.hn);
            this.updatetNotifyFollow(userInfo.om);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026523").put("enter_stranger_state", String.valueOf(userInfo.hn)));
        }
    }

    public void updateLocationSwitch(long status) {
        this.mLocationStatus = status;
        this.mIvLocationSwitch.setImageDrawable(ResourceUtils.getDrawable((int)(this.mLocationStatus == 1L ? R.drawable.icon_on : R.drawable.icon_off)));
    }

    public void updateRecommendSwitch(long status) {
        this.mRecommendationStatus = status;
        this.mIvRecommendSwitch.setImageDrawable(ResourceUtils.getDrawable((int)(this.mRecommendationStatus == 1L ? R.drawable.icon_on : R.drawable.icon_off)));
    }

    public void updateRecommendDiscoverySwitch(long status) {
        this.mRecommendDiscoveryStatus = status;
        this.mIvRecommendDiscoverySwitch.setImageDrawable(ResourceUtils.getDrawable((int)(this.mRecommendDiscoveryStatus == 1L ? R.drawable.icon_on : R.drawable.icon_off)));
    }

    public void setRedPointVisible(int visible) {
        if (this.mRedPoint != null) {
            this.mRedPoint.setVisibility(visible);
        }
    }

    public void updatetNotifyFollow(long status) {
        this.mNotifyFollowedStatus = status;
        this.mIvNotifyFollowed.setImageDrawable(ResourceUtils.getDrawable((int)(this.mNotifyFollowedStatus == 1L ? R.drawable.icon_on : R.drawable.icon_off)));
    }

    public void updateAlterWindowPermission(long status) {
        this.mAlterPermissionWindowStatus = status;
        this.mIvAlterPermissionWindow.setImageDrawable(ResourceUtils.getDrawable((int)(this.mAlterPermissionWindowStatus == 1L ? R.drawable.icon_on : R.drawable.icon_off)));
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.ll_location) {
            this.mLocationStatus = this.mLocationStatus == 1L ? 0L : 1L;
            this.mCallback.onLocationCheckChanged(this.mLocationStatus);
        } else if (id2 == R.id.ll_recommendation) {
            this.mRecommendationStatus = this.mRecommendationStatus == 1L ? 0L : 1L;
            this.mCallback.onFriendRecommendCheckChanged(this.mRecommendationStatus);
        } else if (id2 == R.id.ll_permission) {
            this.mCallback.onPermissionClick();
        } else if (id2 == R.id.ll_recommendation_discover) {
            this.mRecommendDiscoveryStatus = this.mRecommendDiscoveryStatus == 1L ? 0L : 1L;
            this.mCallback.onStrangersRecommendCheckChanged(this.mRecommendDiscoveryStatus);
        } else if (id2 == R.id.ll_notify_followed) {
            this.mNotifyFollowedStatus = this.mNotifyFollowedStatus == 1L ? 0L : 1L;
            this.mCallback.onNotifyFollow(this.mNotifyFollowedStatus);
        } else if (id2 == R.id.ll_alter_window_permission) {
            this.mAlterPermissionWindowStatus = this.mAlterPermissionWindowStatus == 1L ? 0L : 1L;
            SettingFlags.setBoolean((String)"key_alter_permission_window", (this.mAlterPermissionWindowStatus == 1L ? 1 : 0) != 0);
            this.updateAlterWindowPermission(this.mAlterPermissionWindowStatus);
        }
    }
}

