/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.setting.main;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.base.language.LanguageLocaleHelper;
import com.yy.hiyo.main.R;
import com.yy.hiyo.module.setting.main.ISettingCallback;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Locale;

public class SettingPage
extends YYFrameLayout {
    private Context mContext;
    private ISettingCallback mUICallbacks;
    private YYTextView mLlLogout;
    private YYTextView mSwitchAccountTv;
    private YYLinearLayout mLlAbout;
    private YYLinearLayout mLlMatchGender;
    private YYLinearLayout mLlPrivacy;
    private YYLinearLayout mLlBlackList;
    private YYLinearLayout mLLClearCache;
    private YYLinearLayout mLlNotification;
    private YYLinearLayout mLlGamePreferSetting;
    private SimpleTitleBar mStbTitleBar;
    private YYTextView mCacheSize;
    private YYTextView mSelectGender;
    private View mPrivacyRedPoint;
    private View mGamePreferSettingRedPoint;
    private View mSettingCodeRate;
    private YYLinearLayout mPwdManageLl;

    public SettingPage(Context context, ISettingCallback controller) {
        super(context);
        this.mContext = context;
        this.mUICallbacks = controller;
        this.createView();
    }

    private void createView() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_setting_pager, (ViewGroup)this);
        this.initTitle();
        this.initContentViews();
        if (LanguageLocaleHelper.canShowEntry()) {
            this.initHindiSetting();
        }
    }

    private void initTitle() {
        this.mStbTitleBar = (SimpleTitleBar)this.findViewById(R.id.stb_title_bar);
        this.mStbTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.setting));
        this.mStbTitleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                SettingPage.this.mUICallbacks.onBack();
            }
        });
    }

    public View getOffsetView() {
        return this.mStbTitleBar;
    }

    private void initContentViews() {
        this.mLlMatchGender = (YYLinearLayout)this.findViewById(R.id.ll_match_gender);
        this.mSelectGender = (YYTextView)this.findViewById(R.id.tv_match_gender);
        this.mLlAbout = (YYLinearLayout)this.findViewById(R.id.ll_about);
        this.mLlLogout = (YYTextView)this.findViewById(R.id.ll_logout);
        this.mLlPrivacy = (YYLinearLayout)this.findViewById(R.id.ll_privacy);
        this.mLlBlackList = (YYLinearLayout)this.findViewById(R.id.ll_black_list);
        this.mLLClearCache = (YYLinearLayout)this.findViewById(R.id.ll_clear_cache);
        this.mLlNotification = (YYLinearLayout)this.findViewById(R.id.ll_notification);
        this.mCacheSize = (YYTextView)this.findViewById(R.id.tv_cache_size);
        this.mPrivacyRedPoint = this.findViewById(R.id.setting_privacy_red_point);
        this.mSwitchAccountTv = (YYTextView)this.findViewById(R.id.tvSwitchAccount);
        this.mPwdManageLl = (YYLinearLayout)this.findViewById(R.id.ll_pwd_manage);
        this.mSwitchAccountTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SettingPage.this.mUICallbacks.onAccountSwitchClick();
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("click_source", "14").put("function_id", "set_switch_click"));
            }
        });
        this.mLlMatchGender.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SettingPage.this.mUICallbacks.onMatchGenderClick();
            }
        });
        this.mLlLogout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SettingPage.this.mUICallbacks.onSignOutClick();
            }
        });
        this.mLlAbout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SettingPage.this.mUICallbacks.onAboutClick();
            }
        });
        this.mLlBlackList.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SettingPage.this.mUICallbacks.onBlackListClick();
            }
        });
        this.mLlPrivacy.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SettingPage.this.mUICallbacks.onPrivacyClick();
            }
        });
        this.mLlNotification.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SettingPage.this.mUICallbacks.onNotificationSwitchClick();
            }
        });
        this.mLLClearCache.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SettingPage.this.mUICallbacks.onClearClick();
            }
        });
        this.mPwdManageLl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SettingPage.this.mUICallbacks.onPasswordManageClick();
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "password_manager_click"));
            }
        });
        this.mSettingCodeRate = this.findViewById(R.id.llCodeRate);
        this.mSettingCodeRate.setOnClickListener(v -> this.mUICallbacks.showCodeRateDialog());
    }

    private boolean isGamePreferRedPointShow() {
        return this.mGamePreferSettingRedPoint.getVisibility() == 0;
    }

    private void initHindiSetting() {
        View itemView = this.findViewById(R.id.ll_set_language);
        itemView.setVisibility(0);
        itemView.setOnClickListener(v -> {
            this.mUICallbacks.onChangeLanguageClick();
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("click_source", "11").put("function_id", "in_lang_click"));
        });
        TextView languageTextView = (TextView)this.findViewById(R.id.current_language);
        languageTextView.setText((CharSequence)Locale.getDefault().getDisplayLanguage());
    }

    public void updateCacheSize(String cacheSize) {
        this.mCacheSize.setText((CharSequence)cacheSize);
    }

    public void updateLoginAccountState() {
        if (AccountUtil.isLoginByGuest()) {
            this.mLlLogout.setVisibility(8);
            this.mSwitchAccountTv.setVisibility(8);
        } else {
            this.mLlLogout.setVisibility(0);
            this.mSwitchAccountTv.setVisibility(0);
        }
        AccountInfo accountInfo = AccountModel.getInstance().getAccountInfo();
        if (accountInfo != null && accountInfo.showPwdManage()) {
            this.mPwdManageLl.setVisibility(0);
        } else {
            this.mPwdManageLl.setVisibility(8);
        }
    }

    public void setMatchGenderVisible(int visible) {
        if (this.mLlMatchGender != null) {
            this.mLlMatchGender.setVisibility(visible);
        }
    }

    public void setPrivacyRedPoint(int visible) {
        if (this.mPrivacyRedPoint != null) {
            this.mPrivacyRedPoint.setVisibility(visible);
        }
    }

    public void updateSelectGender(int sexResourceId) {
        if (this.mSelectGender != null) {
            this.mSelectGender.setText(this.getResources().getText(sexResourceId));
        }
    }

    public void showCodeRateSetting() {
        this.mSettingCodeRate.setVisibility(0);
    }
}

