/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.setting.envsetting.perf;

import android.content.Context;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.http.HttpUtil;
import com.yy.base.env.ConstDef;
import com.yy.base.env.RuntimeContext;
import com.yy.base.fdutils.FdsController;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.Response;
import com.yy.hiyo.module.setting.envsetting.perf.PerfActionHelper;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/yy/hiyo/module/setting/envsetting/perf/PerfActionHelper;", "", "()V", "API", "", "PERF_ACTION_LOGS", "TAG", "getPerfActionLogsPath", "uploadFDTrace", "", "uploadTaskTrace", "uploadToFileManagerServer", "type", "filePath", "main_googlePlayBillDebug"})
public final class PerfActionHelper {
    private static final String TAG = "PerfActionHelper";
    private static final String PERF_ACTION_LOGS = "PerfActionLog.txt";
    private static final String API = "http://172.25.41.25:5000/api/file/upload";
    public static final PerfActionHelper INSTANCE;

    private final String getPerfActionLogsPath() {
        StringBuilder stringBuilder = new StringBuilder();
        File file = FileStorageUtils.getInstance().getDirAndCreate(true, ConstDef.LOG_DIR);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileStorageUtils.getInst\u2026e(true, ConstDef.LOG_DIR)");
        return stringBuilder.append(file.getAbsolutePath()).append(File.separator).append(PERF_ACTION_LOGS).toString();
    }

    private final void uploadToFileManagerServer(String type2, String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            throw (Throwable)new RuntimeException("file not exist::" + filePath);
        }
        MLog.error((Object)TAG, (String)("\u4e0a\u62a5: " + filePath + ", size:%d"), (Object[])new Object[]{file.length()});
        Map partMap = MapsKt.mapOf((Pair[])new Pair[]{new Pair((Object)"type", (Object)type2), new Pair((Object)"uid", (Object)String.valueOf(AccountUtil.getUid()))});
        HttpUtil.postFile().url(API).parts(partMap).file(file, "file", PERF_ACTION_LOGS, "application/octet-stream").execute((Callback)new Callback<String>(){

            public void onResponse(@Nullable Call<String> call, @Nullable Response<String> res) {
                Response<String> response = res;
                String result = response != null ? (String)response.body() : null;
                JSONObject json = JsonParser.obtainJSONObject((String)result);
                MLog.debug((Object)"PerfActionHelper", (String)("upload ret: " + result), (Object[])new Object[0]);
                int code = json.optInt("code");
                String msg = json.optString("msg");
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)msg, (int)0);
            }

            public void onFailure(@Nullable Call<String> call, @Nullable Throwable e) {
                Throwable throwable = e;
                MLog.error((Object)"PerfActionHelper", (String)("\u4e0a\u62a5\u5931\u8d25: " + (throwable != null ? throwable.getMessage() : null)), (Object[])new Object[0]);
            }
        });
    }

    public final void uploadTaskTrace() {
        this.uploadToFileManagerServer("task_trace", this.getPerfActionLogsPath());
    }

    public final void uploadFDTrace() {
        FdsController.getFilesDetailInfoAndSave((FdsController.CallBack)uploadFDTrace.1.INSTANCE);
    }

    private PerfActionHelper() {
    }

    static {
        PerfActionHelper perfActionHelper;
        INSTANCE = perfActionHelper = new PerfActionHelper();
    }

    public static final /* synthetic */ void access$uploadToFileManagerServer(PerfActionHelper $this, String type2, String filePath) {
        $this.uploadToFileManagerServer(type2, filePath);
    }
}

