/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.setting.envsetting;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Message;
import com.yy.appbase.abtest.ABTestManager;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.http.SimpleNetRespCallback;
import com.yy.appbase.http.SimpleNetStringRespCallback;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkDialog;
import com.yy.appbase.ui.dialog.OkDialogListener;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.IControllerRegister;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.SkipDialogKt;
import com.yy.hiyo.game.GameBaseMsgDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.home.base.HomeBaseMsgDef;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.hiyo.module.push.localpush.LocalPushManager;
import com.yy.hiyo.module.setting.envsetting.DebugEnvSettingWindow;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.FileSelectWindow;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.ILogControllerCallBack;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.LogAnalyseMainWindow;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.LogDetailWindow;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.data.LogItem;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.webservice.WebEnvSettings;
import com.yy.yylite.commonbase.crash.CrashSdk;
import okhttp3.Call;

public class DebugEnvSettingController
extends DefaultWindowController
implements ILogControllerCallBack {
    private static final String TAG = "DebugEnvSettingController";
    private EnvSettingType mUriSetting = EnvSettings.instance().getUriSettingValue();
    private DebugEnvSettingWindow mWindow;
    private LogAnalyseMainWindow mAnalyseMainWindow;
    private FileSelectWindow mFileSelectWindow;
    private LogDetailWindow mLogDetailWindow;

    public DebugEnvSettingController(Environment env) {
        super(env);
    }

    public static void registerEnvSettingController(IControllerRegister register) {
        int[] messageIds = new int[]{MsgDef.SHOW_ENV_SETTINGS_WINDOW};
        int[] notificationIds = new int[]{};
        register.registerController(messageIds, notificationIds, DebugEnvSettingController.class, DebugEnvSettingController::new);
    }

    public void handleMessage(Message msg) {
        if (msg == null) {
            return;
        }
        if (msg.what == MsgDef.SHOW_ENV_SETTINGS_WINDOW) {
            if (this.mWindow == null) {
                this.mWindow = new DebugEnvSettingWindow(this.mContext, (UICallBacks)this);
            }
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
        }
    }

    public void onWindowDetach(AbstractWindow window) {
        if (window == this.mWindow) {
            this.mWindow = null;
        } else if (window == this.mAnalyseMainWindow) {
            this.mAnalyseMainWindow = null;
        } else if (window == this.mFileSelectWindow) {
            this.mFileSelectWindow = null;
        } else if (window == this.mLogDetailWindow) {
            this.mLogDetailWindow = null;
        }
    }

    public void finish() {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            this.mWindow = null;
        }
    }

    public void onSkipDialogSelect(boolean select) {
        SkipDialogKt.setSkipDialog((boolean)select);
    }

    public void onUriSettingSelect(EnvSettingType type2) {
        if (type2 == EnvSettings.instance().getUriSettingValue()) {
            return;
        }
        switch (type2) {
            case Dev: {
                this.mUriSetting = EnvSettingType.Dev;
                break;
            }
            case Product: {
                this.mUriSetting = EnvSettingType.Product;
                break;
            }
            case Test: {
                this.mUriSetting = EnvSettingType.Test;
                break;
            }
        }
        ProtoManager.sNeedCheckToken = false;
        this.mDialogLinkManager.showDialog((BaseDialog)new OkDialog((CharSequence)"\u5207\u6362\u73af\u5883\uff0c\u4f1a\u5220\u9664\u6240\u6709\u65e7\u7684\u6e38\u620f\u5305\uff0c\u7136\u540e\u9000\u51faapp!", true, new OkDialogListener(){

            public void onOk() {
                DebugEnvSettingController.this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog());
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.info((Object)"EnvSetting", (String)"onUriSettingSelect", (Object[])new Object[0]);
                        EnvSettings.instance().setUriEnvSettingValue(DebugEnvSettingController.this.mUriSetting);
                        ((IGameService)ServiceManagerProxy.getService(IGameService.class)).deleteAllGameDebug();
                        FileStorageUtils.getInstance().clearRootDirByChangeEnvSetting();
                        LocalPushManager.INSTANCE.clearData();
                        DebugEnvSettingController.this.sendMessage(MsgDef.LOGIN_OUT, 20, -1, null);
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AccountModel.getInstance().onEnvChanged();
                            }
                        });
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                DebugEnvSettingController.this.mDialogLinkManager.dismissDialog();
                                DebugEnvSettingController.this.sendMessageSync(BaseMsgDef.APP_EXIT);
                            }
                        }, (long)3000L);
                    }
                });
            }
        }));
    }

    public void onTodayRegisteredSelect(boolean value) {
        if (value == EnvSettings.instance().isTodayRegisteredTest()) {
            return;
        }
        EnvSettings.instance().setTodayRegistered(value);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                DebugEnvSettingController.this.sendMessageSync(BaseMsgDef.APP_EXIT);
            }
        }, (long)1000L);
    }

    public EnvSettingType getSettingType() {
        return EnvSettings.instance().getUriSettingValue();
    }

    public void onGameDownloadUriSettingSelect(EnvSettingType type2) {
        if (type2 == EnvSettings.instance().getGameDownloadUriSettingValue()) {
            return;
        }
        EnvSettings.instance().setGameDownloadUriEnvSettingValue(type2);
    }

    public EnvSettingType getGameDownloadSettingType() {
        return EnvSettings.instance().getGameDownloadUriSettingValue();
    }

    public void openWebUrl(String url, boolean useYYJs) {
        if (StringUtils.isNotEmpty((String)url)) {
            if (url.startsWith("olaparty://")) {
                ((IYYUriService)this.getServiceManager().getService(IYYUriService.class)).handleUriString(url);
            } else if (url.startsWith("http") || url.startsWith("file://")) {
                WebEnvSettings s = new WebEnvSettings();
                s.url = url;
                s.useYYJsInterface = useYYJs;
                ((IWebService)this.getServiceManager().getService(IWebService.class)).loadUrl(s);
            } else {
                WebEnvSettings s = new WebEnvSettings();
                s.url = "http://" + url;
                s.useYYJsInterface = useYYJs;
                ((IWebService)this.getServiceManager().getService(IWebService.class)).loadUrl(s);
            }
        } else {
            ToastUtils.showToast((Context)this.mContext, (String)"url \u4e3a\u7a7a\uff0c\u8bf7\u8f93\u5165\u540e\u518d\u6253\u5f00", (int)0);
        }
    }

    public void gameSetting() {
        this.sendMessage(GameBaseMsgDef.SHOW_ENV_GAME_WINDOW);
    }

    public void back() {
        this.mWindowMgr.popWindow(true);
    }

    public void testCrash(int type2) {
        if (type2 == 0) {
            CrashSdk.INSTANCE.testJavaCrash();
        } else if (type2 == 1) {
            CrashSdk.INSTANCE.testNativeCrash();
        }
    }

    public boolean getHiidoEnv() {
        return EnvSettings.instance().getHiidoEnv();
    }

    public void onHiidoEnvChange(boolean isOpen) {
        EnvSettings.instance().setHiidoEnv(isOpen);
    }

    public int getWebUrlReplace() {
        return EnvSettings.instance().getWebUrlReplace();
    }

    public void setWebUrlReplace(int type2) {
        EnvSettings.instance().setWebUrlReplace(type2);
    }

    public boolean getAbTestEnv() {
        return EnvSettings.instance().getAbTestEnv();
    }

    public void onAbTestEnvChange(boolean isOpen) {
        EnvSettings.instance().setAbTestEnv(isOpen);
        ABTestManager.getInstance().clear();
    }

    public boolean getHomeDataEnv() {
        if (!EnvSettings.instance().enableEnvSettingChange()) {
            return false;
        }
        return SettingFlags.getBoolean((String)"ENV_HOME_DATA", (boolean)false);
    }

    public void onHomeDataEnvChange(boolean isOpen) {
        if (!EnvSettings.instance().enableEnvSettingChange()) {
            return;
        }
        SettingFlags.setBoolean((String)"ENV_HOME_DATA", (boolean)isOpen);
        MsgDispatcher.getInstance().sendMessage(HomeBaseMsgDef.getENV_HOME_DATA_CHANGED(), (Object)isOpen);
    }

    @Override
    public UICallBacks getUICallBacks() {
        return this;
    }

    @Override
    public void onBackIconClicked(AbstractWindow window) {
        this.mWindowMgr.popWindow(true, window);
    }

    @Override
    public void openLogAnalyseWindow() {
        this.mFileSelectWindow = new FileSelectWindow(this.mContext, this);
        this.mWindowMgr.pushWindow((AbstractWindow)this.mFileSelectWindow, true);
    }

    @Override
    public void openLogAnalyseMainWindow() {
        this.mAnalyseMainWindow = new LogAnalyseMainWindow(this.mContext, (UICallBacks)this, this);
        this.mWindowMgr.pushWindow((AbstractWindow)this.mAnalyseMainWindow, true);
    }

    @Override
    public void openLogDetail(LogItem item) {
        this.mLogDetailWindow = new LogDetailWindow(this.mContext, this, item);
        this.mWindowMgr.pushWindow((AbstractWindow)this.mLogDetailWindow, true);
    }

    public void clearHdid(String hdid) {
        HttpUtil.get().url("https://i-test-863.kaixindou.net/activity/inviteFriend/deleteDevice?mockUid=101285329&data=" + hdid).execute((INetRespCallback)new SimpleNetStringRespCallback("clearHdid" + hdid){

            public void onError(Call call, Exception e, int id2) {
                super.onError(call, e, id2);
                ToastUtils.showToast((Context)DebugEnvSettingController.this.mContext, (String)"\u6e05\u9664\u5931\u8d25:(", (int)0);
            }

            public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                super.onResponse(response, res, id2);
                ToastUtils.showToast((Context)DebugEnvSettingController.this.mContext, (String)"\u6e05\u9664\u6210\u529f:(", (int)0);
            }
        });
    }

    public void clearOffcialHdid(final String hdid) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setTitle((CharSequence)"\u9009\u62e9\u56fd\u5bb6");
        CharSequence[] items = new String[]{"\u5370\u5c3c", "\u5370\u5ea6", "\u5df4\u897f", "\u4fc4\u7f57\u65af", "\u65b0\u52a0\u5761", "\u7f8e\u56fd", "\u8fea\u62dc"};
        builder.setSingleChoiceItems(items, -1, new DialogInterface.OnClickListener((String[])items){
            final /* synthetic */ String[] val$items;
            {
                this.val$items = stringArray;
            }

            public void onClick(DialogInterface dialog, int which) {
                switch (which) {
                    case 0: {
                        DebugEnvSettingController.this.clearOfficialHdidWithConCode(hdid, 863, this.val$items[which]);
                        break;
                    }
                    case 1: {
                        DebugEnvSettingController.this.clearOfficialHdidWithConCode(hdid, 875, this.val$items[which]);
                        break;
                    }
                    case 2: {
                        DebugEnvSettingController.this.clearOfficialHdidWithConCode(hdid, 889, this.val$items[which]);
                        break;
                    }
                    case 3: {
                        DebugEnvSettingController.this.clearOfficialHdidWithConCode(hdid, 892, this.val$items[which]);
                        break;
                    }
                    case 4: {
                        DebugEnvSettingController.this.clearOfficialHdidWithConCode(hdid, 881, this.val$items[which]);
                        break;
                    }
                    case 5: {
                        DebugEnvSettingController.this.clearOfficialHdidWithConCode(hdid, 872, this.val$items[which]);
                        break;
                    }
                    case 6: {
                        DebugEnvSettingController.this.clearOfficialHdidWithConCode(hdid, 894, this.val$items[which]);
                        break;
                    }
                }
                dialog.dismiss();
            }
        });
        builder.show();
    }

    public void clearOfficialHdidWithConCode(String hdid, final int conCode, final String conName) {
        String url = "https://i-" + conCode + ".kaixindou.net/activity/inviteFriend/deleteDevice?data={\"dev\":\"" + hdid + "\"}";
        HttpUtil.get().url(url).execute((INetRespCallback)new SimpleNetRespCallback<String>("clearOffcialHdidWithConCode_" + hdid + "_" + conCode){

            public void onError(Call call, Exception e, int id2) {
                super.onError(call, e, id2);
                ToastUtils.showToast((Context)DebugEnvSettingController.this.mContext, (String)(conName + conCode + "\uff1a\u6e05\u9664\u5931\u8d25:("), (int)0);
            }

            public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                super.onResponse(response, res, id2);
                ToastUtils.showToast((Context)DebugEnvSettingController.this.mContext, (String)(conName + conCode + "\uff1a\u6e05\u9664\u6210\u529f:("), (int)0);
            }
        });
    }

    protected void jumpToUri(String uri) {
        ((IYYUriService)this.getServiceManager().getService(IYYUriService.class)).handleUriString(uri);
    }

    protected void jumpToGame(final String gameId) {
        if (StringUtils.isNotEmpty((String)gameId)) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    final GameInfo jumpGameInfo = ((IGameInfoService)DebugEnvSettingController.this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
                    if (jumpGameInfo == null) {
                        ToastUtils.showToast((Context)DebugEnvSettingController.this.mContext, (String)"\u65e0\u6b64\u6e38\u620f", (int)0);
                        MLog.error((Object)DebugEnvSettingController.TAG, (String)"jumpToGame gameInfo:%s is null!!!", (Object[])new Object[]{gameId});
                        return;
                    }
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            boolean isGameValid;
                            boolean bl = isGameValid = jumpGameInfo != null && ((IGameService)DebugEnvSettingController.this.getServiceManager().getService(IGameService.class)).isGameValid(jumpGameInfo);
                            if (isGameValid) {
                                DebugEnvSettingController.this.jumpToGameMsg(gameId);
                            } else {
                                ToastUtils.showToast((Context)DebugEnvSettingController.this.mContext, (String)"\u6e38\u620f\u672a\u4e0b\u8f7d\u5b8c\u6210", (int)0);
                                ((IGameService)DebugEnvSettingController.this.getServiceManager().getService(IGameService.class)).downloadGame(jumpGameInfo);
                                MsgDispatcher.getInstance().sendMessage(BaseMsgDef.MSG_GO_TO_HOME_PAGE, (Object)(jumpGameInfo != null ? jumpGameInfo.gid : ""));
                            }
                        }
                    });
                }
            });
        }
    }

    private void jumpToGameMsg(String gameId) {
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.MSG_GAME_JUMP_MAIN_PAGE;
        msg.obj = gameId;
        Bundle bundle = new Bundle();
        msg.setData(bundle);
        this.sendMessage(msg);
    }
}

