/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.network;

import android.content.Context;
import android.os.SystemClock;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.HttpUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.module.performancemonitor.perfcollect.network.ErrorTimesJudger;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class RegisterHostSwitcher {
    private static final String TAG = "RegisterHostSwitcher";
    private IQueueTaskExecutor mTaskExecutor;
    private boolean mHasJudged = false;
    private long mLastJudgeTime = -1L;
    private Runnable mCheckOriginServerIsOk = null;
    private MyRunnable mHandleNetErrorRunnable = null;
    private long mLastSwitchToBackTime = -1L;
    private long mLastCheckServer = -1L;
    private ErrorTimesJudger mErrorTimesJudger;

    public void init() {
        if (AccountUtil.getUid() > 0L && !ProtoManager.getInstance().isWSConnected()) {
            this.onNetError("not connect", ProtoManager.getInstance().getCurWSURL(), true);
        }
    }

    public void onLoginOut() {
        if (!UriProvider.isUseRegisterHostBackUpWs() && !UriProvider.isUseRegisterHostBackUpNormal()) {
            return;
        }
        this.mLastSwitchToBackTime = -1L;
        UriProvider.switchToRegisterHostOrigin((boolean)true, (boolean)true);
    }

    private IQueueTaskExecutor getTaskExecutor() {
        if (this.mTaskExecutor == null) {
            this.mTaskExecutor = YYTaskExecutor.createAQueueExcuter();
        }
        return this.mTaskExecutor;
    }

    public void onNetError(final String error, final String url, final boolean wsError) {
        if (StringUtils.isEmpty((String)url) || AccountUtil.getUid() <= 0L) {
            return;
        }
        if (!SettingFlags.getBoolean((String)"openserverproxy", (boolean)true)) {
            return;
        }
        this.getTaskExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String registerHostOrigin = UriProvider.getRegisterHostOrigin();
                String registerHostBackUp = UriProvider.getRegisterHostBackUp();
                if (StringUtils.isEmpty((String)registerHostOrigin) || StringUtils.isEmpty((String)registerHostBackUp)) {
                    return;
                }
                if (!url.contains(registerHostOrigin) && !url.contains(registerHostBackUp)) {
                    return;
                }
                if (!NetworkUtils.isNetworkStrictlyAvailable((Context)RuntimeContext.sApplicationContext)) {
                    return;
                }
                if (!RegisterHostSwitcher.this.mHasJudged) {
                    RegisterHostSwitcher.this.handleNetError(error, url, wsError);
                } else {
                    if (RegisterHostSwitcher.this.mHandleNetErrorRunnable == null) {
                        RegisterHostSwitcher.this.mHandleNetErrorRunnable = new MyRunnable(error, url, wsError);
                    } else {
                        RegisterHostSwitcher.this.mHandleNetErrorRunnable.update(error, url, wsError);
                    }
                    long gap = SystemClock.elapsedRealtime() - RegisterHostSwitcher.this.mLastJudgeTime;
                    if (gap > 5000L) {
                        YYTaskExecutor.removeRunnableFromMainThread((Runnable)RegisterHostSwitcher.this.mHandleNetErrorRunnable);
                        RegisterHostSwitcher.this.handleNetError(error, url, wsError);
                    } else if (gap > 0L) {
                        YYTaskExecutor.removeTask((Runnable)RegisterHostSwitcher.this.mHandleNetErrorRunnable);
                        YYTaskExecutor.postToMainThread((Runnable)RegisterHostSwitcher.this.mHandleNetErrorRunnable, (long)gap);
                    }
                }
            }
        }, 0L);
    }

    private void handleNetError(String error, String url, boolean wsError) {
        if (!NetworkUtils.isNetworkStrictlyAvailable((Context)RuntimeContext.sApplicationContext)) {
            return;
        }
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        if (!RuntimeContext.sIsForeground) {
            return;
        }
        boolean isRegisterHostError = false;
        boolean isRegisterHostBackUpError = false;
        String registerHostOrigin = UriProvider.getRegisterHostOrigin();
        String registerHostBackUp = UriProvider.getRegisterHostBackUp();
        if (StringUtils.isEmpty((String)registerHostOrigin) || StringUtils.isEmpty((String)registerHostBackUp)) {
            return;
        }
        if (wsError) {
            if (url.startsWith("ws://" + registerHostOrigin)) {
                isRegisterHostError = true;
            } else if (url.startsWith("ws://" + registerHostBackUp)) {
                isRegisterHostBackUpError = true;
            } else if (url.startsWith("https://" + registerHostOrigin)) {
                isRegisterHostError = true;
            } else if (url.startsWith("http://" + registerHostOrigin)) {
                isRegisterHostError = true;
            } else if (url.startsWith("https://" + registerHostBackUp)) {
                isRegisterHostBackUpError = true;
            } else if (url.startsWith("http://" + registerHostBackUp)) {
                isRegisterHostBackUpError = true;
            }
        } else if (url.startsWith("https://" + registerHostOrigin)) {
            isRegisterHostError = true;
        } else if (url.startsWith("http://" + registerHostOrigin)) {
            isRegisterHostError = true;
        } else if (url.startsWith("https://" + registerHostBackUp)) {
            isRegisterHostBackUpError = true;
        } else if (url.startsWith("http://" + registerHostBackUp)) {
            isRegisterHostBackUpError = true;
        }
        if (isRegisterHostError && wsError && UriProvider.isUseRegisterHostBackUpWs()) {
            return;
        }
        if (isRegisterHostError && !wsError && UriProvider.isUseRegisterHostBackUpNormal()) {
            return;
        }
        if (isRegisterHostError && UriProvider.isUseRegisterHostBackUpNormal() && UriProvider.isUseRegisterHostBackUpWs()) {
            return;
        }
        if (isRegisterHostBackUpError && wsError && !UriProvider.isUseRegisterHostBackUpWs()) {
            return;
        }
        if (isRegisterHostBackUpError && !wsError && !UriProvider.isUseRegisterHostBackUpNormal()) {
            return;
        }
        if (isRegisterHostBackUpError && !UriProvider.isUseRegisterHostBackUpNormal() && !UriProvider.isUseRegisterHostBackUpWs()) {
            return;
        }
        MLog.info((Object)TAG, (String)"onNetError %s isRegisterHostError:%s isRegisterHostBackUpError:%s", (Object[])new Object[]{url, String.valueOf(isRegisterHostError), String.valueOf(isRegisterHostBackUpError)});
        if (isRegisterHostError) {
            if (this.needSwitch(registerHostOrigin, registerHostBackUp, url, wsError)) {
                this.mLastSwitchToBackTime = SystemClock.uptimeMillis();
                UriProvider.switchToRegisterHostBackUp((!ProtoManager.getInstance().isWSConnected() || wsError ? 1 : 0) != 0, (boolean)true);
                if (this.mCheckOriginServerIsOk == null) {
                    this.initCheckOriginServerIsOkRunnable();
                } else {
                    YYTaskExecutor.removeTask((Runnable)this.mCheckOriginServerIsOk);
                }
                this.checkOriginServerIsOk();
                RegisterHostSwitcher.reportAppMonitorReturnCode("mainserverproxy/" + registerHostBackUp, -1L, "1");
                MLog.info((Object)TAG, (String)"switchToRegisterHostBackUp ws:%s!", (Object[])new Object[]{String.valueOf(UriProvider.isUseRegisterHostBackUpWs())});
            } else {
                RegisterHostSwitcher.reportAppMonitorReturnCode("mainserverproxy/" + registerHostOrigin, this.mLastCheckServer > 0L ? SystemClock.uptimeMillis() - this.mLastCheckServer : -1L, "0");
            }
            this.mLastCheckServer = SystemClock.uptimeMillis();
        } else if (isRegisterHostBackUpError) {
            if (this.needSwitch(registerHostBackUp, registerHostOrigin, url, wsError)) {
                UriProvider.switchToRegisterHostOrigin((!ProtoManager.getInstance().isWSConnected() || wsError ? 1 : 0) != 0, (boolean)true);
                if (this.mCheckOriginServerIsOk != null) {
                    YYTaskExecutor.removeTask((Runnable)this.mCheckOriginServerIsOk);
                }
                RegisterHostSwitcher.reportAppMonitorReturnCode("mainserverorigin/" + registerHostOrigin, this.mLastSwitchToBackTime > 0L ? SystemClock.uptimeMillis() - this.mLastSwitchToBackTime : -1L, "1");
                this.mLastSwitchToBackTime = -1L;
                MLog.info((Object)TAG, (String)"switchToRegisterHostOrigin ws:%s!", (Object[])new Object[]{String.valueOf(UriProvider.isUseRegisterHostBackUpWs())});
            } else {
                RegisterHostSwitcher.reportAppMonitorReturnCode("mainserverorigin/" + registerHostOrigin, this.mLastCheckServer > 0L ? SystemClock.uptimeMillis() - this.mLastCheckServer : -1L, "0");
            }
            this.mLastCheckServer = SystemClock.uptimeMillis();
        }
        this.mLastJudgeTime = SystemClock.elapsedRealtime();
        this.mHasJudged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needSwitch(String errorHost, String backHost, String url, boolean wsError) {
        if (2 == SettingFlags.getIntValue((String)"proxyjudgetype", (int)1)) {
            RegisterHostSwitcher registerHostSwitcher = this;
            synchronized (registerHostSwitcher) {
                if (this.mErrorTimesJudger == null) {
                    this.mErrorTimesJudger = new ErrorTimesJudger();
                }
                if (!wsError) {
                    this.mErrorTimesJudger.deleteItem(url);
                }
                this.mErrorTimesJudger.addItem(url, wsError, SystemClock.uptimeMillis(), errorHost);
                if (this.mErrorTimesJudger.isExceedErrorTimesInTimeGap(errorHost) && RegisterHostSwitcher.pingHost(backHost)) {
                    this.mErrorTimesJudger.clearErrorList();
                    return true;
                }
                return false;
            }
        }
        return RegisterHostSwitcher.pingHost(backHost) && !RegisterHostSwitcher.pingHost(errorHost);
    }

    private static boolean pingHost(String host) {
        if (SettingFlags.getBoolean((String)"usesystemping", (boolean)false)) {
            return NetworkUtils.pingHost((String)host);
        }
        String resultStr = HttpUtil.httpGetSyncForPing((String)("https://" + host + "/d/_ping"));
        return StringUtils.equal((String)resultStr, (String)"pong");
    }

    public static int isPongHttpNotOkButHttpsOk() {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            return -1;
        }
        if (StringUtils.isEmpty((String)UriProvider.getRegisterHostOrigin())) {
            return -2;
        }
        String resultStr = HttpUtil.httpGetSyncForPing((String)("http://" + UriProvider.getRegisterHostOrigin() + "/d/_ping"));
        if (!StringUtils.equal((String)resultStr, (String)"pong") && StringUtils.equal((String)HttpUtil.httpGetSyncForPing((String)("https://" + UriProvider.getRegisterHostOrigin() + "/d/_ping")), (String)"pong")) {
            return 1;
        }
        if (StringUtils.equal((String)resultStr, (String)"pong")) {
            return 2;
        }
        return 3;
    }

    public static void reportAppMonitorReturnCode(String uri, long time, String returnCode) {
        if (SettingFlagBaseKeys.isNormalMetricSwitchOn()) {
            HiidoStatis.reportAppMonitorReturnCode((String)uri, (long)time, (String)returnCode);
        }
    }

    private void initCheckOriginServerIsOkRunnable() {
        this.mCheckOriginServerIsOk = new Runnable(){

            @Override
            public void run() {
                if (!UriProvider.isUseRegisterHostBackUpWs() && !UriProvider.isUseRegisterHostBackUpNormal()) {
                    return;
                }
                if (!RuntimeContext.sIsForeground) {
                    RegisterHostSwitcher.this.checkOriginServerIsOk();
                    return;
                }
                if (!NetworkUtils.isNetworkStrictlyAvailable((Context)RuntimeContext.sApplicationContext)) {
                    RegisterHostSwitcher.this.checkOriginServerIsOk();
                    return;
                }
                String registerHostOrigin = UriProvider.getRegisterHostOrigin();
                if (RegisterHostSwitcher.pingHost(registerHostOrigin)) {
                    UriProvider.switchToRegisterHostOrigin((!ProtoManager.getInstance().isWSConnected() ? 1 : 0) != 0, (boolean)true);
                    if (RegisterHostSwitcher.this.mCheckOriginServerIsOk != null) {
                        YYTaskExecutor.removeTask((Runnable)RegisterHostSwitcher.this.mCheckOriginServerIsOk);
                    }
                    RegisterHostSwitcher.reportAppMonitorReturnCode("mainserverorigin/" + registerHostOrigin, RegisterHostSwitcher.this.mLastSwitchToBackTime > 0L ? SystemClock.uptimeMillis() - RegisterHostSwitcher.this.mLastSwitchToBackTime : -1L, "0");
                    RegisterHostSwitcher.this.mLastSwitchToBackTime = -1L;
                    MLog.info((Object)RegisterHostSwitcher.TAG, (String)"switchToRegisterHostOrigin ws:%s!", (Object[])new Object[]{String.valueOf(UriProvider.isUseRegisterHostBackUpWs())});
                } else {
                    RegisterHostSwitcher.this.checkOriginServerIsOk();
                }
            }
        };
    }

    private void checkOriginServerIsOk() {
        if (this.mCheckOriginServerIsOk == null) {
            return;
        }
        int timeGap = SettingFlags.getIntValue((String)"serverpingtimegap", (int)120);
        if (timeGap < 10) {
            timeGap = 10;
        }
        YYTaskExecutor.removeTask((Runnable)this.mCheckOriginServerIsOk);
        YYTaskExecutor.execute((Runnable)this.mCheckOriginServerIsOk, (long)(timeGap * 1000));
    }

    private class MyRunnable
    implements Runnable {
        String error;
        String url;
        boolean wsError;

        MyRunnable(String error, String url, boolean wsError) {
            this.error = error;
            this.url = url;
            this.wsError = wsError;
        }

        public void update(String error, String url, boolean wsError) {
            this.error = error;
            this.url = url;
            this.wsError = wsError;
        }

        @Override
        public void run() {
            RegisterHostSwitcher.this.getTaskExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    RegisterHostSwitcher.this.handleNetError(MyRunnable.this.error, MyRunnable.this.url, MyRunnable.this.wsError);
                }
            }, 0L);
        }
    }
}

