/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.global;

import android.content.Context;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.PerformanceData;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.GlobalPerItemBean;
import com.yy.appbase.http.IHttpMetricMonitor;
import com.yy.base.env.RuntimeContext;
import com.yy.base.env.TargetBuildConstant;
import com.yy.base.guid.GuidFactory;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.WsClient;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.AbstractMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.IMonitorCallBack;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.RepeatRequestsMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.network.NetWorkWrapper;
import com.yy.hiyo.proto.IMonitor;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashMap;
import java.util.Map;

public class NetMonitor
extends AbstractMonitor {
    private static final int MAX_URL_STAT_LENGTH = 100;
    private static final int METRIC_RETRY_SUCCESS = 10000;
    private static final int METRIC_ERROR_CODE_TIMEOUT = 99;
    private static final int METRIC_ERROR_CODE_CANCEL = 97;
    private static final int METRIC_ERROR_CODE_WS_NOT_CONNECT = 251;
    private IHttpMetricMonitor mHttpMonitor;
    private IMonitor mWsMonitor;
    private ImageLoader.IMonitor mImageMonitor;
    private Submitter mOkHttpSubmitter;
    private Submitter mWsSubmitter;
    private Submitter mImageSubmitter;
    private final IQueueTaskExecutor mTaskExecutor = YYTaskExecutor.createAQueueExcuter((boolean)false, (boolean)false);
    private boolean mGameProxyCollect = false;

    public NetMonitor(IMonitorCallBack callBack) {
        super(callBack);
    }

    private static boolean isHttpMonitorEnable() {
        return SettingFlags.getBoolean((String)"globalnethttp", (boolean)false) || SettingFlagBaseKeys.isHttpMetricSwitchOn() || SettingFlagBaseKeys.isHttpErrorCollectSwitchOn() || SystemUtils.isShowEnvSetting();
    }

    private static boolean isWsMonitorEnable() {
        return SettingFlags.getBoolean((String)"globalnetws", (boolean)false) || SettingFlagBaseKeys.isWsMetricSwitchOn() || SystemUtils.isShowEnvSetting();
    }

    @Override
    public void start() {
        if (NetMonitor.isHttpMonitorEnable() || SystemUtils.isShowEnvSetting()) {
            if (this.mHttpMonitor == null) {
                this.initOkhttpCallBack();
            }
            if (this.mOkHttpSubmitter != null) {
                if (SettingFlags.getBoolean((String)"globalnethttp", (boolean)false)) {
                    if (SettingFlagBaseKeys.isHttpMetricSwitchOn()) {
                        this.mOkHttpSubmitter.setSubmitType(3);
                    } else {
                        this.mOkHttpSubmitter.setSubmitType(1);
                    }
                } else if (SettingFlagBaseKeys.isHttpMetricSwitchOn()) {
                    this.mOkHttpSubmitter.setSubmitType(2);
                } else if (SettingFlagBaseKeys.isHttpErrorCollectSwitchOn()) {
                    this.mOkHttpSubmitter.setSubmitType(4);
                }
            }
            NetWorkWrapper.setHttpMonitor(this.mHttpMonitor);
        }
        if (NetMonitor.isWsMonitorEnable() || SystemUtils.isShowEnvSetting()) {
            if (this.mWsMonitor == null) {
                this.initWsCallBack();
            }
            if (this.mWsSubmitter != null) {
                if (SettingFlags.getBoolean((String)"globalnetws", (boolean)false)) {
                    if (SettingFlagBaseKeys.isWsMetricSwitchOn()) {
                        this.mWsSubmitter.setSubmitType(3);
                    } else {
                        this.mWsSubmitter.setSubmitType(1);
                    }
                } else if (SettingFlagBaseKeys.isWsMetricSwitchOn()) {
                    this.mWsSubmitter.setSubmitType(2);
                }
            }
            NetWorkWrapper.setProtoMonitor(this.mWsMonitor);
        }
        if (SettingFlags.getBoolean((String)"globalnetimage", (boolean)false)) {
            if (this.mImageMonitor == null) {
                this.initImageCallBack();
            }
            NetWorkWrapper.setImageMonitor(this.mImageMonitor);
        }
        this.mGameProxyCollect = SettingFlags.getBoolean((String)"gameproxycollect", (boolean)false);
    }

    @Override
    public void stop() {
        NetWorkWrapper.setHttpMonitor(null);
        NetWorkWrapper.setProtoMonitor(null);
        NetWorkWrapper.setImageMonitor(null);
    }

    private String getRpcDetailUrl(String statUrl, Map<String, String> header) {
        String sMethod;
        if (header == null || header.isEmpty()) {
            return statUrl;
        }
        String sName = header.get("X-Ymicro-Api-Service-Name");
        String string2 = sMethod = sName != null ? header.get("X-Ymicro-Api-Method-Name") : "";
        if (StringUtils.isEmpty((String)sName)) {
            sName = header.get("x-ymicro-api-service-name");
        }
        if (StringUtils.isEmpty((String)sMethod) && StringUtils.isNotEmpty((String)sName)) {
            sMethod = header.get("x-ymicro-api-method-name");
        }
        if (StringUtils.isNotEmpty((String)sName)) {
            statUrl = statUrl + "/" + sName;
            if (StringUtils.isNotEmpty((String)sMethod)) {
                statUrl = statUrl + "/" + sMethod;
            }
        }
        return statUrl;
    }

    private void initOkhttpCallBack() {
        if (this.mHttpMonitor == null) {
            this.mOkHttpSubmitter = new Submitter();
            this.mHttpMonitor = new IHttpMetricMonitor(){

                public void onStart(final int index, String originUrl, final String requestUrl, final Map<String, String> header) {
                    NetMonitor.this.mTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            int index2;
                            if (NetMonitor.this.mCallBack == null || StringUtils.isEmpty((String)requestUrl)) {
                                return;
                            }
                            String url = requestUrl;
                            if (StringUtils.isEmpty((String)url) || !url.startsWith("http")) {
                                return;
                            }
                            String statUrl = url;
                            if (StringUtils.isNotEmpty((String)url) && (index2 = url.indexOf("?")) > 0) {
                                statUrl = url.substring(0, index2);
                            }
                            if (statUrl != null && statUrl.contains("/ymicro/api")) {
                                statUrl = NetMonitor.this.getRpcDetailUrl(statUrl, header);
                            }
                            GlobalPerItemBean globalPItem = NetMonitor.this.mCallBack.createBaseItem(2, 1, 0, statUrl, YYTaskExecutor.isMainThread());
                            NetMonitor.this.mOkHttpSubmitter.addItem(index, globalPItem);
                            if (NetMonitor.isAppTestSwitchOn()) {
                                MLog.debug((Object)"NetMonitor", (String)"onHttpRequestStart url:%s!", (Object[])new Object[]{statUrl});
                            }
                        }
                    }, 0L);
                }

                public void onCancel(final int index, String originUrl, final String requestUrl, Map<String, String> header) {
                    NetMonitor.this.mTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (NetMonitor.this.mCallBack == null || StringUtils.isEmpty((String)requestUrl)) {
                                return;
                            }
                            NetMonitor.this.mOkHttpSubmitter.updateItemByCancel(index);
                            if (NetMonitor.isAppTestSwitchOn()) {
                                MLog.debug((Object)"NetMonitor", (String)"onHttpRequestCancel url:%s!", (Object[])new Object[]{requestUrl});
                            }
                        }
                    }, 0L);
                }

                public void onFailure(final int index, String originUrl, final String requestUrl, final Throwable e, final Map<String, String> header) {
                    NetMonitor.this.mTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (NetMonitor.this.mCallBack == null || StringUtils.isEmpty((String)requestUrl)) {
                                return;
                            }
                            NetMonitor.this.mOkHttpSubmitter.updateItemByError(index, e != null ? e.toString() : "", NetMonitor.getErrorCodeByExc(e));
                            if (NetMonitor.isAppTestSwitchOn()) {
                                int index2;
                                String statUrl = requestUrl;
                                if (StringUtils.isNotEmpty((String)requestUrl) && (index2 = requestUrl.indexOf("?")) > 0) {
                                    statUrl = requestUrl.substring(0, index2);
                                }
                                if (statUrl != null && statUrl.contains("/ymicro/api")) {
                                    statUrl = NetMonitor.this.getRpcDetailUrl(statUrl, header);
                                }
                                MLog.debug((Object)"NetMonitor", (String)"onHttpRequestError url:%s \n error:%s!", (Object[])new Object[]{statUrl, e != null ? e.toString() : ""});
                            }
                        }
                    }, 0L);
                }

                public void onResponse(final int index, final String originUrl, final String requestUrl, final long contentLength, final Map<String, String> header) {
                    NetMonitor.this.mTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (NetMonitor.this.mCallBack == null || StringUtils.isEmpty((String)requestUrl)) {
                                return;
                            }
                            boolean useBackUpSuccess = !StringUtils.equal((String)originUrl, (String)requestUrl);
                            NetMonitor.this.mOkHttpSubmitter.updateItemByOk(index, (int)contentLength, useBackUpSuccess);
                            if (NetMonitor.isAppTestSwitchOn()) {
                                int index2;
                                String statUrl = requestUrl;
                                if (StringUtils.isNotEmpty((String)requestUrl) && (index2 = requestUrl.indexOf("?")) > 0) {
                                    statUrl = requestUrl.substring(0, index2);
                                }
                                if (statUrl != null && statUrl.contains("/ymicro/api")) {
                                    statUrl = NetMonitor.this.getRpcDetailUrl(statUrl, header);
                                }
                                MLog.debug((Object)"NetMonitor", (String)"onHttpRequestSucess url:%s,contentLength:%d!", (Object[])new Object[]{statUrl, contentLength});
                            }
                        }
                    }, 0L);
                }
            };
        }
    }

    public static int getErrorCodeByExc(Throwable e) {
        return NetworkUtils.getErrorCodeByExc((Throwable)e);
    }

    private void initWsCallBack() {
        if (this.mWsMonitor == null) {
            this.mWsSubmitter = new Submitter();
            this.mWsMonitor = new IMonitor(){

                public void onRequestStart(final long seqId, int requestLength, String wsUrl, final String protoServiceName, final String method, final int uri, final long queueSize, AndroidMessage proto) {
                    RepeatRequestsMonitor.onRpcRequestStart(wsUrl, protoServiceName, method, uri, proto);
                    NetMonitor.this.mTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (NetMonitor.this.mCallBack == null || StringUtils.isEmpty((String)protoServiceName)) {
                                return;
                            }
                            if (StringUtils.equal((String)protoServiceName, (String)"ikxd_online_d")) {
                                return;
                            }
                            if (!NetMonitor.this.mGameProxyCollect && StringUtils.equal((String)protoServiceName, (String)"ikxd_gameproxy_d")) {
                                return;
                            }
                            String protoServiceNameAndMethod = protoServiceName;
                            if (StringUtils.isNotEmpty((String)method)) {
                                protoServiceNameAndMethod = protoServiceNameAndMethod + "/" + method;
                            }
                            GlobalPerItemBean globalPItem = NetMonitor.this.mCallBack.createBaseItem(2, 2, uri, protoServiceNameAndMethod, YYTaskExecutor.isMainThread());
                            globalPItem.queueSize = queueSize;
                            NetMonitor.this.mWsSubmitter.addItem(seqId, globalPItem);
                        }
                    }, 0L);
                    if (NetMonitor.isAppTestSwitchOn()) {
                        MLog.debug((Object)"NetMonitor", (String)"onWsRequestStart protoServiceName:%s, uri:%d!", (Object[])new Object[]{protoServiceName, uri});
                    }
                }

                public void onHttpRpcRequestStart(String roomId, String url, String protoServiceName, String method, AndroidMessage proto) {
                    RepeatRequestsMonitor.onHttpRpcRequestStart(roomId, url, protoServiceName, method, proto);
                }

                public void onResponse(final long seqId, final int resLength) {
                    NetMonitor.this.mTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            GlobalPerItemBean globalPItem;
                            if (NetMonitor.this.mCallBack == null) {
                                return;
                            }
                            if (NetMonitor.isAppTestSwitchOn() && (globalPItem = NetMonitor.this.mWsSubmitter.getItem(seqId)) != null) {
                                MLog.debug((Object)"NetMonitor", (String)"onWsRequestSuccess protoServiceName:%s, uri:%d, resLength:%d!", (Object[])new Object[]{globalPItem.actI, globalPItem.actT, resLength});
                            }
                            NetMonitor.this.mWsSubmitter.updateItemByOk(seqId, resLength);
                        }
                    }, 0L);
                }

                public void onTimeout(final long seqId) {
                    NetMonitor.this.mTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            GlobalPerItemBean globalPItem;
                            if (NetMonitor.this.mCallBack == null) {
                                return;
                            }
                            if (NetMonitor.isAppTestSwitchOn() && (globalPItem = NetMonitor.this.mWsSubmitter.getItem(seqId)) != null) {
                                MLog.debug((Object)"NetMonitor", (String)"onWsRequestTimeout protoServiceName:%s, uri:%d!", (Object[])new Object[]{globalPItem.actI, globalPItem.actT});
                            }
                            NetMonitor.this.mWsSubmitter.updateItemByError(seqId, "TimeOut", 99);
                        }
                    }, 0L);
                }

                public void onError(final long seqId, final String reason, final int code) {
                    NetMonitor.this.mTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            GlobalPerItemBean globalPItem;
                            if (NetMonitor.this.mCallBack == null) {
                                return;
                            }
                            if (NetMonitor.isAppTestSwitchOn() && (globalPItem = NetMonitor.this.mWsSubmitter.getItem(seqId)) != null) {
                                MLog.debug((Object)"NetMonitor", (String)"onWsRequestError reason:%s protoServiceName:%s, uri:%d!", (Object[])new Object[]{globalPItem.actI, globalPItem.actT});
                            }
                            NetMonitor.this.mWsSubmitter.updateItemByError(seqId, reason, code);
                        }
                    }, 0L);
                }

                public void onNotify(final String wsUrl, final String protoServiceName, final int length) {
                    NetMonitor.this.mTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (NetMonitor.this.mCallBack == null) {
                                return;
                            }
                            if (StringUtils.equal((String)protoServiceName, (String)"ikxd_online_d")) {
                                return;
                            }
                            if (!NetMonitor.this.mGameProxyCollect && StringUtils.equal((String)protoServiceName, (String)"ikxd_gameproxy_d")) {
                                return;
                            }
                            GlobalPerItemBean globalPItem = NetMonitor.this.mCallBack.createBaseItem(2, 3, -1, protoServiceName, YYTaskExecutor.isMainThread());
                            globalPItem.size = length;
                            NetMonitor.this.mCallBack.addPerItem(globalPItem);
                            if (RuntimeContext.sIsDebuggable && globalPItem != null) {
                                MLog.debug((Object)"NetMonitor", (String)"onNotify wsUrl:%s, protoServiceName:%s, uri:%d!", (Object[])new Object[]{wsUrl, protoServiceName, length});
                            }
                        }
                    }, 0L);
                }

                public void onCheckOutExe(int consume, String statStr) {
                    if (!RuntimeContext.isInGray()) {
                        return;
                    }
                    StatisContent statContent = new StatisContent();
                    statContent.put("act", "hagoperf");
                    statContent.put("sfield", GuidFactory.getInstance().getGuid());
                    statContent.put("ifield", consume);
                    statContent.put("ifieldtwo", RuntimeContext.sIsForeground ? 1 : 0);
                    statContent.put("sfieldtwo", AccountUtil.getUid());
                    statContent.put("sfieldthree", statStr);
                    statContent.put("perftype", "wschecktimeout2");
                    HiidoStatis.reportContent((StatisContent)statContent);
                }

                public void onMsgConsumeTime(long seqId, String protoServiceName, int uri, long time, int retryTimes, String traceStr) {
                    if (!RuntimeContext.isInGray()) {
                        return;
                    }
                    StatisContent statContent = new StatisContent();
                    statContent.put("act", "hagoperf");
                    statContent.put("sfield", GuidFactory.getInstance().getGuid());
                    statContent.put("sfieldtwo", (RuntimeContext.sIsForeground ? 1 : 0) + "_" + protoServiceName);
                    statContent.put("ifield", uri);
                    statContent.put("ifieldtwo", time);
                    statContent.put("sfieldthree", seqId + "_" + traceStr);
                    statContent.put("ifieldthree", retryTimes);
                    statContent.put("perftype", "wsmsgconsume4");
                    HiidoStatis.reportContent((StatisContent)statContent);
                }

                public void onResponseTimeGap(long seqId, String protoServiceName, int uri, long time) {
                    if (!RuntimeContext.isInGray()) {
                        return;
                    }
                    StatisContent statContent = new StatisContent();
                    statContent.put("act", "hagoperf");
                    statContent.put("sfield", GuidFactory.getInstance().getGuid());
                    statContent.put("sfieldtwo", protoServiceName);
                    statContent.put("ifield", uri);
                    statContent.put("ifieldtwo", time);
                    statContent.put("sfieldthree", seqId);
                    statContent.put("perftype", "wsresponse");
                    HiidoStatis.reportContent((StatisContent)statContent);
                }

                public void onResponseExcuteTime(long seqId, String protoServiceName, int uri, long time) {
                    if (!RuntimeContext.isInGray()) {
                        return;
                    }
                    StatisContent statContent = new StatisContent();
                    statContent.put("act", "hagoperf");
                    statContent.put("sfield", GuidFactory.getInstance().getGuid());
                    statContent.put("sfieldtwo", protoServiceName);
                    statContent.put("ifield", uri);
                    statContent.put("ifieldtwo", time);
                    statContent.put("sfieldthree", seqId);
                    statContent.put("perftype", "wsresponseex");
                    HiidoStatis.reportContent((StatisContent)statContent);
                }

                public boolean isEnableWsClientBackgroundReconnect(WsClient socket, String wsUrl) {
                    return false;
                }
            };
        }
    }

    private void initImageCallBack() {
        if (this.mImageMonitor == null) {
            this.mImageSubmitter = new Submitter();
            this.mImageMonitor = new ImageLoader.IMonitor(){

                public void onStart(final int id2, final boolean loadImage, final @Nullable String url, int width, int height) {
                    NetMonitor.this.mTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (NetMonitor.this.mCallBack == null) {
                                return;
                            }
                            GlobalPerItemBean globalPItem = NetMonitor.this.mCallBack.createBaseItem(2, 5, loadImage ? 1 : 2, url, YYTaskExecutor.isMainThread());
                            NetMonitor.this.mImageSubmitter.addItem(id2, globalPItem);
                            if (RuntimeContext.sIsDebuggable) {
                                MLog.debug((Object)"NetMonitor", (String)"Image onRequestStart url:%s!", (Object[])new Object[]{url});
                            }
                        }
                    }, 0L);
                }

                public void onSuccess(final int id2, @Nullable String url, final int size, final boolean isFirstResource, @Nullable DataSource dataSource, @Nullable PerformanceData performanceData) {
                    NetMonitor.this.mTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (NetMonitor.this.mCallBack == null) {
                                return;
                            }
                            if (isFirstResource) {
                                if (RuntimeContext.sIsDebuggable) {
                                    MLog.debug((Object)"NetMonitor", (String)"Image onRequestSuccess url:%d!", (Object[])new Object[]{size});
                                }
                                NetMonitor.this.mImageSubmitter.updateItemByOk(id2, size);
                            } else {
                                NetMonitor.this.mImageSubmitter.deleteItem(id2);
                            }
                        }
                    }, 0L);
                }

                public void onError(final int id2, final @Nullable String url, final Exception e) {
                    NetMonitor.this.mTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (NetMonitor.this.mCallBack == null) {
                                return;
                            }
                            NetMonitor.this.mImageSubmitter.updateItemByError(id2, e != null ? e.toString() : "", NetMonitor.getErrorCodeByExc(e));
                            if (RuntimeContext.sIsDebuggable) {
                                MLog.debug((Object)"NetMonitor", (String)"Image onRequestError url:%s \n error:%s!", (Object[])new Object[]{url, e != null ? e.toString() : ""});
                            }
                        }
                    }, 0L);
                }

                public void onClear(final int id2) {
                    NetMonitor.this.mTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (NetMonitor.this.mCallBack == null) {
                                return;
                            }
                            NetMonitor.this.mImageSubmitter.updateItemByCancel(id2);
                        }
                    }, 0L);
                }
            };
        }
    }

    public static boolean isAppTestSwitchOn() {
        return RuntimeContext.sIsDebuggable || TargetBuildConstant.showSetting == 1 && TargetBuildConstant.releaseApkCheck;
    }

    private class SubType {
        public static final int NORMAL = 1;
        public static final int METRICS = 2;
        public static final int NORMAL_AND_METRICS = 3;
        public static final int ERROR_CLLECT = 4;

        private SubType() {
        }
    }

    private class Submitter {
        private final HashMap<Object, GlobalPerItemBean> mItems = new HashMap();
        private int mSubmitType = 1;

        private Submitter() {
        }

        private void setSubmitType(int type2) {
            this.mSubmitType = type2;
        }

        private void addItem(Object index, GlobalPerItemBean globalPItem) {
            if (NetMonitor.this.mCallBack == null || globalPItem == null) {
                return;
            }
            this.mItems.put(index, globalPItem);
            if (this.mSubmitType == 1 || this.mSubmitType == 3) {
                NetMonitor.this.mCallBack.addPerItem(globalPItem);
            }
        }

        private void updateItemByError(Object index, String error, int errorCode) {
            GlobalPerItemBean globalPItem = this.mItems.get(index);
            if (globalPItem == null) {
                return;
            }
            if (error != null && error.length() > 100) {
                error = error.substring(0, 100);
            }
            if (error == null) {
                error = "";
            }
            globalPItem.result = 2;
            globalPItem.cTime = (int)(SystemClock.uptimeMillis() - globalPItem.startUptimeM);
            globalPItem.endW = NetMonitor.this.mCallBack.getCurWindow();
            globalPItem.eCode = error;
            if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                errorCode = 250;
            }
            if (this.mSubmitType == 1 || this.mSubmitType == 3) {
                NetMonitor.this.mCallBack.updatePerItem(globalPItem);
            } else if (this.mSubmitType == 4 && errorCode != 250) {
                globalPItem.subPT = 9;
                NetMonitor.this.mCallBack.addPerItem(globalPItem);
                NetMonitor.this.mCallBack.updatePerItem(globalPItem);
            }
            if (this.mSubmitType == 2 || this.mSubmitType == 3) {
                this.statErrorToMetrics(globalPItem, errorCode);
            }
            this.mItems.remove(index);
        }

        private GlobalPerItemBean getItem(Object index) {
            GlobalPerItemBean globalPItem = this.mItems.get(index);
            return globalPItem;
        }

        private void updateItemByOk(Object index, int size) {
            this.updateItemByOk(index, size, false);
        }

        private void updateItemByOk(Object index, int size, boolean useBackUpUrlSuccess) {
            GlobalPerItemBean globalPItem = this.mItems.get(index);
            if (globalPItem == null) {
                return;
            }
            globalPItem.result = 1;
            globalPItem.cTime = (int)(SystemClock.uptimeMillis() - globalPItem.startUptimeM);
            globalPItem.endW = NetMonitor.this.mCallBack.getCurWindow();
            globalPItem.size = size;
            if (this.mSubmitType == 1 || this.mSubmitType == 3) {
                NetMonitor.this.mCallBack.updatePerItem(globalPItem);
            }
            if (this.mSubmitType == 2 || this.mSubmitType == 3) {
                this.statToMetrics(globalPItem, 0, useBackUpUrlSuccess, size);
            }
            this.mItems.remove(index);
        }

        private void updateItemByCancel(Object index) {
            GlobalPerItemBean globalPItem = this.mItems.get(index);
            if (globalPItem == null) {
                return;
            }
            globalPItem.result = 3;
            globalPItem.cTime = (int)(SystemClock.uptimeMillis() - globalPItem.startUptimeM);
            globalPItem.endW = NetMonitor.this.mCallBack.getCurWindow();
            if (this.mSubmitType == 1 || this.mSubmitType == 3) {
                NetMonitor.this.mCallBack.updatePerItem(globalPItem);
            }
            if (this.mSubmitType == 2 || this.mSubmitType == 3) {
                this.statErrorToMetrics(globalPItem, 97);
            }
            this.mItems.remove(index);
        }

        private void deleteItem(Object index) {
            GlobalPerItemBean globalPItem = this.mItems.get(index);
            if (globalPItem == null) {
                return;
            }
            if (this.mSubmitType == 1 || this.mSubmitType == 3) {
                NetMonitor.this.mCallBack.deleteItem(globalPItem);
            }
            this.mItems.remove(index);
        }

        private void statErrorToMetrics(GlobalPerItemBean globalPItem, int errorcode) {
            this.statToMetrics(globalPItem, errorcode, false, 0);
        }

        private void statToMetrics(GlobalPerItemBean globalPItem, int errorcode, boolean useBackUpUrlSuccess, int contentLength) {
            if (globalPItem == null) {
                return;
            }
            if (this == NetMonitor.this.mOkHttpSubmitter) {
                if (SystemUtils.isShowEnvSetting() && !NetMonitor.isHttpMonitorEnable()) {
                    return;
                }
                String url = globalPItem.actI;
                if (url != null && url.startsWith("https://")) {
                    url = url.substring(8);
                } else if (url != null && url.startsWith("http://")) {
                    url = url.substring(7);
                } else {
                    return;
                }
                if (url != null) {
                    int index = url.indexOf(63);
                    if (index > 0) {
                        url = url.substring(0, index);
                    }
                    url = url.replace('/', '_');
                    url = url.replaceFirst("_", "/");
                }
                String urlStat = "hyhttp__clearpool_" + url;
                String codeStat = globalPItem.result == 1 ? (useBackUpUrlSuccess ? String.valueOf(10000) : "0") : String.valueOf(errorcode);
                HiidoStatis.reportAppMonitorReturnCode((String)urlStat, (long)globalPItem.cTime, (String)codeStat);
                if (NetMonitor.isAppTestSwitchOn()) {
                    MLog.info((Object)"NetMonitor", (String)"RequestMetric onHttp url:%s, time:%d, contentLength:%d, code:%s!", (Object[])new Object[]{urlStat, globalPItem.cTime, contentLength, codeStat});
                }
            } else if (this == NetMonitor.this.mWsSubmitter) {
                if (SystemUtils.isShowEnvSetting() && !NetMonitor.isWsMonitorEnable()) {
                    return;
                }
                if (globalPItem.result != 1 && !ProtoManager.getInstance().isWSConnected()) {
                    errorcode = 251;
                }
                String uri = "hyWs_" + globalPItem.actI;
                if (globalPItem.actT > 0) {
                    uri = uri + "/" + globalPItem.actT;
                }
                String code = globalPItem.result == 1 ? "0" : String.valueOf(errorcode);
                HiidoStatis.reportAppMonitorReturnCode((String)uri, (long)globalPItem.cTime, (String)code);
                if (NetMonitor.isAppTestSwitchOn()) {
                    MLog.info((Object)"NetMonitor", (String)"RequestMetric onWs url:%s, time:%d, contentLength:%d,  code:%s!", (Object[])new Object[]{uri, globalPItem.cTime, contentLength, code});
                }
            }
        }
    }
}

