/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.global;

import android.content.Context;
import android.os.Message;
import android.os.SystemClock;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.GlobalPerItemBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.DataParserMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.DnsMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.FileMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.IMonitorCallBack;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.IPCMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.NetMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.WindowPathMonitor;
import com.yy.yylite.commonbase.crash.CrashSdk;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GlobalPerfMonitor
extends DefaultController {
    private static final String TAG = "GlobalPerfMonitor";
    private static final int ACTION_ID_MAX_LENGTH = 150;
    private static int SAVE_TO_DB_TIME_GAP = 8000;
    private static int REPORT_TIME_GAP = 180000;
    private IMonitorCallBack mMonitorCallBack;
    private WindowPathMonitor mWindowPathMonitor;
    private NetMonitor mNetMonitor;
    private FileMonitor mFileMonitor;
    private IPCMonitor mIPCMonitor;
    private DataParserMonitor mDataParserMonitor;
    private DnsMonitor mDnsMonitor;
    private final IQueueTaskExecutor mQueueExecutor = YYTaskExecutor.createAQueueExcuter();
    private boolean mAfterStartUpFiveSec = false;
    private final ArrayList<GlobalPerItemBean> mItemsToSave = new ArrayList();
    private final ArrayList<GlobalPerItemBean> mItemsToUpdate = new ArrayList();
    private volatile long mLastSaveTime = -1L;
    private volatile Runnable mSaveToDbRunnable;
    private volatile Runnable mReportRunnable;
    private boolean mJudgeWindow = true;

    public GlobalPerfMonitor(Environment baseEnv) {
        super(baseEnv);
        this.initMonitorCallBack();
        if (this.mWindowPathMonitor == null) {
            this.mWindowPathMonitor = new WindowPathMonitor(new WindowPathMonitor.IWindowPathMonitorCallBack(){

                @Override
                public void onCurWindowChanged() {
                    GlobalPerfMonitor.this.handleCurWindowChange();
                }
            });
            AbstractWindow window = this.mWindowMgr.getCurrentWindow();
            if (window instanceof DefaultWindow) {
                this.mWindowPathMonitor.onShown((DefaultWindow)window);
            }
            this.updateCrashCurWin(window);
        }
        this.registerMessage(MsgDef.PRINT_APP_WINDOW_SWITCH_PROCESS);
        this.registerMessage(MsgDef.FETCH_APP_WINDOW_SWITCH_PROCESS);
    }

    public Object handleMessageSync(Message msg) {
        if (msg == null) {
            return null;
        }
        if (msg.what == MsgDef.PRINT_APP_WINDOW_SWITCH_PROCESS) {
            if (this.mWindowPathMonitor != null) {
                this.mWindowPathMonitor.printWindowSwtichProcess();
                return true;
            }
        } else if (msg.what == MsgDef.FETCH_APP_WINDOW_SWITCH_PROCESS && this.mWindowPathMonitor != null) {
            return this.mWindowPathMonitor.getPathItems();
        }
        return null;
    }

    private void initConfigData() {
        SAVE_TO_DB_TIME_GAP = SettingFlags.getIntValue((String)"globalpcsavetime", (int)8000);
        if (SAVE_TO_DB_TIME_GAP < 5000) {
            SAVE_TO_DB_TIME_GAP = 5000;
        }
        if ((REPORT_TIME_GAP = SettingFlags.getIntValue((String)"globalpcreporttime", (int)300000)) < 120000) {
            REPORT_TIME_GAP = 120000;
        }
        if (SystemUtils.isShowEnvSetting()) {
            REPORT_TIME_GAP = 60000;
        }
        this.mJudgeWindow = SettingFlags.getBoolean((String)"globalpcjudgewin", (boolean)true);
    }

    public void start() {
        boolean switchOn = this.isSwitchOn();
        if (RuntimeContext.sIsDebuggable) {
            boolean isGameFirstPageOpen = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
            boolean isGameAutoOpen = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
            if (isGameAutoOpen || isGameFirstPageOpen) {
                switchOn = false;
            }
        }
        if (switchOn) {
            this.startMonitor();
        } else {
            this.stopMonitor();
        }
        final boolean statSwitch = switchOn;
        YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                MLog.error((Object)GlobalPerfMonitor.TAG, (String)"monitor status : %d", (Object[])new Object[]{statSwitch ? 1 : 0});
            }
        }, (long)6000L);
    }

    public void onStartUpFinished() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                GlobalPerfMonitor.this.mAfterStartUpFiveSec = true;
                boolean switchOn = GlobalPerfMonitor.this.isReportSwitchOn();
                if (switchOn) {
                    GlobalPerfMonitor.this.reportAllItems();
                }
            }
        }, (long)5000L);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractWindow window;
                if (GlobalPerfMonitor.this.mWindowPathMonitor != null && StringUtils.isEmpty((String)GlobalPerfMonitor.this.mWindowPathMonitor.getCurWindow()) && (window = GlobalPerfMonitor.this.mWindowMgr.getCurrentWindow()) instanceof DefaultWindow) {
                    GlobalPerfMonitor.this.mWindowPathMonitor.onShown((DefaultWindow)window);
                }
            }
        });
    }

    private boolean isSwitchOn() {
        if (SystemUtils.isShowEnvSetting()) {
            return true;
        }
        return SettingFlags.getBoolean((String)"globalperfcollect", (boolean)false);
    }

    private boolean isReportSwitchOn() {
        return this.isSwitchOn() && !SystemUtils.isShowEnvSetting();
    }

    private void startMonitor() {
        if (this.mNetMonitor == null) {
            this.mNetMonitor = new NetMonitor(this.mMonitorCallBack);
        }
        DefaultWindow.addGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)this.mWindowPathMonitor);
        this.mNetMonitor.start();
        if (!SettingFlagBaseKeys.isForceCloseReport()) {
            if (this.mFileMonitor == null) {
                this.mFileMonitor = new FileMonitor(this.mMonitorCallBack);
            }
            this.mFileMonitor.start();
            if (this.mIPCMonitor == null) {
                this.mIPCMonitor = new IPCMonitor(this.mMonitorCallBack);
            }
            this.mIPCMonitor.start();
            if (this.mDataParserMonitor == null) {
                this.mDataParserMonitor = new DataParserMonitor(this.mMonitorCallBack);
            }
            this.mDataParserMonitor.start();
        }
        if (RuntimeContext.sIsDebuggable || SettingFlags.getBoolean((String)"dnscollect", (boolean)false)) {
            if (this.mDnsMonitor == null) {
                this.mDnsMonitor = new DnsMonitor(this.mMonitorCallBack);
            }
            this.mDnsMonitor.start();
        }
    }

    private void stopMonitor() {
        DefaultWindow.removeGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)this.mWindowPathMonitor);
        if (this.mNetMonitor != null) {
            this.mNetMonitor.stop();
        }
        if (this.mFileMonitor != null) {
            this.mFileMonitor.stop();
        }
        if (this.mIPCMonitor != null) {
            this.mIPCMonitor.stop();
        }
        if (this.mDataParserMonitor != null) {
            this.mDataParserMonitor.stop();
        }
        if (this.mDnsMonitor != null) {
            this.mDnsMonitor.stop();
        }
    }

    public void onPerConfigUpdated() {
        this.initConfigData();
        this.start();
    }

    public void handleCurWindowChange() {
        this.updateCrashCurWin(this.getCurrentWindow());
    }

    private void updateCrashCurWin(AbstractWindow window) {
        if (window != null && window.getName() != null) {
            String lastWindow = CrashSdk.INSTANCE.getExtend("curWin", "");
            String lastSecondWindow = CrashSdk.INSTANCE.getExtend("lastWin", "");
            if (StringUtils.isNotEmpty((String)lastWindow)) {
                CrashSdk.INSTANCE.addExtend("lastWin", lastWindow);
            }
            if (StringUtils.isNotEmpty((String)lastSecondWindow)) {
                CrashSdk.INSTANCE.addExtend("lastSecondWin", lastSecondWindow);
            }
            CrashSdk.INSTANCE.addExtend("curWin", window.getName());
        }
    }

    private GlobalPerItemBean createBaseItem(int perfType, int subPerType, int actionType, String actionId, boolean isMainThread) {
        if (actionId == null) {
            actionId = "";
        } else if (actionId.length() > 150) {
            actionId = actionId.substring(150);
        }
        long curTime = System.currentTimeMillis();
        GlobalPerItemBean itemBean = new GlobalPerItemBean();
        itemBean.startUptimeM = SystemClock.uptimeMillis();
        itemBean.perfType = perfType;
        itemBean.subPT = subPerType;
        itemBean.actT = actionType;
        itemBean.actI = actionId;
        itemBean.isMT = isMainThread ? 1 : 0;
        itemBean.index = curTime;
        itemBean.result = 9;
        itemBean.firstO = RuntimeContext.isStartAtFirstInstalled() ? 1 : 0;
        itemBean.appRT = (int)(itemBean.startUptimeM - RuntimeContext.sMainActivityStartTime);
        itemBean.foreT = (int)RuntimeContext.getForeGroundRunTime();
        itemBean.foreG = RuntimeContext.sIsForeground ? 1 : 0;
        int n = itemBean.isSUF = RuntimeContext.sIsAppStartFinished ? 1 : 0;
        if (itemBean.perfType == 2 || itemBean.perfType == 5) {
            itemBean.netType = NetworkUtils.getNetworkType((Context)RuntimeContext.sApplicationContext);
        }
        if (this.mWindowPathMonitor != null) {
            itemBean.curWST = (int)(curTime - this.mWindowPathMonitor.getWindowShowStartTime());
            itemBean.startW = this.mWindowPathMonitor.getCurWindow();
        }
        itemBean.uid = AccountUtil.getUid();
        return itemBean;
    }

    private void flushToDB() {
        long timeGap;
        long curUpTime = SystemClock.uptimeMillis();
        if (this.mLastSaveTime == -1L) {
            this.mLastSaveTime = curUpTime;
        }
        if ((timeGap = (long)SAVE_TO_DB_TIME_GAP - (curUpTime - this.mLastSaveTime)) < 0L) {
            timeGap = 0L;
        }
        if (this.mSaveToDbRunnable == null) {
            this.mSaveToDbRunnable = new Runnable(){

                @Override
                public void run() {
                    Runnable command = new Runnable(){

                        @Override
                        public void run() {
                            GlobalPerfMonitor.this.mLastSaveTime = SystemClock.uptimeMillis();
                            int addSize = GlobalPerfMonitor.this.mItemsToSave.size();
                            int updateSize = GlobalPerfMonitor.this.mItemsToUpdate.size();
                            if (addSize <= 0 && updateSize <= 0) {
                                return;
                            }
                            IServiceManager serviceManager = GlobalPerfMonitor.this.getServiceManager();
                            if (serviceManager == null) {
                                return;
                            }
                            IDBService dbService = (IDBService)serviceManager.getService(IDBService.class);
                            if (dbService == null) {
                                return;
                            }
                            MyBox box = dbService.boxForGlobal(GlobalPerItemBean.class);
                            if (box == null) {
                                return;
                            }
                            SimpleDateFormat fmt = CommonUtils.getSimpleDateFormat((String)"yyyyMMdd");
                            if (addSize > 0) {
                                for (GlobalPerItemBean itemBean : GlobalPerfMonitor.this.mItemsToSave) {
                                    if (itemBean == null || !StringUtils.isEmpty((String)itemBean.time) || itemBean.index <= 0L) continue;
                                    itemBean.time = fmt.format(new Date(itemBean.index));
                                }
                                box.addItems((List)GlobalPerfMonitor.this.mItemsToSave);
                                GlobalPerfMonitor.this.mItemsToSave.clear();
                            }
                            if (updateSize > 0) {
                                box.updateItems((List)GlobalPerfMonitor.this.mItemsToUpdate, false);
                                GlobalPerfMonitor.this.mItemsToUpdate.clear();
                            }
                            if (RuntimeContext.sIsDebuggable) {
                                MLog.info((Object)GlobalPerfMonitor.TAG, (String)"flush to DB addSize:%d, updateSize:%d!", (Object[])new Object[]{addSize, updateSize});
                            }
                        }
                    };
                    GlobalPerfMonitor.this.mQueueExecutor.execute(command, 0L);
                }
            };
        } else {
            YYTaskExecutor.removeTask((Runnable)this.mSaveToDbRunnable);
        }
        YYTaskExecutor.execute((Runnable)this.mSaveToDbRunnable, (long)timeGap);
    }

    private void addItem(final GlobalPerItemBean itemBean) {
        if (!this.isReportSwitchOn()) {
            return;
        }
        if (itemBean == null) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (GlobalPerfMonitor.this.mItemsToSave.contains(itemBean)) {
                    return;
                }
                GlobalPerfMonitor.this.mItemsToSave.add(itemBean);
                GlobalPerfMonitor.this.flushToDB();
            }
        };
        this.mQueueExecutor.execute(command, 0L);
    }

    public void updatePerItem(final GlobalPerItemBean itemBean) {
        if (!this.isReportSwitchOn()) {
            return;
        }
        if (itemBean == null) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (GlobalPerfMonitor.this.mItemsToUpdate.contains(itemBean)) {
                    return;
                }
                GlobalPerfMonitor.this.mItemsToUpdate.add(itemBean);
                GlobalPerfMonitor.this.flushToDB();
            }
        };
        this.mQueueExecutor.execute(command, 0L);
    }

    public void deletePerItem(final GlobalPerItemBean itemBean) {
        if (!this.isReportSwitchOn()) {
            return;
        }
        if (itemBean == null) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (GlobalPerfMonitor.this.mItemsToSave.contains(itemBean)) {
                    GlobalPerfMonitor.this.mItemsToSave.remove(itemBean);
                }
                if (GlobalPerfMonitor.this.mItemsToUpdate.contains(itemBean)) {
                    GlobalPerfMonitor.this.mItemsToUpdate.remove(itemBean);
                }
            }
        };
        this.mQueueExecutor.execute(command, 0L);
    }

    private void reportAllItems() {
        if (!this.isReportSwitchOn()) {
            return;
        }
        if (!this.mAfterStartUpFiveSec) {
            return;
        }
        if (this.mReportRunnable == null) {
            this.mReportRunnable = new Runnable(){

                @Override
                public void run() {
                    GlobalPerfMonitor.this.reportAllItemsInner();
                    GlobalPerfMonitor.this.reportAllItems();
                }
            };
        } else {
            YYTaskExecutor.removeTask((Runnable)this.mReportRunnable);
        }
        YYTaskExecutor.execute((Runnable)this.mReportRunnable, (long)REPORT_TIME_GAP);
    }

    private void reportAllItemsInner() {
        if (!this.canReport()) {
            return;
        }
        IDBService dbService = (IDBService)this.getServiceManager().getService(IDBService.class);
        if (dbService == null) {
            return;
        }
        final MyBox box = dbService.boxForGlobal(GlobalPerItemBean.class);
        if (box == null) {
            return;
        }
        box.getAll(new MyBox.IGetItemsCallBack(){

            public void onLoaded(final ArrayList datas) {
                if (datas == null || datas.size() <= 0) {
                    return;
                }
                if (!GlobalPerfMonitor.this.canReport()) {
                    return;
                }
                Runnable command = new Runnable(){

                    @Override
                    public void run() {
                        if (!GlobalPerfMonitor.this.canReport()) {
                            return;
                        }
                        long curTime = System.currentTimeMillis();
                        ArrayList allData = datas;
                        ArrayList<GlobalPerItemBean> reportedItems = new ArrayList<GlobalPerItemBean>();
                        for (GlobalPerItemBean itemBean : allData) {
                            if (itemBean == null || itemBean.index - curTime <= 60000L && curTime - itemBean.index <= 60000L) continue;
                            GlobalPerfMonitor.this.reportItemNow(itemBean);
                            reportedItems.add(itemBean);
                        }
                        if (RuntimeContext.sIsDebuggable) {
                            MLog.info((Object)GlobalPerfMonitor.TAG, (String)"reportAllItems : %d !", (Object[])new Object[]{reportedItems.size()});
                        }
                        box.deleteItems(reportedItems);
                    }
                };
                GlobalPerfMonitor.this.mQueueExecutor.execute(command, 0L);
            }
        });
    }

    private boolean canReport() {
        if (!this.isReportSwitchOn()) {
            return false;
        }
        if (!this.mAfterStartUpFiveSec) {
            return false;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) || !RuntimeContext.sIsAppStartFinished) {
            return false;
        }
        if (this.mJudgeWindow && !RuntimeContext.sIsDebuggable) {
            String windowName = "";
            if (this.mWindowPathMonitor != null) {
                windowName = this.mWindowPathMonitor.getCurWindow();
            }
            if (StringUtils.equal((String)windowName, (String)"MatchGame") || StringUtils.equal((String)windowName, (String)"Game") || StringUtils.equal((String)windowName, (String)"LoginTypeSelect") || StringUtils.equal((String)windowName, (String)"PhoneLogin")) {
                return false;
            }
        }
        return true;
    }

    private void reportItemNow(GlobalPerItemBean itemBean) {
        if (itemBean == null) {
            return;
        }
        if (!this.isReportSwitchOn()) {
            return;
        }
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperfmonitor");
        statContent.put("perftype", itemBean.perfType);
        statContent.put("subtype", itemBean.subPT);
        statContent.put("hyat", itemBean.actT);
        statContent.put("hyid", itemBean.actI);
        statContent.put("hyst", itemBean.time);
        statContent.put("hyct", itemBean.cTime);
        statContent.put("hyres", itemBean.result);
        statContent.put("hysize", itemBean.size);
        statContent.put("hyw", itemBean.startW);
        statContent.put("hymt", itemBean.isMT);
        statContent.put("hysu", itemBean.isSUF);
        statContent.put("hyrt", itemBean.appRT);
        statContent.put("hyrtr", itemBean.foreT);
        statContent.put("hywt", itemBean.curWST);
        statContent.put("hyfg", itemBean.foreG);
        statContent.put("hyfo", itemBean.firstO);
        statContent.put("hywe", itemBean.endW);
        statContent.put("hynet", itemBean.netType);
        statContent.put("hyec", itemBean.eCode);
        statContent.put("hyuid", itemBean.uid);
        statContent.put("queuesize", itemBean.queueSize);
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    private void initMonitorCallBack() {
        this.mMonitorCallBack = new IMonitorCallBack(){

            @Override
            public GlobalPerItemBean createBaseItem(int perfType, int subPerType, int actionType, String actionId, boolean isMainThread) {
                return GlobalPerfMonitor.this.createBaseItem(perfType, subPerType, actionType, actionId, isMainThread);
            }

            @Override
            public void addPerItem(GlobalPerItemBean itemBean) {
                GlobalPerfMonitor.this.addItem(itemBean);
            }

            @Override
            public void updatePerItem(GlobalPerItemBean itemBean) {
                GlobalPerfMonitor.this.updatePerItem(itemBean);
            }

            @Override
            public void deleteItem(GlobalPerItemBean itemBean) {
                GlobalPerfMonitor.this.deletePerItem(itemBean);
            }

            @Override
            public String getCurWindow() {
                return GlobalPerfMonitor.this.mWindowPathMonitor != null ? GlobalPerfMonitor.this.mWindowPathMonitor.getCurWindow() : "";
            }
        };
    }
}

