/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.networkdiagnose.view;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.yy.base.memoryrecycle.views.YYButton;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.AbstractWindowManager;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.XQJustifyTextView;
import com.yy.hiyo.main.R;
import com.yy.hiyo.module.networkdiagnose.model.CheckNetworkResultAct;
import com.yy.hiyo.module.networkdiagnose.model.OnCheckProgressListener;

public class CheckNetworkWindow
extends DefaultWindow
implements OnCheckProgressListener,
View.OnClickListener {
    private YYImageView mYYImageViewCheckStatusIcon;
    private YYImageView mYYImageViewCheckClose;
    private YYTextView mYYTextViewProgress;
    private YYButton mYYButtonGoto;
    private View mRootView;
    private XQJustifyTextView mXQJustifyTextView;
    private CheckNetworkResultAct mCheckNetworkResultAct;
    private AbstractWindowManager mAbstractWindowManager;

    public CheckNetworkWindow(Context context, UICallBacks callBacks, String name, AbstractWindowManager windowManager) {
        super(context, callBacks, name);
        this.mAbstractWindowManager = windowManager;
        this.mRootView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_checking_network, null);
        this.getBaseLayer().addView(this.mRootView, new ViewGroup.LayoutParams(-1, -1));
        this.initView();
    }

    private void initView() {
        this.mYYImageViewCheckClose = (YYImageView)this.mRootView.findViewById(R.id.check_network_close_iv);
        this.mYYImageViewCheckStatusIcon = (YYImageView)this.mRootView.findViewById(R.id.check_network_status_iv);
        this.mYYTextViewProgress = (YYTextView)this.mRootView.findViewById(R.id.check_network_tips_progress_tv);
        this.mYYButtonGoto = (YYButton)this.mRootView.findViewById(R.id.check_network_goto_btn);
        this.mYYButtonGoto.setVisibility(4);
        this.mXQJustifyTextView = (XQJustifyTextView)this.mRootView.findViewById(R.id.check_network_tips_tv);
        this.mYYImageViewCheckClose.setOnClickListener((View.OnClickListener)this);
        this.mYYTextViewProgress.setText((CharSequence)StringUtils.format((String)this.getResources().getString(R.string.check_network_progress_desc), (Object[])new Object[]{"5%"}));
    }

    @Override
    public void onCheckProgress(int progress) {
        this.mYYTextViewProgress.setText((CharSequence)StringUtils.format((String)this.getResources().getString(R.string.check_network_progress_desc), (Object[])new Object[]{progress + "%"}));
    }

    @Override
    public void onComplete(CheckNetworkResultAct checkNetworkResultAct) {
        this.mCheckNetworkResultAct = checkNetworkResultAct;
        this.mYYTextViewProgress.setText((CharSequence)checkNetworkResultAct.getIAct().actDesc());
        this.mYYImageViewCheckStatusIcon.setImageResource(R.drawable.ic_checking_network_error);
        this.mXQJustifyTextView.setVisibility(4);
        this.mYYButtonGoto.setVisibility(0);
        this.mYYButtonGoto.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        this.mAbstractWindowManager.popWindow(false, (AbstractWindow)this);
        if (R.id.check_network_goto_btn == v.getId()) {
            this.mCheckNetworkResultAct.getIAct().goToAct((Activity)this.getContext());
        }
    }
}

