/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.networkdiagnose.model.resource.dns.localdns;

import com.yy.hiyo.module.networkdiagnose.model.resource.dns.localdns.DnsException;
import com.yy.hiyo.module.networkdiagnose.model.resource.dns.localdns.DnsMessage;
import com.yy.hiyo.module.networkdiagnose.model.resource.dns.localdns.Record;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Random;

public final class Resolver {
    private static final Random random = new Random();
    final InetAddress address;

    public Resolver(InetAddress address) {
        this.address = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record[] resolve(String domain) throws IOException {
        int id2;
        Random random = Resolver.random;
        synchronized (random) {
            id2 = Resolver.random.nextInt() & 0xFF;
        }
        byte[] query = DnsMessage.buildQuery(domain, id2);
        byte[] answer = this.udpCommunicate(query);
        if (answer == null) {
            throw new DnsException(domain, "cant get answer");
        }
        return DnsMessage.parseResponse(answer, id2, domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] udpCommunicate(byte[] question) throws IOException {
        try (DatagramSocket socket = null;){
            socket = new DatagramSocket();
            DatagramPacket packet = new DatagramPacket(question, question.length, this.address, 53);
            socket.setSoTimeout(10000);
            socket.send(packet);
            packet = new DatagramPacket(new byte[1500], 1500);
            socket.receive(packet);
            byte[] byArray = packet.getData();
            return byArray;
        }
    }
}

