/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.networkdiagnose.model.resource.dns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DNS {
    private static final String F_Start = "<iframe src=\"";
    private static final String F_End = ".php";
    private static final String C_Start = "<tr>";
    private static final String C_End = "</table>";

    private static InetAddress[] getByCommand() {
        try {
            Process process = Runtime.getRuntime().exec("getprop");
            InputStream inputStream = process.getInputStream();
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(inputStream));
            String line = null;
            ArrayList<InetAddress> servers = new ArrayList<InetAddress>(5);
            while ((line = lnr.readLine()) != null) {
                InetAddress ip;
                int split = line.indexOf("]: [");
                if (split == -1) continue;
                String property = line.substring(1, split);
                String value = line.substring(split + 4, line.length() - 1);
                if (!property.endsWith(".dns") && !property.endsWith(".dns1") && !property.endsWith(".dns2") && !property.endsWith(".dns3") && !property.endsWith(".dns4") || (ip = InetAddress.getByName(value)) == null || (value = ip.getHostAddress()) == null || value.length() == 0) continue;
                servers.add(ip);
            }
            if (servers.size() > 0) {
                return servers.toArray(new InetAddress[servers.size()]);
            }
        }
        catch (IOException e) {
            Logger.getLogger("AndroidDnsServer").log(Level.WARNING, "Exception in findDNSByExec", e);
        }
        return null;
    }

    private static InetAddress[] getByReflection() {
        try {
            Class<?> SystemProperties = Class.forName("android.os.SystemProperties");
            Method method = SystemProperties.getMethod("get", String.class);
            ArrayList<InetAddress> servers = new ArrayList<InetAddress>(5);
            for (String propKey : new String[]{"net.dns1", "net.dns2", "net.dns3", "net.dns4"}) {
                InetAddress ip;
                String value = (String)method.invoke(null, propKey);
                if (value == null || value.length() == 0 || (ip = InetAddress.getByName(value)) == null || (value = ip.getHostAddress()) == null || value.length() == 0 || servers.contains(ip)) continue;
                servers.add(ip);
            }
            if (servers.size() > 0) {
                return servers.toArray(new InetAddress[servers.size()]);
            }
        }
        catch (Exception e) {
            Logger.getLogger("AndroidDnsServer").log(Level.WARNING, "Exception in findDNSByReflection", e);
        }
        return null;
    }

    public static String[] local() {
        InetAddress[] addresses = DNS.getByReflection();
        if (addresses == null && (addresses = DNS.getByCommand()) == null) {
            return new String[0];
        }
        String[] ret = new String[addresses.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = addresses[i].toString();
            if (ret[i].indexOf(47) != 0) continue;
            ret[i] = ret[i].substring(1);
        }
        return ret;
    }
}

