/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.homeplan;

import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserAgeLevelService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.IUserAgeLevelCallback;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.policy.srv.minors.AgeInfo;
import net.ihago.policy.srv.minors.GetAgeLevelReq;
import net.ihago.policy.srv.minors.GetAgeLevelRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0005J\u0012\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/yy/hiyo/module/homeplan/UserAgeLevelService;", "Lcom/yy/appbase/service/IUserAgeLevelService;", "Lcom/yy/framework/core/INotify;", "()V", "TAG", "", "mAgeLevelMap", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "mCallback", "Lcom/yy/appbase/service/callback/IUserAgeLevelCallback;", "getAgeLevel", "uid", "notify", "", "notification", "Lcom/yy/framework/core/Notification;", "requestAgeLevel", "birthday", "setCallback", "callback", "main_googlePlayBillDebug"})
public final class UserAgeLevelService
implements IUserAgeLevelService,
INotify {
    private final String TAG = "UserAgeLevelService";
    private final HashMap<Long, Integer> mAgeLevelMap = new HashMap();
    private IUserAgeLevelCallback mCallback;

    public void setCallback(@Nullable IUserAgeLevelCallback callback) {
        this.mCallback = callback;
    }

    public int getAgeLevel(long uid) {
        if (uid <= 0L) {
            return -1;
        }
        Integer level = this.mAgeLevelMap.get(uid);
        if (level != null) {
            return level;
        }
        level = SettingFlags.getIntValue((String)("agelevel_" + uid), (int)-1);
        int n = -1;
        if (level != n) {
            ((Map)this.mAgeLevelMap).put(uid, level);
        }
        this.requestAgeLevel(uid);
        return level;
    }

    public void notify(@NotNull Notification notification) {
        Intrinsics.checkParameterIsNotNull((Object)notification, (String)"notification");
        if (notification.id == NotificationDef.N_USER_INFO_UPDATED && AccountUtil.getUid() > 0L) {
            MLog.info((Object)this.TAG, (String)"user info update notify", (Object[])new Object[0]);
            this.requestAgeLevel(AccountUtil.getUid());
        }
    }

    public final void requestAgeLevel(long uid) {
        if (uid != AccountUtil.getUid()) {
            this.requestAgeLevel(uid, "");
        } else {
            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
            UserInfoKS userInfo = iServiceManager != null && (iServiceManager = (IUserInfoService)iServiceManager.getService(IUserInfoService.class)) != null ? iServiceManager.getUserInfo(uid) : null;
            Object object = userInfo;
            if (object == null || (object = object.birthday) == null) {
                object = "";
            }
            this.requestAgeLevel(uid, (String)object);
        }
    }

    public final void requestAgeLevel(long uid, @NotNull String birthday) {
        Intrinsics.checkParameterIsNotNull((Object)birthday, (String)"birthday");
        AgeInfo ageInfo = new AgeInfo.Builder().uid(Long.valueOf(uid)).birthday(birthday).build();
        GetAgeLevelReq req2 = new GetAgeLevelReq.Builder().infos(Collections.singletonList(ageInfo)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req2, (IProtoCallback)new SimpleProtoCallback<GetAgeLevelRes>(this, uid, this.TAG){
            final /* synthetic */ UserAgeLevelService this$0;
            final /* synthetic */ long $uid;

            public void onResponse(@NotNull GetAgeLevelRes message, long code, @NotNull String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)UserAgeLevelService.access$getTAG$p(this.this$0), (String)("get age level respone: " + message), (Object[])new Object[0]);
                if (ProtoManager.isSuccessCode((long)code)) {
                    AgeInfo ageInfo = (AgeInfo)message.infos.get(0);
                    Map map = UserAgeLevelService.access$getMAgeLevelMap$p(this.this$0);
                    Long l = ageInfo.uid;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"ageInfo.uid");
                    Integer n = ageInfo.level;
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"ageInfo.level");
                    map.put(l, n);
                    if (this.$uid == AccountUtil.getUid()) {
                        String string2 = "agelevel_" + this.$uid;
                        Integer n2 = ageInfo.level;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"ageInfo.level");
                        SettingFlags.setIntValue((String)string2, (int)n2);
                    }
                    IUserAgeLevelCallback iUserAgeLevelCallback = UserAgeLevelService.access$getMCallback$p(this.this$0);
                    if (iUserAgeLevelCallback != null) {
                        Integer n3 = ageInfo.level;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"ageInfo.level");
                        iUserAgeLevelCallback.onAgeLevelFetched(this.$uid, n3.intValue());
                    }
                } else {
                    ((Map)UserAgeLevelService.access$getMAgeLevelMap$p(this.this$0)).put(this.$uid, -1);
                }
            }

            public void onError(@Nullable String reason, int code) {
                super.onError(reason, code);
                ((Map)UserAgeLevelService.access$getMAgeLevelMap$p(this.this$0)).put(this.$uid, -1);
            }
            {
                this.this$0 = $outer;
                this.$uid = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
    }

    public UserAgeLevelService() {
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_USER_INFO_UPDATED, (INotify)this);
    }

    public static final /* synthetic */ String access$getTAG$p(UserAgeLevelService $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ HashMap access$getMAgeLevelMap$p(UserAgeLevelService $this) {
        return $this.mAgeLevelMap;
    }

    public static final /* synthetic */ IUserAgeLevelCallback access$getMCallback$p(UserAgeLevelService $this) {
        return $this.mCallback;
    }

    public static final /* synthetic */ void access$setMCallback$p(UserAgeLevelService $this, IUserAgeLevelCallback iUserAgeLevelCallback) {
        $this.mCallback = iUserAgeLevelCallback;
    }
}

