/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.home.base.startup;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.DiskCacheChecker;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.util.Hiido2TrackStatHandler;
import com.yy.appbase.util.HiidoEventInterceptor;
import com.yy.base.env.MyApplication;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.startup.StartUpExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.timing.TimingTracer;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.NotificationsUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.app.HagoEnvIniter;
import com.yy.hiyo.app.startup.StepInitUtils;
import com.yy.hiyo.home.base.perforstat.StartupStatHelper;
import com.yy.hiyo.home.base.startup.CrashInitUtil;
import com.yy.hiyo.home.base.startup.StartUpBridgeHelper;
import com.yy.hiyo.home.base.startup.StartUpRequestInfo;
import com.yy.hiyo.main.base.startup.IStartUpBridge;
import com.yy.hiyo.metric.IReportMetricSampleImpl;
import com.yy.hiyo.module.download.DownloadCenterHelper;
import com.yy.location.ILocationServiceFactory;
import com.yy.location.LocationHelper;
import com.yy.location.inner.LocationServiceFactory;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import com.yy.yylite.commonbase.hiido.HiidoStatisInit;
import com.yy.yylite.commonbase.hiido.IReportMetricSample;
import com.yy.yylite.hiido.HiidoABTestJson;
import downloader.DownloadClient;
import downloader.client.IBasicParamsProvider;
import java.util.ArrayList;

public class StartUpManager {
    private static final String TAG = "StartUpManager";
    private StartUpRequestInfo mStartUpInfo;
    private IStartUpCallBack mCallBack;
    private StartUpExecutor mStartUpManager = new StartUpExecutor();
    private ArrayList<StartUpExecutor.Step> mBaseSteps = new ArrayList();
    private ArrayList<StartUpExecutor.Step> mStepsAfterSplash = new ArrayList();
    private ArrayList<StartUpExecutor.Step> mStepsAfterStorageCheck = new ArrayList();
    private ArrayList<StartUpExecutor.Step> mStepsAfterFinish = new ArrayList();
    private IStartUpBridge mModuleLoadersManager;
    private Runnable mDelayInitedRunnable = new Runnable(){

        @Override
        public void run() {
            if (StartUpManager.this.mStepsAfterFinish.size() <= 0) {
                return;
            }
            for (StartUpExecutor.Step step : StartUpManager.this.mStepsAfterFinish) {
                StartUpManager.this.mStartUpManager.runInMainThread(step);
            }
        }
    };

    public StartUpManager(IStartUpCallBack callBack) {
        this.mCallBack = callBack;
        this.mModuleLoadersManager = HagoEnvIniter.getModuleLoadersManager();
        this.mBaseSteps.add(new InitUtils());
        this.mBaseSteps.add(new InitBaseEnv());
        this.mBaseSteps.add(new StepRequestHomepageData());
        this.mBaseSteps.add(new ShowSplash());
        this.mStepsAfterSplash.add(new StepInitCrash());
        this.mStepsAfterSplash.add(new StepStorageCheck(new DiskCacheChecker.ICheckCallBack(){

            public void onFinished() {
                if (RuntimeContext.isHagoPartySdk()) {
                    for (StartUpExecutor.Step step : StartUpManager.this.mStepsAfterStorageCheck) {
                        step.run();
                    }
                } else {
                    for (StartUpExecutor.Step step : StartUpManager.this.mStepsAfterStorageCheck) {
                        StartUpManager.this.mStartUpManager.runInMainThread(step);
                    }
                }
            }
        }));
        this.mStepsAfterStorageCheck.add(new InitServicesEnv());
        this.mStepsAfterStorageCheck.add(new StepInitDownload());
        this.mStepsAfterStorageCheck.add(new StepStartUpFinish());
        this.mStepsAfterFinish.add(new StepInitHiddo(false));
        this.mStepsAfterFinish.add(new StepLoadCocosSo());
        this.mStepsAfterFinish.add(new StepLazyLog());
        this.mStepsAfterFinish.add(new StepNotification());
        this.mStepsAfterFinish.add(new StepAudience());
    }

    public void onMainActivityCreate(FragmentActivity activity) {
        this.mModuleLoadersManager.onMainActivityCreate(activity);
    }

    public void onMainActivityCreated() {
        this.mModuleLoadersManager.onMainActivityCreated();
    }

    public void onMainActivityDestroy() {
        this.mModuleLoadersManager.onMainActivityDestroy();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        this.mModuleLoadersManager.onActivityResult(requestCode, resultCode, data);
    }

    public void start(StartUpRequestInfo info) {
        TimingTracer.addSplit((String)"startup", (String)"StartUpManager start");
        this.mStartUpInfo = info;
        this.start();
    }

    private void start() {
        for (StartUpExecutor.Step step : this.mBaseSteps) {
            step.run();
        }
    }

    public void onSplashFinished() {
        if (RuntimeContext.isHagoPartySdk()) {
            for (StartUpExecutor.Step step : this.mStepsAfterSplash) {
                step.run();
            }
        } else {
            for (StartUpExecutor.Step step : this.mStepsAfterSplash) {
                this.mStartUpManager.runInMainThread(step);
            }
        }
    }

    public void onSplashHidden() {
        YYTaskExecutor.removeTask((Runnable)this.mDelayInitedRunnable);
        if (this.mStartUpInfo != null && this.mStartUpInfo.getStartupFrom() != 1) {
            YYTaskExecutor.postToMainThread((Runnable)this.mDelayInitedRunnable, (long)200L);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)this.mDelayInitedRunnable, (long)600L);
        }
    }

    public void afterEnvInit() {
        this.mModuleLoadersManager.afterEnvInit();
        this.mModuleLoadersManager.ensureKvoModuleRegister();
    }

    public void afterStartup() {
        this.mModuleLoadersManager.initModuleAfterStartup();
    }

    public void afterStartupOneSecond() {
        this.mModuleLoadersManager.initModuleAfterStartupOneSecond();
    }

    public void afterStartupThreeSecond() {
        this.mModuleLoadersManager.initModuleAfterStartupThreeSecond();
    }

    public void afterStartupFiveSecond() {
        this.mModuleLoadersManager.initModuleAfterStartupFiveSecond();
    }

    public void afterStartupTenSecond() {
        this.mModuleLoadersManager.initModuleAfterStartupTenSecond();
    }

    private void initHiidoSdk(String json) {
        HiidoStatisInit.INSTANCE.iniHiidoSdk(true, json, (HiidoStatis.IHiidoEventInterceptor)new HiidoEventInterceptor(), (HiidoStatis.ITrackStatEventHandler)new Hiido2TrackStatHandler(), (IReportMetricSample)new IReportMetricSampleImpl());
    }

    private class StepAudience
    extends MyStep {
        private StepAudience() {
        }

        public void doAction() {
            if (RuntimeContext.isHagoPartySdk()) {
                return;
            }
            StartUpBridgeHelper.INSTANCE.getStartUpBridge().onAudienceInit();
        }

        public String getDescription() {
            return "StepAudience";
        }

        public int getID() {
            return 0;
        }
    }

    private class StepLazyLog
    extends MyStep {
        private StepLazyLog() {
        }

        public void doAction() {
            YYTaskExecutor.getDefaultIdleExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    MLog.info((Object)"MyApplication", (String)"packgename:%s, CurProcessName %s, sIsDebuggable %d, phoneType %d, Cpu arch: %s, Device: %s", (Object[])new Object[]{RuntimeContext.sPackageName, RuntimeContext.sCurProcessName, RuntimeContext.sIsDebuggable ? 1 : 0, RuntimeContext.getPhoneType(), HardwareUtils.getCpuArch(), Build.BRAND + "_" + Build.DEVICE});
                    MLog.info((Object)"MyApplication", (String)"network is connect %d type %d", (Object[])new Object[]{NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) ? 1 : 0, NetworkUtils.getNetworkType((Context)RuntimeContext.sApplicationContext)});
                }
            }, 10000L);
        }

        public String getDescription() {
            return "StepLazyLog";
        }

        public int getID() {
            return 0;
        }
    }

    private abstract class MyStep
    extends StartUpExecutor.Step {
        private MyStep() {
        }

        public final void run() {
            super.run();
            TimingTracer.addSplit((String)"startup", (String)this.getDescription());
            StartupStatHelper.getStartPathLogger().add(this.getDescription(), new Object[0]);
        }
    }

    private class StepInitDownload
    extends MyStep {
        private StepInitDownload() {
        }

        public void doAction() {
            DownloadClient.setBasicParamsProvider((IBasicParamsProvider)new DownloadCenterHelper());
        }

        public String getDescription() {
            return "StepInitDownload";
        }

        public int getID() {
            return 0;
        }
    }

    private class StepLoadCocosSo
    extends MyStep {
        private StepLoadCocosSo() {
        }

        public void doAction() {
            if (RuntimeContext.isHagoPartySdk()) {
                return;
            }
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                }
            });
        }

        public String getDescription() {
            return "StepLoadCocosSo";
        }

        public int getID() {
            return 0;
        }
    }

    private class StepInitCrash
    extends MyStep {
        private StepInitCrash() {
        }

        public void doAction() {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    CrashInitUtil.initCrashSdk();
                }
            });
        }

        public String getDescription() {
            return "StepInitCrash";
        }

        public int getID() {
            return 0;
        }
    }

    private class StepNotification
    extends MyStep {
        private StepNotification() {
        }

        public void doAction() {
            if (RuntimeContext.isHagoPartySdk()) {
                return;
            }
            YYTaskExecutor.getDefaultIdleExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    NotificationsUtils.isNotificationEnabled((Context)RuntimeContext.sApplicationContext);
                }
            }, 8000L);
        }

        public String getDescription() {
            return "StepAfterFinish";
        }

        public int getID() {
            return 0;
        }
    }

    private class StepInitHiddo
    extends MyStep {
        boolean mImmediately;
        Runnable mRunnable = new Runnable(){

            @Override
            public void run() {
                IAB iab = NewABDefine.HIIDO_AND_HAGO_NEWPACKERMODULE.getTest();
                String json = HiidoABTestJson.parseHiidoAbTestJson((int)NewABDefine.HIIDO_AND_HAGO_NEWPACKERMODULE.getAbType().value(), (String)(iab != null ? iab.getValue("action") : ""));
                if (RuntimeContext.sIsDebuggable) {
                    long time = System.currentTimeMillis();
                    MLog.debug((Object)StartUpManager.TAG, (String)("parseHiidoAbTestJson json\uff1a " + json), (Object[])new Object[0]);
                    StartUpManager.this.initHiidoSdk(json);
                    MLog.debug((Object)StartUpManager.TAG, (String)("iniHiidoSdk time\uff1a " + (System.currentTimeMillis() - time)), (Object[])new Object[0]);
                } else {
                    StartUpManager.this.initHiidoSdk(json);
                }
            }
        };

        public StepInitHiddo(boolean immediately) {
            this.mImmediately = immediately;
        }

        public void doAction() {
            if (this.mImmediately) {
                this.mRunnable.run();
            } else {
                YYTaskExecutor.execute((Runnable)this.mRunnable, (long)3000L);
            }
        }

        public String getDescription() {
            return "StepInitHiddo";
        }

        public int getID() {
            return 0;
        }
    }

    private class StepRequestHomepageData
    extends MyStep {
        private StepRequestHomepageData() {
        }

        private void requestLivingNavData() {
            StartUpBridgeHelper.INSTANCE.getStartUpBridge().onRequestHomepageData();
        }

        public void doAction() {
            this.requestLivingNavData();
        }

        public String getDescription() {
            return "StepRequestLiveNavData";
        }

        public int getID() {
            return 0;
        }

        protected boolean needRedo() {
            return true;
        }
    }

    private class InitUtils
    extends MyStep {
        private InitUtils() {
        }

        public void doAction() {
            new StepInitUtils().init();
        }

        public int getID() {
            return 0;
        }

        public String getDescription() {
            return "InitUtils";
        }
    }

    private class InitBaseEnv
    extends MyStep {
        private InitBaseEnv() {
        }

        public void doAction() {
            StartUpManager.this.mCallBack.initBaseEnv();
            StartupStatHelper.onEnvInited();
        }

        public int getID() {
            return 0;
        }

        public String getDescription() {
            return "InitBaseEnv";
        }

        protected boolean needRedo() {
            return true;
        }
    }

    private class ShowSplash
    extends MyStep {
        private ShowSplash() {
        }

        public void doAction() {
            StartUpManager.this.mCallBack.showSplash();
        }

        public int getID() {
            return 0;
        }

        public String getDescription() {
            return "ShowSplash";
        }

        protected boolean needRedo() {
            return true;
        }
    }

    private class InitServicesEnv
    extends MyStep {
        private InitServicesEnv() {
        }

        public void doAction() {
            StartupStatHelper.onServicesInit();
            StartUpManager.this.mCallBack.initServicesEnv();
            StartupStatHelper.onServicesInited();
        }

        public int getID() {
            return 0;
        }

        public String getDescription() {
            return "InitServicesEnv";
        }

        protected boolean needRedo() {
            return true;
        }
    }

    private class StepStorageCheck
    extends MyStep {
        private DiskCacheChecker.ICheckCallBack mCheckCallBack;

        StepStorageCheck(DiskCacheChecker.ICheckCallBack checkCallBack) {
            this.mCheckCallBack = checkCallBack;
        }

        public void doAction() {
            if (RuntimeContext.isHagoPartySdk()) {
                MyApplication.initLogging((boolean)true);
                this.mCheckCallBack.onFinished();
                return;
            }
            SettingFlags.setBoolean((String)"hasstorageper", (boolean)true);
            this.startCheckInnerStorage();
            StartupStatHelper.getStartPathLogger().add("StepCheckStoragePermission", new Object[0]);
            if (!RuntimeContext.isHagoPartySdk()) {
                this.setLocationPermission();
            }
        }

        private void startCheckInnerStorage() {
            DiskCacheChecker.startCheckInnerStorage((DiskCacheChecker.ICheckCallBack)this.mCheckCallBack, (Activity)StartUpManager.this.mCallBack.getActivity());
        }

        private void setLocationPermission() {
            LocationHelper.setLocationFactory((ILocationServiceFactory)new LocationServiceFactory());
            LocationHelper.setPermissionHandler((LocationHelper.IPermissionHandler)new LocationHelper.IPermissionHandler(){

                public boolean checkPermission() {
                    return PermissionHelper.hasLocationPermission((Activity)StartUpManager.this.mCallBack.getActivity());
                }

                public void requestPermission(final LocationHelper.IPermissionCallBack callBack) {
                    PermissionHelper.requestLocationPermission((Activity)StartUpManager.this.mCallBack.getActivity(), (IPermissionListener)new IPermissionListener(){

                        public void onPermissionGranted(@NonNull String[] permission) {
                            if (callBack != null) {
                                callBack.onGrented();
                            }
                        }

                        public void onPermissionDenied(@NonNull String[] permission) {
                            if (callBack != null) {
                                callBack.onDenied();
                            }
                        }
                    }, (boolean)false);
                }
            });
        }

        public int getID() {
            return 0;
        }

        public String getDescription() {
            return "StepStorageCheck";
        }

        protected boolean needRedo() {
            return true;
        }
    }

    private class StepStartUpFinish
    extends MyStep {
        private StepStartUpFinish() {
        }

        public void doAction() {
            StartUpManager.this.mCallBack.onFinished();
        }

        public int getID() {
            return 0;
        }

        public String getDescription() {
            return "StepStartUpFinish";
        }

        protected boolean needRedo() {
            return true;
        }
    }

    public static interface IStartUpCallBack {
        public void initBaseEnv();

        public void showSplash();

        public void initServicesEnv();

        public void onFinished();

        public Activity getActivity();
    }
}

