/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.crashprotect;

import android.os.Looper;
import android.util.Log;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CrashProtectConfig;
import com.yy.appbase.unifyconfig.config.TryCatchSwitchConfig;
import com.yy.base.crash.CrashMonitor;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ThrowUtils;
import com.yy.hiyo.app.perf.PerfManager;
import com.yy.hiyo.crashprotect.CrashPreProtecter;
import java.util.concurrent.TimeoutException;

public class CrashProtecter {
    private static final String TAG = "CrashProtecter";
    private static volatile boolean sInited = false;
    private static volatile boolean sMonnintorInited = false;
    private static volatile int sProtectTimes = 0;
    private static Thread.UncaughtExceptionHandler sDefaultHandler;

    public static synchronized void init() {
        CrashProtecter.initUnCaughtHandler();
        CrashProtecter.initMonitorChecker();
    }

    private static void initUnCaughtHandler() {
        if (sInited) {
            return;
        }
        if (!CrashProtecter.isOpenUnCaughtHandler()) {
            MLog.info((Object)TAG, (String)"close UnCaughtHandler", (Object[])new Object[0]);
            return;
        }
        CrashProtecter.logError(TAG, "init!");
        sInited = true;
        sDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                String eString;
                if (!CrashProtecter.isCatchProtectOpen()) {
                    CrashProtecter.logError(CrashProtecter.TAG, e);
                    sDefaultHandler.uncaughtException(t, e);
                    return;
                }
                String string2 = eString = e != null ? e.toString() : "";
                if (t == Looper.getMainLooper().getThread()) {
                    if (CrashProtecter.needCatch(e, true, eString)) {
                        CrashProtecter.logError(CrashProtecter.TAG, e);
                        CrashProtecter.loopAgain();
                    } else {
                        CrashProtecter.logError(CrashProtecter.TAG, e);
                        sDefaultHandler.uncaughtException(t, e);
                    }
                } else {
                    if (e instanceof TimeoutException) {
                        String message = eString;
                        if (message != null && message.contains("finalize") && sProtectTimes < 20) {
                            PerfManager.statCrashProtect(e, eString);
                            ++sProtectTimes;
                            return;
                        }
                        CrashProtecter.logError(CrashProtecter.TAG, sProtectTimes + ",TimeoutException not catch:", e);
                    } else {
                        String message = eString;
                        if (message != null && message.contains("java.util.concurrent.TimeoutException") && message.contains("finalize") && sProtectTimes < 20) {
                            PerfManager.statCrashProtect(e, eString);
                            ++sProtectTimes;
                            return;
                        }
                        CrashProtecter.logError(CrashProtecter.TAG, sProtectTimes + ",TimeoutException not catch:", e);
                    }
                    if (CrashProtecter.needCatch(e, false, eString)) {
                        CrashProtecter.logError(CrashProtecter.TAG, e);
                        return;
                    }
                    CrashProtecter.logError(CrashProtecter.TAG, e);
                    sDefaultHandler.uncaughtException(t, e);
                }
            }
        });
    }

    private static boolean isCatchProtectOpen() {
        if (SystemUtils.isShowEnvSetting()) {
            return false;
        }
        return RuntimeContext.sIsDebuggable || SettingFlags.getBoolean((String)"crashprotectswitch", (boolean)true);
    }

    private static boolean isOpenUnCaughtHandler() {
        if (RuntimeContext.isHagoPartySdk()) {
            return true;
        }
        return CrashProtecter.isCatchProtectOpen();
    }

    private static void logError(String tag, String msg) {
        MLog.error((Object)tag, (String)msg, (Object[])new Object[0]);
        Log.e((String)tag, (String)msg);
    }

    private static void logError(String tag, Throwable e) {
        MLog.error((Object)tag, (Throwable)e);
        Log.e((String)tag, (String)e.getMessage());
    }

    private static void logError(String tag, String msg, Throwable e) {
        MLog.error((Object)tag, (String)msg, (Throwable)e, (Object[])new Object[0]);
        Log.e((String)tag, (String)(msg + " ; " + e.getMessage()));
    }

    private static void initMonitorChecker() {
        if (sMonnintorInited) {
            return;
        }
        if (!TryCatchSwitchConfig.isOpen()) {
            return;
        }
        sMonnintorInited = true;
        CrashMonitor.setTryCatchChecker((id2, e) -> {
            if (RuntimeContext.sIsDebuggable) {
                return false;
            }
            return CrashProtecter.checkSingleCatch(id2, e);
        });
    }

    private static void loopAgain() {
        ++CrashPreProtecter.sProtectTimesWhenNotStartUpFinish;
        ++sProtectTimes;
        try {
            Looper.loop();
        }
        catch (Throwable e) {
            String eString = e != null ? e.toString() : "";
            CrashProtecter.logError(TAG, "Looper.loop catch:" + eString);
            if (CrashProtecter.needCatch(e, true, eString)) {
                CrashProtecter.loopAgain();
            }
            if (sDefaultHandler != null) {
                sDefaultHandler.uncaughtException(Looper.getMainLooper().getThread(), e);
            }
            ThrowUtils.throwException((Throwable)e);
        }
    }

    private static boolean checkSingleCatch(String biz, Throwable e) {
        if (TryCatchSwitchConfig.isTryCatch((String)biz, (Throwable)e)) {
            if (TryCatchSwitchConfig.isTryCatchReport((String)biz)) {
                PerfManager.reportSingleCrash(e, biz, TryCatchSwitchConfig.stack((String)biz));
            }
            return true;
        }
        return false;
    }

    private static boolean needCatch(Throwable e, boolean uiThread, String eString) {
        try {
            if (e == null) {
                return false;
            }
            if (CrashProtecter.inCatchHardcodeList(e, eString)) {
                return true;
            }
            AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.CRASH_PROTECT);
            if (configData instanceof CrashProtectConfig) {
                String detailMsg;
                CrashProtectConfig config = (CrashProtectConfig)configData;
                boolean result = config.needCatchByExtInfoContain(uiThread, sProtectTimes, eString);
                if (result) {
                    PerfManager.statCrashProtect(e, eString);
                    return result;
                }
                String string2 = detailMsg = StringUtils.isNotEmpty((String)eString) ? eString : e.getMessage();
                if (detailMsg != null) {
                    result = config.needCatchByExtInfoContain(uiThread, sProtectTimes, detailMsg);
                }
                if (result) {
                    PerfManager.statCrashProtect(e, detailMsg);
                    CrashProtecter.logError(TAG, sProtectTimes + ",catched by detailMsg:" + detailMsg);
                    return result;
                }
                CrashProtecter.logError(TAG, sProtectTimes + ",not catched by detailMsg:" + (detailMsg != null ? detailMsg : ""));
                StackTraceElement[] elements = null;
                try {
                    elements = e.getStackTrace();
                }
                catch (Throwable throwable) {
                    return false;
                }
                result = config.needCatch(uiThread, elements, sProtectTimes);
                if (result) {
                    PerfManager.statCrashProtect(e, eString);
                } else if (elements != null) {
                    if (elements.length <= 4) {
                        if (elements.length >= 1) {
                            StackTraceElement elementOne = elements[0];
                            CrashProtecter.log(elementOne, "StackTraceElement elementOne");
                        }
                        CrashProtecter.logError(TAG, sProtectTimes + ",StackTraceElement length not valid:" + elements.length);
                    } else {
                        StackTraceElement elementOne = elements[0];
                        StackTraceElement elementTwo = elements[1];
                        CrashProtecter.log(elementOne, "StackTraceElement elementOne");
                        CrashProtecter.log(elementTwo, "StackTraceElement elementTwo");
                    }
                }
                return result;
            }
            CrashProtecter.logError(TAG, "config is Empty!");
            return CrashPreProtecter.needCatchWhenNotStartFinish(e, uiThread);
        }
        catch (Throwable e2) {
            CrashProtecter.logError(TAG, e2);
            return false;
        }
    }

    private static void log(StackTraceElement element, String tagPrefix) {
        String className = "";
        String fileName = "";
        String methodName = "";
        int lineNumber = -1;
        if (element != null) {
            className = element.getClassName();
            fileName = element.getFileName();
            methodName = element.getMethodName();
            lineNumber = element.getLineNumber();
            CrashProtecter.logError(TAG, tagPrefix + " className:" + (className != null ? className : "") + ",fileName:" + (fileName != null ? fileName : "") + ",methodName:" + (methodName != null ? methodName : "") + ",lineNumber" + lineNumber);
        } else {
            CrashProtecter.logError(TAG, tagPrefix + " null");
        }
    }

    private static boolean inCatchHardcodeList(Throwable e, String eString) {
        if (e != null && StringUtils.isNotEmpty((String)e.getMessage()) && e.getMessage().contains("did not then call Service.startForeground")) {
            PerfManager.statCrashProtect(e, eString);
            return true;
        }
        if (e == null) {
            return false;
        }
        String errorMsg = e.getMessage();
        errorMsg = errorMsg == null ? "" : errorMsg;
        String causeMsg = e.getCause() != null ? e.getCause().getMessage() : errorMsg;
        causeMsg = StringUtils.isEmpty((String)causeMsg) ? errorMsg : causeMsg;
        MLog.info((Object)TAG, (String)"inCatchHardcodeList errorMsg: %s, causeMsg: %s", (Object[])new Object[]{errorMsg, causeMsg});
        if (StringUtils.isEmpty((String)errorMsg) && StringUtils.isEmpty((String)causeMsg)) {
            return false;
        }
        if (errorMsg.contains("Bad notification posted from package com.live.party")) {
            PerfManager.statCrashProtect(e, eString);
            return true;
        }
        if (errorMsg.contains("Using WebView from more than one process at once with the same data directory") || e instanceof RuntimeException && errorMsg.contains("at org.chromium.android_webview.AwBrowserProcess.b(PG:11)")) {
            if (SettingFlags.hasInited()) {
                SettingFlags.setBoolean((String)"adnotusemultiprocess", (boolean)true);
            }
            PerfManager.statCrashProtect(e, eString);
            return true;
        }
        if (errorMsg.contains("android.app.RemoteServiceException") && errorMsg.contains("Bad notification posted from package")) {
            PerfManager.statCrashProtect(e, eString);
            return true;
        }
        if (causeMsg.contains("Transaction failed on small parcel; remote process probably died")) {
            PerfManager.statCrashProtect(e, eString);
            return true;
        }
        return false;
    }

    public static boolean handleCachedExe(Throwable e, boolean uiThread) {
        String eString = e != null ? e.toString() : "";
        CrashProtecter.logError(TAG, "handleCachedExe:" + eString);
        boolean needCatch = CrashProtecter.needCatch(e, uiThread, eString);
        if (!needCatch) {
            throw new RuntimeException(e);
        }
        return needCatch;
    }
}

