/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.crashprotect;

import android.os.Looper;
import android.util.Log;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ThrowUtils;
import com.yy.hiyo.crashprotect.CrashProtecter;

public class CrashPreProtecter {
    private static volatile boolean sInited = false;
    public static volatile int sProtectTimesWhenNotStartUpFinish = 0;
    private static Thread.UncaughtExceptionHandler sDefaultHandler;
    private static Throwable errorExcepToHandler;
    private static boolean errorExcepToHandlerInUiThread;
    private static boolean switchOn;

    public static synchronized void init() {
        CrashPreProtecter.initUnCaughtHandler();
    }

    private static void initUnCaughtHandler() {
        if (sInited) {
            return;
        }
        if (!RuntimeContext.sIsDebuggable && SettingFlags.hasInited() && !SettingFlags.getBoolean((String)"crashprotectswitch", (boolean)true)) {
            return;
        }
        CrashPreProtecter.logError("CrashPreProtecter", "init!");
        sInited = true;
        sDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (t == Looper.getMainLooper().getThread()) {
                    if (CrashPreProtecter.needCatchWhenNotStartFinish(e, true)) {
                        CrashPreProtecter.logError("CrashPreProtecterr", "catch:" + (e != null ? e.toString() : ""));
                        CrashPreProtecter.loopAgain(e);
                    } else {
                        sDefaultHandler.uncaughtException(t, e);
                    }
                } else {
                    if (CrashPreProtecter.needCatchWhenNotStartFinish(e, false)) {
                        CrashPreProtecter.logError("CrashPreProtecterr", "catch:" + (e != null ? e.toString() : ""));
                        return;
                    }
                    sDefaultHandler.uncaughtException(t, e);
                }
            }
        });
    }

    private static void loopAgain(Throwable cause) {
        ++sProtectTimesWhenNotStartUpFinish;
        try {
            Looper.loop();
        }
        catch (Throwable e) {
            if (CrashPreProtecter.needCatchWhenNotStartFinish(e, true)) {
                CrashPreProtecter.loopAgain(cause);
            }
            if (sDefaultHandler != null) {
                if (e != null && e != cause && cause != null) {
                    e.addSuppressed(cause);
                }
                sDefaultHandler.uncaughtException(Looper.getMainLooper().getThread(), e);
            }
            if (e != null && e != cause && cause != null) {
                e.addSuppressed(cause);
            }
            ThrowUtils.throwException((Throwable)e);
        }
    }

    private static boolean inCatchHardcodeList(Throwable e) {
        if (e == null) {
            return false;
        }
        if (sProtectTimesWhenNotStartUpFinish > 10) {
            return false;
        }
        String errorMsg = e.getMessage();
        if (StringUtils.isEmpty((String)errorMsg)) {
            return false;
        }
        if (errorMsg.contains("Using WebView from more than one process at once with the same data directory") || e instanceof RuntimeException && errorMsg.contains("at org.chromium.android_webview.AwBrowserProcess.b(PG:11)")) {
            if (SettingFlags.hasInited()) {
                SettingFlags.setBoolean((String)"adnotusemultiprocess", (boolean)true);
            }
            return true;
        }
        return errorMsg.contains("android.app.RemoteServiceException") && errorMsg.contains("Bad notification posted from package");
    }

    public static boolean needCatchWhenNotStartFinish(Throwable e, boolean uiThread) {
        if (e == null) {
            return false;
        }
        if (CrashPreProtecter.inCatchHardcodeList(e)) {
            return true;
        }
        if (sProtectTimesWhenNotStartUpFinish > 3 || !switchOn) {
            return false;
        }
        if (RuntimeContext.sIsAppStartFinishAfterFiveSecond) {
            return false;
        }
        if (errorExcepToHandler == null) {
            errorExcepToHandler = e;
            errorExcepToHandlerInUiThread = uiThread;
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (RuntimeContext.sIsAppStartFinishAfterFiveSecond) {
                        return;
                    }
                    if (errorExcepToHandler != null) {
                        CrashPreProtecter.logError("CrashPreProtecterr", "timeout!");
                        ThrowUtils.throwException((Throwable)errorExcepToHandler);
                    }
                }
            }, (long)15000L);
        }
        return true;
    }

    public static void afterStartupFiveSecond() {
        final Throwable throwable = errorExcepToHandler;
        if (throwable != null) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    CrashProtecter.handleCachedExe(throwable, errorExcepToHandlerInUiThread);
                }
            }, (long)3000L);
            switchOn = false;
            errorExcepToHandler = null;
        }
    }

    private static void logError(String tag, String msg) {
        MLog.error((Object)tag, (String)msg, (Object[])new Object[0]);
        Log.e((String)tag, (String)msg);
    }

    static {
        errorExcepToHandler = null;
        errorExcepToHandlerInUiThread = false;
        switchOn = true;
    }
}

