/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.core.register;

import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.paneldialog.PanelDialogController;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.IControllerRegister;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.app.AppController;
import com.yy.hiyo.app.deeplink.DeferredDeepLinkManager;
import com.yy.hiyo.app.handleintent.MsgHandleIntent;
import com.yy.hiyo.app.web.WebServiceWrapperController;
import com.yy.hiyo.app.web.grace.WebDispatchController;
import com.yy.hiyo.app.web.preload.WebPreloadController;
import com.yy.hiyo.channel.ChannelBaseMsgDef;
import com.yy.hiyo.channel.listentogether.ListenTogetherController;
import com.yy.hiyo.game.GameBaseMsgDef;
import com.yy.hiyo.game.base.GameNotificationDef;
import com.yy.hiyo.home.base.startup.StartUpBridgeHelper;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.hiyo.mixmodule.base.MixBaseMsgDef;
import com.yy.hiyo.module.floatwindow.FloatWindowController;
import com.yy.hiyo.module.grwothconfig.GrowthConfigController;
import com.yy.hiyo.module.hagoactivity.WebActController;
import com.yy.hiyo.module.handlefileIntent.HandleFileIntentController;
import com.yy.hiyo.module.handlefileIntent.HandleFileIntentMsgDef;
import com.yy.hiyo.module.keepalive.DarkModeReportController;
import com.yy.hiyo.module.networkdiagnose.NetworkDiagnoseController;
import com.yy.hiyo.module.performancemonitor.perfcollect.memorythread.MemoryThreadController;
import com.yy.hiyo.module.performancemonitor.perfcollect.memorythread.MemoryThreadMsgId;
import com.yy.hiyo.module.preconnect.HostPreConnectController;
import com.yy.hiyo.module.scan.ScanController;
import com.yy.hiyo.module.screenshot.GameScreenShotController;
import com.yy.hiyo.module.screenshot.ScreenShotController;
import com.yy.hiyo.module.setting.envsetting.DebugEnvSetttingIniter;
import com.yy.hiyo.module.setting.envsetting.debugrouting.DebugRoutingController;
import com.yy.hiyo.module.setting.envsetting.debugsvg.DebugSvgaController;
import com.yy.hiyo.module.setting.followus.FollowUsWindowController;
import com.yy.hiyo.module.setting.main.SettingController;
import com.yy.hiyo.module.setting.notification.NotificationController;
import com.yy.hiyo.module.setting.privacy.PrivacyController;
import com.yy.hiyo.module.socialmedia.FirebaseRemoteConfigController;
import com.yy.hiyo.module.splash.SplashController;
import com.yy.hiyo.module.upgrade.UpgradeController;
import com.yy.hiyo.module.yyuri.YYUriHandlerController;

public class ControllerRegistry
implements IControllerRegister.IControllerCenterCallback {
    private static final int MODE_DEPENDS_CONTROLLER_CREATED = 0x40000000;
    private IControllerRegister mRegister;
    private volatile boolean isRegisterNonCoreControllers = false;

    public ControllerRegistry(IControllerRegister register) {
        this.mRegister = register;
    }

    public void registerCoreControllers() {
        boolean delayRegisterNonCoreControllers;
        MLog.debug((Object)"ControllerRegistry", (String)"registerCoreControllers", (Object[])new Object[0]);
        this.registerAppController();
        this.registerWebServiceWrapperController();
        this.registerWebPluginController();
        this.registerYYUriHandlerController();
        this.registerHostPreConnectController();
        if (SystemUtils.isShowEnvSetting()) {
            this.registerEnvSettingController();
        }
        if (RuntimeContext.sIsDebuggable) {
            this.registerMemoryThreadController();
        }
        if (!RuntimeContext.isHagoPartySdk()) {
            this.registerSplashController();
            StartUpBridgeHelper.INSTANCE.getStartUpBridge().onRegisterCoreControllers(this.mRegister);
        }
        if (!RuntimeContext.isHagoPartySdk()) {
            this.registerDeferredDeepLinkManager();
        }
        if (!(delayRegisterNonCoreControllers = SettingFlags.getBoolean((String)"delay_register_non_core_controllers", (boolean)true))) {
            this.registerNonCoreControllers();
        }
    }

    public void onMsgHanderNotFind(int msgId) {
        this.registerNonCoreControllers();
        MsgDispatcher.getInstance().sendMessageSync(BaseMsgDef.ON_MSG_HANDLER_NOT_FIND, msgId);
    }

    public void registerNonCoreControllers() {
        if (this.isRegisterNonCoreControllers) {
            return;
        }
        this.isRegisterNonCoreControllers = true;
        MLog.debug((Object)"ControllerRegistry", (String)"registerNonCoreControllers..", (Object[])new Object[0]);
        this.registerNotificationController();
        this.registerSettingController();
        this.registerPrivacyController();
        this.registerGameScreenShotController();
        this.registerWebActController();
        this.registerFollowUsController();
        this.registerFloatWindowController();
        this.registerPanelDialogController();
        this.registerScanController();
        this.registerHandleFileIntentController();
        this.registerGrowthConfigController();
        if (!RuntimeContext.isHagoPartySdk()) {
            this.registerFirebaseRemoteConfigController();
            this.registerUpgradeController();
        }
        this.registerListenTogetherController();
        this.registerDebugSvgaController();
        this.registerDebugRoutingController();
        boolean isSwitchOn = SettingFlags.getBoolean((String)"dark_mode_report_switch", (boolean)false);
        if (isSwitchOn) {
            this.registerDarkModeReportController();
        }
        this.registerNetworkDiagnoseController();
    }

    private void registerScanController() {
        int[] messageIds = new int[]{BaseMsgDef.OPEN_SCANE};
        this.mRegister.registerController(messageIds, null, ScanController.class, ScanController::new);
    }

    private void registerAppController() {
        int[] messageIds = new int[]{MsgDef.ROOT_SPLASH_HIHHEN, MsgDef.ROOT_SPLASH_FINISH, BaseMsgDef.GOTO_HOMEPAGE, BaseMsgDef.GOTO_SESSION_PAGE, BaseMsgDef.APP_EXIT, BaseMsgDef.MIC_NOTIFYCATION_SHOW, MsgDef.ROOT_ONCREATE, MsgDef.ROOT_ONNEWINTENT, MsgDef.ROOT_ONSTOP, MsgDef.ROOT_ONBACKPRESS, AppbaseMsgDef.ROOT_ON_APP_DESTROY, MsgDef.ROOT_MOVE_TASK_TO_BACK, MsgDef.ROOT_START_GUEST_LOGIN, MsgDef.ROOT_ONACTIVITYRESULT, MsgDef.PARTY_SDK_ACTIVITY_DESTROY};
        int[] notificationIds = new int[]{NotificationDef.N_STARTUP_FINISHED, NotificationDef.N_LOGIN_SUCCESS, NotificationDef.N_PARTY_SDK_LOCALE_CHANGED};
        this.mRegister.registerController(messageIds, notificationIds, AppController.class, AppController::new);
    }

    private void registerHostPreConnectController() {
        int[] messageIds = new int[]{BaseMsgDef.MSG_ENTER_LOGIN, BaseMsgDef.MSG_ENTER_CHANNEL, BaseMsgDef.MSG_ENTER_RECHARGE};
        int[] notificationIds = new int[]{NotificationDef.N_FOREGROUND_CHANGE | 0x40000000};
        this.mRegister.registerController(messageIds, notificationIds, HostPreConnectController.class, HostPreConnectController::new);
    }

    private void registerNetworkDiagnoseController() {
        int[] messageIds = new int[]{BaseMsgDef.MSG_ENTER_NETWORK_DIAGNOSE};
        int[] notificationIds = new int[]{NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS};
        this.mRegister.registerController(messageIds, notificationIds, NetworkDiagnoseController.class, NetworkDiagnoseController::new);
    }

    private void registerWebServiceWrapperController() {
        int[] messageIds = new int[]{MsgDef.MSG_WEBSERVICEWRAPPER_LOADURL, MsgDef.MSG_WEBSERVICEWRAPPER_ADDGLOBALJSEVENT, MsgDef.MSG_WEBSERVICEWRAPPER_CREATEWEBMANAGER, MsgDef.MSG_WEBSERVICEWRAPPER_CREATEWEBPANEL, MsgDef.MSG_WEBSERVICEWRAPPER_LOADNOTIFYJS_WITH_ID, MsgDef.MSG_WEBSERVICEWRAPPER_LOADPUREJS, MsgDef.MSG_WEBSERVICEWRAPPER_REGISTERWEBBUSINESS, MsgDef.MSG_WEBSERVICEWRAPPER_REMOVEGLOBALJSEVENT, MsgDef.MSG_WEBSERVICEWRAPPER_UNREGISTERWEBBUSINESS, MsgDef.MSG_WEBSERVICEWRAPPER_PRECREATE_WEB};
        int[] notificationIds = new int[]{NotificationDef.N_LOGIN_LOGIN_OUT | 0x40000000, NotificationDef.N_PARTY_SDK_LOCALE_CHANGED | 0x40000000, NotificationDef.N_LOGIN_SUCCESS, NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS, NotificationDef.N_FOREGROUND_CHANGE | 0x40000000, NotificationDef.N_STARTUP_FINISHED_AFTER_10_SECONDS};
        this.mRegister.registerController(messageIds, notificationIds, WebServiceWrapperController.class, WebServiceWrapperController::new);
    }

    private void registerWebPluginController() {
        int[] preloadIds = new int[]{MsgDef.MSG_WEB_PRELOAD_INIT};
        this.mRegister.registerController(preloadIds, new int[0], WebPreloadController.class, WebPreloadController::new);
        int[] dispatchIds = new int[]{MsgDef.MSG_WEB_DISPATCH_INIT};
        this.mRegister.registerController(dispatchIds, new int[0], WebDispatchController.class, WebDispatchController::new);
    }

    private void registerYYUriHandlerController() {
        int[] messageIds = new int[]{MsgDef.MSG_YYURIHANDLER_HANDLEURI, MsgDef.MSG_YYURIHANDLER_HANDLEURISTRING, MsgDef.MSG_YYURIHANDLER_MATCHCODE, BaseMsgDef.MSG_GET_GAME_INVITE_LINK, MixBaseMsgDef.HOME_WIN_CREATE};
        int[] notificationIds = new int[]{NotificationDef.N_LOGIN_LOGIN_OUT, NotificationDef.N_PARTY_SDK_BASE_INIT, NotificationDef.N_SHOW_HOME_PAGE, NotificationDef.N_LOGIN_PROCESS_COMPLETED, NotificationDef.N_LOGIN_SUCCESS, NotificationDef.N_PERMISSION_REQUEST_SHOW, NotificationDef.N_PERMISSION_REQUEST_ANSWERED};
        this.mRegister.registerController(messageIds, notificationIds, YYUriHandlerController.class, YYUriHandlerController::new);
    }

    private void registerSplashController() {
        int[] messageIds = new int[]{MsgDef.SPLASH_SHOW, MsgDef.SPLASH_HIDE, MsgDef.SPLASH_SHOULD_SHOW, MsgDef.SPLASH_UPDATE_WINDOW, MsgDef.SPLASH_POSTPONE_START, MsgDef.SPLASH_POSTPONE_FINISH};
        int[] notificationIds = new int[]{NotificationDef.N_APP_DESTROY, NotificationDef.N_LOGIN_SUCCESS, NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS};
        this.mRegister.registerController(messageIds, notificationIds, SplashController.class, SplashController::new);
    }

    private void registerEnvSettingController() {
        DebugEnvSetttingIniter initer = new DebugEnvSetttingIniter();
        initer.registerEnvSettingController(this.mRegister);
    }

    private void registerNotificationController() {
        int[] messageIds = new int[]{MsgDef.SHOW_WINDOW_NOTIFICATION, MsgDef.CLOSE_WINDOW_NOTIFICATION};
        int[] notificationIds = new int[]{};
        this.mRegister.registerController(messageIds, notificationIds, NotificationController.class, NotificationController::new);
    }

    private void registerSettingController() {
        int[] messageIds = new int[]{BaseMsgDef.SHOW_WINDOW_SETTING, MsgDef.OPEN_WINDOW_PWD_MANAGE};
        this.mRegister.registerController(messageIds, null, SettingController.class, SettingController::new);
    }

    private void registerDebugRoutingController() {
        int[] messageIds = new int[]{BaseMsgDef.OPEN_ROUTING_KEY_DIALOG};
        this.mRegister.registerController(messageIds, null, DebugRoutingController.class, DebugRoutingController::new);
    }

    private void registerMemoryThreadController() {
        int[] messageIds = new int[]{MemoryThreadMsgId.OPEN_MONITOR, MemoryThreadMsgId.CLOSE_MONITOR, MemoryThreadMsgId.GET_MONITOR_VALUE};
        this.mRegister.registerController(messageIds, null, MemoryThreadController.class, MemoryThreadController::new);
    }

    private void registerScreenShotController() {
        int[] notificationIds = new int[]{NotificationDef.N_STARTUP_FINISHED_AFTER_5_SECONDS};
        this.mRegister.registerController(null, notificationIds, ScreenShotController.class, ScreenShotController::new);
    }

    private void registerGameScreenShotController() {
        int[] messageIds = new int[]{BaseMsgDef.MSG_GAME_SCREEN_SHOT_SHARE};
        this.mRegister.registerController(messageIds, null, GameScreenShotController.class, GameScreenShotController::new);
    }

    private void registerPrivacyController() {
        int[] messageIds = new int[]{MsgDef.OPEN_WINDOW_PRIVACY};
        this.mRegister.registerController(messageIds, null, PrivacyController.class, PrivacyController::new);
    }

    private void registerWebActController() {
        int[] messageIds = new int[]{GameBaseMsgDef.CallOutSide.IS_ACTIVITY_SYNC, GameBaseMsgDef.CallOutSide.GET_ACTIVITY_ID_SYNC};
        int[] notificationIds = new int[]{GameNotificationDef.GAME_MODLE_INIT, GameNotificationDef.MATCH_MODLE_INIT};
        this.mRegister.registerController(messageIds, notificationIds, WebActController.class, WebActController::new);
    }

    private void registerFollowUsController() {
        int[] messageIds = new int[]{MsgDef.OPEN_WINDOW_FOLLOW_US};
        this.mRegister.registerController(messageIds, null, FollowUsWindowController.class, FollowUsWindowController::new);
    }

    private void registerFloatWindowController() {
        int[] messageIds = new int[]{BaseMsgDef.ADD_FLOAT_WINDOW, BaseMsgDef.REMOVE_FLOAT_WINDOW};
        this.mRegister.registerController(messageIds, null, FloatWindowController.class, FloatWindowController::new);
    }

    private void registerPanelDialogController() {
        int[] messageIds = new int[]{BaseMsgDef.SHOW_PANEL_DIALOG, BaseMsgDef.SHOW_PANEL_DIALOG_WEB_VIEW};
        this.mRegister.registerController(messageIds, null, PanelDialogController.class, PanelDialogController::new);
    }

    private void registerHandleFileIntentController() {
        int[] msgIds = new int[]{MsgHandleIntent.INSTANCE.getMSG_SEND_FRIEND_IMG(), MsgHandleIntent.INSTANCE.getMSG_SEND_FRIEND_TEXT(), HandleFileIntentMsgDef.MSG_SHOW_HANDLE_FILE_INTENT, HandleFileIntentMsgDef.MSG_CLOSE_SHOW_HANDLE_FILE_INTENT};
        this.mRegister.registerController(msgIds, null, HandleFileIntentController.class, HandleFileIntentController::new);
    }

    private void registerGrowthConfigController() {
        int[] msgIds = new int[]{};
        int[] notifyIds = new int[]{NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS};
        this.mRegister.registerController(msgIds, notifyIds, GrowthConfigController.class, GrowthConfigController::new);
    }

    private void registerUpgradeController() {
        int[] msgIds = new int[]{};
        int[] notifyIds = new int[]{NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS, NotificationIdDef.GAME_DOWNLOAD_PAUSE, NotificationIdDef.GAME_DOWNLOAD_RESTART_ALL, NotificationIdDef.GAME_DOWNLOAD_FINISH};
        this.mRegister.registerController(msgIds, notifyIds, UpgradeController.class, UpgradeController::new);
    }

    private void registerDeferredDeepLinkManager() {
        int[] msgIds = new int[]{};
        int[] notifyIds = new int[]{NotificationDef.N_SERVICE_INIT_FINISHED, NotificationDef.N_LOGIN_SUCCESS, NotificationDef.N_SHOW_HOME_PAGE};
        this.mRegister.registerController(msgIds, notifyIds, DeferredDeepLinkManager.class, DeferredDeepLinkManager::new);
    }

    private void registerFirebaseRemoteConfigController() {
        int[] notifyIds = new int[]{NotificationDef.N_STARTUP_FINISHED_AFTER_10_SECONDS};
        if (!RuntimeContext.isHagoPartySdk()) {
            this.mRegister.registerController(null, notifyIds, FirebaseRemoteConfigController.class, FirebaseRemoteConfigController::new);
        }
    }

    private void registerListenTogetherController() {
        int[] messageIds = new int[]{ChannelBaseMsgDef.OPEN_LISTEN_TOGETHER_DETAIL};
        this.mRegister.registerController(messageIds, null, ListenTogetherController.class, ListenTogetherController::new);
    }

    private void registerDebugSvgaController() {
        int[] messageIds = new int[]{MsgDef.DEBUG_SVGA_WINDOW};
        this.mRegister.registerController(messageIds, null, DebugSvgaController.class, DebugSvgaController::new);
    }

    private void registerDarkModeReportController() {
        int[] notificationIds = new int[]{NotificationDef.N_STARTUP_FINISHED_AFTER_10_SECONDS};
        this.mRegister.registerController(null, notificationIds, DarkModeReportController.class, DarkModeReportController::new);
    }
}

