/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.wrapper;

import android.content.Context;
import android.os.SystemClock;
import com.yy.appbase.constant.WindowNameDef;
import com.yy.appbase.ui.toast.ToastMessage;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.app.wrapper.BaseWrapper;
import com.yy.hiyo.main.R;

class NetToastWrapper
extends BaseWrapper {
    private ToastMessage mNetErrorToast;
    private long mLastShowNetErrorToastTime;

    NetToastWrapper() {
    }

    @Override
    public void onForegroundChange(boolean fore) {
        if (SettingFlags.getBoolean((String)"shownetunavailabletips", (boolean)true)) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (RuntimeContext.sIsForeground && SystemClock.elapsedRealtime() - NetToastWrapper.this.mLastShowNetErrorToastTime > 8000L) {
                        boolean netOk = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
                        NetToastWrapper.this.toastNetUnavailable(netOk);
                    }
                }
            }, (long)1500L);
        }
    }

    @Override
    public void onNetworkStateChange(boolean isNetOk) {
        this.toastNetUnavailable(isNetOk);
    }

    private void toastNetUnavailable(boolean netOk) {
        if (this.mNetErrorToast != null) {
            TopToastUtils.removeToast((ToastMessage)this.mNetErrorToast);
            this.mNetErrorToast = null;
        }
        if (!netOk && !WindowNameDef.isHomePage((String)RuntimeContext.sCurWin)) {
            this.mNetErrorToast = TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)1);
            this.mLastShowNetErrorToastTime = SystemClock.elapsedRealtime();
        }
    }
}

