/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.wrapper;

import android.os.SystemClock;
import android.view.ViewGroup;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.RecycleUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.app.wrapper.BaseWrapper;
import java.util.ArrayList;

class MemWrapper
extends BaseWrapper {
    private int mWinImageOptType = -1;
    private long mWinImageOptLastTime = -1L;

    MemWrapper() {
    }

    private void handleMemoryWarn(int level, boolean lowMemory) {
        MLog.info((Object)"MemoryOpt", (String)"WinImageOpt handleMemoryWarn!", (Object[])new Object[0]);
        if (this.mWinImageOptType == -1) {
            IAB windowInvisibleOpt = NewABDefine.MEMORY_OPT_WINDOW_IMAGE.getTest();
            if (windowInvisibleOpt != null && windowInvisibleOpt.isValid()) {
                this.mWinImageOptType = NAB.A.equals((Object)windowInvisibleOpt) ? 1 : (NAB.B.equals((Object)windowInvisibleOpt) ? 2 : (NAB.C.equals((Object)windowInvisibleOpt) ? 3 : 0));
            } else if (SystemUtils.isShowEnvSetting()) {
                this.mWinImageOptType = SystemUtils.isShowEnvSetting() ? 2 : SettingFlags.getIntValue((String)"memopt_windowimage_type", (int)0);
            }
        }
        MLog.info((Object)"MemoryOpt", (String)"WinImageOpt type:%d!", (Object[])new Object[]{this.mWinImageOptType});
        if (this.mWinImageOptType != 2 && this.mWinImageOptType != 3) {
            return;
        }
        boolean needRecycle = false;
        if (lowMemory || RuntimeContext.sHappenLowMemWarn) {
            needRecycle = true;
        } else if (this.mWinImageOptType == 2 && RuntimeContext.getPhoneType() != 3 && level > 5) {
            needRecycle = true;
        }
        if (!needRecycle) {
            MLog.info((Object)"MemoryOpt", (String)"WinImageOpt not needRecycle!", (Object[])new Object[0]);
            return;
        }
        AbstractWindow window = this.getWindowManager().getCurrentWindow();
        if (window == null || window.isTransparent()) {
            MLog.info((Object)"MemoryOpt", (String)"WinImageOpt cur window is transparent!", (Object[])new Object[0]);
            return;
        }
        if (!SystemUtils.isShowEnvSetting() && this.mWinImageOptLastTime > 0L && SystemClock.uptimeMillis() - this.mWinImageOptLastTime < 60000L) {
            MLog.info((Object)"MemoryOpt", (String)"WinImageOpt last reycle in 30s!", (Object[])new Object[0]);
            return;
        }
        ArrayList<AbstractWindow> windows = new ArrayList<AbstractWindow>();
        AbstractWindow behindWin = this.getWindowManager().getWindowBehind(window);
        if (behindWin != null) {
            do {
                windows.add(behindWin);
            } while ((behindWin = this.getWindowManager().getWindowBehind(behindWin)) != null);
        }
        if (windows.size() > 0) {
            MLog.info((Object)"MemoryOpt", (String)"WinImageOpt window size:%d!", (Object[])new Object[]{windows.size()});
            this.mWinImageOptLastTime = SystemClock.uptimeMillis();
            for (AbstractWindow item : windows) {
                MLog.info((Object)"MemoryOpt", (String)"recycleAllImageView in win:%s", (Object[])new Object[]{item.getName()});
                if ("ChannelWindow".equals(item.getName()) || "Game".equals(item.getName())) continue;
                RecycleUtils.recycleAllImageView((ViewGroup)item);
            }
        }
    }

    @Override
    public void onTrimMemory(int level) {
        this.handleMemoryWarn(level, false);
    }

    @Override
    public void onLowMemory() {
        this.handleMemoryWarn(-1, true);
    }
}

