/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.wrapper;

import android.content.Context;
import android.os.Message;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.base.env.RuntimeContext;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.app.wrapper.BaseWrapper;
import com.yy.hiyo.app.wrapper.CrashWrapper;
import com.yy.hiyo.app.wrapper.DataCenterWrapper;
import com.yy.hiyo.app.wrapper.DysWrapper;
import com.yy.hiyo.app.wrapper.GlobalBanWrapper;
import com.yy.hiyo.app.wrapper.LocationReportWrapper;
import com.yy.hiyo.app.wrapper.MemWrapper;
import com.yy.hiyo.app.wrapper.NetToastWrapper;
import com.yy.hiyo.app.wrapper.PushWrapper;
import com.yy.hiyo.app.wrapper.SdkDataProviderWrapper;
import com.yy.hiyo.app.wrapper.SplashWrapper;
import com.yy.hiyo.app.wrapper.WindowPathWrapper;
import com.yy.tjgsdk.TjgSDK;
import java.util.ArrayList;

public class CommonModuleBridger
extends DefaultController {
    private static ArrayList<BaseWrapper> sWrappers;
    private LocationReportWrapper mLocationReportWrapper;

    public CommonModuleBridger(Environment baseEnv) {
        super(baseEnv);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_5_SECONDS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_10_SECONDS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_SUCCESS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_PROCESS_COMPLETED, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_USER_INFO_UPDATED, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_ON_TRIM_MEMORY, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_ON_LOW_MEMORY, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_APP_DESTROY, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.WEBSOCKET_CONNECT, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.WEBSOCKET_DISCONNECT, (INotify)this);
        CommonModuleBridger.initWrappers();
        this.updateWrappers();
        this.mLocationReportWrapper = new LocationReportWrapper();
        sWrappers.add(this.mLocationReportWrapper);
        this.registerMessage(BaseMsgDef.MSG_GET_USER_EXTRA_INFO);
        for (BaseWrapper baseWrapper : sWrappers) {
            baseWrapper.onBaseEnvInit(baseEnv);
        }
    }

    private void updateWrappers() {
        sWrappers.add(new DataCenterWrapper());
        sWrappers.add(new WindowPathWrapper());
        sWrappers.add(new MemWrapper());
        sWrappers.add(new DysWrapper());
        sWrappers.add(new GlobalBanWrapper());
        sWrappers.add(new NetToastWrapper());
        if (!RuntimeContext.isHagoPartySdk()) {
            sWrappers.add(new LocationReportWrapper());
            sWrappers.add(new PushWrapper());
            sWrappers.add(new SplashWrapper());
        }
    }

    private static void initWrappers() {
        if (sWrappers == null) {
            sWrappers = new ArrayList();
            sWrappers.add(new CrashWrapper());
            sWrappers.add(new SdkDataProviderWrapper());
        }
    }

    public static void onApplicationCreate() {
        CommonModuleBridger.initWrappers();
        for (BaseWrapper baseWrapper : sWrappers) {
            baseWrapper.onApplicationCreate();
        }
    }

    public void notify(Notification notification) {
        block14: {
            block28: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                block19: {
                                                    block18: {
                                                        block17: {
                                                            block16: {
                                                                block15: {
                                                                    block13: {
                                                                        if (notification == null) {
                                                                            return;
                                                                        }
                                                                        if (notification.id != NotificationDef.N_STARTUP_FINISHED) break block13;
                                                                        for (BaseWrapper baseWrapper : sWrappers) {
                                                                            baseWrapper.onStartUpFinish();
                                                                        }
                                                                        break block14;
                                                                    }
                                                                    if (notification.id != NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS) break block15;
                                                                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                                                        @Override
                                                                        public void run() {
                                                                            for (BaseWrapper baseWrapper : sWrappers) {
                                                                                baseWrapper.onStartUpFinishAfterOneSecond();
                                                                            }
                                                                        }
                                                                    });
                                                                    break block14;
                                                                }
                                                                if (notification.id != NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS) break block16;
                                                                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                                                    @Override
                                                                    public void run() {
                                                                        TjgSDK.Companion.getInstance().systemInit();
                                                                        for (BaseWrapper baseWrapper : sWrappers) {
                                                                            baseWrapper.onStartUpFinishAfterThreeSecond();
                                                                        }
                                                                    }
                                                                });
                                                                break block14;
                                                            }
                                                            if (notification.id != NotificationDef.N_STARTUP_FINISHED_AFTER_5_SECONDS) break block17;
                                                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                                                @Override
                                                                public void run() {
                                                                    for (BaseWrapper baseWrapper : sWrappers) {
                                                                        baseWrapper.onStartUpFinishAfterFiveSecond();
                                                                    }
                                                                }
                                                            });
                                                            break block14;
                                                        }
                                                        if (notification.id != NotificationDef.N_STARTUP_FINISHED_AFTER_10_SECONDS) break block18;
                                                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                                            @Override
                                                            public void run() {
                                                                for (BaseWrapper baseWrapper : sWrappers) {
                                                                    baseWrapper.onStartUpFinishAfterTenSecond();
                                                                }
                                                            }
                                                        });
                                                        break block14;
                                                    }
                                                    if (notification.id != NotificationDef.N_FOREGROUND_CHANGE) break block19;
                                                    for (BaseWrapper baseWrapper : sWrappers) {
                                                        baseWrapper.onForegroundChange(RuntimeContext.sIsForeground);
                                                    }
                                                    break block14;
                                                }
                                                if (notification.id != NotificationDef.N_USER_INFO_UPDATED) break block20;
                                                for (BaseWrapper baseWrapper : sWrappers) {
                                                    baseWrapper.onUserInfoUpdated();
                                                }
                                                break block14;
                                            }
                                            if (notification.id != NotificationDef.N_ON_TRIM_MEMORY) break block21;
                                            int level = (Integer)notification.extObj;
                                            for (BaseWrapper baseWrapper : sWrappers) {
                                                baseWrapper.onTrimMemory(level);
                                            }
                                            break block14;
                                        }
                                        if (notification.id != NotificationDef.N_ON_LOW_MEMORY) break block22;
                                        for (BaseWrapper baseWrapper : sWrappers) {
                                            baseWrapper.onLowMemory();
                                        }
                                        break block14;
                                    }
                                    if (notification.id != NotificationDef.N_LOGIN_SUCCESS) break block23;
                                    for (BaseWrapper baseWrapper : sWrappers) {
                                        baseWrapper.onLoginSuccess();
                                    }
                                    break block14;
                                }
                                if (notification.id != NotificationDef.N_LOGIN_LOGIN_OUT) break block24;
                                for (BaseWrapper baseWrapper : sWrappers) {
                                    baseWrapper.onLoginout((Long)notification.extObj);
                                }
                                break block14;
                            }
                            if (notification.id != NotificationDef.N_LOGIN_PROCESS_COMPLETED) break block25;
                            for (BaseWrapper baseWrapper : sWrappers) {
                                baseWrapper.onLoginProcessCompleted();
                            }
                            break block14;
                        }
                        if (notification.id != NotificationDef.N_NETWORK_STATE_CHANGE) break block26;
                        boolean netOk = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
                        for (BaseWrapper baseWrapper : sWrappers) {
                            baseWrapper.onNetworkStateChange(netOk);
                        }
                        break block14;
                    }
                    if (notification.id != NotificationDef.N_APP_DESTROY) break block27;
                    for (BaseWrapper baseWrapper : sWrappers) {
                        baseWrapper.onAppDestory();
                    }
                    break block14;
                }
                if (notification.id != NotificationIdDef.WEBSOCKET_CONNECT) break block28;
                for (BaseWrapper baseWrapper : sWrappers) {
                    baseWrapper.onWsSocketChanged(true);
                }
                break block14;
            }
            if (notification.id != NotificationIdDef.WEBSOCKET_DISCONNECT) break block14;
            for (BaseWrapper baseWrapper : sWrappers) {
                baseWrapper.onWsSocketChanged(false);
            }
        }
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (BaseMsgDef.MSG_GET_USER_EXTRA_INFO == msg.what && this.mLocationReportWrapper != null) {
            this.mLocationReportWrapper.handleMessage(msg);
        }
    }
}

