/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.web;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.DebugTestUriProvider;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.permission.Permission;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.web.IWebManager;
import com.yy.appbase.service.web.IWebManagerCallBack;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.BackupHostConfig;
import com.yy.appbase.unifyconfig.config.IntentFilterConfig;
import com.yy.appbase.unifyconfig.config.WebViewLayerConfig;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.AppMetaDataUtil;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.WebViewUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.app.web.IWebBusinessCallBackEx;
import com.yy.hiyo.app.web.IntentFilterManager;
import com.yy.hiyo.app.web.StatHelper;
import com.yy.hiyo.app.web.WebManager;
import com.yy.hiyo.app.web.request.WebRequestService;
import com.yy.hiyo.bbs.base.service.ITopicService;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.home.base.IHomeGameService;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.main.R;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.hiyo.module.webbussiness.base.BaseJsEventModule;
import com.yy.hiyo.module.webbussiness.nativeapp.AppInfoJsEvent;
import com.yy.hiyo.module.webbussiness.ui.UiJsEventModule;
import com.yy.hiyo.module.webbussiness.yy.YYJsEventModule;
import com.yy.hiyo.wallet.base.IActivityService;
import com.yy.webservice.WebConfigure;
import com.yy.webservice.WebController;
import com.yy.webservice.WebEnvSettings;
import com.yy.webservice.client.IWebBusinessCallBack;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.client.IWebServiceCallBack;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.NotifyJs;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.preload.ILoadInterceptor;
import com.yy.webservice.preload.ILoadInterceptorCallBack;
import com.yy.webservice.webpanel.IWebPanelCallback;
import com.yy.webservice.webpanel.IWebPanelManager;
import com.yy.webservice.webpanel.WebPanelManager;
import com.yy.webservice.webwindow.titlebar.WebTitleButton;
import com.yy.webservice.webwindow.webview.IWebIntentFilter;
import com.yy.webservice.webwindow.webview.IWebViewPermissionCallback;
import com.yy.webservice.webwindow.webview.WebBusinessHandlerCallback;
import com.yy.webservice.webwindow.webview.WebViewController;
import com.yy.webservice.webwindow.webview.base.WebViewReuse;
import com.yy.webservice.webwindow.webview.base.WebViewSettings;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class WebServiceWrapperController
extends DefaultController
implements ILoadInterceptor {
    private static final String TAG = "Web_WebServiceWrapperController";
    private WebController mWebController;
    private WebRequestService mWebRequestService;
    private final ArrayList<WeakReference<IWebBusinessCallBack>> mBusinessCallBacks = new ArrayList(5);
    private final List<IWebBusinessHandler> mWebBusinessHandlers = new CopyOnWriteArrayList<IWebBusinessHandler>();
    private final List<JsEvent> mJsEvents = new CopyOnWriteArrayList<JsEvent>();
    private boolean mHasCookieSeted = false;
    private boolean mHasTokenSeted = false;
    private volatile boolean mInitBasicJsEvent = false;
    private boolean mBasicJsEventIniting = false;
    private AppInfoJsEvent mAppInfoJsEvent;
    private int mRetryTime = 0;
    private final Runnable mRetryCookieTask = () -> {
        if (this.mRetryTime < 3) {
            this.syncSetCookie();
        }
    };

    public WebServiceWrapperController(Environment env) {
        super(env);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_ON_TRIM_MEMORY, (INotify)this);
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)TAG, (String)"isLowPhone %s, isSwitchOn:%s", (Object[])new Object[]{RuntimeContext.isPhoneSuperLow(), SettingFlags.getBoolean((String)"webviewreuse", (boolean)true)});
        }
        WebViewController.setInterceptor((WebViewController.IWebInterceptor)new WebViewController.IWebInterceptor(){

            public String replaceUrl(String url) {
                String urlNew = URLUtils.replaceUrl((String)url);
                if (BackupHostConfig.sReplaceWebHttpToHttps) {
                    return URLUtils.replaceHttpByConfig((String)urlNew);
                }
                return urlNew;
            }

            public boolean isOurUrl(String url) {
                return URLUtils.isOurHostByUrl((String)url);
            }

            public boolean isOurHost(String host) {
                return URLUtils.isOurHost((String)host);
            }

            public String replaceTestUrl(String url, int type2) {
                String testDomainSuffix = DebugTestUriProvider.TEST_DEFAULT_MAIN_HOST_SUFFIX + "/a/";
                String testOlaDomainSuffix = DebugTestUriProvider.TEST_OLA_DEFAULT_MAIN_HOST_SUFFIX + "/a/";
                if (type2 == 1) {
                    if (url.contains("//test" + testDomainSuffix)) {
                        url = url.replace("//test" + testDomainSuffix, "//www" + testDomainSuffix);
                    }
                    if (url.contains("//pre" + testDomainSuffix)) {
                        url = url.replace("//pre" + testDomainSuffix, "//www" + testDomainSuffix);
                    }
                    if (url.contains("//test" + testOlaDomainSuffix)) {
                        url = url.replace("//test" + testOlaDomainSuffix, "//www" + testOlaDomainSuffix);
                    }
                    if (url.contains("//pre" + testOlaDomainSuffix)) {
                        url = url.replace("//pre" + testOlaDomainSuffix, "//www" + testOlaDomainSuffix);
                    }
                } else if (type2 == 2) {
                    if (url.contains("//www" + testDomainSuffix)) {
                        url = url.replace("//www" + testDomainSuffix, "//pre" + testDomainSuffix);
                    }
                    if (url.contains("//test" + testDomainSuffix)) {
                        url = url.replace("//test" + testDomainSuffix, "//pre" + testDomainSuffix);
                    }
                    if (url.contains("//www" + testOlaDomainSuffix)) {
                        url = url.replace("//www" + testOlaDomainSuffix, "//pre" + testOlaDomainSuffix);
                    }
                    if (url.contains("//test" + testOlaDomainSuffix)) {
                        url = url.replace("//test" + testOlaDomainSuffix, "//pre" + testOlaDomainSuffix);
                    }
                } else if (type2 == 3) {
                    if (url.contains("//www/" + testDomainSuffix)) {
                        url = url.replace("//www/" + testDomainSuffix, "//test" + testDomainSuffix);
                    }
                    if (url.contains("//pre" + testDomainSuffix)) {
                        url = url.replace("//pre" + testDomainSuffix, "//test" + testDomainSuffix);
                    }
                    if (url.contains("//www/" + testOlaDomainSuffix)) {
                        url = url.replace("//www/" + testOlaDomainSuffix, "//test" + testOlaDomainSuffix);
                    }
                    if (url.contains("//pre" + testOlaDomainSuffix)) {
                        url = url.replace("//pre" + testOlaDomainSuffix, "//test" + testOlaDomainSuffix);
                    }
                }
                return url;
            }
        });
        if (!SystemUtils.isShowEnvSetting() || SettingFlags.getBoolean((String)"debug_WEB_OPT_SWITCH_KEY", (boolean)true)) {
            boolean flag;
            boolean bl = flag = !RuntimeContext.isPhoneSuperLow();
            if (flag && SettingFlags.getBoolean((String)"webviewreuse", (boolean)true)) {
                WebViewReuse.setCallBack((WebViewReuse.IWebViewReuseCallBack)new WebViewReuse.IWebViewReuseCallBack(){

                    public boolean isSwitchOn() {
                        if (!SettingFlags.getBoolean((String)"webviewreuse", (boolean)true)) {
                            return false;
                        }
                        return NAB.A.equals((Object)NewABDefine.H5_PRELOAD.getTest());
                    }

                    public boolean canCacheNow() {
                        return !((IGameCenterService)WebServiceWrapperController.this.getServiceManager().getService(IGameCenterService.class)).isPlaying();
                    }
                });
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        YYTaskExecutor.postIdleRunnableToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                WebViewReuse.precreateWebView((Context)WebServiceWrapperController.this.mContext);
                            }
                        });
                    }
                }, (long)10000L);
            }
        }
    }

    private WebController getWebController() {
        if (this.mWebController == null) {
            this.mWebController = new WebController(this.getEnvironment(), WebServiceWrapperController.getYYDefaultUa(), this.generateWebConfigure(), this.createWebServiceCallback());
        }
        return this.mWebController;
    }

    private IWebServiceCallBack createWebServiceCallback() {
        return new IWebServiceCallBack(){

            public boolean nativeGetGameIsInstall(String gameId) {
                if (WebServiceWrapperController.this.getServiceManager().getService(IGameService.class) != null && WebServiceWrapperController.this.getServiceManager().getService(IGameInfoService.class) != null) {
                    GameInfo gameInfo = ((IGameInfoService)WebServiceWrapperController.this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
                    return ((IGameService)WebServiceWrapperController.this.getServiceManager().getService(IGameService.class)).isGameValid(gameInfo);
                }
                return false;
            }

            public String appInfo() {
                if (WebServiceWrapperController.this.mAppInfoJsEvent == null) {
                    WebServiceWrapperController.this.mAppInfoJsEvent = new AppInfoJsEvent();
                }
                return WebServiceWrapperController.this.mAppInfoJsEvent.appInfo();
            }

            public String userToken() {
                String token = "";
                AccountInfo accountInfo = AccountModel.getInstance().getAccountInfo();
                if (accountInfo != null) {
                    token = accountInfo.token;
                }
                return token;
            }

            public String myselfUserInfo() {
                UserInfoKS userInfo = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
                JsonStringBuilder json = JsonStringBuilder.newBuilder().put("uid", (Object)userInfo.uid).put("nickname", (Object)userInfo.nick);
                return json.buildJson();
            }

            @Nullable
            public IWebIntentFilter getIntentFilter(String url) {
                return IntentFilterManager.INSTANCE.getIntentFilter(url);
            }

            public void onWebBusinessCreated(IWebBusinessHandler businessHandler) {
                if (businessHandler != null) {
                    businessHandler.loadNotifyJs(JsEventDefine.NOTIFY.onWebViewLifecycle.notifyName(), "onCreate");
                }
                WebServiceWrapperController.this.handleWebBusinessCreated(businessHandler);
                StatHelper.onWebBusinessCreated(businessHandler);
            }

            public void onWebBusinessDestroyed(IWebBusinessHandler businessHandler) {
                if (businessHandler != null) {
                    businessHandler.loadNotifyJs(JsEventDefine.NOTIFY.onWebViewLifecycle.notifyName(), "onDestroy");
                }
                WebServiceWrapperController.this.handleWebBusinessDestroyed(businessHandler);
                StatHelper.onWebBusinessDestroyed(businessHandler);
            }

            public void onPermissionRequested(String permission, IWebViewPermissionCallback callback) {
                WebServiceWrapperController.this.handleonPermissionRequested(permission, callback);
            }

            public void onWebShown(IWebBusinessHandler bussinessHandler, boolean webWindowFromCache) {
                if (bussinessHandler != null) {
                    bussinessHandler.loadNotifyJs(JsEventDefine.NOTIFY.onWebViewLifecycle.notifyName(), "onResume");
                    if (webWindowFromCache) {
                        bussinessHandler.loadNotifyJs(JsEventDefine.NOTIFY.onWebViewLifecycle.notifyName(), "webWindowFromCache");
                    }
                }
            }

            public void onWebHidden(IWebBusinessHandler bussinessHandler) {
                if (bussinessHandler != null) {
                    bussinessHandler.loadNotifyJs(JsEventDefine.NOTIFY.onWebViewLifecycle.notifyName(), "onPause");
                }
            }
        };
    }

    private WebConfigure generateWebConfigure() {
        WebConfigure config = new WebConfigure();
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.WEB_INTENT_FILTER);
        if (configData instanceof IntentFilterConfig) {
            config.setIgnoreOverrideBlack(((IntentFilterConfig)configData).getIgnoreOverrideBlack());
        }
        return config;
    }

    public Object handleMessageSync(Message msg) {
        if (MsgDef.MSG_WEBSERVICEWRAPPER_LOADURL == msg.what) {
            if (msg.obj instanceof String[] && ((String[])msg.obj).length == 2) {
                String[] pa = (String[])msg.obj;
                this.loadUrl(pa[0], pa[1]);
            } else if (msg.obj instanceof WebEnvSettings) {
                this.loadUrl((WebEnvSettings)msg.obj);
            }
            return null;
        }
        if (MsgDef.MSG_WEBSERVICEWRAPPER_UNREGISTERWEBBUSINESS == msg.what) {
            if (msg.obj instanceof IWebBusinessCallBack) {
                this.unRegisterWebBusiness((IWebBusinessCallBack)msg.obj);
                return null;
            }
        } else if (MsgDef.MSG_WEBSERVICEWRAPPER_REMOVEGLOBALJSEVENT == msg.what) {
            if (msg.obj instanceof JsEvent) {
                this.removeGlobalJsEvent((JsEvent)msg.obj);
                return null;
            }
        } else if (MsgDef.MSG_WEBSERVICEWRAPPER_REGISTERWEBBUSINESS == msg.what) {
            if (msg.obj instanceof IWebBusinessCallBack) {
                this.registerWebBusiness((IWebBusinessCallBack)msg.obj);
                return null;
            }
        } else if (MsgDef.MSG_WEBSERVICEWRAPPER_LOADPUREJS == msg.what) {
            if (msg.obj instanceof String) {
                this.loadPureJs((String)msg.obj);
                return null;
            }
        } else if (MsgDef.MSG_WEBSERVICEWRAPPER_LOADNOTIFYJS_WITH_ID == msg.what) {
            Object[] objects;
            if (msg.obj instanceof Object[] && (objects = (Object[])msg.obj).length == 3 && objects[1] instanceof NotifyJs) {
                this.loadNotifyJs((String)objects[0], (NotifyJs)objects[1], (String)objects[2]);
                return null;
            }
        } else if (MsgDef.MSG_WEBSERVICEWRAPPER_CREATEWEBMANAGER == msg.what) {
            Object[] objects;
            if (msg.obj instanceof Object[] && (objects = (Object[])msg.obj).length >= 2 && objects[0] instanceof IWebManagerCallBack && objects[1] instanceof WebView) {
                WebViewSettings settings = objects.length >= 3 && objects[2] instanceof WebViewSettings ? (WebViewSettings)objects[2] : null;
                return this.createWebManager((IWebManagerCallBack)objects[0], (WebView)objects[1], settings);
            }
        } else if (MsgDef.MSG_WEBSERVICEWRAPPER_CREATEWEBPANEL == msg.what) {
            Object[] objects;
            if (msg.obj instanceof Object[] && (objects = (Object[])msg.obj).length >= 2 && objects[0] instanceof ViewGroup && (objects[1] == null || objects[1] instanceof IWebPanelCallback)) {
                IWebPanelCallback callback = null;
                if (objects[1] != null) {
                    callback = (IWebPanelCallback)objects[1];
                }
                return this.createWebPanel((ViewGroup)objects[0], callback);
            }
        } else if (MsgDef.MSG_WEBSERVICEWRAPPER_ADDGLOBALJSEVENT == msg.what) {
            if (msg.obj instanceof JsEvent) {
                this.addGlobalJsEvent((JsEvent)msg.obj);
                return null;
            }
        } else if (MsgDef.MSG_WEBSERVICEWRAPPER_PRECREATE_WEB == msg.what) {
            YYTaskExecutor.postIdleRunnableToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    WebViewReuse.precreateWebView((Context)WebServiceWrapperController.this.mContext);
                }
            });
        }
        return null;
    }

    private void notifyJsWebViewIsAppear(final boolean isForeground) {
        if (this.mWebController != null) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    BaseJsParam cbParam = isForeground ? BaseJsParam.builder().put("isAppear", (Object)true).build() : BaseJsParam.builder().put("isAppear", (Object)false).build();
                    WebServiceWrapperController.this.loadNotifyJs("", JsEventDefine.NOTIFY.onForegroundChanged, cbParam.toJson());
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureinitBasicJsEvent() {
        if (this.mInitBasicJsEvent) {
            return;
        }
        WebServiceWrapperController webServiceWrapperController = this;
        synchronized (webServiceWrapperController) {
            if (this.mInitBasicJsEvent || this.mBasicJsEventIniting) {
                return;
            }
            this.mBasicJsEventIniting = true;
            this.addJsEventSet(new BaseJsEventModule(this.getEnvironment()).allJsEvent());
            this.addJsEventSet(new UiJsEventModule(this.getEnvironment()).allJsEvent());
            this.addJsEventSet(((IActivityService)ServiceManagerProxy.getService(IActivityService.class)).getRevenueJsEvent(this.getEnvironment()));
            this.addJsEventSet(new YYJsEventModule(this.getEnvironment()).allJsEvent());
            this.addJsEventSet(((ITopicService)ServiceManagerProxy.getService(ITopicService.class)).getBBSJsEvent(this.getEnvironment()));
            this.addJsEventSet(((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getJsEvent(this.getEnvironment()));
            if (!RuntimeContext.isHagoPartySdk()) {
                this.addJsEventSet(((IHomeGameService)ServiceManagerProxy.getService(IHomeGameService.class)).getHomeGameJsEvent(this.getEnvironment()));
            }
            this.mInitBasicJsEvent = true;
            this.mBasicJsEventIniting = false;
        }
    }

    private void addJsEventSet(JsEvent[] list) {
        this.ensureinitBasicJsEvent();
        if (FP.empty((Object[])list)) {
            return;
        }
        for (JsEvent event : list) {
            this.addGlobalJsEvent(event);
        }
    }

    private void syncSetCookie() {
        if (this.mHasCookieSeted && this.mHasTokenSeted) {
            return;
        }
        try {
            CookieSyncManager.createInstance((Context)RuntimeContext.sApplicationContext);
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.setAcceptCookie(true);
            if (Build.VERSION.SDK_INT >= 21) {
                cookieManager.removeSessionCookies(null);
            }
            String cookieValue = "uaasCookie=";
            String hagoUid = "hagouid=";
            String username = "username=";
            AccountInfo info = AccountModel.getInstance().getAccountInfo();
            if (info != null) {
                long uid = info.uuid;
                String token = info.token;
                if (uid > 0L && TextUtils.isEmpty((CharSequence)token)) {
                    IllegalArgumentException exception = new IllegalArgumentException("syncSetCookie token is empty " + uid);
                    if (RuntimeContext.sIsDebuggable) {
                        throw exception;
                    }
                    MLog.error((Object)TAG, (Throwable)exception);
                    this.reportNotToken(uid, 0, "");
                    this.retryCookie();
                } else {
                    this.mHasTokenSeted = true;
                    YYTaskExecutor.removeTask((Runnable)this.mRetryCookieTask);
                }
                cookieValue = cookieValue + token;
                hagoUid = hagoUid + String.valueOf(uid);
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)"syncSetCookie uid: %s, token: %s", (Object[])new Object[]{uid, token});
                }
            } else {
                this.retryCookie();
            }
            UserInfoKS userInfoKS = this.getUserInfo(AccountUtil.getUid());
            if (userInfoKS != null) {
                username = username + URLEncoder.encode(userInfoKS.nick, "UTF-8");
            }
            List firstHostSuffixList = URLUtils.getOurFirstHostSuffixList();
            for (String uri : firstHostSuffixList) {
                this.setCookieValue(cookieManager, uri, cookieValue, hagoUid, username);
            }
            if (Build.VERSION.SDK_INT >= 21) {
                cookieManager.flush();
            } else {
                CookieSyncManager.getInstance().sync();
            }
            this.checkCookie(cookieManager);
            this.mHasCookieSeted = true;
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
    }

    private void checkCookie(CookieManager cookieManager) {
        String cookie = cookieManager.getCookie(URLUtils.replaceHostSuffix((String)".ihago.net"));
        if (TextUtils.isEmpty((CharSequence)cookie)) {
            this.reportNotToken(AccountUtil.getUid(), 1, "");
            this.mHasTokenSeted = false;
            this.retryCookie();
            return;
        }
        String[] cookies = cookie.split(";");
        boolean had = false;
        for (String c : cookies) {
            if (!c.contains("uaasCookie=") || c.length() <= 50) continue;
            had = true;
            break;
        }
        if (!had) {
            MLog.error((Object)TAG, (String)"checkCookie %s", (Object[])new Object[]{cookie});
            this.mHasTokenSeted = false;
            this.retryCookie();
            this.reportNotToken(AccountUtil.getUid(), 2, cookie);
        }
    }

    private void retryCookie() {
        if (this.mRetryTime < 5) {
            ++this.mRetryTime;
            YYTaskExecutor.postToMainThread((Runnable)this.mRetryCookieTask, (long)(this.mRetryTime * 1000));
        }
    }

    private void setCookieValue(CookieManager cookieManager, String domain, String ... values) {
        if (cookieManager == null) {
            return;
        }
        for (final String value : values) {
            if (Build.VERSION.SDK_INT < 21) {
                cookieManager.setCookie(domain, value);
                continue;
            }
            cookieManager.setCookie(domain, value, (ValueCallback)new ValueCallback<Boolean>(){

                public void onReceiveValue(Boolean success) {
                    if (!success.booleanValue()) {
                        MLog.error((Object)WebServiceWrapperController.TAG, (String)"setCookieValue onReceiveValue: %b, length: %d", (Object[])new Object[]{success, value.length()});
                    }
                    if (!(success != null && success.booleanValue() || value.length() <= 50)) {
                        WebServiceWrapperController.this.mHasTokenSeted = false;
                        WebServiceWrapperController.this.retryCookie();
                        WebServiceWrapperController.this.reportNotToken(AccountUtil.getUid(), 3, value);
                    }
                }
            });
        }
    }

    private UserInfoKS getUserInfo(long uid) {
        return ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(uid);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification == null) {
            return;
        }
        if (NotificationDef.N_LOGIN_LOGIN_OUT == notification.id) {
            this.mHasCookieSeted = false;
            this.mRetryTime = 0;
            this.mHasTokenSeted = false;
        } else if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            Boolean isForeground = (Boolean)notification.extObj;
            this.notifyJsWebViewIsAppear(isForeground);
        } else if (notification.id == NotificationDef.N_LOGIN_SUCCESS) {
            if (this.mHasCookieSeted) {
                this.mHasCookieSeted = false;
                this.mRetryTime = 0;
                this.mHasTokenSeted = false;
                this.syncSetCookie();
            }
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS) {
            if (RuntimeContext.isStartAtFirstInstalled()) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WebServiceWrapperController.this.initWebInterceptor();
                    }
                }, (long)5000L);
            } else {
                this.initWebInterceptor();
            }
        } else if (notification.id == NotificationDef.N_ON_TRIM_MEMORY) {
            if (YYTaskExecutor.isMainThread()) {
                WebViewReuse.releaseCacheByTrimMemory();
                if (this.mWebController != null) {
                    this.mWebController.releaseCacheByTrimMemory();
                }
            } else {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WebViewReuse.releaseCacheByTrimMemory();
                        if (WebServiceWrapperController.this.mWebController != null) {
                            WebServiceWrapperController.this.mWebController.releaseCacheByTrimMemory();
                        }
                    }
                });
                if (this.mWebController != null) {
                    this.mWebController.releaseCacheByTrimMemory();
                }
            }
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_10_SECONDS) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!RuntimeContext.sIsDebuggable && !SettingFlags.getBoolean((String)"key_webview_version_report", (boolean)false)) {
                        SettingFlags.setBoolean((String)"key_webview_version_report", (boolean)true);
                        PackageInfo packageInfo = WebViewUtils.INSTANCE.getCurrentWebViewPackage(RuntimeContext.sApplicationContext);
                        if (packageInfo != null && !TextUtils.isEmpty((CharSequence)packageInfo.versionName)) {
                            StatisContent statContent = new StatisContent();
                            statContent.put("act", "hagoperf");
                            statContent.put("perftype", "webview_version_stat");
                            statContent.put("sfieldfive", packageInfo.versionName);
                            HiidoStatis.reportContent((StatisContent)statContent);
                        }
                    }
                }
            });
        } else if (notification.id == NotificationDef.N_PARTY_SDK_LOCALE_CHANGED && this.mWebController != null) {
            this.mWebController.setDefaultUa(WebServiceWrapperController.getYYDefaultUa());
        }
    }

    private void loadUrl(String url, String title) {
        this.ensureinitBasicJsEvent();
        this.syncSetCookie();
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        WebEnvSettings webEnvSettings = WebEnvSettings.obtain();
        webEnvSettings.url = url;
        webEnvSettings.title = title;
        if (url.startsWith("https://payouts.payoneer.com/") || url.startsWith("http://payouts.payoneer.com/")) {
            webEnvSettings.disablePullRefresh = true;
        }
        this.loadUrl(webEnvSettings);
    }

    private void loadUrl(final WebEnvSettings webEnvSettings) {
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.N_BEFORE_WEB_LOAD));
        if (YYTaskExecutor.isMainThread()) {
            this.loadUrlInner(webEnvSettings);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    WebServiceWrapperController.this.loadUrlInner(webEnvSettings);
                }
            });
        }
    }

    private void initWebInterceptor() {
        if (this.mWebRequestService == null) {
            this.mWebRequestService = new WebRequestService(this.getEnvironment());
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.sendMessageSync(MsgDef.MSG_WEB_PRELOAD_INIT);
            this.sendMessageSync(MsgDef.MSG_WEB_DISPATCH_INIT);
        } else {
            MLog.info((Object)TAG, (String)"initWebInterceptor ignore, version is lower than lollipop", (Object[])new Object[0]);
        }
    }

    private void loadUrlInner(final WebEnvSettings webEnvSettings) {
        this.initWebInterceptor();
        if (webEnvSettings != null) {
            webEnvSettings.statParams.startLoadPageTime = System.currentTimeMillis();
        }
        this.interceptEnvSetting(webEnvSettings);
        final Runnable command = new Runnable(){

            @Override
            public void run() {
                String url;
                if (!WebServiceWrapperController.this.mHasTokenSeted) {
                    WebServiceWrapperController.this.mRetryTime = 0;
                }
                WebServiceWrapperController.this.ensureinitBasicJsEvent();
                WebServiceWrapperController.this.syncSetCookie();
                String string2 = url = webEnvSettings != null ? webEnvSettings.url : "";
                if (url.startsWith("https://payouts.payoneer.com/") || url.startsWith("http://payouts.payoneer.com/")) {
                    webEnvSettings.disablePullRefresh = true;
                }
                webEnvSettings.forceEnableSwLayer = WebServiceWrapperController.this.shouldEnableSwLayer(RuntimeContext.sApplicationContext);
                WebServiceWrapperController.this.getWebController().loadUrl(webEnvSettings);
            }
        };
        this.onLoadInterceptor(webEnvSettings.url, webEnvSettings, new ILoadInterceptorCallBack(){

            public void continueLoad() {
                if (YYTaskExecutor.isMainThread()) {
                    command.run();
                } else {
                    YYTaskExecutor.postToMainThread((Runnable)command);
                }
            }

            public void cancel() {
                MLog.info((Object)"WebManager", (String)"load url canceled by Interceptor!", (Object[])new Object[0]);
            }

            public int from() {
                return 1;
            }
        });
    }

    private void addGlobalJsEvent(@NonNull JsEvent event) {
        this.ensureinitBasicJsEvent();
        if (this.mJsEvents.contains(event)) {
            return;
        }
        this.mJsEvents.add(event);
        if (FP.empty(this.mWebBusinessHandlers)) {
            return;
        }
        for (IWebBusinessHandler handler : this.mWebBusinessHandlers) {
            handler.addJsEvent(event);
        }
    }

    private void removeGlobalJsEvent(@NonNull JsEvent event) {
        if (!this.mJsEvents.contains(event)) {
            return;
        }
        this.mJsEvents.remove(event);
        if (FP.empty(this.mWebBusinessHandlers)) {
            return;
        }
        for (IWebBusinessHandler handler : this.mWebBusinessHandlers) {
            handler.removeJsEvent(event);
        }
    }

    private void loadNotifyJs(final String toWebId, final NotifyJs notify, final String param) {
        if (FP.empty(this.mWebBusinessHandlers)) {
            return;
        }
        this.ensureinitBasicJsEvent();
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    WebServiceWrapperController.this.notifyJsAsync(toWebId, notify.notifyName(), param);
                }
            });
        } else {
            this.notifyJsAsync(toWebId, notify.notifyName(), param);
        }
    }

    private void loadPureJs(String js) {
        this.ensureinitBasicJsEvent();
        if (FP.empty(this.mWebBusinessHandlers)) {
            return;
        }
        for (IWebBusinessHandler handler : this.mWebBusinessHandlers) {
            handler.loadPureJs(js);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWebBusiness(IWebBusinessCallBack callBack) {
        if (callBack == null) {
            return;
        }
        ArrayList<WeakReference<IWebBusinessCallBack>> arrayList = this.mBusinessCallBacks;
        synchronized (arrayList) {
            for (WeakReference<IWebBusinessCallBack> item : this.mBusinessCallBacks) {
                IWebBusinessCallBack temp = (IWebBusinessCallBack)item.get();
                if (temp != callBack) continue;
                return;
            }
            this.mBusinessCallBacks.add(new WeakReference<IWebBusinessCallBack>(callBack));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unRegisterWebBusiness(IWebBusinessCallBack callBack) {
        if (callBack == null) {
            return;
        }
        ArrayList<WeakReference<IWebBusinessCallBack>> arrayList = this.mBusinessCallBacks;
        synchronized (arrayList) {
            for (WeakReference<IWebBusinessCallBack> item : this.mBusinessCallBacks) {
                IWebBusinessCallBack temp = (IWebBusinessCallBack)item.get();
                if (temp != callBack) continue;
                this.mBusinessCallBacks.remove(item);
                break;
            }
        }
    }

    private IWebManager createWebManager(IWebManagerCallBack callBack, WebView webView, @Nullable WebViewSettings settings) {
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.N_BEFORE_WEB_LOAD));
        this.ensureinitBasicJsEvent();
        this.syncSetCookie();
        WebManager webManager = new WebManager(callBack, webView, WebServiceWrapperController.getYYDefaultUa(), settings, new IWebBusinessCallBack(){

            public void onWebBusinessCreated(IWebBusinessHandler businessHandler) {
                WebServiceWrapperController.this.handleWebBusinessCreated(businessHandler);
                StatHelper.onWebBusinessCreated(businessHandler);
            }

            public void onWebBusinessDestroyed(IWebBusinessHandler businessHandler) {
                WebServiceWrapperController.this.handleWebBusinessDestroyed(businessHandler);
                StatHelper.onWebBusinessDestroyed(businessHandler);
            }
        });
        webManager.setLoadInterceptor(this);
        return webManager;
    }

    private IWebPanelManager createWebPanel(ViewGroup containerLayout, @Nullable IWebPanelCallback callback) {
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.N_BEFORE_WEB_LOAD));
        this.ensureinitBasicJsEvent();
        this.syncSetCookie();
        WebPanelManager manager = new WebPanelManager(containerLayout, WebServiceWrapperController.getYYDefaultUa(), this.generateWebConfigure(), this.createWebServiceCallback(), callback);
        manager.setLoadInterceptor((ILoadInterceptor)this);
        return manager;
    }

    private void notifyJsAsync(String toWebId, String notifyName, String param) {
        param = param == null ? "" : param;
        boolean isToWebIdEmpty = TextUtils.isEmpty((CharSequence)toWebId);
        for (IWebBusinessHandler handler : this.mWebBusinessHandlers) {
            String webId = handler.getWeId();
            if (isToWebIdEmpty || TextUtils.isEmpty((CharSequence)webId) || StringUtils.equal((String)toWebId, (String)webId)) {
                handler.loadNotifyJs(notifyName, param);
                continue;
            }
            MLog.error((Object)TAG, (String)"can not found equal webId toWebId\uff1a %s, notifyName: %s", (Object[])new Object[]{toWebId, notifyName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWebBusinessCreated(final IWebBusinessHandler businessHandler) {
        ((IGameService)this.getServiceManager().getService(IGameService.class)).pauseAllDownload("webView");
        if (businessHandler == null || this.mWebBusinessHandlers.contains(businessHandler)) {
            return;
        }
        this.mWebBusinessHandlers.add(businessHandler);
        businessHandler.addWebViewListener(new WebBusinessHandlerCallback(){

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                businessHandler.loadNotifyJs(JsEventDefine.NOTIFY.onWebViewLifecycle.notifyName(), "onFinishLoad");
            }
        });
        ArrayList<WeakReference<IWebBusinessCallBack>> arrayList = this.mBusinessCallBacks;
        synchronized (arrayList) {
            for (WeakReference<IWebBusinessCallBack> item : this.mBusinessCallBacks) {
                IWebBusinessCallBack temp = (IWebBusinessCallBack)item.get();
                if (temp == null) continue;
                temp.onWebBusinessCreated(businessHandler);
            }
        }
        for (JsEvent event : this.mJsEvents) {
            businessHandler.addJsEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWebBusinessDestroyed(IWebBusinessHandler businessHandler) {
        ((IGameService)this.getServiceManager().getService(IGameService.class)).restartAllDownload("webView");
        if (businessHandler == null) {
            return;
        }
        this.mWebBusinessHandlers.remove(businessHandler);
        for (JsEvent event : this.mJsEvents) {
            businessHandler.removeJsEvent(event);
        }
        ArrayList<WeakReference<IWebBusinessCallBack>> arrayList = this.mBusinessCallBacks;
        synchronized (arrayList) {
            for (WeakReference<IWebBusinessCallBack> item : this.mBusinessCallBacks) {
                IWebBusinessCallBack temp = (IWebBusinessCallBack)item.get();
                if (temp == null) continue;
                temp.onWebBusinessDestroyed(businessHandler);
            }
        }
    }

    private static String getYYDefaultUa() {
        String baseUserAgent = WebServiceWrapperController.addOnePieceUserAgent();
        VersionUtil.Ver ver = VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext);
        String userAgent = "";
        userAgent = RuntimeContext.isHagoPartySdk() ? " Platform/Android" + Build.VERSION.RELEASE + " APP/" + AppKeysDef.getAppName() + ver.getVersionNameWithoutSnapshot() + " SDK/" + "hago" + CommonHttpHeader.getHagoAppVerStr() + " Channel/(" + AppMetaDataUtil.getChannelID((Context)RuntimeContext.sApplicationContext) + ") Model/" + Build.MODEL + " Browser/Default Language/" + CommonHttpHeader.getLang() + " " + baseUserAgent : " Platform/Android" + Build.VERSION.RELEASE + " APP/" + "yym-olaparty-and" + ver.getVersionNameWithoutSnapshot() + " Channel/(" + AppMetaDataUtil.getChannelID((Context)RuntimeContext.sApplicationContext) + ") Model/" + Build.MODEL + " Browser/Default Language/" + CommonHttpHeader.getLang() + " " + baseUserAgent;
        MLog.info((Object)TAG, (String)"getYYDefaultUa userAgent: %s", (Object[])new Object[]{userAgent});
        return userAgent;
    }

    private static String addOnePieceUserAgent() {
        EnvSettingType env = EnvSettings.instance().getUriSettingValue();
        String envStr = null;
        envStr = env == EnvSettingType.Dev || env == EnvSettingType.Test ? "Preview" : "Online";
        return " Environment/" + envStr + " NetType/" + NetworkUtils.getNetworkName((Context)RuntimeContext.sApplicationContext) + " UserMode/" + (AccountUtil.isLoginByGuest() ? "Guest" : "Registered");
    }

    public void handleonPermissionRequested(String permission, final IWebViewPermissionCallback callback) {
        if (permission.equals("android.webkit.resource.VIDEO_CAPTURE")) {
            PermissionHelper.requestCameraPermission((Activity)this.getActivity(), (IPermissionListener)new IPermissionListener(){

                @RequiresApi(api=21)
                public void onPermissionGranted(@NonNull String[] permission) {
                    WebServiceWrapperController.this.onWebPermissionGranted(permission, callback);
                }

                @RequiresApi(api=21)
                public void onPermissionDenied(@NonNull String[] permission) {
                    WebServiceWrapperController.this.onWebPermissionDeny(permission, callback);
                }
            });
        }
    }

    @RequiresApi(api=21)
    private void onWebPermissionGranted(String[] permission, IWebViewPermissionCallback callback) {
        Arrays.sort(permission);
        Arrays.sort(Permission.Group.CAMERA);
        if (Arrays.equals(permission, Permission.Group.CAMERA)) {
            callback.onGrant("android.webkit.resource.VIDEO_CAPTURE");
        }
    }

    @RequiresApi(api=21)
    private void onWebPermissionDeny(String[] permission, IWebViewPermissionCallback callback) {
        Arrays.sort(permission);
        Arrays.sort(Permission.Group.CAMERA);
        if (Arrays.equals(permission, Permission.Group.CAMERA)) {
            callback.onDeny("android.webkit.resource.VIDEO_CAPTURE");
        }
    }

    public void onLoadInterceptor(final String url, final WebEnvSettings settings, final ILoadInterceptorCallBack originCallBack) {
        final ILoadInterceptorCallBack callBack = new ILoadInterceptorCallBack(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void continueLoad() {
                ArrayList arrayList = WebServiceWrapperController.this.mBusinessCallBacks;
                synchronized (arrayList) {
                    for (WeakReference item : WebServiceWrapperController.this.mBusinessCallBacks) {
                        IWebBusinessCallBack temp = (IWebBusinessCallBack)item.get();
                        if (temp == null || !(temp instanceof IWebBusinessCallBackEx)) continue;
                        ((IWebBusinessCallBackEx)temp).afterLoadInterceptor(url, settings);
                    }
                }
                originCallBack.continueLoad();
            }

            public void cancel() {
                originCallBack.cancel();
            }

            public int from() {
                return originCallBack.from();
            }
        };
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean intercepted = false;
                ArrayList arrayList = WebServiceWrapperController.this.mBusinessCallBacks;
                synchronized (arrayList) {
                    WeakReference item;
                    IWebBusinessCallBack temp;
                    Iterator iterator = WebServiceWrapperController.this.mBusinessCallBacks.iterator();
                    while (!(!iterator.hasNext() || (temp = (IWebBusinessCallBack)(item = (WeakReference)iterator.next()).get()) != null && temp instanceof IWebBusinessCallBackEx && (intercepted = ((IWebBusinessCallBackEx)temp).onLoadInterceptor(url, settings, callBack)))) {
                    }
                }
                final boolean fIntercepted = intercepted;
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!fIntercepted) {
                            callBack.continueLoad();
                        }
                    }
                });
            }
        }, (long)0L, (int)5);
    }

    private void reportNotToken(long uid, int place, String value) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("perftype", "webview_not_token");
        statContent.put("sfield", "" + uid);
        statContent.put("sfieldtwo", String.valueOf(SystemClock.uptimeMillis() - RuntimeContext.sMainActivityStartTime));
        statContent.put("ifield", RuntimeContext.sIsAppStartFinished ? "1" : "0");
        statContent.put("ifieldtwo", RuntimeContext.isStartAtFirstInstalled() ? "1" : "0");
        statContent.put("ifieldthree", this.mRetryTime);
        statContent.put("ifieldfour", place);
        statContent.put("sfieldthree", value);
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    private void interceptEnvSetting(WebEnvSettings webEnvSettings) {
        String url;
        String string2 = url = webEnvSettings != null ? webEnvSettings.url : "";
        if (url.contains("a/show-fans-club/index.html")) {
            WebTitleButton rightButton = new WebTitleButton();
            rightButton.iconType = 2;
            rightButton.iconDrawable = ResourceUtils.getDrawable((int)R.drawable.icon_help);
            rightButton.setOnClickListener(v -> {
                WebEnvSettings settings = new WebEnvSettings();
                settings.url = UriProvider.fansClubFAQUrl();
                settings.usePageTitle = true;
                settings.disablePullRefresh = true;
                ((IWebService)ServiceManagerProxy.getService(IWebService.class)).loadUrl(settings);
            });
            webEnvSettings.rightButton = rightButton;
        }
    }

    private boolean shouldEnableSwLayer(Context context) {
        WebViewLayerConfig webViewLayerConfig;
        WebViewLayerConfig.WebViewLayerConfigData hwConfigData;
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.WEBVIEW_LAYER_CONFIG);
        if (configData instanceof WebViewLayerConfig && (hwConfigData = (webViewLayerConfig = (WebViewLayerConfig)configData).getData()) != null && hwConfigData.getConfigs() != null && !hwConfigData.getConfigs().isEmpty()) {
            int sdk = Build.VERSION.SDK_INT;
            PackageInfo webViewPackage = WebViewUtils.INSTANCE.getCurrentWebViewPackage(context);
            if (webViewPackage != null && !TextUtils.isEmpty((CharSequence)webViewPackage.versionName)) {
                String webViewVersion = webViewPackage.versionName;
                int scene = 0;
                for (WebViewLayerConfig.WebViewLayerConfigItem item : hwConfigData.getConfigs()) {
                    if (item.getSdkInt() != sdk || item.getScene() != scene || !webViewVersion.equals(item.getWebViewVersion())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

