/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.web;

import android.graphics.Bitmap;
import android.os.Build;
import android.os.SystemClock;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.app.web.preload.WebPreloadUtil;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.webwindow.webview.WebBusinessHandlerCallback;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;

class StatHelper {
    private static final String TAG = "WEB_StatHelper";
    private static final int CODE_START = 100111;
    private static final int CODE_SUCCESS = 200;
    private static final int CODE_CANCEL = 300;
    private static final int CODE_ERROR = 400;
    private static ArrayList<StatItem> sStatItems;
    private static HashMap<IWebBusinessHandler, WebBusinessHandlerCallback> sCallBacks;

    StatHelper() {
    }

    public static synchronized void onWebBusinessCreated(final IWebBusinessHandler businessHandler) {
        if (businessHandler == null || businessHandler.getWebEnvSettings() == null) {
            return;
        }
        if (WebPreloadUtil.isLogEnable()) {
            MLog.info((Object)TAG, (String)"load url created:%s", (Object[])new Object[]{businessHandler.getWebEnvSettings().url});
        }
        if (sStatItems == null) {
            sStatItems = new ArrayList(3);
        }
        if (sCallBacks == null) {
            sCallBacks = new HashMap(3);
        }
        WebBusinessHandlerCallback callback = new WebBusinessHandlerCallback(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                StatItem item;
                if (WebPreloadUtil.isLogEnable()) {
                    MLog.info((Object)StatHelper.TAG, (String)"load url start: %s", (Object[])new Object[]{businessHandler.getWebEnvSettings().url});
                }
                if ((item = StatHelper.find(businessHandler)) != null) {
                    item.onStart();
                }
            }

            public void onPageFinished(WebView view, String url) {
                if (url != null && businessHandler.getWebEnvSettings().url != null && url.contains(businessHandler.getWebEnvSettings().url)) {
                    StatItem item;
                    if (WebPreloadUtil.isLogEnable()) {
                        MLog.info((Object)StatHelper.TAG, (String)"load url finish: %s, cosumeTime:%s", (Object[])new Object[]{businessHandler.getWebEnvSettings().url, String.valueOf(System.currentTimeMillis() - businessHandler.getWebEnvSettings().statParams.startLoadPageTime)});
                    }
                    if ((item = StatHelper.find(businessHandler)) != null) {
                        item.onFinish();
                    }
                }
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                MLog.info((Object)StatHelper.TAG, (String)"load url error: %s", (Object[])new Object[]{businessHandler.getWebEnvSettings().url});
                StatItem item = StatHelper.find(businessHandler);
                if (item != null) {
                    item.onError(errorCode);
                }
            }

            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                MLog.info((Object)StatHelper.TAG, (String)"load url httperror: %s", (Object[])new Object[]{businessHandler.getWebEnvSettings().url});
                StatItem item = StatHelper.find(businessHandler);
                if (item != null) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        item.onError(errorResponse != null ? errorResponse.getStatusCode() : 400);
                    } else {
                        item.onError(400);
                    }
                }
            }
        };
        sCallBacks.put(businessHandler, callback);
        StatItem statItem = new StatItem(businessHandler);
        statItem.isUseCacheWeb = businessHandler.isUseCacheWeb();
        sStatItems.add(statItem);
        businessHandler.addWebViewListener(callback);
    }

    public static synchronized void onWebBusinessDestroyed(IWebBusinessHandler businessHandler) {
        StatItem item;
        if (businessHandler == null || businessHandler.getWebEnvSettings() == null) {
            return;
        }
        if (WebPreloadUtil.isLogEnable()) {
            MLog.info((Object)TAG, (String)"load url destroy:%s", (Object[])new Object[]{businessHandler.getWebEnvSettings().url});
        }
        if (sCallBacks != null && sCallBacks.size() > 0) {
            WebBusinessHandlerCallback callback = sCallBacks.get(businessHandler);
            if (callback != null) {
                businessHandler.removeWebViewListener(callback);
            }
            sCallBacks.remove(businessHandler);
        }
        if ((item = StatHelper.find(businessHandler)) != null) {
            if (item.resultCode != 200) {
                item.onCancel();
            }
            sStatItems.remove(item);
        }
    }

    private static synchronized StatItem find(IWebBusinessHandler webBusinessHandler) {
        if (sStatItems != null && sStatItems.size() > 0) {
            for (StatItem item : sStatItems) {
                WeakReference<IWebBusinessHandler> wItem = item.webHandler;
                if (wItem == null || wItem.get() != webBusinessHandler) continue;
                return item;
            }
        }
        return null;
    }

    private static void reportItem(final StatItem item) {
        if (item == null || StringUtils.isEmpty((String)item.statUrl)) {
            return;
        }
        if (WebPreloadUtil.isLogEnable()) {
            MLog.info((Object)TAG, (String)"report item, url:%s, code:%d, isFromDeepLink:%b", (Object[])new Object[]{item.statUrl, item.resultCode, item.isFromDeepLink});
        }
        sStatItems.remove(item);
        YYTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                long consumeTime = SystemClock.uptimeMillis() - item.startTime;
                String metricUrl = "";
                String[] strs = item.statUrl.split("\\?", 2);
                metricUrl = strs == null || strs.length <= 0 ? "" : strs[0];
                if (metricUrl.startsWith("http://")) {
                    metricUrl = metricUrl.substring(7);
                } else if (metricUrl.startsWith("https://")) {
                    metricUrl = metricUrl.substring(8);
                }
                HashMap<String, String> extra = new HashMap<String, String>(1);
                extra.put("is_from_deeplink", item.isFromDeepLink ? "1" : "0");
                if (item.isUseCacheWeb) {
                    HiidoStatis.reportAppMonitorReturnCode((String)("hyWebviewUseCache/" + metricUrl), (long)((int)consumeTime), (String)String.valueOf(item.resultCode == 200 ? 0 : item.resultCode), extra);
                } else {
                    HiidoStatis.reportAppMonitorReturnCode((String)("hyWebview/" + metricUrl), (long)((int)consumeTime), (String)String.valueOf(item.resultCode == 200 ? 0 : item.resultCode), extra);
                }
            }
        });
    }

    private static class StatItem {
        public WeakReference<IWebBusinessHandler> webHandler;
        public long startTime;
        public int resultCode = -1;
        public String statUrl = "";
        public boolean isUseCacheWeb;
        public boolean isFromDeepLink;

        StatItem(IWebBusinessHandler webBusinessHandler) {
            this.webHandler = new WeakReference<IWebBusinessHandler>(webBusinessHandler);
            this.startTime = SystemClock.uptimeMillis();
            if (webBusinessHandler != null) {
                this.statUrl = webBusinessHandler.getWebEnvSettings().url;
                if (this.statUrl == null) {
                    this.statUrl = "";
                }
                this.isFromDeepLink = webBusinessHandler.getWebEnvSettings().isFromDeepLink;
            }
        }

        public void onStart() {
            this.resultCode = 100111;
        }

        public void onFinish() {
            this.resultCode = 200;
            StatHelper.reportItem(this);
        }

        public void onError(int errorCode) {
            if (errorCode <= 0 || errorCode != 200 && errorCode != 300) {
                this.resultCode = 400;
            }
            this.resultCode = errorCode;
            MLog.info((Object)StatHelper.TAG, (String)"onError %d", (Object[])new Object[]{this.resultCode});
        }

        public void onCancel() {
            this.resultCode = 300;
            StatHelper.reportItem(this);
        }
    }
}

