/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.handleintent;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import com.yy.base.utils.filestorage.FileStorageUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static String getPath(Context ctx, Uri uri) {
        String ret;
        try {
            ret = Build.VERSION.SDK_INT >= 19 ? FileUtils.getUriRealPathAboveKitkat(ctx, uri) : FileUtils.getRealPath(ctx.getContentResolver(), uri, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            ret = FileUtils.getFilePathFromURI(ctx, uri);
        }
        return ret;
    }

    private static String getFilePathFromURI(Context context, Uri contentUri) {
        String fileName = FileUtils.getFileName(contentUri);
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            File tempDirPath = FileStorageUtils.getInstance().getTempDir();
            File copyFile = new File(tempDirPath, fileName);
            FileUtils.copy(context, contentUri, copyFile);
            return copyFile.getAbsolutePath();
        }
        return null;
    }

    public static String getFileName(Uri uri) {
        if (uri == null) {
            return null;
        }
        String fileName = null;
        String path = uri.getPath();
        int cut = path.lastIndexOf(47);
        if (cut != -1) {
            fileName = path.substring(cut + 1);
        }
        return fileName;
    }

    public static void copy(Context context, Uri srcUri, File dstFile) {
        try {
            InputStream inputStream = context.getContentResolver().openInputStream(srcUri);
            if (inputStream == null) {
                return;
            }
            FileOutputStream outputStream = new FileOutputStream(dstFile);
            FileUtils.copy(inputStream, outputStream);
            inputStream.close();
            ((OutputStream)outputStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = FileUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    @RequiresApi(api=19)
    private static String getUriRealPathAboveKitkat(Context ctx, Uri uri) {
        String ret = "";
        if (ctx != null && uri != null) {
            if (FileUtils.isContentUri(uri)) {
                ret = FileUtils.isGooglePhotoDoc(uri.getAuthority()) ? uri.getLastPathSegment() : FileUtils.getRealPath(ctx.getContentResolver(), uri, null);
            } else if (FileUtils.isFileUri(uri)) {
                ret = uri.getPath();
            } else if (FileUtils.isDocumentUri(ctx, uri)) {
                String[] idArr;
                String documentId = DocumentsContract.getDocumentId((Uri)uri);
                String uriAuthority = uri.getAuthority();
                if (FileUtils.isMediaDoc(uriAuthority)) {
                    String[] idArr2 = documentId.split(":");
                    if (idArr2.length == 2) {
                        String docType = idArr2[0];
                        String realDocId = idArr2[1];
                        Uri mediaContentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                        if ("image".equals(docType)) {
                            mediaContentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                        } else if ("video".equals(docType)) {
                            mediaContentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                        } else if ("audio".equals(docType)) {
                            mediaContentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                        }
                        String whereClause = "_id = " + realDocId;
                        ret = FileUtils.getRealPath(ctx.getContentResolver(), mediaContentUri, whereClause);
                    }
                } else if (FileUtils.isDownloadDoc(uriAuthority)) {
                    Uri downloadUri = Uri.parse((String)"content://downloads/public_downloads");
                    Uri downloadUriAppendId = ContentUris.withAppendedId((Uri)downloadUri, (long)Long.valueOf(documentId));
                    ret = FileUtils.getRealPath(ctx.getContentResolver(), downloadUriAppendId, null);
                } else if (FileUtils.isExternalStoreDoc(uriAuthority) && (idArr = documentId.split(":")).length == 2) {
                    String type2 = idArr[0];
                    String realDocId = idArr[1];
                    if ("primary".equalsIgnoreCase(type2) && FileStorageUtils.isStoragePermissionGranted((Context)ctx)) {
                        ret = Environment.getExternalStorageDirectory() + "/" + realDocId;
                    }
                }
            }
        }
        return ret;
    }

    @RequiresApi(api=19)
    private static boolean isDocumentUri(Context ctx, Uri uri) {
        boolean ret = false;
        if (ctx != null && uri != null) {
            ret = DocumentsContract.isDocumentUri((Context)ctx, (Uri)uri);
        }
        return ret;
    }

    private static boolean isContentUri(Uri uri) {
        String uriSchema;
        boolean ret = false;
        if (uri != null && "content".equalsIgnoreCase(uriSchema = uri.getScheme())) {
            ret = true;
        }
        return ret;
    }

    private static boolean isFileUri(Uri uri) {
        String uriSchema;
        boolean ret = false;
        if (uri != null && "file".equalsIgnoreCase(uriSchema = uri.getScheme())) {
            ret = true;
        }
        return ret;
    }

    private static boolean isExternalStoreDoc(String uriAuthority) {
        boolean ret = false;
        if ("com.android.externalstorage.documents".equals(uriAuthority)) {
            ret = true;
        }
        return ret;
    }

    private static boolean isDownloadDoc(String uriAuthority) {
        boolean ret = false;
        if ("com.android.providers.downloads.documents".equals(uriAuthority)) {
            ret = true;
        }
        return ret;
    }

    private static boolean isMediaDoc(String uriAuthority) {
        boolean ret = false;
        if ("com.android.providers.media.documents".equals(uriAuthority)) {
            ret = true;
        }
        return ret;
    }

    private static boolean isGooglePhotoDoc(String uriAuthority) {
        boolean ret = false;
        if ("com.google.android.apps.photos.content".equals(uriAuthority)) {
            ret = true;
        }
        return ret;
    }

    @SuppressLint(value={"Recycle"})
    private static String getRealPath(ContentResolver contentResolver, Uri uri, String whereClause) {
        boolean moveToFirst;
        String ret = "";
        Cursor cursor = contentResolver.query(uri, null, whereClause, null, null);
        if (cursor != null && (moveToFirst = cursor.moveToFirst())) {
            String columnName = "_data";
            if (uri == MediaStore.Images.Media.EXTERNAL_CONTENT_URI) {
                columnName = "_data";
            } else if (uri == MediaStore.Audio.Media.EXTERNAL_CONTENT_URI) {
                columnName = "_data";
            } else if (uri == MediaStore.Video.Media.EXTERNAL_CONTENT_URI) {
                columnName = "_data";
            }
            int columnIndex = cursor.getColumnIndex(columnName);
            ret = cursor.getString(columnIndex);
        }
        return ret;
    }
}

