/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import androidx.annotation.Keep;
import com.duowan.hiyo.crash.SdkCrash;
import com.yy.appbase.service.LiveEnv;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.app.HagoEnvIniter;
import com.yy.hiyo.app.startup.StepInitBaseEnv;
import com.yy.hiyo.app.startup.StepInitUtils;
import com.yy.hiyo.applicationroute.MainApplication;
import com.yy.hiyo.main.base.ActivityTaskUtils;
import com.yy.hiyo.main.base.PartySdkLocale;
import java.util.Locale;

@Keep
public class HagoPartySdkApplication {
    private static final String TAG = "HagoPartySdkInit";
    private static Application lastApplication;

    public static synchronized void onCreate(Application application) {
        if (application == null) {
            MLog.error((Object)TAG, (String)"application is null", (Object[])new Object[0]);
            return;
        }
        if (lastApplication == application) {
            MLog.info((Object)TAG, (String)"application is same", (Object[])new Object[0]);
            return;
        }
        ActivityTaskUtils.INSTANCE.start(application);
        lastApplication = application;
        RuntimeContext.sApplicationContext = application;
        PartySdkLocale.INSTANCE.setGlobalLocale(Locale.getDefault());
        ActivityTaskUtils.INSTANCE.start(application);
        long curTime = -1L;
        long settingFlagInit = -1L;
        long beforeAppCreate = -1L;
        if (SystemUtils.isShowEnvSetting()) {
            curTime = System.currentTimeMillis();
        }
        SettingFlags.init((Context)application);
        if (RuntimeContext.isLocalBuild()) {
            // empty if block
        }
        if (SystemUtils.isShowEnvSetting()) {
            settingFlagInit = System.currentTimeMillis();
        }
        MainApplication.beforeAppCreate(application);
        if (SystemUtils.isShowEnvSetting()) {
            beforeAppCreate = System.currentTimeMillis();
        }
        MainApplication.afterAppCreate(application, true);
        if (SystemUtils.isShowEnvSetting()) {
            HagoPartySdkApplication.log(TAG, "SettingFlags init end :%s!", String.valueOf(settingFlagInit - curTime));
            HagoPartySdkApplication.log(TAG, "Application beforeAppCreate end :%s!", String.valueOf(beforeAppCreate - curTime));
            HagoPartySdkApplication.log(TAG, "Application afterAppCreate end :%s!", String.valueOf(System.currentTimeMillis() - curTime));
        }
        LiveEnv liveEnv = HagoEnvIniter.initEnv(application);
        if (SystemUtils.isShowEnvSetting()) {
            HagoPartySdkApplication.log(TAG, "initEnv end :%s!", String.valueOf(System.currentTimeMillis() - curTime));
        }
        new StepInitUtils().init();
        if (SystemUtils.isShowEnvSetting()) {
            HagoPartySdkApplication.log(TAG, "InitUtils end :%s!", String.valueOf(System.currentTimeMillis() - curTime));
        }
        new StepInitBaseEnv((Environment)liveEnv).init();
        HagoEnvIniter.getModuleLoadersManager().afterEnvInit();
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_PARTY_SDK_BASE_INIT));
        if (SystemUtils.isShowEnvSetting()) {
            HagoPartySdkApplication.log(TAG, "end:%s!", String.valueOf(System.currentTimeMillis() - curTime));
        } else {
            HagoPartySdkApplication.log(TAG, "end!", new Object[0]);
        }
        MLog.error((Object)TAG, (String)"HagoPartySdkApplication init sdk version:%s", (Object[])new Object[]{"1.8.1.0.34-SNAPSHOT"});
        Log.i((String)TAG, (String)"HagoPartySdkApplication init sdk version: 1.8.1.0.34-SNAPSHOT");
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                MLog.error((Object)HagoPartySdkApplication.TAG, (String)"HagoPartySdkApplication init delay sdk version:%s", (Object[])new Object[]{"1.8.1.0.34-SNAPSHOT"});
            }
        }, (long)5000L);
        SdkCrash.INSTANCE.initCrash();
    }

    public static void attachBaseContext(Context base) {
    }

    private static void log(String obj, String format, Object ... args) {
        if (RuntimeContext.isLocalBuild()) {
            if (args != null && args.length >= 1) {
                Log.i((String)obj, (String)(format + args[0]));
            } else {
                Log.i((String)obj, (String)format);
            }
        } else {
            MLog.info((Object)obj, (String)format, (Object[])args);
        }
    }
}

