/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.account;

import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountList;
import java.util.ArrayList;
import java.util.List;

public class AccountListManager {
    private static final String FILE_NAME = "LoginAccountList";
    private volatile AccountList mAccountList = new AccountList();
    private boolean mLoadFromFile = false;
    private IQueueTaskExecutor mTaskExecutor;

    private synchronized IQueueTaskExecutor getTaskExecutor() {
        if (this.mTaskExecutor == null) {
            this.mTaskExecutor = YYTaskExecutor.createAQueueExcuter();
        }
        return this.mTaskExecutor;
    }

    public synchronized void getAccount(final long uid, final IObtainCallBack callBack) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (callBack != null) {
                    AccountInfo accountInfo = AccountListManager.this.mAccountList.findAccountInfo(uid);
                    if (accountInfo != null) {
                        ArrayList<AccountInfo> result = new ArrayList<AccountInfo>(1);
                        result.add(accountInfo);
                        callBack.onCallBackOnUiThread(result);
                    } else {
                        callBack.onCallBackOnUiThread(null);
                    }
                }
            }
        };
        this.executeAfterLoadFromFile(command);
    }

    public synchronized void getAccounts(final IObtainCallBack callBack) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (callBack != null) {
                    callBack.onCallBackOnUiThread(AccountListManager.this.mAccountList.getAccounts());
                }
            }
        };
        this.executeAfterLoadFromFile(command);
    }

    public synchronized void addAccount(final AccountInfo info) {
        if (info == null || info.uuid <= 0L || info.loginType <= 0 || info.loginType == 10) {
            return;
        }
        final AccountInfo accountInfo = AccountInfo.obtain(info);
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (accountInfo.uuid <= 0L || accountInfo.loginType <= 0 || info.loginType == 10) {
                    return;
                }
                MLog.info((Object)"FTLoginAccount", (String)"AccountListManager addAccount uid:%s type:%d", (Object[])new Object[]{String.valueOf(info.uuid), info.loginType});
                AccountListManager.this.mAccountList.addAccount(accountInfo);
                AccountListManager.this.saveInfoToFile();
            }
        };
        this.executeAfterLoadFromFile(command);
    }

    public synchronized void updateAccount(final AccountInfo info) {
        if (info == null || info.uuid <= 0L || info.loginType <= 0 || info.loginType == 10) {
            return;
        }
        final AccountInfo accountInfo = AccountInfo.obtain(info);
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (accountInfo.uuid <= 0L || accountInfo.loginType <= 0 || info.loginType == 10) {
                    return;
                }
                MLog.info((Object)"FTLoginAccount", (String)"AccountListManager updateAccount uid:%s type:%d", (Object[])new Object[]{String.valueOf(info.uuid), info.loginType});
                AccountListManager.this.mAccountList.updateAccount(accountInfo);
                AccountListManager.this.saveInfoToFile();
            }
        };
        this.executeAfterLoadFromFile(command);
    }

    public synchronized void deleteAccount(final long uid) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                MLog.info((Object)"FTLoginAccount", (String)"AccountListManager delete Account uid:%s", (Object[])new Object[]{String.valueOf(uid)});
                AccountInfo info = AccountListManager.this.mAccountList.deleteAccount(uid);
                if (info != null) {
                    AccountListManager.this.saveInfoToFile();
                }
            }
        };
        this.executeAfterLoadFromFile(command);
    }

    public synchronized void clear() {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                MLog.info((Object)"FTLoginAccount", (String)"AccountListManager clear!", (Object[])new Object[0]);
                boolean result = AccountListManager.this.mAccountList.clear();
                if (result) {
                    AccountListManager.this.saveInfoToFile();
                }
            }
        };
        this.executeAfterLoadFromFile(command);
    }

    public void updateLoginedAccountUserInfo(final List<UserInfoKS> userInfos) {
        if (userInfos == null || userInfos.size() <= 0) {
            return;
        }
        this.getAccounts(new IObtainCallBack(){

            @Override
            public void onCallBackOnUiThread(List<AccountInfo> list) {
                if (list == null || list.size() <= 0) {
                    return;
                }
                boolean needUpdate = false;
                ArrayList<AccountInfo> listUpdated = new ArrayList<AccountInfo>(list.size());
                for (AccountInfo info : list) {
                    if (info == null) continue;
                    needUpdate = false;
                    for (UserInfoKS item : userInfos) {
                        if (item == null || item.uid != info.uuid) continue;
                        if (!StringUtils.equal((String)info.userName, (String)item.nick)) {
                            info.userName = item.nick;
                            needUpdate = true;
                        }
                        if (!StringUtils.equal((String)info.iconUrl, (String)item.avatar)) {
                            info.iconUrl = item.avatar;
                            needUpdate = true;
                        }
                        if (info.vid != item.vid) {
                            info.vid = item.vid;
                            needUpdate = true;
                        }
                        if (info.sex == item.sex) break;
                        info.sex = item.sex;
                        needUpdate = true;
                        break;
                    }
                    if (!needUpdate) continue;
                    MLog.info((Object)"FTLoginAccount", (String)"AccountListManager update info uid:%s nick:%s!", (Object[])new Object[]{String.valueOf(info.uuid), info.userName});
                    listUpdated.add(info);
                }
                if (listUpdated.size() > 0 && AccountListManager.this.mAccountList != null) {
                    AccountListManager.this.mAccountList.updateAccounts(listUpdated);
                    AccountListManager.this.saveInfoToFile();
                }
            }
        });
    }

    private void executeAfterLoadFromFile(Runnable command) {
        if (command == null) {
            return;
        }
        if (this.mLoadFromFile) {
            command.run();
        } else {
            this.getTaskExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    AccountListManager.this.ensureLoad();
                }
            }, command, 0L);
        }
    }

    private synchronized void ensureLoad() {
        if (this.mLoadFromFile) {
            return;
        }
        AccountList list = this.readInfoFromFile();
        if (list != null) {
            this.mAccountList = list;
        }
        this.mLoadFromFile = true;
    }

    private void saveInfoToFile() {
        long delayMillis = 0L;
        if (!RuntimeContext.sIsServicesInited) {
            delayMillis = 5000L;
        }
        YYTaskExecutor.getDefaultIdleExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String data = JsonParser.toJson((Object)AccountListManager.this.mAccountList);
                if (StringUtils.isEmpty((String)data)) {
                    if (AccountListManager.this.mAccountList.isEmpty()) {
                        FileStorageUtils.getInstance().saveToFile(true, data, AccountListManager.FILE_NAME);
                    }
                } else {
                    FileStorageUtils.getInstance().saveToFile(true, data, AccountListManager.FILE_NAME);
                }
            }
        }, delayMillis);
    }

    private AccountList readInfoFromFile() {
        String data = FileStorageUtils.getInstance().getStrFromFile(true, FILE_NAME);
        if (StringUtils.isNotEmpty((String)data)) {
            return (AccountList)JsonParser.parseJsonObject((String)data, AccountList.class);
        }
        return null;
    }

    public static interface IObtainCallBack {
        public void onCallBackOnUiThread(List<AccountInfo> var1);
    }
}

