/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.stat;

import android.content.Context;
import android.os.Build;
import android.os.SystemClock;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.guid.GuidFactory;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.stat.LoginResultStatisticsItem;
import com.yy.hiyo.login.stat.LoginStatisticsItem;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.data.LoginErrorResult;
import com.yy.socialplatformbase.data.LoginSuccessResult;
import com.yy.socialplatformbase.platform.IPlatformAvailableCallBack;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import com.yy.yylite.commonbase.hiido.HiidoUtils;

public class LoginStatistics {
    private static final String TAG = "loginStat";
    private static final int MAX_STAT_STR_LENGTH = 150;
    private LoginStatisticsItem mItem;
    private static long sLoginStartTime = -1L;
    private static int sLastLoginType = -1;
    private static long sStartUpWorksFinishTime = -1L;
    private static long sGoogleGuestLoginHandleFinishTime = -1L;
    private static volatile boolean sPingFacebook = false;
    private static volatile boolean sPingGoogle = false;
    private static volatile boolean sPingBaidu = false;
    private static volatile boolean sPinging = false;
    private static volatile String sGoogleVerName = "";
    private static volatile int sGoogleVer = -1;
    private static volatile String sFacebookVerName = "";
    private static volatile int sFacebookVer = -1;

    public void onLoginSelectWindowShow(final long uptimeMillis) {
        this.mItem = new LoginStatisticsItem();
        this.mItem.mLoginedType = AccountModel.hasLoginedBefore();
        if (this.mItem.mLoginedType > 0) {
            this.mItem.mLoginedBefore = true;
        }
        this.mItem.mFirstOpen = RuntimeContext.isStartAtFirstInstalled();
        this.mItem.mLoginSelectShowStartTime = System.currentTimeMillis();
        this.mItem.mComsumeTime = 0;
        sLoginStartTime = this.mItem.mLoginSelectShowStartTime;
        sLastLoginType = this.mItem.mLoginedType;
        final int loginType = this.mItem.mLoginedType;
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("ifield", loginType);
                statContent.put("ifieldtwo", uptimeMillis - RuntimeContext.sMainActivityStartTime);
                statContent.put("ifieldthree", RuntimeContext.getRunTimes());
                statContent.put("ifieldfour", sStartUpWorksFinishTime - RuntimeContext.sMainActivityStartTime);
                statContent.put("ifieldfive", sGoogleGuestLoginHandleFinishTime - RuntimeContext.sMainActivityStartTime);
                statContent.put("sfield", HiidoUtils.getHdid());
                statContent.put("sfieldtwo", "loginselects");
                if (uptimeMillis - RuntimeContext.sAppOncreateTime > 12000L && uptimeMillis - RuntimeContext.sMainActivityStartTime < 9000L) {
                    statContent.put("sfieldthree", String.valueOf(uptimeMillis - RuntimeContext.sMainActivityStartTime));
                }
                if (HardwareUtils.isSimulator()) {
                    statContent.put("sfieldfive", Build.MODEL);
                }
                statContent.put("perftype", "login");
                HiidoStatis.reportContent((StatisContent)statContent);
            }
        });
    }

    public void onBasicProfileOpen() {
        AccountInfo info = AccountModel.getInstance().getAccountInfo();
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("ifield", this.mItem != null ? this.mItem.mLoginedType : -1);
        statContent.put("ifieldthree", RuntimeContext.getRunTimes());
        statContent.put("ifieldfour", info != null ? info.loginType : -1);
        statContent.put("sfield", HiidoUtils.getHdid());
        statContent.put("sfieldtwo", "profileshow");
        statContent.put("sfieldthree", AccountUtil.getUid() > 0L ? String.valueOf(AccountUtil.getUid()) : "");
        statContent.put("perftype", "login");
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    public void onLoginAllWindowClose() {
        if (this.mItem != null) {
            this.mItem.mFinishType = 1;
            if (this.mItem.mComsumeTime < 0) {
                this.mItem.mComsumeTime = 0;
            }
            this.mItem.mComsumeTime += (int)(System.currentTimeMillis() - this.mItem.mLoginSelectShowStartTime);
            this.statLoginProcess(this.mItem);
            StatisContent statContent = new StatisContent();
            statContent.put("act", "hagoperf");
            statContent.put("ifield", this.mItem.mLoginedType);
            statContent.put("ifieldtwo", this.mItem.mComsumeTime);
            statContent.put("ifieldthree", RuntimeContext.getRunTimes());
            statContent.put("ifieldfour", this.mItem.mLoginResult.mLoginTypeSelect);
            statContent.put("sfield", HiidoUtils.getHdid());
            statContent.put("sfieldtwo", "loginfinish");
            statContent.put("sfieldthree", AccountUtil.getUid() > 0L ? String.valueOf(AccountUtil.getUid()) : "");
            statContent.put("perftype", "login");
            HiidoStatis.reportContent((StatisContent)statContent);
            this.mItem = null;
        }
    }

    public static void onStartUpWorksFinish() {
        if (AccountUtil.getUid() > 0L) {
            return;
        }
        sStartUpWorksFinishTime = SystemClock.uptimeMillis();
    }

    public static void onGoogleGuestLoginHandleFinish() {
        if (AccountUtil.getUid() > 0L) {
            return;
        }
        sGoogleGuestLoginHandleFinishTime = SystemClock.uptimeMillis();
    }

    public static void onHomeShowEvent() {
        if (sLoginStartTime > 0L && sLastLoginType <= 0) {
            StatisContent statContent = new StatisContent();
            statContent.put("act", "hagoperf");
            statContent.put("ifield", sLastLoginType);
            statContent.put("ifieldtwo", System.currentTimeMillis() - sLoginStartTime);
            statContent.put("ifieldthree", RuntimeContext.getRunTimes());
            statContent.put("ifieldfour", AccountUtil.getsLoginType());
            statContent.put("sfield", HiidoUtils.getHdid());
            statContent.put("sfieldtwo", "homeShowAfterLogin");
            statContent.put("sfieldthree", AccountUtil.getUid() > 0L ? String.valueOf(AccountUtil.getUid()) : "");
            statContent.put("perftype", "login");
            HiidoStatis.reportContent((StatisContent)statContent);
        }
    }

    public static void onHomePageDataShow(int showType) {
        if (sLoginStartTime > 0L && sLastLoginType <= 0) {
            StatisContent statContent = new StatisContent();
            statContent.put("act", "hagoperf");
            statContent.put("ifield", sLastLoginType);
            statContent.put("ifieldtwo", System.currentTimeMillis() - sLoginStartTime);
            statContent.put("ifieldthree", RuntimeContext.getRunTimes());
            statContent.put("ifieldfour", AccountUtil.getsLoginType());
            statContent.put("ifieldfive", showType);
            statContent.put("sfield", HiidoUtils.getHdid());
            statContent.put("sfieldtwo", "homePageAfterLogin");
            statContent.put("perftype", "login");
            HiidoStatis.reportContent((StatisContent)statContent);
        }
    }

    public void onChangeBackground(boolean foreground) {
        if (foreground) {
            // empty if block
        }
    }

    public void onAppExit() {
        if (this.mItem != null) {
            this.mItem.mFinishType = 1;
            if (this.mItem.mComsumeTime < 0) {
                this.mItem.mComsumeTime = 0;
            }
            this.mItem.mComsumeTime += (int)(System.currentTimeMillis() - this.mItem.mLoginSelectShowStartTime);
            this.statLoginProcess(this.mItem);
        }
    }

    public void onLoginSelected(int loginType) {
        if (this.mItem != null) {
            ++this.mItem.mLoginSelectClickTimes;
            this.mItem.mLoginResult.mLoginTypeSelect = loginType;
            this.mItem.mLoginResult.mLoginStartTime = System.currentTimeMillis();
            this.mItem.mLoginResult.mLoginComsumeTime = 0;
            StatisContent statContent = new StatisContent();
            statContent.put("act", "hagoperf");
            statContent.put("ifield", this.mItem.mLoginedType);
            statContent.put("ifieldtwo", this.mItem.mLoginResult.mLoginStartTime - this.mItem.mLoginSelectShowStartTime);
            statContent.put("ifieldthree", RuntimeContext.getRunTimes());
            statContent.put("ifieldfour", loginType);
            statContent.put("sfield", HiidoUtils.getHdid());
            statContent.put("sfieldtwo", "LoginSelect");
            statContent.put("perftype", "login");
            HiidoStatis.reportContent((StatisContent)statContent);
        }
    }

    public void onLoginSuccess(int loginType, String account, LoginSuccessResult result) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        if (this.mItem != null && this.mItem.mLoginResult.mLoginTypeSelect == loginType) {
            this.mItem.mLoginResult.mLoginRes = true;
            this.mItem.mLoginResult.mLoginAccount = account;
            if (this.mItem.mLoginResult.mLoginComsumeTime < 0) {
                this.mItem.mLoginResult.mLoginComsumeTime = 0;
            }
            this.mItem.mLoginResult.mLoginComsumeTime = (int)(System.currentTimeMillis() - this.mItem.mLoginResult.mLoginStartTime);
            this.mItem.mLoginResult.loginAuthorizeSuccess = true;
            this.mItem.mLoginResult.isClientAuthorize = result != null && result.authorizedData.isClientAuthorize;
            this.mItem.mLoginResult.errorTime = result != null ? result.authorizedData.errorTime : 0;
            this.statLoginResult(this.mItem.mLoginResult);
            statContent.put("ifield", this.mItem.mLoginedType);
            statContent.put("ifieldtwo", this.mItem.mLoginResult.mLoginComsumeTime);
        }
        statContent.put("ifieldthree", RuntimeContext.getRunTimes());
        statContent.put("ifieldfour", loginType);
        statContent.put("sfield", HiidoUtils.getHdid());
        statContent.put("sfieldtwo", "loginsuccess");
        statContent.put("perftype", "login");
        HiidoStatis.reportContent((StatisContent)statContent);
        this.statToMeric(loginType, true);
    }

    public void onLoginError(int loginType, String account, String errorCode, String errorDes, LoginSuccessResult loginSuccessResult, LoginErrorResult loginErrorResult) {
        if (this.mItem != null && this.mItem.mLoginResult.mLoginTypeSelect == loginType) {
            this.mItem.mLoginResult.mLoginRes = false;
            this.mItem.mLoginResult.mLoginErrorType = errorCode;
            this.mItem.mLoginResult.mLoginErrorDes = errorDes;
            this.mItem.mLoginResult.mLoginAccount = account;
            ++this.mItem.mLoginResult.mLoginErrorTimes;
            if (this.mItem.mLoginResult.mLoginComsumeTime < 0) {
                this.mItem.mLoginResult.mLoginComsumeTime = 0;
            }
            this.mItem.mLoginResult.mLoginComsumeTime = (int)(System.currentTimeMillis() - this.mItem.mLoginResult.mLoginStartTime);
            this.mItem.mLoginResult.loginAuthorizeSuccess = loginSuccessResult != null;
            this.mItem.mLoginResult.isClientAuthorize = loginSuccessResult != null ? loginSuccessResult.authorizedData.isClientAuthorize : loginErrorResult != null && loginErrorResult.isClientAuthorize;
            this.mItem.mLoginResult.errorTime = loginSuccessResult != null ? loginSuccessResult.authorizedData.errorTime : (loginErrorResult != null ? loginErrorResult.errorTime : 0);
            this.statLoginResult(this.mItem.mLoginResult);
        }
        this.statToMeric(loginType, false);
    }

    public static void statErrorTips(int loginType, boolean clickOk) {
        try {
            StatisContent statContent = new StatisContent();
            statContent.put("act", "hagoperf");
            statContent.put("ifield", AccountModel.hasLoginedBefore());
            statContent.put("ifieldtwo", loginType);
            statContent.put("ifieldthree", clickOk ? "1" : "0");
            statContent.put("sfield", GuidFactory.getInstance().getGuid());
            statContent.put("sfieldtwo", "loginerrortips");
            statContent.put("perftype", "login");
            HiidoStatis.reportContent((StatisContent)statContent);
        }
        catch (Exception e) {
            MLog.error((Object)"LoginStatics", (Throwable)e);
        }
    }

    private void statToMeric(int loginedType, boolean success) {
        int consumeTime = -1;
        if (this.mItem != null) {
            consumeTime = this.mItem.mLoginResult != null ? this.mItem.mLoginResult.mLoginComsumeTime : -1;
        }
        String loginUri = "";
        if (loginedType == 1) {
            loginUri = "hylogin/facebook";
        } else if (loginedType == 3) {
            loginUri = "hylogin/google";
        } else if (loginedType == 4) {
            loginUri = "hylogin/line";
        } else if (loginedType == 2) {
            loginUri = "hylogin/phone";
        } else if (loginedType == 10) {
            loginUri = "hylogin/guest";
        } else if (loginedType == 7) {
            loginUri = "hylogin/zalo";
        } else if (loginedType == 9) {
            loginUri = "hylogin/snapchat";
        }
        HiidoStatis.reportAppMonitorReturnCode((String)loginUri, (long)consumeTime, (String)(success ? "0" : "1"));
    }

    public void onSmsGetClicked() {
        if (this.mItem != null) {
            ++this.mItem.mSmsCheckClick;
        }
    }

    public void onCountryClicked() {
        if (this.mItem != null) {
            ++this.mItem.mCountryClick;
        }
    }

    public void onSmsGetResult(boolean success, String errorType) {
        if (this.mItem != null) {
            this.mItem.mSmsGetResult = success ? 1 : 0;
            this.mItem.mSmsGetErrorType = !success ? errorType : "";
        }
    }

    public void onSmsCheckClicked(String checkInfo) {
        if (this.mItem != null) {
            ++this.mItem.mSmsCheckClick;
            this.mItem.mSmsCheckInfo = checkInfo;
        }
    }

    public void onProfileShowed() {
        if (this.mItem != null) {
            this.mItem.mProfileShow = true;
        }
    }

    public void onProfileSkipClicked() {
        if (this.mItem != null) {
            this.mItem.mProfileSkip = true;
        }
    }

    public void onProfileSaveClicked() {
        if (this.mItem != null) {
            ++this.mItem.mProfileSaveClick;
        }
    }

    public void onProfileSaveResult(boolean success) {
        if (this.mItem != null) {
            this.mItem.mProfileSaveResult = success ? 1 : 0;
        }
    }

    private void statLoginProcess(LoginStatisticsItem item) {
        if (item == null) {
            return;
        }
        StatisContent statContent = null;
        statContent = item.mLoginResult != null ? this.createStatisContent(item.mLoginResult) : this.createBaseStatisContent(item);
        statContent.put("loginshow", String.valueOf(1));
        statContent.put("finish", String.valueOf(item.mFinishType));
        statContent.put("loginselectclick", item.mLoginSelectClickTimes);
        if (item.mComsumeTime > 0) {
            statContent.put("comsume", String.valueOf(item.mComsumeTime));
        }
        statContent.put("smsgetc", String.valueOf(item.mSmsGetClick));
        if (item.mSmsGetResult > -1) {
            statContent.put("smsres", item.mSmsGetResult);
            if (item.mSmsGetResult != 1 && StringUtils.isNotEmpty((String)item.mSmsGetErrorType)) {
                statContent.put("smserrortype", item.mSmsGetErrorType);
            }
        }
        statContent.put("smscheckc", String.valueOf(item.mSmsCheckClick));
        if (item.mSmsCheckComsume > 0) {
            statContent.put("smsinputc", item.mSmsCheckComsume);
        }
        if (StringUtils.isNotEmpty((String)item.mSmsCheckInfo)) {
            if (StringUtils.isNotEmpty((String)item.mSmsCheckInfo) && item.mSmsCheckInfo.length() > 150) {
                item.mSmsCheckInfo = item.mSmsCheckInfo.substring(0, 150);
            }
            statContent.put("smsinput", String.valueOf(item.mSmsCheckInfo));
        }
        statContent.put("countryc", item.mCountryClick);
        statContent.put("profileshow", item.mProfileShow ? "1" : "0");
        statContent.put("profileskip", item.mProfileSkip ? "1" : "0");
        statContent.put("profilesave", item.mProfileSaveClick);
        if (item.mProfileSaveResult > 0) {
            statContent.put("profilesaveres", item.mProfileSaveResult);
        }
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    private StatisContent createBaseStatisContent(LoginStatisticsItem item) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagologin");
        if (item != null) {
            statContent.put("logined", item.mLoginedBefore ? "1" : "0");
            if (item.mLoginedBefore) {
                statContent.put("logintype", String.valueOf(item.mLoginedType));
            }
            statContent.put("firstopen", item.mFirstOpen ? "1" : "0");
        }
        statContent.put("hyguid", HiidoUtils.getHdid());
        statContent.put("hynet", NetworkUtils.getNetworkType((Context)RuntimeContext.sApplicationContext));
        return statContent;
    }

    private StatisContent createStatisContent(LoginResultStatisticsItem item) {
        LoginStatisticsItem processItem;
        if (item == null) {
            return new StatisContent();
        }
        StatisContent statContent = this.createBaseStatisContent(this.mItem);
        statContent.put("typeselect", String.valueOf(item.mLoginTypeSelect));
        if (!item.mLoginRes) {
            String errorDes;
            if (StringUtils.isNotEmpty((String)item.mLoginErrorType)) {
                statContent.put("errort", String.valueOf(item.mLoginErrorType));
            }
            if (StringUtils.isNotEmpty((String)(errorDes = item.mLoginErrorDes))) {
                if (StringUtils.isNotEmpty((String)errorDes) && errorDes.length() > 150) {
                    errorDes = errorDes.substring(0, 150);
                }
                statContent.put("errord", String.valueOf(errorDes));
            }
        }
        statContent.put("res", item.mLoginRes ? "1" : "0");
        if (StringUtils.isNotEmpty((String)item.mLoginAccount)) {
            statContent.put("acc", item.mLoginAccount);
        }
        if (item.mLoginAccountInput > 0) {
            statContent.put("accinput", item.mLoginAccountInput);
        }
        if (item.mLoginComsumeTime > 0) {
            statContent.put("loginc", String.valueOf(item.mLoginComsumeTime));
        }
        if ((processItem = this.mItem) != null && item.mLoginTypeSelect == 2) {
            statContent.put("smsgetc", String.valueOf(processItem.mSmsGetClick));
            if (processItem.mSmsGetResult > -1) {
                statContent.put("smsres", processItem.mSmsGetResult);
                if (processItem.mSmsGetResult != 1 && StringUtils.isNotEmpty((String)processItem.mSmsGetErrorType)) {
                    statContent.put("smserrortype", processItem.mSmsGetErrorType);
                }
            }
            statContent.put("smscheckc", String.valueOf(processItem.mSmsCheckClick));
            if (processItem.mSmsCheckComsume > 0) {
                statContent.put("smsinputc", processItem.mSmsCheckComsume);
            }
            if (StringUtils.isNotEmpty((String)processItem.mSmsCheckInfo)) {
                if (StringUtils.isNotEmpty((String)processItem.mSmsCheckInfo) && processItem.mSmsCheckInfo.length() > 150) {
                    processItem.mSmsCheckInfo = processItem.mSmsCheckInfo.substring(0, 150);
                }
                statContent.put("smsinput", String.valueOf(processItem.mSmsCheckInfo));
            }
            statContent.put("countryc", processItem.mCountryClick);
        }
        statContent.put("loginerrortimes", item.mLoginErrorTimes);
        statContent.put("client_auth", item.isClientAuthorize ? "1" : "0");
        statContent.put("retry_times", item.errorTime);
        statContent.put("client_auth_status", item.loginAuthorizeSuccess ? "1" : "0");
        return statContent;
    }

    private void statLoginResult(final LoginResultStatisticsItem item) {
        if (item == null) {
            return;
        }
        final StatisContent statContent = this.createStatisContent(item);
        statContent.put("loginshow", String.valueOf(2));
        if (!item.mLoginRes) {
            AbsPlatformAdapter platformAdapter = null;
            if (item.mLoginTypeSelect == 3 && (platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(6)) != null) {
                platformAdapter.getPlatformVersion(new IPlatformAvailableCallBack(){

                    public void onCallBack(boolean isServicesAvailable, int version, String verName, String packName) {
                        if (isServicesAvailable) {
                            sGoogleVer = version;
                            sGoogleVerName = verName;
                        }
                    }
                });
            }
            if (item.mLoginTypeSelect == 1 && (platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(5)) != null) {
                platformAdapter.getPlatformVersion(new IPlatformAvailableCallBack(){

                    public void onCallBack(boolean isServicesAvailable, int version, String verName, String packName) {
                        if (isServicesAvailable) {
                            sFacebookVer = version;
                            sFacebookVerName = verName;
                        }
                    }
                });
            }
        }
        if (!sPinging && !item.mLoginRes) {
            sPinging = true;
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    boolean needPingGoogle;
                    boolean bl = needPingGoogle = !StringUtils.equalsIgnoreCase((String)SystemUtils.getHagoCountry(), (String)"CN");
                    if (item.mLoginTypeSelect == 1) {
                        sPingFacebook = NetworkUtils.pingHost((String)"m.facebook.com");
                    }
                    if (!needPingGoogle) {
                        sPingBaidu = NetworkUtils.pingHost((String)"www.baidu.com");
                    } else {
                        sPingGoogle = NetworkUtils.pingHost((String)"www.google.com");
                    }
                    sPinging = false;
                }
            });
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    statContent.put("hypingf", sPingFacebook ? 1 : 0);
                    statContent.put("hypingg", sPingGoogle || sPingBaidu ? 1 : 0);
                    if (item.mLoginTypeSelect == 1) {
                        statContent.put("hyptver", sFacebookVer);
                        statContent.put("hyptvern", sFacebookVerName);
                    } else if (item.mLoginTypeSelect == 3) {
                        statContent.put("hyptver", sGoogleVer);
                        statContent.put("hyptvern", sGoogleVerName);
                    }
                    MLog.infoIfDebug((Object)LoginStatistics.TAG, (String)(statContent.toString() + "  !sPinging && !item.mLoginRes"), (Object[])new Object[0]);
                    HiidoStatis.reportContent((StatisContent)statContent);
                }
            }, (long)10000L);
        } else {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!item.mLoginRes) {
                        if (item.mLoginTypeSelect == 1) {
                            statContent.put("hyptver", sFacebookVer);
                            statContent.put("hyptvern", sFacebookVerName);
                        } else if (item.mLoginTypeSelect == 3) {
                            statContent.put("hyptver", sGoogleVer);
                            statContent.put("hyptvern", sGoogleVerName);
                        }
                    }
                    MLog.infoIfDebug((Object)LoginStatistics.TAG, (String)statContent.toString(), (Object[])new Object[0]);
                    HiidoStatis.reportContent((StatisContent)statContent);
                }
            }, (long)5000L);
        }
    }

    public static void statLoginOutEvent(int from) {
        LoginStatistics.statLoginOutEvent(AccountUtil.getUid(), from);
    }

    public static void statLoginOutEvent(final long uid, final int from) {
        final int loginType = AccountUtil.getsLoginType();
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("sfield", uid);
                statContent.put("sfieldtwo", HiidoUtils.getHdid());
                statContent.put("ifield", from);
                statContent.put("ifieldtwo", loginType);
                statContent.put("ifieldthree", RuntimeContext.sIsForeground ? 1 : 0);
                statContent.put("perftype", "loginout");
                HiidoStatis.reportContent((StatisContent)statContent);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "set_logout_click").put("logout_source", String.valueOf(from)));
            }
        });
    }
}

