/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.base.utils;

import android.os.Bundle;
import android.os.Message;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.NTProductConfig;
import com.yy.base.logger.MLog;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.login.base.LoginGuideDialogCallback;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0002J\u0006\u0010\f\u001a\u00020\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/yy/hiyo/login/base/utils/GuestLoginUtils;", "", "()V", "SP_CHANNEL_SPEAK_COUNT", "", "TAG", "canGuestSpeak", "", "checkAndShowGuide", "type", "", "getSpeakCount", "isSpeakLimit", "showLoginGuide", "", "bundle", "Landroid/os/Bundle;", "callback", "Lcom/yy/hiyo/login/base/LoginGuideDialogCallback;", "login-base_release"})
public final class GuestLoginUtils {
    private static final String TAG = "GuestLoginUtils";
    private static final String SP_CHANNEL_SPEAK_COUNT = "sp_channel_speak_count";
    public static final GuestLoginUtils INSTANCE;

    public final boolean canGuestSpeak() {
        return AccountUtil.getAccountSetting().getInt(SP_CHANNEL_SPEAK_COUNT, 0) < this.getSpeakCount() + 1;
    }

    @JvmStatic
    public static final boolean checkAndShowGuide(int type) {
        if (!AccountUtil.isLoginByGuest()) {
            return false;
        }
        if (type == 20 && INSTANCE.isSpeakLimit()) {
            int count = AccountUtil.getAccountSetting().getInt(SP_CHANNEL_SPEAK_COUNT, 0);
            AccountUtil.getAccountSetting().edit().putInt(SP_CHANNEL_SPEAK_COUNT, ++count).apply();
            return false;
        }
        if (AccountUtil.isLoginByGuest()) {
            Bundle bundle = new Bundle();
            bundle.putInt("type_from_key", type);
            GuestLoginUtils.showLoginGuide(bundle);
            return true;
        }
        return false;
    }

    @JvmStatic
    public static final void showLoginGuide(int type) {
        Bundle bundle = new Bundle();
        bundle.putInt("type_from_key", type);
        GuestLoginUtils.showLoginGuide(bundle);
    }

    @JvmStatic
    public static final void showLoginGuide(@NotNull Bundle bundle) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        MLog.info((Object)TAG, (String)"login guest bundle: %d", (Object[])new Object[]{bundle});
        Message message = new Message();
        message.what = BaseMsgDef.MSG_SHOW_LOGIN_GUIDE_DIALOG;
        message.setData(bundle);
        MsgDispatcher.getInstance().sendMessage(message);
    }

    @JvmStatic
    public static final void showLoginGuide(@NotNull Bundle bundle, @NotNull LoginGuideDialogCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        MLog.info((Object)TAG, (String)"login guest bundle: %d", (Object[])new Object[]{bundle});
        Message message = new Message();
        message.what = BaseMsgDef.MSG_SHOW_LOGIN_GUIDE_DIALOG;
        message.setData(bundle);
        message.obj = callback;
        MsgDispatcher.getInstance().sendMessage(message);
    }

    public final boolean isSpeakLimit() {
        return AccountUtil.getAccountSetting().getInt(SP_CHANNEL_SPEAK_COUNT, 0) < this.getSpeakCount();
    }

    private final int getSpeakCount() {
        NTProductConfig nTProductConfig;
        AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.NT_PRODUCT_CONFIG);
        if (!(aConfigData instanceof NTProductConfig)) {
            aConfigData = null;
        }
        return (nTProductConfig = (NTProductConfig)aConfigData) != null && (nTProductConfig = nTProductConfig.getNtConfig()) != null ? nTProductConfig.getGuestSpeakCount() : 2;
    }

    private GuestLoginUtils() {
    }

    static {
        GuestLoginUtils guestLoginUtils;
        INSTANCE = guestLoginUtils = new GuestLoginUtils();
    }
}

