/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.account;

import android.os.Build;
import com.yy.appbase.abtest.ABTestManager;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.WsStatus;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.login.LoginRequestHelper;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountListManager;
import com.yy.hiyo.login.stat.LoginStatistics;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.ISocketStateChangeListener;
import com.yy.yylite.commonbase.CommonBaseTransfer;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.List;

public class AccountModel {
    private static final String TAG = "AccountModel";
    private static final String KEY_ACCOUNT_UUID = "4c41dd1dcb783cde006fcb9744e11455";
    private static final String KEY_ACCOUNT_SESSION_KEY = "6ab5d4d6bfd4465fba03dd147e1396e9";
    private static final String KEY_ACCOUNT_TOKEN = "f809867cfc1983b3a1c87a84e66ed953";
    private static final String KEY_ACCOUNT_LOGIN_TYPE = "ad881fe8abae3cdff2736e66208d9356";
    private static final String KEY_ACCOUNT_LOCAL_TIMESTAMP = "8f39b35b85cf0026dba472c3e984a7e6";
    private static final String KEY_ACCOUNT_LIFECYCLE = "fbb5f182d5838f153823f706dace4085";
    private static final String KEY_ACCOUNT_REGISTER_COUNTRY = "e2e23441234hu4124141u4wer3ef45er";
    public static final String KEY_ACCOUNT_REAL_COUNTRY = "23432fhuhfi2u327382h3h3r4t5y6u7a";
    private static final String KEY_LAST_ACCOUNT_SESSION_KEY = "last6ab5d4d6bfd4465fba03dd147e1396e9";
    private static final String KEY_LAST_ACCOUNT_UUID = "last4c41dd1dcb783cde006fcb9744e11455";
    private static final String KEY_LAST_ACCOUNT_TOKEN = "lastf809867cfc1983b3a1c87a84e66ed953";
    private static final String KEY_LAST_ACCOUNT_LOGIN_TYPE = "lastad881fe8abae3cdff2736e66208d9356";
    private static final String KEY_LAST_ACCOUNT_LOCAL_TIMESTAMP = "last8f39b35b85cf0026dba472c3e984a7e6";
    private static final String KEY_LAST_ACCOUNT_LIFECYCLE = "lastfbb5f182d5838f153823f706dace4085";
    private static final String KEY_LAST_ACCOUNT_REGISTER_COUNTRY = "laste2e23441234hu4124141u4wer3ef45er";
    private static final String KEY_LAST_ACCOUNT_REAL_COUNTRY = "last23432fhuhfi2u327382h3h3r4t5y6u7a";
    private static final String KEY_NEED_AUTO_RELOGIN_UID_KEY = "needautoreloginuid";
    private static AccountModel sInstance;
    private AccountInfo mAccountInfo = new AccountInfo();
    private AccountListManager mAccountListManager;
    private IQueueTaskExecutor mQueueTaskExecutor;
    private ISocketStateChangeListener mSocketStateChangeListener;
    private IWsTokenInvalidCallBack mWsTokenInvalidCallBack;
    private IWsConnectErrorHandler mWsConnectErrorHandler;
    private boolean mWillLogoutByKickOffOrBanned = false;
    private static int sLastLoginType;

    private AccountModel() {
    }

    public static AccountModel getInstance() {
        return sInstance;
    }

    public void init() {
        this.mAccountInfo.sessionKey = SettingFlags.getStringValue((String)KEY_ACCOUNT_SESSION_KEY, (String)"");
        this.mAccountInfo.token = SettingFlags.getStringValue((String)KEY_ACCOUNT_TOKEN, (String)"");
        this.mAccountInfo.loginType = SettingFlags.getIntValue((String)KEY_ACCOUNT_LOGIN_TYPE, (int)-1);
        this.mAccountInfo.uuid = SettingFlags.getLongValue((String)KEY_ACCOUNT_UUID);
        this.mAccountInfo.localTimestamp = SettingFlags.getLongValue((String)KEY_ACCOUNT_LOCAL_TIMESTAMP);
        this.mAccountInfo.lifecycle = SettingFlags.getLongValue((String)KEY_ACCOUNT_LIFECYCLE);
        this.mAccountInfo.registerCountry = SettingFlags.getStringValue((String)KEY_ACCOUNT_REGISTER_COUNTRY, (String)"");
        this.mAccountInfo.realCountry = SettingFlags.getStringValue((String)KEY_ACCOUNT_REAL_COUNTRY, (String)"");
        this.checkToken();
        this.handleAccountInfoUpdated();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AccountModel.this.mAccountInfo == null) {
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)AccountModel.TAG, (String)"login init:%s type:%d token length:%s", (Object[])new Object[]{String.valueOf(((AccountModel)AccountModel.this).mAccountInfo.uuid), ((AccountModel)AccountModel.this).mAccountInfo.loginType, String.valueOf(((AccountModel)AccountModel.this).mAccountInfo.token != null ? ((AccountModel)AccountModel.this).mAccountInfo.token.length() : 0)});
                }
            }
        }, (long)5000L);
        this.mAccountListManager = new AccountListManager();
        this.updateAccountHistory();
    }

    public void onKickOffNotify() {
        this.mWillLogoutByKickOffOrBanned = true;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onKickOffNotify!", (Object[])new Object[0]);
        }
    }

    public void onBannedNotify() {
        this.mWillLogoutByKickOffOrBanned = true;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onBannedNotify!", (Object[])new Object[0]);
        }
    }

    private void updateAccountHistory() {
        this.mAccountListManager.updateAccount(this.mAccountInfo);
    }

    public AccountInfo getAccountInfo() {
        return this.mAccountInfo;
    }

    public void updateLoginData(AccountInfo info, boolean byLogin) {
        if (info == null || !info.isValid()) {
            return;
        }
        this.setAutoReloginAccountId(-1L);
        if (this.mAccountInfo.lifecycle != info.lifecycle && info.lifecycle > 0L) {
            this.mAccountInfo.lifecycle = info.lifecycle;
            SettingFlags.setLongValue((String)KEY_ACCOUNT_LIFECYCLE, (long)this.mAccountInfo.lifecycle);
        }
        if (this.mAccountInfo.uuid != info.uuid && info.uuid > 0L) {
            this.mAccountInfo.uuid = info.uuid;
            SettingFlags.setLongValue((String)KEY_ACCOUNT_UUID, (long)this.mAccountInfo.uuid);
        }
        if (this.mAccountInfo.localTimestamp != info.localTimestamp) {
            this.mAccountInfo.localTimestamp = info.localTimestamp;
            SettingFlags.setLongValue((String)KEY_ACCOUNT_LOCAL_TIMESTAMP, (long)this.mAccountInfo.localTimestamp);
        }
        if (this.mAccountInfo.loginType != info.loginType && info.loginType != -1) {
            this.mAccountInfo.loginType = info.loginType;
            SettingFlags.setIntValue((String)KEY_ACCOUNT_LOGIN_TYPE, (int)this.mAccountInfo.loginType);
        }
        if (StringUtils.isNotEmpty((String)info.token) && !StringUtils.equals((String)this.mAccountInfo.token, (String)info.token)) {
            this.mAccountInfo.token = info.token;
            SettingFlags.setStringValue((String)KEY_ACCOUNT_TOKEN, (String)this.mAccountInfo.token);
        }
        if (StringUtils.isNotEmpty((String)info.sessionKey) && !StringUtils.equals((String)this.mAccountInfo.sessionKey, (String)info.sessionKey)) {
            this.mAccountInfo.sessionKey = info.sessionKey;
            SettingFlags.setStringValue((String)KEY_ACCOUNT_SESSION_KEY, (String)this.mAccountInfo.sessionKey);
        }
        if (this.mAccountInfo.resultType != info.resultType) {
            this.mAccountInfo.resultType = info.resultType;
        }
        if (StringUtils.isNotEmpty((String)info.registerCountry) && !StringUtils.equals((String)this.mAccountInfo.registerCountry, (String)info.registerCountry)) {
            this.mAccountInfo.registerCountry = info.registerCountry;
            SettingFlags.setStringValue((String)KEY_ACCOUNT_REGISTER_COUNTRY, (String)this.mAccountInfo.registerCountry);
        }
        if (StringUtils.isNotEmpty((String)info.realCountry) && !StringUtils.equals((String)this.mAccountInfo.realCountry, (String)info.realCountry)) {
            this.mAccountInfo.realCountry = info.realCountry;
            SettingFlags.setStringValue((String)KEY_ACCOUNT_REAL_COUNTRY, (String)this.mAccountInfo.realCountry);
        }
        this.handleAccountInfoUpdated();
        ABTestManager.getInstance().setUid(this.mAccountInfo.uuid);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"login update:%s type:%d token length:%s lifecycle:%d", (Object[])new Object[]{String.valueOf(this.mAccountInfo.uuid), this.mAccountInfo.loginType, String.valueOf(this.mAccountInfo.token != null ? this.mAccountInfo.token.length() : 0), (int)this.mAccountInfo.lifecycle});
        }
        if (byLogin) {
            this.mAccountListManager.addAccount(this.mAccountInfo);
        } else {
            this.mAccountListManager.updateAccount(this.mAccountInfo);
        }
    }

    private void setLastAccount(AccountInfo accountInfo) {
        if (accountInfo == null) {
            return;
        }
        sLastLoginType = accountInfo.loginType;
        SettingFlags.setLongValue((String)KEY_LAST_ACCOUNT_LIFECYCLE, (long)accountInfo.lifecycle);
        SettingFlags.setStringValue((String)KEY_LAST_ACCOUNT_SESSION_KEY, (String)accountInfo.sessionKey);
        SettingFlags.setLongValue((String)KEY_LAST_ACCOUNT_UUID, (long)accountInfo.uuid);
        SettingFlags.setLongValue((String)KEY_LAST_ACCOUNT_LOCAL_TIMESTAMP, (long)accountInfo.localTimestamp);
        SettingFlags.setIntValue((String)KEY_LAST_ACCOUNT_LOGIN_TYPE, (int)accountInfo.loginType);
        SettingFlags.setStringValue((String)KEY_LAST_ACCOUNT_TOKEN, (String)accountInfo.token);
        SettingFlags.setStringValue((String)KEY_LAST_ACCOUNT_REGISTER_COUNTRY, (String)accountInfo.registerCountry);
        SettingFlags.setStringValue((String)KEY_LAST_ACCOUNT_REAL_COUNTRY, (String)accountInfo.realCountry);
    }

    public void loginOut() {
        this.mWillLogoutByKickOffOrBanned = false;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AccountModel.this.mSocketStateChangeListener != null) {
                    ProtoManager.getInstance().removeSocketStateChangeListener(AccountModel.this.mSocketStateChangeListener);
                }
            }
        });
        ProtoManager.sNeedCheckToken = false;
        long oldUUID = this.mAccountInfo.uuid;
        if (oldUUID > 0L) {
            this.setLastAccount(this.mAccountInfo);
        }
        this.mAccountInfo.lifecycle = -1L;
        this.mAccountInfo.uuid = -1L;
        this.mAccountInfo.localTimestamp = -1L;
        this.mAccountInfo.loginType = -1;
        this.mAccountInfo.token = "";
        this.mAccountInfo.sessionKey = "";
        this.mAccountInfo.registerCountry = "";
        this.mAccountInfo.realCountry = "";
        this.mAccountInfo.resultType = -1;
        SettingFlags.setLongValue((String)KEY_ACCOUNT_LIFECYCLE, (long)this.mAccountInfo.lifecycle);
        SettingFlags.setLongValue((String)KEY_ACCOUNT_UUID, (long)this.mAccountInfo.uuid);
        SettingFlags.setLongValue((String)KEY_ACCOUNT_LOCAL_TIMESTAMP, (long)this.mAccountInfo.localTimestamp);
        SettingFlags.setIntValue((String)KEY_ACCOUNT_LOGIN_TYPE, (int)this.mAccountInfo.loginType);
        SettingFlags.setStringValue((String)KEY_ACCOUNT_TOKEN, (String)this.mAccountInfo.token);
        SettingFlags.setStringValue((String)KEY_ACCOUNT_SESSION_KEY, (String)this.mAccountInfo.sessionKey);
        SettingFlags.setStringValue((String)KEY_ACCOUNT_REGISTER_COUNTRY, (String)this.mAccountInfo.registerCountry);
        SettingFlags.setStringValue((String)KEY_ACCOUNT_REAL_COUNTRY, (String)this.mAccountInfo.realCountry);
        this.handleAccountInfoUpdated();
        ABTestManager.getInstance().setUid(this.mAccountInfo.uuid);
        this.clearGameSdkCache();
        LoginRequestHelper.onLogout();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"login out %s", (Object[])new Object[]{String.valueOf(oldUUID)});
        }
    }

    private void handleAccountInfoUpdated() {
        if (this.mAccountInfo.token != null) {
            CommonHttpHeader.setAuthToken((String)this.mAccountInfo.token);
        }
        AccountUtil.setLoginType((int)this.mAccountInfo.loginType);
        AccountUtil.setResultType((int)this.mAccountInfo.resultType);
        AccountUtil.updateUid((long)this.mAccountInfo.uuid);
        AccountUtil.setNewRegister((boolean)this.mAccountInfo.isNewRegister());
        AccountUtil.setRegisterCountry((String)this.mAccountInfo.registerCountry);
        AccountUtil.upDateLastLoginTime();
        AccountUtil.setRealCountry((String)this.mAccountInfo.realCountry);
        if (SettingFlags.getBoolean((String)"countryusehago", (boolean)true)) {
            SystemUtils.setHagoCountry((String)AccountUtil.realCountry());
        }
        CommonHttpHeader.setCountryCode();
        if (RuntimeContext.sIsMainProcess) {
            if (this.mQueueTaskExecutor == null) {
                this.mQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
            }
            final long uuid = this.mAccountInfo.uuid;
            final String token = this.mAccountInfo.token;
            this.mQueueTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ProtoManager.getInstance().setCurToken(uuid, token);
                    if (AccountModel.this.mSocketStateChangeListener == null) {
                        AccountModel.this.mSocketStateChangeListener = new ISocketStateChangeListener(){

                            public void onSocketStateChanged(final int code, final String wsUrl, final String errorInfo) {
                                if (AccountUtil.getUid() != ProtoManager.getInstance().getCurWSUid()) {
                                    return;
                                }
                                if (YYTaskExecutor.isMainThread()) {
                                    AccountModel.this.onSocketStateChanged(code, wsUrl, errorInfo);
                                } else {
                                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            AccountModel.this.onSocketStateChanged(code, wsUrl, errorInfo);
                                        }
                                    });
                                }
                            }
                        };
                    }
                    ProtoManager.getInstance().addSocketStateChangeListener(AccountModel.this.mSocketStateChangeListener);
                }
            }, 0L);
        }
        CommonBaseTransfer.onUpdateAccount((long)this.mAccountInfo.uuid, (String)this.mAccountInfo.token);
        YYTaskExecutor.postToMainThread(this::reportLoginAbTest, (long)5000L);
        if (this.mAccountInfo.uuid > 0L && StringUtils.isEmpty((String)this.mAccountInfo.token)) {
            throw new RuntimeException("token is empty!");
        }
    }

    public void setWsTokenInvalidCallBack(IWsTokenInvalidCallBack callBack) {
        this.mWsTokenInvalidCallBack = callBack;
    }

    public void setWsConnectErrorHandler(IWsConnectErrorHandler handler) {
        this.mWsConnectErrorHandler = handler;
    }

    private void onSocketStateChanged(final int code, String wsUrl, String errorInfo) {
        if (code == 1000 || code == -1 || code == 103 || code == 102) {
            return;
        }
        WsStatus status = ProtoManager.getInstance().getWsStatus();
        if (status != WsStatus.CONNECT_FAIL) {
            return;
        }
        if (AccountUtil.getUid() <= 0L || this.mAccountInfo == null || AccountUtil.getUid() != ProtoManager.getInstance().getCurWSUid()) {
            return;
        }
        if (!StringUtils.equal((String)wsUrl, (String)ProtoManager.getInstance().getCurWSURL())) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onSocketStateChanged code: %d, wsUrl: %s", (Object[])new Object[]{code, wsUrl});
        }
        boolean wsTokenProtect = SettingFlags.getBoolean((String)"wsTokenProtectNew", (boolean)true);
        boolean loginOut = false;
        if (wsTokenProtect) {
            if (code == 4101) {
                loginOut = true;
            } else if (!(code != 4002 && code != 4000 && code != 4004 || this.mWillLogoutByKickOffOrBanned)) {
                loginOut = true;
            } else if (code == 4010) {
                loginOut = true;
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"login out by code: %d", (Object[])new Object[]{code});
            }
        }
        if (loginOut) {
            final long curUid = AccountUtil.getUid();
            if (this.mWsConnectErrorHandler == null || !this.mWsConnectErrorHandler.onCurWsConnectError(code)) {
                if (code != 4004) {
                    this.deleteHasLoginedAccount(AccountUtil.getUid());
                }
                if (this.mWsTokenInvalidCallBack != null) {
                    this.mWsTokenInvalidCallBack.onWsTokenInvalid(AccountUtil.getUid(), code);
                } else {
                    this.loginOut();
                    if (code != 4004) {
                        this.setAutoReloginAccountId(-1L);
                    } else {
                        this.setAutoReloginAccountId(curUid);
                    }
                    if (code == 4010 && EnvSettings.instance().getUriSettingValue() == EnvSettingType.Test) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (AccountModel.this.mWsTokenInvalidCallBack != null && AccountUtil.getUid() <= 0L) {
                                    AccountModel.this.mWsTokenInvalidCallBack.onWsTokenInvalid(curUid, code);
                                }
                            }
                        }, (long)1500L);
                    }
                }
            }
        }
        if (SettingFlagBaseKeys.isNormalMetricSwitchOn()) {
            String token = this.mAccountInfo.token;
            long lifeCycle = this.mAccountInfo.lifecycle;
            long localTimestamp = this.mAccountInfo.localTimestamp;
            StatisContent statContent = new StatisContent();
            statContent.put("act", "hagoperf");
            statContent.put("ifield", code);
            statContent.put("ifieldtwo", RuntimeContext.getRunTimes());
            statContent.put("ifieldthree", loginOut ? 1 : 0);
            statContent.put("sfield", token);
            statContent.put("sfieldtwo", String.valueOf(lifeCycle));
            statContent.put("sfieldthree", String.valueOf(localTimestamp));
            if (HardwareUtils.isSimulator()) {
                statContent.put("sfieldfive", Build.MODEL);
            }
            statContent.put("perftype", "wstokeninvalid");
            HiidoStatis.reportContent((StatisContent)statContent);
        }
    }

    public void onMainActivityStarted() {
    }

    public void setAutoReloginAccountId(long uid) {
        SettingFlags.setLongValue((String)KEY_NEED_AUTO_RELOGIN_UID_KEY, (long)uid);
    }

    public long getAutoReloginAccountId() {
        return SettingFlags.getLongValue((String)KEY_NEED_AUTO_RELOGIN_UID_KEY, (long)-1L);
    }

    private void checkToken() {
        if (this.mAccountInfo.uuid > 0L && StringUtils.isEmpty((String)this.mAccountInfo.token)) {
            this.loginOutByTokenInfoEmpty(this.mAccountInfo.uuid);
            return;
        }
        if (StringUtils.isNotEmpty((String)this.mAccountInfo.token) && this.mAccountInfo.localTimestamp > 0L && this.mAccountInfo.lifecycle > 0L) {
            long curTime = System.currentTimeMillis();
            if (curTime > 0L) {
                if (this.mAccountInfo.localTimestamp + this.mAccountInfo.lifecycle * 60L * 1000L < curTime) {
                    this.loginOutByLifecycle((int)this.mAccountInfo.lifecycle);
                } else if (curTime < this.mAccountInfo.localTimestamp - this.mAccountInfo.lifecycle * 60L * 1000L) {
                    this.loginOutByLifecycle((int)this.mAccountInfo.lifecycle);
                }
            } else if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("checkToken curTime invalid " + String.valueOf(curTime)), (Object[])new Object[0]);
            }
        }
    }

    private void loginOutByLifecycle(final int lifeCycle) {
        long uid;
        long l = uid = this.mAccountInfo != null ? this.mAccountInfo.uuid : -1L;
        if (uid > 0L) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    LoginStatistics.statLoginOutEvent(uid, 6);
                }
            }, (long)10000L);
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)AccountModel.TAG, (String)"oginOutByLifecycle %d", (Object[])new Object[]{lifeCycle});
                }
            }
        }, (long)4000L);
        this.loginOut();
    }

    private void loginOutByTokenInfoEmpty(final long uid) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                LoginStatistics.statLoginOutEvent(uid, 7);
            }
        }, (long)10000L);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)AccountModel.TAG, (String)"loginOutByTokenInfoEmpty", (Object[])new Object[0]);
                }
            }
        }, (long)4000L);
        this.loginOut();
    }

    public static int hasLoginedBefore() {
        if (sLastLoginType == -1) {
            long lastUid = SettingFlags.getLongValue((String)KEY_LAST_ACCOUNT_UUID);
            if (lastUid > 0L) {
                sLastLoginType = SettingFlags.getIntValue((String)KEY_LAST_ACCOUNT_LOGIN_TYPE);
            } else {
                return -1;
            }
        }
        return sLastLoginType;
    }

    public void getAccountsHasLogined(AccountListManager.IObtainCallBack callBack) {
        this.mAccountListManager.getAccounts(callBack);
    }

    public void deleteHasLoginedAccount(long uid) {
        this.mAccountListManager.deleteAccount(uid);
    }

    public void updateLoginedAccountUserInfo(List<UserInfoBean> userInfo) {
        this.mAccountListManager.updateLoginedAccountUserInfo(userInfo);
    }

    public boolean isAccountValidIncludeToken(AccountInfo accountInfo) {
        if (accountInfo == null || !accountInfo.isValid()) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)accountInfo.token) && accountInfo.localTimestamp > 0L && accountInfo.lifecycle > 0L) {
            long curTime = System.currentTimeMillis();
            if (curTime > 0L) {
                if (accountInfo.localTimestamp + accountInfo.lifecycle * 60L * 1000L < curTime) {
                    return false;
                }
                return curTime >= accountInfo.localTimestamp - accountInfo.lifecycle * 60L * 1000L;
            }
            return true;
        }
        return false;
    }

    private void reportLoginAbTest() {
        HiidoStatis.putAbTestFlag((String)"login", (String)(AccountUtil.isLoginByGuest() ? "B" : "A"));
    }

    public void onEnvChanged() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onEnvChanged", (Object[])new Object[0]);
        }
        this.setLastAccount(new AccountInfo());
        this.mAccountListManager.clear();
        this.clearGameSdkCache();
    }

    private void clearGameSdkCache() {
        RuntimeContext.sApplicationContext.getSharedPreferences("game_sdk_shared_pref", 0).edit().clear().commit();
    }

    public boolean isAccountIn() {
        if (this.getAccountInfo() != null && "in".equals(this.getAccountInfo().registerCountry)) {
            if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"\u7528\u6237\u7684\u6ce8\u518c\u56fd\u5bb6\u662f\u5370\u5ea6", (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    static {
        sLastLoginType = -1;
        sInstance = new AccountModel();
    }

    public static interface IWsConnectErrorHandler {
        public boolean onCurWsConnectError(int var1);
    }

    public static interface IWsTokenInvalidCallBack {
        public void onWsTokenInvalid(long var1, int var3);
    }
}

