/*
 * Decompiled with CFR 0.152.
 */
package com.yy.location;

import android.annotation.SuppressLint;
import android.os.Build;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.location.ILocationChangedListener;
import com.yy.location.ILocationServiceFactory;
import com.yy.location.LocationAbnormalCallback;
import com.yy.location.LocationInfo;
import com.yy.location.LocationUtils;
import com.yy.location.inner.LocationHandler;

public class LocationHelper {
    private static final String TAG = "LocationHelper";
    private static final long LOCATION_TIME_INTVAL = 1800000L;
    private static volatile IPermissionHandler sPermissionHandler;
    private static long mLastLocationTime;
    private static LocationHandler mLocationHandler;
    private static ILocationServiceFactory sLocationFactory;

    public static void setLocationFactory(ILocationServiceFactory factory) {
        sLocationFactory = factory;
    }

    public static void setPermissionHandler(IPermissionHandler permissionHandler) {
        sPermissionHandler = permissionHandler;
    }

    public static void location() {
        if (sPermissionHandler != null) {
            sPermissionHandler.requestPermission(new IPermissionCallBack(){

                @Override
                public void onDenied() {
                    MLog.info((Object)LocationHelper.TAG, (String)"location permission is not valid", (Object[])new Object[0]);
                    if (LocationHelper.getLocationHandler() != null) {
                        LocationHelper.getLocationHandler().clearCache();
                    }
                }

                @Override
                public void onGrented() {
                    long curTiem = System.currentTimeMillis();
                    MLog.info((Object)LocationHelper.TAG, (String)"location permission is valid mLastLocationTime: %s, curTiem: %s", (Object[])new Object[]{mLastLocationTime, curTiem});
                    if (mLastLocationTime <= 0L || curTiem - mLastLocationTime >= 1800000L) {
                        mLastLocationTime = curTiem;
                        YYTaskExecutor.execute((Runnable)new Runnable(){

                            @Override
                            @SuppressLint(value={"MissingPermission"})
                            public void run() {
                                if (LocationHelper.getLocationHandler() != null) {
                                    LocationHelper.getLocationHandler().initAndStart();
                                }
                            }
                        });
                    } else if (LocationHelper.getLocationHandler() != null) {
                        LocationHelper.getLocationHandler().notifyCacheLocation();
                    }
                }
            });
        }
    }

    public static void wemeetLocation() {
        if (sPermissionHandler != null) {
            sPermissionHandler.requestPermission(new IPermissionCallBack(){

                @Override
                public void onDenied() {
                    if (LocationHelper.getLocationHandler() != null) {
                        LocationHelper.getLocationHandler().clearCache();
                    }
                }

                @Override
                public void onGrented() {
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        @SuppressLint(value={"MissingPermission"})
                        public void run() {
                            if (LocationHelper.getLocationHandler() != null) {
                                LocationHelper.getLocationHandler().initAndStart();
                            }
                        }
                    });
                }
            });
        }
    }

    public static boolean checkLocationPermission() {
        if (sPermissionHandler != null) {
            boolean isLocation = sPermissionHandler.checkPermission();
            if (Build.VERSION.SDK_INT >= 23 && !isLocation && LocationHelper.getLocationHandler() != null) {
                LocationHelper.getLocationHandler().clearCache();
            }
            return isLocation;
        }
        boolean isOpen = LocationUtils.checkLocationPermission(RuntimeContext.sApplicationContext);
        boolean fail = true;
        if (LocationHelper.getLocationHandler() != null) {
            fail = LocationHelper.getLocationHandler().isLocationFailed();
        }
        return isOpen && !fail;
    }

    @Nullable
    public static LocationInfo getLocationInfo(boolean lastCache) {
        if (LocationHelper.getLocationHandler() != null) {
            return LocationHelper.getLocationHandler().getLocationInfo(lastCache);
        }
        return null;
    }

    public static void addLocationListener(ILocationChangedListener listener) {
        if (LocationHelper.getLocationHandler() != null) {
            LocationHelper.getLocationHandler().addLocationListener(listener);
        }
    }

    public static void removeLocationListener(ILocationChangedListener listener) {
        if (LocationHelper.getLocationHandler() != null) {
            LocationHelper.getLocationHandler().removeLocationListener(listener);
        }
    }

    public static void setAbnormalCallback(LocationAbnormalCallback abnormalCallback) {
        if (LocationHelper.getLocationHandler() != null) {
            LocationHelper.getLocationHandler().setAbnormalCallback(abnormalCallback);
        }
    }

    @Nullable
    private static LocationHandler getLocationHandler() {
        if (mLocationHandler == null && sLocationFactory != null) {
            mLocationHandler = new LocationHandler(RuntimeContext.sApplicationContext, sLocationFactory);
        }
        return mLocationHandler;
    }

    public static interface IPermissionHandler {
        public boolean checkPermission();

        public void requestPermission(IPermissionCallBack var1);
    }

    public static interface IPermissionCallBack {
        public void onDenied();

        public void onGrented();
    }
}

