/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.songlist;

import android.content.Context;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVCommonPresenter;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVProtoCallback;
import com.yy.hiyo.channel.plugins.ktv.list.songlist.IKTVSongListOperator;
import com.yy.hiyo.channel.plugins.ktv.list.songlist.KTVSongListContract;
import com.yy.hiyo.channel.plugins.ktv.list.songlist.KTVSongListPanel;
import com.yy.hiyo.channel.plugins.ktv.model.room.KTVRoomServices;
import com.yy.hiyo.channel.plugins.ktv.service.KTVProtoService;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import java.util.ArrayList;
import java.util.List;
import net.ihago.ktv.api.biz.KaraokeSongDragSortRes;
import org.jetbrains.annotations.NotNull;

public class KTVSongListPresenter
extends KTVCommonPresenter
implements KTVSongListContract.Presenter {
    public static final String TAG = "KTVSongListPresenter";
    private PanelLayer mLayer;
    private KTVSongListOperator mOperator;
    public KTVSongListContract.View mView;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public KTVSongListPresenter(PanelLayer layer, @NonNull IKTVHandler iktvHandle) {
        super(iktvHandle);
        this.mLayer = layer;
        this.mOperator = new KTVSongListOperator();
    }

    @KvoMethodAnnotation(name="mKTVRoomSongInfoList", sourceClass=KTVRoomServices.class)
    public void onSongListChanged(KvoEventIntent data) {
        List<KTVRoomSongInfo> originalList = ((KTVRoomServices)data.source()).getKTVRoomSongInfoList();
        FeatureLog.i((String)"FTKTVList_KTVSongListPresenter", (String)"onSongListChanged, size = %s", (Object[])new Object[]{originalList == null ? 0 : originalList.size()});
        final ArrayList<KTVRoomSongInfo> list = new ArrayList<KTVRoomSongInfo>();
        for (int i = 0; i < originalList.size(); ++i) {
            KTVRoomSongInfo songInfo = originalList.get(i);
            songInfo.setPosition(i);
            songInfo = KTVRoomSongInfo.clone((KTVRoomSongInfo)songInfo);
            list.add(songInfo);
        }
        if (YYTaskExecutor.isMainThread()) {
            if (this.mView != null) {
                this.mView.updateSongList(list);
            }
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (KTVSongListPresenter.this.mView != null) {
                        KTVSongListPresenter.this.mView.updateSongList(list);
                    }
                }
            });
        }
    }

    @Override
    public void onKTVDestroy() {
        super.onKTVDestroy();
        this.mBinder.clearAllKvoConnections();
        this.mView = null;
        this.mLayer = null;
    }

    public void start() {
        FeatureLog.i((String)"FTKTVList_KTVSongListPresenter", (String)"start", (Object[])new Object[0]);
        this.mBinder.singleBindSourceTo((KvoSource)((KTVRoomServices)this.getHandler().getKTVManager().getKTVRoomServices()));
    }

    @Override
    public void stop() {
        FeatureLog.i((String)"FTKTVList_KTVSongListPresenter", (String)"stop", (Object[])new Object[0]);
        this.mBinder.clearKvoConnection(KTVRoomServices.class.getName());
    }

    @Override
    public void openSongLibrary() {
        if (this.mView != null) {
            this.mView.hide();
        }
        this.getHandler().getKTVOperateProvider().getIKTVMusicLibraryOperator().showMusicLibrary();
    }

    @Override
    public void deleteSong(KTVRoomSongInfo songInfo) {
        FeatureLog.i((String)"FTKTVList", (String)"deleteSong, songInfo : %s", (Object[])new Object[]{songInfo});
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            return;
        }
        if (songInfo != null) {
            this.getHandler().getKTVManager().getKTVRoomServices().deleteSong(songInfo.getSongId(), null);
            if (this.getHandler().getmRoomDataContainer().getRoomInfo().getOwnerId() == AccountUtil.getUid() && songInfo.getUid() == AccountUtil.getUid()) {
                KTVEventReportUtil.reportSongListDelClick("1&2");
            }
            if (this.getHandler().getmRoomDataContainer().getRoomInfo().getOwnerId() == AccountUtil.getUid() && songInfo.getUid() != AccountUtil.getUid()) {
                KTVEventReportUtil.reportSongListDelClick("1");
            }
            if (this.getHandler().getmRoomDataContainer().getRoomInfo().getOwnerId() != AccountUtil.getUid() && songInfo.getUid() == AccountUtil.getUid()) {
                KTVEventReportUtil.reportSongListDelClick("2");
            }
        }
    }

    @Override
    public void setTopSong(KTVRoomSongInfo songInfo) {
        FeatureLog.i((String)"FTKTVList", (String)"setTopSong, songInfo : %s", (Object[])new Object[]{songInfo});
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            return;
        }
        if (songInfo != null) {
            this.getHandler().getKTVManager().getKTVRoomServices().setSongTop(songInfo.getSongId(), null);
        }
    }

    @Override
    public boolean isKTVPlayManager() {
        return this.getHandler().getmRoomDataContainer().isKTVPlayManager(AccountUtil.getUid());
    }

    @Override
    public void uploadSongDragSort(String preSongId, String targetSongId) {
        KTVProtoService.getInstance().uploadSongDragSort(this.getHandler().getmRoomDataContainer().getRoomId(), preSongId, targetSongId, new IKTVProtoCallback<KaraokeSongDragSortRes>(){

            @Override
            public void onSuccess(@NonNull @NotNull KaraokeSongDragSortRes data) {
            }

            @Override
            public void onError(int code, String errorMessage) {
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.ktv_sort_song_error, (int)0);
            }
        });
    }

    public IKTVSongListOperator getContract() {
        return this.mOperator;
    }

    public class KTVSongListOperator
    implements IKTVSongListOperator {
        private Boolean isKTVPlayManager = null;

        @Override
        public void showSongListPanel() {
            if (KTVSongListPresenter.this.mView == null) {
                KTVSongListPresenter.this.mView = new KTVSongListPanel(KTVSongListPresenter.this.mLayer, KTVSongListPresenter.this.getHandler());
                KTVSongListPresenter.this.mView.setPresenter(KTVSongListPresenter.this);
            }
            KTVSongListPresenter.this.mView.show();
            if (this.isKTVPlayManager != null && !this.isKTVPlayManager.equals(KTVSongListPresenter.this.getHandler().getmRoomDataContainer().isKTVPlayManager(AccountUtil.getUid()))) {
                KTVSongListPresenter.this.mView.notifyDataSetChanged();
            }
            this.isKTVPlayManager = KTVSongListPresenter.this.getHandler().getmRoomDataContainer().isKTVPlayManager(AccountUtil.getUid());
        }
    }
}

