/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.panel;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Observer;
import com.yy.appbase.ablum_select.mulitablumselect.internal.entity.BasicMediaInfo;
import com.yy.appbase.ablum_select.mulitablumselect.internal.entity.RecordVideoInfo;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.DefaultCommonCallBack;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.common.BiCallback;
import com.yy.appbase.common.Callback;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.safelivedata.SafeLiveData;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.hiyo.bbs.base.BBSBaseTrack;
import com.yy.hiyo.bbs.base.bean.postinfo.BasePostInfo;
import com.yy.hiyo.bbs.base.bean.postinfo.CommonPostItemInfo;
import com.yy.hiyo.bbs.base.bean.sectioninfo.IVideoSectionPost;
import com.yy.hiyo.bbs.base.bean.sectioninfo.KtvSectionInfo;
import com.yy.hiyo.bbs.base.bean.sectioninfo.VideoSectionInfo;
import com.yy.hiyo.camera.base.ICameraService;
import com.yy.hiyo.camera.base.ablum_select.listener.OnCameraPathListCallback;
import com.yy.hiyo.channel.ChannelBaseMsgDef;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.KTVPlayerInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.base.service.IKtvAudioEffectService;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.intercepter.ISeatIntercepter;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.model.bean.RoomInfo;
import com.yy.hiyo.channel.cbase.module.common.KtvRoomModel;
import com.yy.hiyo.channel.cbase.module.ktv.KTVCommonCallback;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomData;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomOperateInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.cbase.module.ktv.live.IKtvLivePresenter;
import com.yy.hiyo.channel.cbase.module.ktv.live.IKtvPlayContract;
import com.yy.hiyo.channel.cbase.module.ktv.room.IKTVNotifyHandler;
import com.yy.hiyo.channel.cbase.module.radio.beauty.BeautyPresenter;
import com.yy.hiyo.channel.cbase.module.radio.beauty.IBeautyView;
import com.yy.hiyo.channel.cbase.module.radio.beauty.IOrangeFilterView;
import com.yy.hiyo.channel.cbase.module.radio.beauty.OrangeFilterPresenter;
import com.yy.hiyo.channel.cbase.module.radio.config.LiveConfigPresenter;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenPresenter;
import com.yy.hiyo.channel.cbase.tools.IRevenueToolsModulePresenter;
import com.yy.hiyo.channel.cbase.utils.preference.RoomSetting;
import com.yy.hiyo.channel.component.profile.profilecard.base.ProfileCardPresenter;
import com.yy.hiyo.channel.component.theme.ThemePresenter;
import com.yy.hiyo.channel.plugins.ktv.IUICallback;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.beauty.KtvBeautyPanel;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVManager;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseContext;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVCommonPresenter;
import com.yy.hiyo.channel.plugins.ktv.common.bean.KTVControlInfo;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVPanelUICallback;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVQueryCallback;
import com.yy.hiyo.channel.plugins.ktv.live.KtvLivePresenter;
import com.yy.hiyo.channel.plugins.ktv.live.KtvPlayPresenter;
import com.yy.hiyo.channel.plugins.ktv.model.downloader.IKTVdownloadCallback;
import com.yy.hiyo.channel.plugins.ktv.model.player.IKTVPlayerCallback;
import com.yy.hiyo.channel.plugins.ktv.model.record.IKTVRecorder;
import com.yy.hiyo.channel.plugins.ktv.model.record.KTVPostUtils;
import com.yy.hiyo.channel.plugins.ktv.model.record.KTVRecorder;
import com.yy.hiyo.channel.plugins.ktv.model.record.KTVWorksUtils;
import com.yy.hiyo.channel.plugins.ktv.model.record.RecordCompleteDialog;
import com.yy.hiyo.channel.plugins.ktv.panel.IControlInfoCallBack;
import com.yy.hiyo.channel.plugins.ktv.panel.IKTVPanelListener;
import com.yy.hiyo.channel.plugins.ktv.panel.IKTVPanelOperater;
import com.yy.hiyo.channel.plugins.ktv.panel.ISvgaAnimListener;
import com.yy.hiyo.channel.plugins.ktv.panel.KTVPanelContract;
import com.yy.hiyo.channel.plugins.ktv.panel.KTVPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.VirtualSeatHelper;
import com.yy.hiyo.channel.plugins.ktv.panel.utils.KTVDataReportHelper;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVAudioSettingPanelView;
import com.yy.hiyo.channel.plugins.ktv.seat.KTVSeatPresenter;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.user.base.profilecard.OpenProfileFrom;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.param.GiftUserInfo;
import com.yy.hiyo.wallet.base.revenue.gift.param.ShowGiftPanelParam;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.ihago.bbs.srv.mgr.ECode;
import net.ihago.ktv.api.biz.SwitchAVModeReq;
import org.jetbrains.annotations.NotNull;

public class KTVPanelPresenter
extends KTVCommonPresenter
implements KTVPanelContract.Presenter,
IKTVPanelUICallback,
IKTVPlayerCallback,
KTVRecorder.IKtvRecordListener {
    private static final String TAG = "KTVPanelPresenter";
    private final PanelLayer panelLayer;
    private YYFrameLayout container;
    private KTVPanelView mView;
    private IKtvLivePresenter mKtvLivePresenter;
    private IKtvPlayContract.IKtvPlayPresenter mKtvPlayPresenter;
    private IUICallback mUICallback;
    private KtvBeautyPanel mBeautyPanel;
    private OrangeFilterPresenter mFilterPresenter;
    private BeautyPresenter mBeautyPresenter;
    private KTVAudioSettingPanelView mKtvSettingPanelView;
    private boolean mIsOwnerOrMaster;
    private String mCurrentNeedPlaySongId = "";
    private String mLastReportSongId = "";
    private boolean mCameraOpen = false;
    private String mCurrentAudioPath;
    private KTVRoomSongInfo mCurrentSongInfo;
    private List<String> mSavingAudioPathList;
    private int retryPublishTimes = 0;
    private int mBeautyLevel = -1;
    private int mCurrentEffectId = 0;
    private IKTVNotifyHandler<KTVRoomOperateInfo> mTerminateSongNotify = this::handleTerminateSongNotify;
    private RecordCompleteDialog dialog;
    private KTVMusicInfo mKtvMusicInfo;
    private final SafeLiveData<KTVControlInfo> mControlData = SafeLiveData.Companion.of((Object)new KTVControlInfo());
    private VirtualSeatHelper mVirtualSeatHelper;
    private OnCameraPathListCallback mRecordCallback = new OnCameraPathListCallback(){

        public void onPatchPathBack(@NotNull List<String> paths) {
        }

        public void onPatchInfoBack(@NotNull List<BasicMediaInfo> infos) {
        }

        public void onPermissionDeny() {
            ((ICameraService)ServiceManagerProxy.getInstance().getService(ICameraService.class)).cleanCallback();
        }

        public void onRecordVideoPath(@NotNull RecordVideoInfo msg) {
            MLog.info((Object)KTVPanelPresenter.TAG, (String)("recordFinish and " + msg), (Object[])new Object[0]);
            if (KTVPanelPresenter.this.dialog != null && KTVPanelPresenter.this.dialog.isShowing()) {
                try {
                    KTVPanelPresenter.this.dialog.dismiss();
                    KTVPanelPresenter.this.dialog = null;
                }
                catch (Exception e) {
                    e.getMessage();
                }
            }
            ((ICameraService)ServiceManagerProxy.getInstance().getService(ICameraService.class)).cleanCallback();
            KTVWorksUtils.INSTANCE.shareToVideoBBS(msg, KTVPanelPresenter.this.mKtvMusicInfo, new BiCallback<BasePostInfo, Integer>(){

                public void onSuccess(BasePostInfo data) {
                    KTVPanelPresenter.this.sendPublicScreenByVideoMsg(data, KTVPanelPresenter.this.mKtvMusicInfo);
                }

                public void onError(Integer error) {
                }
            });
        }

        public void onGallarySelect(int size) {
        }

        public void onFinish(String path) {
        }

        public void onBackPress() {
            ((ICameraService)ServiceManagerProxy.getInstance().getService(ICameraService.class)).cleanCallback();
            MLog.info((Object)KTVPanelPresenter.TAG, (String)"onBackPress====", (Object[])new Object[0]);
            KTVPanelPresenter.this.showShareDialog();
        }

        public void onAlbumSelectVideo(@NotNull RecordVideoInfo msg) {
        }
    };
    IKTVdownloadCallback iktVdownloadCallback = new IKTVdownloadCallback(){

        @Override
        public void onSuccess(KTVMusicInfo songInfo, String type, String filePath) {
            int currentSongInfoStatus;
            if (songInfo == null) {
                return;
            }
            KTVRoomData currentKTVRoomData = KTVPanelPresenter.this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
            if (currentKTVRoomData == null) {
                return;
            }
            KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
            if (currentSongInfo == null) {
                return;
            }
            if (KTVPanelPresenter.this.mCurrentNeedPlaySongId.equals(songInfo.getSongId()) && type.equals("Instrumental") && currentSongInfo.getUid() == AccountUtil.getUid()) {
                FeatureLog.i((String)"FTKTVPanel", (String)"download music success,start play uid: %s", (Object[])new Object[]{currentSongInfo.getUid()});
                if (KTVPanelPresenter.this.getHandler().getKTVManager().getKTVDownloader().checkInstrumentalVaild(songInfo) == 2) {
                    KTVPanelPresenter.this.getHandler().getKTVManager().getKTVPlayer().play(KTVPanelPresenter.this.mCurrentNeedPlaySongId, KTVPanelPresenter.this);
                } else {
                    KTVPanelPresenter.this.onPlayFailed(songInfo.getSongId());
                }
            }
            if (StringUtils.isNotEmpty((String)currentSongInfo.getResourceId()) && currentSongInfo.getResourceId().equals(songInfo.getSongId()) && type.equals("lyric") && ((currentSongInfoStatus = currentSongInfo.getStatus()) == 1 || currentSongInfoStatus == 2) && KTVPanelPresenter.this.mView != null) {
                FeatureLog.i((String)"FTKTVPanel", (String)"download mOriginSinger lyric success,start load lyric uid: %s", (Object[])new Object[]{currentSongInfo.getUid()});
                KTVPanelPresenter.this.mView.loadPanelLyric(filePath);
            }
        }

        @Override
        public void onStarted(KTVMusicInfo songInfo, String type) {
            FeatureLog.i((String)"FTKTVPanel", (String)"start download music and lyric resource id: %s", (Object[])new Object[]{songInfo == null ? "unKnown" : songInfo.getSongId()});
        }

        @Override
        public void onError(KTVMusicInfo songInfo, String type, String errorMessage) {
            FeatureLog.e((String)"FTKTVPanel", (String)"download song id: %s,download %s error: %s", (Object[])new Object[]{songInfo == null ? "unKnown" : songInfo.getSongId(), type, errorMessage});
            if ("Instrumental".equals(type)) {
                if (songInfo == null) {
                    return;
                }
                KTVRoomData currentKTVRoomData = KTVPanelPresenter.this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
                if (currentKTVRoomData == null) {
                    return;
                }
                KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
                if (currentSongInfo == null) {
                    return;
                }
                if (KTVPanelPresenter.this.mCurrentNeedPlaySongId.equals(songInfo.getSongId()) && currentSongInfo.getUid() == AccountUtil.getUid()) {
                    String songId = currentSongInfo.getSongId();
                    FeatureLog.e((String)"FTKTVPanel", (String)"my song download failed,terminate song: %s", (Object[])new Object[]{songId});
                    if (StringUtils.isNotEmpty((String)songId)) {
                        KTVPanelPresenter.this.getHandler().getKTVManager().getKTVRoomServices().terminateSong(songId, 1, null);
                    }
                }
            }
        }

        @Override
        public void onProgress(KTVMusicInfo songInfo, String type, long total, long current) {
            if (songInfo == null) {
                MLog.info((Object)"KTVProgress", (String)"songInfo null", (Object[])new Object[0]);
                return;
            }
            MLog.info((Object)"KTVProgress", (String)"currentSongId:%s, songId:%s, type:%s", (Object[])new Object[]{KTVPanelPresenter.this.mCurrentNeedPlaySongId, songInfo.getSongId(), type});
            if (KTVPanelPresenter.this.mCurrentNeedPlaySongId.equals(songInfo.getSongId()) && "Instrumental".equals(type) && KTVPanelPresenter.this.mView != null) {
                KTVPanelPresenter.this.mView.showLoading(total, current);
            }
        }
    };
    private Observer<KTVControlInfo> mControlObserver = new Observer<KTVControlInfo>(){

        public void onChanged(KTVControlInfo ktvControlInfo) {
            if (KTVPanelPresenter.this.mView != null) {
                KTVPanelPresenter.this.mView.updateControlState(ktvControlInfo);
            }
        }
    };
    private KvoBinder mBinder = new KvoBinder((Object)this);
    private KTVAudioSettingPanelView.OnSettingPanelListener mOnSettingPanelListener = new KTVAudioSettingPanelView.OnSettingPanelListener(){

        @Override
        public void effectItemSelect(int id2) {
            MLog.info((Object)KTVPanelPresenter.TAG, (String)("effectItemSelect id:" + id2), (Object[])new Object[0]);
            if (KTVPanelPresenter.this.isSinger()) {
                KTVPanelPresenter.this.updateAudioEffectSelect(id2);
                ChannelTrack.INSTANCE.ktvAudioEffectClick(id2);
            } else {
                ToastUtils.showToast((Context)KTVPanelPresenter.this.getContext(), (int)R.string.title_ktv_audio_no_permission);
            }
        }

        @Override
        public void disableEffect() {
            KTVPanelPresenter.this.setSoundEffect(0);
        }

        @Override
        public void clickPauseBtn(View view) {
            MLog.info((Object)KTVPanelPresenter.TAG, (String)"clickPauseBtn", (Object[])new Object[0]);
            if (KTVPanelPresenter.this.isPause()) {
                KTVPanelPresenter.this.resumeSingSong();
                if (KTVPanelPresenter.this.mKtvSettingPanelView != null) {
                    KTVPanelPresenter.this.mKtvSettingPanelView.updatePauseBtnState(false);
                }
            } else {
                KTVPanelPresenter.this.pauseSingSong();
                if (KTVPanelPresenter.this.mKtvSettingPanelView != null) {
                    KTVPanelPresenter.this.mKtvSettingPanelView.updatePauseBtnState(true);
                }
            }
            if (KTVPanelPresenter.this.isSinger()) {
                KTVEventReportUtil.reportPauseClick();
            }
            KTVEventReportUtil.reportSettingsPauseClick(KTVPanelPresenter.this.isMeShowing(), KTVPanelPresenter.this.isSinger(), KTVPanelPresenter.this.isInSeat());
        }

        @Override
        public void clickSkipBtn(View view) {
            MLog.info((Object)KTVPanelPresenter.TAG, (String)"clickSkipBtn", (Object[])new Object[0]);
            KTVPanelPresenter.this.skipSong();
            if (KTVPanelPresenter.this.mKtvSettingPanelView != null) {
                KTVPanelPresenter.this.mKtvSettingPanelView.onPanelViewHide();
            }
            KTVEventReportUtil.reportChangeSongClick("3");
            KTVEventReportUtil.reportSettingsSkipClick(KTVPanelPresenter.this.isMeShowing(), KTVPanelPresenter.this.isSinger(), KTVPanelPresenter.this.isInSeat());
        }

        @Override
        public void onIdleStateEnd() {
            MLog.info((Object)KTVPanelPresenter.TAG, (String)"onIdleStateEnd", (Object[])new Object[0]);
        }

        @Override
        public void onStartTrackingTouch(boolean touchVoice) {
            MLog.info((Object)KTVPanelPresenter.TAG, (String)("onStartTrackingTouch touchVoice:" + touchVoice), (Object[])new Object[0]);
            if (touchVoice) {
                KTVPanelPresenter.this.onVoiceTouchStart();
            }
        }

        @Override
        public void clickBack() {
            MLog.info((Object)KTVPanelPresenter.TAG, (String)"clickBack", (Object[])new Object[0]);
        }

        @Override
        public void closed() {
            MLog.info((Object)KTVPanelPresenter.TAG, (String)"closed", (Object[])new Object[0]);
            if (KTVPanelPresenter.this.mKtvSettingPanelView != null) {
                KTVPanelPresenter.this.mKtvSettingPanelView.onPanelViewHide();
            }
        }
    };
    private IKTVPanelListener iktvPanelListener;

    public void onPlayFailed(String playFailSongId) {
        String songId;
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_can_not_play_song), (int)0);
        if (this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData() != null && this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo() != null && (songId = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getResourceId()).equals(playFailSongId)) {
            this.getHandler().getKTVManager().getKTVRoomServices().terminateSong(songId, 1, null);
        }
    }

    public KTVPanelPresenter(YYFrameLayout container, IKTVHandler handler, PanelLayer panelLayer) {
        super(handler);
        this.container = container;
        this.panelLayer = panelLayer;
        this.getHandler().getKTVManager().getKTVPlayer().registerKTVPanelUICallback(this);
        this.registerDownloader();
        this.getHandler().getKTVManager().getKTVRoomServices().registerTerminateSongNotify(this.mTerminateSongNotify);
        this.getHandler().getKTVManager().getKTVRecorder().setKtvRecordListener(this);
        this.requestBeautyLevel();
        this.mCurrentEffectId = SettingFlags.getIntValue((String)("key_ktv_effect_select_id" + AccountUtil.getUid()), (int)0);
        MLog.info((Object)TAG, (String)("init updateAudioEffectSelect mCurrentEffectId:" + this.mCurrentEffectId), (Object[])new Object[0]);
        this.updateAudioEffectSelect(this.mCurrentEffectId);
        this.registerSeatIntercepter();
        this.mVirtualSeatHelper = new VirtualSeatHelper(handler.getKTVManager().getKTVRoomServices(), (IChannelPageContext<AbsPage>)this.getRoomContext());
    }

    private void handleTerminateSongNotify(KTVRoomOperateInfo operateInfo) {
        if (0 == operateInfo.getOperateFlag() && null != this.mView) {
            KTVRoomSongInfo songInfo = operateInfo.getKTVRoomSongInfo();
            this.mView.showEndingPanel(this.isSinger(), songInfo);
        }
    }

    public void start() {
    }

    private void startKtvLive() {
        if (this.isSinger()) {
            this.tryStopWatchLive();
            this.initKtvLiveModel();
            if (this.mKtvLivePresenter != null) {
                this.mKtvLivePresenter.start();
            }
            this.mCameraOpen = this.mKtvLivePresenter.onVideoMode();
            this.initKtvPlayModel();
            if (this.mKtvPlayPresenter != null) {
                this.mKtvPlayPresenter.start();
            }
        }
    }

    private void tryStopWatchLive() {
        boolean videoMode;
        if (this.mKtvPlayPresenter != null && (videoMode = this.mKtvPlayPresenter.onVideoMode())) {
            this.mKtvPlayPresenter.stopWatchLive();
        }
    }

    private void startWatchLive() {
        if (!this.isSinger()) {
            this.initKtvPlayModel();
            if (this.mKtvPlayPresenter != null) {
                this.mKtvPlayPresenter.start();
            }
        }
    }

    private void registerDownloader() {
        this.getHandler().getKTVManager().getKTVDownloader().registerKTVDonwloadListener(this.iktVdownloadCallback);
    }

    private void requestBeautyLevel() {
        IChannelPageContext roomContext = this.getRoomContext();
        if (roomContext != null && !roomContext.isDestroy()) {
            ((LiveConfigPresenter)roomContext.getPresenter(LiveConfigPresenter.class)).getBeautyLevel((Callback)new Callback<Integer>(){

                public void onResponse(Integer data) {
                    KTVPanelPresenter.this.mBeautyLevel = data;
                    if (data < 2 && KTVPanelPresenter.this.mBeautyPresenter == null) {
                        KTVPanelPresenter.this.mBeautyPresenter = new BeautyPresenter(data.intValue(), null);
                    }
                }
            });
        }
    }

    @Override
    public void openPanel() {
        this.mIsOwnerOrMaster = this.getHandler().getmRoomDataContainer().getRoomInfo().isOwnerOrMaster(AccountUtil.getUid());
        this.mView = new KTVPanelView(this.container.getContext());
        this.mView.setPresenter(this);
        this.container.removeAllViews();
        this.container.addView(this.mView.getKtvPanelView());
        this.getHandler().getKTVManager().getKTVRoomServices().fetchKTVRoomOrderedSongList(null);
        this.mBinder.singleBindSourceTo((KvoSource)this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo());
        this.mBinder.singleBindSourceTo((KvoSource)this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData());
        this.bindControlObserver();
    }

    private void bindControlObserver() {
        this.mControlData.observeForever(this.mControlObserver);
    }

    @Override
    public void playSong() {
        FeatureLog.i((String)"FTKTVPanel", (String)"clicked sing and play song", (Object[])new Object[0]);
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            FeatureLog.i((String)"FTKTVPanel", (String)"network unavailable", (Object[])new Object[0]);
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
            return;
        }
        KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            FeatureLog.e((String)"FTKTVPlayer", (String)"play song currentKTVRoomData is null.", (Object[])new Object[0]);
            return;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo == null) {
            FeatureLog.e((String)"FTKTVPlayer", (String)"play song currentSongInfo is null.", (Object[])new Object[0]);
            return;
        }
        String resourceId = currentSongInfo.getResourceId();
        if (StringUtils.isEmpty((String)resourceId)) {
            FeatureLog.e((String)"FTKTVPlayer", (String)"play song resourceId is null.", (Object[])new Object[0]);
            return;
        }
        this.mCurrentNeedPlaySongId = resourceId;
        this.showGetReadyPanel(this.isSinger(), currentKTVRoomData.hasSkipSongPolicy(), true, currentSongInfo);
        if (this.isSinger() && RoomSetting.lastOpenVideo() && this.getHandler().getKTVManager().getKTVRecorder().getNeedRecordSong()) {
            RoomSetting.onSaveKtvScheme((boolean)false);
        }
        this.startKtvLive();
        this.reportHidoEvent(1);
        this.getHandler().getKTVManager().getKTVPlayer().play(resourceId, this);
    }

    @Override
    public void openSongList() {
        this.getHandler().getKTVOperateProvider().getIKTVSongListOperator().showSongListPanel();
    }

    @Override
    public void openSongLib() {
        if (this.getHandler().getKTVOperateProvider().getIKTVMusicLibraryOperator() != null) {
            this.getHandler().getKTVOperateProvider().getIKTVMusicLibraryOperator().setMode(0);
            this.getHandler().getKTVOperateProvider().getIKTVMusicLibraryOperator().showMusicLibrary();
        }
    }

    @Override
    public void skipSong() {
        FeatureLog.i((String)"FTKTVPanel", (String)"click skip song", (Object[])new Object[0]);
        KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            return;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        String currentSongId = currentSongInfo.getSongId();
        FeatureLog.i((String)"FTKTVPlayer", (String)"skipSong song id: %s", (Object[])new Object[]{currentSongId});
        if (StringUtils.isNotEmpty((String)currentSongId)) {
            this.getHandler().getKTVManager().getKTVRoomServices().terminateSong(currentSongId, 1, null);
        }
        this.handleWhenSkipSong(currentSongInfo.getUid());
    }

    private void handleWhenSkipSong(long currentSingerUid) {
        if (this.isSinger() && this.mKtvLivePresenter != null) {
            this.mKtvLivePresenter.onSingEnd(false);
            this.cancelRecord();
        } else if (currentSingerUid == AccountUtil.getUid() && this.mKtvPlayPresenter != null) {
            this.mKtvPlayPresenter.stopWatchLive();
        }
    }

    private void handleWhenSongStop() {
        boolean isSinger = this.isSinger();
        FeatureLog.i((String)"FTKTVPlayer", (String)"handleWhenSongStop isSinger:%b", (Object[])new Object[]{isSinger});
        if (this.mKtvLivePresenter != null) {
            this.mKtvLivePresenter.onSingEnd(false);
        }
    }

    @Override
    public void closePanel() {
        if (this.iktvPanelListener != null) {
            this.iktvPanelListener.onQuited();
        }
        this.closePanelInner();
    }

    public void closePanelInner() {
        if (this.container != null) {
            this.container.removeAllViews();
        }
    }

    @Override
    public void onKTVDestroy() {
        super.onKTVDestroy();
        if (this.mVirtualSeatHelper != null) {
            this.mVirtualSeatHelper.onDestroy();
            this.mVirtualSeatHelper = null;
        }
        this.mBinder.clearAllKvoConnections();
        this.destoryRes();
        if (this.mView != null) {
            this.mView.destroy();
            this.mView = null;
        }
        if (this.container != null) {
            this.container.removeAllViews();
        }
        this.container = null;
        if (this.mKtvLivePresenter != null) {
            this.mKtvLivePresenter.destroy();
        }
        if (this.mKtvPlayPresenter != null) {
            this.mKtvPlayPresenter.destroy();
        }
        if (this.mBeautyPresenter != null) {
            this.mBeautyPresenter.destroyOrangeFilter();
            this.mBeautyPresenter = null;
        }
        this.mControlData.removeObserver(this.mControlObserver);
    }

    void destoryRes() {
        this.getHandler().getKTVManager().getKTVDownloader().unRegisterKTVDonwloadListener(this.iktVdownloadCallback);
        this.getHandler().getKTVManager().getKTVPlayer().registerKTVPanelUICallback(null);
        this.getHandler().getKTVManager().getKTVRoomServices().unRegisterTerminateSongNotify(this.mTerminateSongNotify);
        if (this.getRoomContext() != null) {
            this.getRoomContext().getChannel().getMediaService().setSeatIntercepter(null);
        }
    }

    @Override
    public void pauseSingSong() {
        KTVRoomData currentKTVRoomData;
        FeatureLog.i((String)"FTKTVPanel", (String)"clicked pause song", (Object[])new Object[0]);
        if (this.isSinger()) {
            this.getHandler().getKTVManager().getKTVPlayer().pause();
        }
        if (this.mView != null) {
            this.mView.onIsPauseState(true);
        }
        if ((currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData()) == null) {
            return;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo == null) {
            return;
        }
        String songId = currentSongInfo.getSongId();
        FeatureLog.i((String)"FTKTVPanel", (String)"clicked pause song id: %s", (Object[])new Object[]{songId});
        if (StringUtils.isNotEmpty((String)songId)) {
            this.getHandler().getKTVManager().getKTVRoomServices().pauseSong(songId, null);
        }
    }

    @Override
    public void resumeSingSong() {
        KTVRoomData currentKTVRoomData;
        FeatureLog.i((String)"FTKTVPanel", (String)"clicked resume song", (Object[])new Object[0]);
        if (this.isSinger()) {
            this.getHandler().getKTVManager().getKTVPlayer().resume();
        }
        if (null != this.mView) {
            this.mView.onIsPauseState(false);
        }
        if ((currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData()) == null) {
            return;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo == null) {
            return;
        }
        String songId = currentSongInfo.getSongId();
        FeatureLog.i((String)"FTKTVPanel", (String)"clicked resume song id: %s", (Object[])new Object[]{songId});
        if (StringUtils.isNotEmpty((String)songId)) {
            this.getHandler().getKTVManager().getKTVRoomServices().startSong(songId, null);
        }
    }

    @Override
    public boolean isPause() {
        return this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getStatus() == 2;
    }

    @Override
    public boolean isSinging() {
        return this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getStatus() == 1;
    }

    @Override
    public boolean isSinger() {
        return this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().isSinger();
    }

    @Override
    public boolean isRoomOwner() {
        return this.mIsOwnerOrMaster;
    }

    @Override
    public boolean isOwnerOrMaster() {
        return this.mIsOwnerOrMaster;
    }

    @Override
    public void showSingerProfile(long uid) {
        IChannelPageContext roomPageContext = this.getRoomContext();
        if (roomPageContext != null) {
            if (this.isInSeat(uid) || this.mVirtualSeatHelper != null && this.mVirtualSeatHelper.isInVirtualSeat(uid)) {
                ((ProfileCardPresenter)roomPageContext.getPresenter(ProfileCardPresenter.class)).showProfileCard(uid, true, OpenProfileFrom.FROM_SEAT);
            } else {
                ((ProfileCardPresenter)roomPageContext.getPresenter(ProfileCardPresenter.class)).showProfileCard(uid, OpenProfileFrom.FROM_OTHER);
            }
            if (roomPageContext.getChannel() != null && roomPageContext.getChannel().getRoleService() != null) {
                String role = roomPageContext.getChannel().getRoleService().getRoleCache(AccountUtil.getUid()) + "";
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "ktv_profile_click").put("room_id", this.getRoomId()).put("user_role", role));
            }
        }
    }

    @Override
    public GiftItemInfo getGiftInfo() {
        return this.getHandler().getKTVManager().getKTVRoomServices().getGiftInfo();
    }

    @Override
    public void sendGift(GiftItemInfo giftInfo) {
        this.sendGift(null, giftInfo);
    }

    @Override
    public void sendGift(KTVRoomSongInfo songInfo, GiftItemInfo info) {
        IChannelPageContext roomPageContext;
        if (null != this.getHandler().getKTVManager() && null != this.getHandler().getKTVManager().getContext() && null != (roomPageContext = this.getRoomContext())) {
            if (songInfo == null) {
                songInfo = this.getCurrentSongInfo();
            }
            if (songInfo != null && songInfo.getUid() != 0L) {
                GiftUserInfo giftUserInfo = new GiftUserInfo();
                giftUserInfo.setUserInfo(((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(songInfo.getUid(), null));
                ArrayList<GiftUserInfo> list = new ArrayList<GiftUserInfo>();
                list.add(giftUserInfo);
                info.setShowCombo(false);
                ((IRevenueToolsModulePresenter)roomPageContext.getPresenter(IRevenueToolsModulePresenter.class)).sendGift(list, 17, info, 1);
                RoomTrack.INSTANCE.onKtvQuickGiftClick(info.getPropsId());
            }
        }
    }

    @Override
    public void onVideoSettingClick(boolean cameraOpen) {
        if (this.mBeautyLevel == -1) {
            this.requestBeautyLevel();
            this.onSingerVideoToggleClick(cameraOpen);
        } else if (this.mBeautyLevel < 2) {
            if (!cameraOpen) {
                this.openVideoSettingPanel(true);
                this.onSingerVideoToggleClick(false);
            } else {
                this.openVideoSettingPanel(true);
            }
        } else {
            this.onSingerVideoToggleClick(cameraOpen);
        }
    }

    private void onSingerVideoToggleClick(boolean oldState) {
        this.updateControlInfo(controlInfo -> controlInfo.getVideoBtnState().setCameraOpen(!oldState));
        this.openVideoScheme(!oldState);
        if (this.isRecording()) {
            this.cancelRecord();
            this.mView.getSingerSingingPanelView().showRecording(false);
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_ktv_cancel_record);
        }
    }

    @Override
    public void openVideoSettingPanel(boolean cameraOpen) {
        if (null == this.mBeautyPanel) {
            this.mBeautyPanel = new KtvBeautyPanel(this.getContext(), this.panelLayer);
            this.mBeautyPanel.setOnCheckedChangeListener((Function1<? super Boolean, Unit>)((Function1)checked -> {
                if (this.mView.getSingerSingingPanelView() != null && this.mView.getSingerSingingPanelView().getMIsShowing() || this.mView.getSingerVideoPanelView().isShown()) {
                    this.onSingerVideoToggleClick(checked == false);
                }
                return Unit.INSTANCE;
            }));
        }
        if (this.mFilterPresenter == null) {
            this.mFilterPresenter = new OrangeFilterPresenter();
        }
        if (this.mBeautyPresenter == null) {
            this.mBeautyPresenter = new BeautyPresenter(this.mBeautyLevel, (ICommonCallback)new DefaultCommonCallBack<Boolean>(){

                public void onSuccess(Boolean data, Object ... ext) {
                    KTVPanelPresenter.this.mBeautyPresenter.connectOrangeFilter();
                }
            });
        }
        this.mFilterPresenter.setOrangeFilterPanelView((IOrangeFilterView)this.mBeautyPanel);
        this.mBeautyPresenter.setView((IBeautyView)this.mBeautyPanel);
        this.mBeautyPanel.showPanel(cameraOpen);
    }

    @Override
    public void hideVideoSettingPanel() {
        if (this.mBeautyPanel != null) {
            this.mBeautyPanel.hidePanel();
        }
    }

    private void updateAudioEffectSelect(int effectId) {
        if (ServiceManagerProxy.getService(IKtvAudioEffectService.class) != null) {
            ((IKtvAudioEffectService)ServiceManagerProxy.getService(IKtvAudioEffectService.class)).setSelectEffect(effectId);
        }
        this.setSoundEffect(effectId);
    }

    private void setSoundEffect(int effectId) {
        IChannelPageContext roomPageContext;
        MLog.info((Object)TAG, (String)("setSoundEffect effectId:" + effectId), (Object[])new Object[0]);
        if (effectId < 0) {
            return;
        }
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setSoundEffect(effectId);
        if (effectId == 0 && (roomPageContext = this.getRoomContext()) != null && roomPageContext.getChannel() != null && roomPageContext.getChannel().getVoiceFilterService() != null) {
            roomPageContext.getChannel().getVoiceFilterService().resumeSelectId();
        }
    }

    @Override
    public void openAudioSettingPanel(boolean hasPausePolicy) {
        if (null == this.mKtvSettingPanelView) {
            this.mKtvSettingPanelView = new KTVAudioSettingPanelView(this.getContext(), this.panelLayer);
            this.mKtvSettingPanelView.setBackgroundResource(R.drawable.shape_272735);
        }
        this.mKtvSettingPanelView.setOnSettingPanelListener(this.mOnSettingPanelListener);
        this.mKtvSettingPanelView.onPanelViewShow(hasPausePolicy, this.isSinger(), this.isPause());
        ChannelTrack.INSTANCE.ktvControlShow();
    }

    @Override
    public void updateControlInfo(IControlInfoCallBack callBack) {
        callBack.update((KTVControlInfo)this.mControlData.getValue());
        this.mControlData.postValue(this.mControlData.getValue());
    }

    @Override
    public KTVControlInfo getControlInfo() {
        return (KTVControlInfo)this.mControlData.getValue();
    }

    @Override
    public Drawable getThemeBg() {
        IChannelPageContext roomPageContext;
        if (null != this.getHandler().getKTVManager() && null != this.getHandler().getKTVManager().getContext() && null != (roomPageContext = this.getRoomContext())) {
            return ((ThemePresenter)roomPageContext.getPresenter(ThemePresenter.class)).getBgDrawable();
        }
        return null;
    }

    @Override
    public List<View> getScrollViews() {
        return this.getView().getScrollViews();
    }

    @Override
    public void onAudienceVideoModeChange(boolean isVideoMode) {
        if (this.iktvPanelListener != null) {
            this.iktvPanelListener.onVideoModeChange(isVideoMode);
        }
    }

    @Override
    public void onSingerVideoModeChange(boolean isVideoMode) {
        if (this.iktvPanelListener != null) {
            this.iktvPanelListener.onVideoModeChange(isVideoMode);
        }
    }

    private void showSingingPanel(boolean isSinger, KTVRoomSongInfo songInfo, boolean isOwner) {
        if (this.mView != null) {
            this.mView.showSingingPanel(isSinger, songInfo, isOwner);
        }
    }

    private void showGetReadyPanel(boolean isSinger, boolean showSkip, boolean isDownloading, KTVRoomSongInfo songInfo) {
        if (this.mView != null) {
            this.mView.showGetReadyPanel(isSinger, showSkip, isDownloading, songInfo);
        }
    }

    @Override
    public boolean isMeShowing() {
        RoomInfo roomInfo = this.getHandler().getmRoomDataContainer().getRoomInfo();
        if (roomInfo.isGroupParty() && 0L != roomInfo.getShowUid()) {
            return AccountUtil.getUid() == roomInfo.getShowUid();
        }
        return this.isRoomOwner();
    }

    @Override
    public boolean isInSeat() {
        if (this.getRoomContext() == null) {
            return false;
        }
        return this.getRoomContext().getChannel().getSeatService().isInSeat(AccountUtil.getUid());
    }

    @Override
    public boolean isInSeat(Long uid) {
        return this.getRoomContext().getChannel().getSeatService().isInSeat(uid.longValue());
    }

    @Override
    public void onPrepare(KTVRoomSongInfo songInfo) {
        FeatureLog.i((String)"FTKTVPanel", (String)"onPrepare", (Object[])new Object[0]);
        if (StringUtils.isEmpty((String)songInfo.getSongId())) {
            if (this.mView != null) {
                KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
                this.mView.showNoSongPanel(this.isInSeat(), currentKTVRoomData.hasCloseKTVPolicy());
            }
        } else {
            if (this.mView != null) {
                KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
                this.showGetReadyPanel(this.isSinger(), currentKTVRoomData.hasSkipSongPolicy(), false, songInfo);
            }
            if (this.mVirtualSeatHelper != null) {
                this.mVirtualSeatHelper.startCheckOpenVirtualSeat(songInfo);
            }
        }
    }

    @Override
    public void onStart(final KTVRoomSongInfo songInfo) {
        String resourceId;
        FeatureLog.i((String)"FTKTVPanel", (String)"onStart", (Object[])new Object[0]);
        if (this.mVirtualSeatHelper != null) {
            this.mVirtualSeatHelper.checkOpenVirtualSeat(songInfo);
        }
        if (StringUtils.isNotEmpty((String)(resourceId = songInfo.getResourceId()))) {
            this.getHandler().getKTVManager().getKTVMusicListProvider().getMusicInfo(resourceId, new IKTVQueryCallback<KTVMusicInfo>(){

                @Override
                public void onSuccess(KTVMusicInfo data, boolean isCache) {
                    if (KTVPanelPresenter.this.getHandler().getKTVManager() != null) {
                        String lyricFilePath = KTVPanelPresenter.this.getHandler().getKTVManager().getKTVDownloader().getLocalLyricFilePath(data);
                        FeatureLog.i((String)"FTKTVPanel", (String)"onStart load lyric path: %s", (Object[])new Object[]{lyricFilePath});
                        if (KTVPanelPresenter.this.mView != null) {
                            if (StringUtils.isNotEmpty((String)lyricFilePath)) {
                                KTVPanelPresenter.this.mView.loadPanelLyric(lyricFilePath);
                            }
                            KTVPanelPresenter.this.showSingingPanel(KTVPanelPresenter.this.isSinger(), songInfo, KTVPanelPresenter.this.isRoomOwner());
                        }
                    }
                }

                @Override
                public void onFail(String errorMessage) {
                    FeatureLog.e((String)"FTKTVPanel", (String)"load lyric failed: %s", (Object[])new Object[]{errorMessage});
                }
            });
        }
        this.startWatchLive();
    }

    @Override
    public void onPause(boolean isFirstEnter, KTVRoomSongInfo songInfo) {
        FeatureLog.i((String)"FTKTVPanel", (String)"onPause", (Object[])new Object[0]);
        this.getHandler().getKTVManager().getKTVPlayer().pause();
        if (this.mView != null) {
            this.mView.onIsPauseState(true);
            this.showSingingPanel(this.isSinger(), songInfo, this.isRoomOwner());
        }
        if (isFirstEnter) {
            this.startWatchLive();
        }
    }

    @Override
    public void onResume(final KTVRoomSongInfo songInfo) {
        FeatureLog.i((String)"FTKTVPanel", (String)"onResume", (Object[])new Object[0]);
        this.getHandler().getKTVManager().getKTVPlayer().resume();
        if (this.mView != null) {
            this.mView.onIsPauseState(false);
            if (this.mView.hasLoadLyricFile()) {
                this.showSingingPanel(this.isSinger(), songInfo, this.isRoomOwner());
            } else {
                String resourceId = songInfo.getResourceId();
                if (StringUtils.isNotEmpty((String)resourceId)) {
                    this.getHandler().getKTVManager().getKTVMusicListProvider().queryMusic(resourceId, new KTVCommonCallback<KTVMusicInfo>(){

                        public void onSuccess(KTVMusicInfo data) {
                            String lyricFilePath = KTVPanelPresenter.this.getHandler().getKTVManager().getKTVDownloader().getLocalLyricFilePath(data);
                            if (StringUtils.isNotEmpty((String)lyricFilePath) && KTVPanelPresenter.this.mView != null) {
                                KTVPanelPresenter.this.mView.loadPanelLyric(lyricFilePath);
                            }
                            KTVPanelPresenter.this.showSingingPanel(KTVPanelPresenter.this.isSinger(), songInfo, KTVPanelPresenter.this.isRoomOwner());
                        }

                        public void onFail(int code, String errorMessage) {
                            FeatureLog.e((String)"FTKTVPlayer", (String)"load lyric failed: %s", (Object[])new Object[]{errorMessage});
                        }
                    });
                }
            }
        }
    }

    @Override
    public void onClear(KTVRoomSongInfo songInfo) {
        FeatureLog.i((String)"FTKTVPanel", (String)"onClear", (Object[])new Object[0]);
        KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
        if (StringUtils.isEmpty((String)songInfo.getSongId())) {
            if (this.mView != null) {
                this.mView.showNoSongPanel(this.isInSeat(), currentKTVRoomData.hasCloseKTVPolicy());
            }
            if (this.mVirtualSeatHelper != null) {
                this.mVirtualSeatHelper.startCheckCloseVirtualSeat();
            }
        } else {
            this.showGetReadyPanel(this.isSinger(), currentKTVRoomData.hasSkipSongPolicy(), false, songInfo);
        }
    }

    @Override
    public void onLoading(KTVRoomSongInfo songInfo) {
        FeatureLog.i((String)"FTKTVPanel", (String)"onLoading", (Object[])new Object[0]);
        if (this.mView != null) {
            KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
            this.mView.showLoadingPanel(currentKTVRoomData.hasCloseKTVPolicy());
        }
    }

    @Override
    public String getRoomId() {
        return this.getHandler().getmRoomDataContainer().getRoomId();
    }

    public KTVPanelOperater getContract() {
        return new KTVPanelOperater();
    }

    @Override
    public void onAudioPlaySpectrumData(byte[] data) {
    }

    @Override
    public void onLyricsTime(int time, int totalDuration) {
        if (this.mView != null) {
            this.mView.updateLyricTime(time, totalDuration);
        }
    }

    @KvoMethodAnnotation(sourceClass=KTVRoomSongInfo.class, name="status")
    public void onSongStatusChanged(KvoEventIntent event) {
        if (event == null) {
            return;
        }
        int oldValue = (Integer)event.oldValue();
        int newValue = (Integer)event.newValue();
        FeatureLog.i((String)"FTKTVPanel", (String)"old value: %s,new value: %s", (Object[])new Object[]{oldValue, newValue});
        if (newValue == -2) {
            this.mCurrentNeedPlaySongId = "";
            this.onLoading((KTVRoomSongInfo)event.source());
        } else if (newValue == -1) {
            this.onClear((KTVRoomSongInfo)event.source());
        } else if (newValue == 0) {
            this.onPrepare((KTVRoomSongInfo)event.source());
        } else if ((oldValue == -2 || oldValue == -1 || oldValue == 0 || oldValue == 3) && newValue == 1) {
            this.onStart((KTVRoomSongInfo)event.source());
        } else if ((oldValue == 2 || oldValue == 1) && newValue == 1) {
            this.onResume((KTVRoomSongInfo)event.source());
        } else if (newValue == 2) {
            boolean isFirstEnter = oldValue == -2 || oldValue == -1;
            this.onPause(isFirstEnter, (KTVRoomSongInfo)event.source());
        }
        if (newValue == 3 || newValue == -1) {
            this.mCurrentNeedPlaySongId = "";
            this.handleWhenSongStop();
        }
    }

    @KvoMethodAnnotation(sourceClass=KTVRoomData.class, name="mPolicy", thread=1)
    public void onPolicyChanged(KvoEventIntent event) {
        this.checkSelectSongPolicy(KTVRoomData.getSelectSongPolicy((int)((Integer)event.oldValue())), KTVRoomData.getSelectSongPolicy((int)((Integer)event.newValue())));
    }

    private void checkSelectSongPolicy(int oldPolicy, int newPolicy) {
        if (newPolicy == 1) {
            if (this.mView != null) {
                this.mView.setSelectSongPolicy(this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getStatus(), false);
            }
        } else if (newPolicy == 2 && this.mView != null) {
            this.mView.setSelectSongPolicy(this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getStatus(), true);
        }
    }

    @Override
    public void onPlaySuccess() {
        KTVDataReportHelper.playSongReport(this.mCurrentNeedPlaySongId, 2);
        IKTVRecorder ktvRecorder = this.getHandler().getKTVManager().getKTVRecorder();
        if (ktvRecorder.hasRecordPermission() && ktvRecorder.getNeedRecordSong()) {
            this.resetRecordState();
            ktvRecorder.startRecord();
            if (null != this.mView && null != this.mView.getSingerSingingPanelView()) {
                this.mView.getSingerSingingPanelView().showRecording(true);
            }
        } else if (null != this.mView && null != this.mView.getSingerSingingPanelView()) {
            this.mView.getSingerSingingPanelView().showRecording(false);
        }
    }

    @Override
    public void onPlayFail() {
        FeatureLog.e((String)"FTKTVPanel", (String)"play song resource id: %s failed.", (Object[])new Object[]{this.mCurrentNeedPlaySongId});
        KTVDataReportHelper.playSongReport(this.mCurrentNeedPlaySongId, 1);
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_can_not_play_song), (int)0);
    }

    @Override
    public void onPlayEnd() {
        KTVEventReportUtil.reportChangeSongClick("5");
        if (this.mKtvLivePresenter != null && this.isSinger()) {
            this.mKtvLivePresenter.onSingEnd(false);
        }
        if (this.mKtvPlayPresenter != null && !this.isSinger()) {
            this.mKtvPlayPresenter.stopWatchLive();
        }
        this.getHandler().getKTVManager().getKTVRecorder().stopRecord();
    }

    @Override
    public void onPrePlay() {
        KTVDataReportHelper.playSongReport(this.mCurrentNeedPlaySongId, 0);
    }

    @Override
    public void showGiftPanel(long uid) {
        IChannelPageContext roomPageContext = this.getRoomContext();
        if (null != roomPageContext) {
            if (uid == 0L) {
                ((IRevenueToolsModulePresenter)roomPageContext.getPresenter(IRevenueToolsModulePresenter.class)).getGiftPresenter().showGiftPanel(5);
            } else {
                ShowGiftPanelParam param = new ShowGiftPanelParam(5);
                param.setSelectedUid(Collections.singletonList(uid));
                ((IRevenueToolsModulePresenter)roomPageContext.getPresenter(IRevenueToolsModulePresenter.class)).openGiftPanel(param);
            }
        }
    }

    @Override
    public KTVPanelContract.View getView() {
        return this.mView;
    }

    public boolean checkScrollSongInfo() {
        EnvSettingType type = EnvSettings.instance().getUriSettingValue();
        if (type == EnvSettingType.Test) {
            return true;
        }
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.PERFORMANCE_CONFIG);
        return null != configData && configData.getBoolValue("ktv_composer_and_writer_show", false);
    }

    @Override
    public void openVideoScheme(boolean openCamera) {
        this.mCameraOpen = openCamera;
        if (this.mCameraOpen) {
            KtvRoomModel.INSTANCE.setMVideoScheme(SwitchAVModeReq.AVMode.AVMode_Video);
        } else {
            KtvRoomModel.INSTANCE.setMVideoScheme(SwitchAVModeReq.AVMode.AVMode_Audio);
        }
        if (openCamera) {
            if (this.container.getContext() instanceof Activity) {
                Activity activity = (Activity)this.container.getContext();
                PermissionHelper.requestCameraPermission((Activity)activity, (IPermissionListener)new IPermissionListener(){

                    public void onPermissionGranted(@NonNull String[] permission) {
                        if (!RoomSetting.getPermission()) {
                            KTVEventReportUtil.reportVideoPesmissionDialog();
                            KTVEventReportUtil.reportVideoPesmissionOK();
                            RoomSetting.onSaveKtvPermission((boolean)true);
                        }
                        if (NetworkUtils.isWifiActive((Context)RuntimeContext.sApplicationContext) || RoomSetting.useMobileNetWork) {
                            KTVPanelPresenter.this.beginLive();
                        } else {
                            KtvRoomModel.INSTANCE.showMobileNetWorkDialogTip(KTVPanelPresenter.this.container.getContext(), () -> {
                                KTVPanelPresenter.this.beginLive();
                                return null;
                            }, () -> {
                                if (null != KTVPanelPresenter.this.mView) {
                                    KTVPanelPresenter.this.mView.getKtvLiveView().resetView();
                                }
                                return null;
                            });
                        }
                    }

                    public void onPermissionDenied(@NonNull String[] permission) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.camear_authority_forbid);
                        KTVEventReportUtil.reportVideoPesmissionCancel();
                        if (KTVPanelPresenter.this.mKtvLivePresenter != null) {
                            KTVPanelPresenter.this.mKtvLivePresenter.noPermisssion();
                        }
                        KTVPanelPresenter.this.resetOnNoPermission();
                    }
                });
            }
        } else {
            if (this.mKtvLivePresenter != null) {
                this.mKtvLivePresenter.stopLive(true);
            }
            KTVEventReportUtil.reportVideoClose(this.isMeShowing(), this.isSinger(), this.isInSeat());
        }
        RoomSetting.onSaveKtvScheme((boolean)this.mCameraOpen);
        this.reportHidoEvent(2);
    }

    @Override
    public void startGiftSvga(String url, ISvgaAnimListener listener) {
        if (this.mView != null) {
            this.mView.startGiftSvga(url, listener);
        }
    }

    @Override
    public KTVRoomSongInfo getCurrentSongInfo() {
        KTVRoomData currentKTVRoomData = this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            return null;
        }
        return currentKTVRoomData.getCurrentSongInfo();
    }

    private void resetOnNoPermission() {
        this.mCameraOpen = false;
        RoomSetting.onSaveKtvScheme((boolean)false);
        KtvRoomModel.INSTANCE.setMVideoScheme(SwitchAVModeReq.AVMode.AVMode_Audio);
    }

    private void beginLive() {
        this.initKtvLiveModel();
        this.mKtvLivePresenter.startLive(true, true);
        if (this.mBeautyPresenter != null) {
            this.mBeautyPresenter.connectOrangeFilter();
        }
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class)).switchFrontCamera(true);
    }

    private void initKtvLiveModel() {
        if (this.mKtvLivePresenter == null && this.mView != null) {
            String roomId = this.getHandler().getmRoomDataContainer().getRoomInfo().getRoomId();
            this.mKtvLivePresenter = new KtvLivePresenter(this.isMeShowing(), roomId, this.isInSeat(), this.isSinger());
            this.mKtvLivePresenter.setView(this.mView.getKtvLiveView());
        }
    }

    private void initKtvPlayModel() {
        if (this.mKtvPlayPresenter == null && this.mView != null) {
            long roomOwnerUid = this.getHandler().getmRoomDataContainer().getRoomInfo().getOwnerId();
            IChannel channel = ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(this.getHandler().getmRoomDataContainer().getRoomId());
            this.mKtvPlayPresenter = new KtvPlayPresenter(roomOwnerUid, channel);
            this.mKtvPlayPresenter.setView(this.mView.getKtvPlayView());
        }
    }

    @Override
    public void setUICallback(IUICallback callback) {
        this.mUICallback = callback;
    }

    public void reportHidoEvent(int flag) {
        String ktvMode = KTVEventReportUtil.MODE_VIDEO;
        if (!this.mCameraOpen) {
            ktvMode = KTVEventReportUtil.MODE_VOICE;
        }
        if (flag == 1) {
            KTVEventReportUtil.reportMusicTouch(this.mCurrentNeedPlaySongId, ktvMode);
        } else if (flag == 2 && !this.mLastReportSongId.equals(this.mCurrentNeedPlaySongId)) {
            KTVEventReportUtil.reportKTVModelChange(this.mCurrentNeedPlaySongId, ktvMode);
            this.mLastReportSongId = this.mCurrentNeedPlaySongId;
        }
    }

    public void onVoiceTouchStart() {
        KTVEventReportUtil.reportVoiceTouch(this.getRoomId());
    }

    @Override
    public boolean hasRecordKtvPermission() {
        return this.getHandler().getKTVManager().getKTVRecorder().hasRecordPermission();
    }

    @Override
    public boolean hasSeletedRecord() {
        return this.getHandler().getKTVManager().getKTVRecorder().getNeedRecordSong();
    }

    @Override
    public boolean isRecording() {
        return this.getHandler().getKTVManager().getKTVRecorder().isRecording();
    }

    @Override
    public boolean isRecordComplete() {
        return !TextUtils.isEmpty((CharSequence)this.mCurrentAudioPath) && this.mCurrentSongInfo != null;
    }

    @Override
    public void cancelRecord() {
        this.getHandler().getKTVManager().getKTVRecorder().cancelRecord();
    }

    @Override
    public void setCurrentRecordSong(boolean record) {
        this.getHandler().getKTVManager().getKTVRecorder().setNeedRecordSong(record);
    }

    private void resetRecordState() {
        this.mCurrentAudioPath = null;
        this.mCurrentSongInfo = null;
    }

    @Override
    public void recordComplete(@NotNull String audioPath, @NonNull KTVRoomSongInfo currentSongInfo) {
        if (null == this.container || null == this.container.getContext()) {
            MLog.info((Object)TAG, (String)"recordComplete container null", (Object[])new Object[0]);
            return;
        }
        this.mCurrentAudioPath = audioPath;
        this.mCurrentSongInfo = currentSongInfo;
        this.showRecordComplete(audioPath, currentSongInfo);
    }

    private void showRecordComplete(final @NotNull String audioPath, final @NotNull KTVRoomSongInfo currentSongInfo) {
        this.getHandler().getKTVManager().getKTVMusicListProvider().getMusicInfo(currentSongInfo.getResourceId(), new IKTVQueryCallback<KTVMusicInfo>(){

            @Override
            public void onSuccess(final KTVMusicInfo ktvMusicInfo, boolean isCache) {
                if (null == ktvMusicInfo) {
                    MLog.error((Object)KTVPanelPresenter.TAG, (String)"KTVMusicInfo = null", (Object[])new Object[0]);
                    return;
                }
                KtvSectionInfo ktvSectionInfo = new KtvSectionInfo();
                ktvSectionInfo.setMSongName(currentSongInfo.getSongName());
                ktvSectionInfo.setMAudioUrl(audioPath);
                ktvSectionInfo.setMCoverUrl(currentSongInfo.getCoverImageUrl());
                ktvSectionInfo.setMOriginSinger(currentSongInfo.getOriginalSinger());
                ktvSectionInfo.setMLyricUrl(ktvMusicInfo.getLyricUrl());
                ktvSectionInfo.setMSingerAvatar(currentSongInfo.getAvatar());
                KTVPanelPresenter.this.mKtvMusicInfo = ktvMusicInfo;
                KTVPanelPresenter.this.dialog = new RecordCompleteDialog(KTVPanelPresenter.this.container.getContext());
                KTVPanelPresenter.this.dialog.initKtvView(ktvSectionInfo);
                KTVPanelPresenter.this.dialog.setRecordCompleteListener(new RecordCompleteDialog.IRecordCompleteListener(){

                    @Override
                    public void shareOpenRecordMv() {
                        if (!NetworkUtils.isNetworkAvailable((Context)KTVPanelPresenter.this.getContext())) {
                            ToastUtils.showToast((Context)KTVPanelPresenter.this.getContext(), (int)R.string.network_error);
                            return;
                        }
                        KTVPanelPresenter.this.dialog.dismiss();
                        if (KTVPanelPresenter.this.mUICallback != null) {
                            KTVPanelPresenter.this.mUICallback.operLocalMic(false);
                        }
                        KTVPostUtils.INSTANCE.goMtvRecordVideo(audioPath, ktvMusicInfo, KTVPanelPresenter.this.mRecordCallback);
                        KTVEventReportUtil.reportAudioShareDialogAddMvClick();
                    }

                    @Override
                    public void shareToBbs(String shareTxt) {
                        KTVPanelPresenter.this.retryPublishTimes = 0;
                        if (!NetworkUtils.isNetworkAvailable((Context)KTVPanelPresenter.this.getContext())) {
                            ToastUtils.showToast((Context)KTVPanelPresenter.this.getContext(), (int)R.string.network_error);
                            return;
                        }
                        KTVPanelPresenter.this.dialog.dismiss();
                        KTVPanelPresenter.this.shareToBBS(shareTxt, audioPath, ktvMusicInfo, currentSongInfo);
                        KTVEventReportUtil.reportAudioShareDialogShareClick();
                    }

                    @Override
                    public void openKtvPlayerPage() {
                        KTVPanelPresenter.this.dialog.dismiss();
                        if (null != KTVPanelPresenter.this.mUICallback) {
                            KTVPanelPresenter.this.mUICallback.audioPlaying();
                        }
                        Message msg = Message.obtain();
                        msg.what = ChannelBaseMsgDef.OPEN_KTV_PLAYER_PAGE;
                        KTVPlayerInfo ktvPlayerInfo = new KTVPlayerInfo();
                        ktvPlayerInfo.setSongId(currentSongInfo.getSongId());
                        ktvPlayerInfo.setLyricUrl(ktvMusicInfo.getLyricUrl());
                        ktvPlayerInfo.setSinger(currentSongInfo.getNick());
                        ktvPlayerInfo.setSongCover(currentSongInfo.getCoverImageUrl());
                        ktvPlayerInfo.setSongUrl(audioPath);
                        ktvPlayerInfo.setSongName(currentSongInfo.getSongName());
                        Bundle bundle = new Bundle();
                        bundle.putSerializable("KTVPlayerInfo", (Serializable)ktvPlayerInfo);
                        bundle.putSerializable("RecordCompleteDialog", (Serializable)KTVPanelPresenter.this.dialog);
                        msg.setData(bundle);
                        msg.arg1 = 1;
                        MsgDispatcher.getInstance().sendMessage(msg);
                    }

                    @Override
                    public void clickCover() {
                        if (null != KTVPanelPresenter.this.mUICallback) {
                            KTVPanelPresenter.this.mUICallback.audioPlaying();
                            KTVEventReportUtil.reportAudioShareDialogPlayClick();
                        }
                    }
                });
                KTVPanelPresenter.this.dialog.show();
                KTVEventReportUtil.reportAudioShareDialogShow();
            }

            @Override
            public void onFail(String errorMessage) {
            }
        });
    }

    private void shareToBBS(final String shareTxt, final String audioPath, final KTVMusicInfo ktvMusicInfo, final KTVRoomSongInfo currentSongInfo) {
        KTVPostUtils.INSTANCE.publishFile(audioPath, new BiCallback<String, Integer>(){

            public void onSuccess(String url) {
                ArrayList<String> cidList = new ArrayList<String>();
                KTVPostUtils.INSTANCE.publishKtvPost(url, shareTxt, ktvMusicInfo.getLyricUrl(), currentSongInfo, ktvMusicInfo.getSongId(), cidList, new BiCallback<BasePostInfo, Integer>(){

                    public void onSuccess(BasePostInfo data) {
                        if (null != data) {
                            MLog.info((Object)KTVPanelPresenter.TAG, (String)("postinfo: " + data), (Object[])new Object[0]);
                            KTVPanelPresenter.this.sendPublicScreenMsg(data);
                            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.btn_ktv_record_complete_publish_bbs_succ);
                        }
                    }

                    public void onError(Integer error) {
                        MLog.info((Object)KTVPanelPresenter.TAG, (String)("publishKtvPost onError: " + error), (Object[])new Object[0]);
                        if (error.intValue() == ECode.E_CODE_SENSITIVE.getValue()) {
                            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.publish_failed);
                        } else if (error.intValue() == ECode.E_CODE_SYNC_TO_CHANNEL_NO_PERMISSION.getValue()) {
                            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_no_permission_share_post_to_channel);
                        } else {
                            KTVPanelPresenter.this.retryPublishTimes++;
                            if (KTVPanelPresenter.this.retryPublishTimes > 3) {
                                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.publish_failed);
                            } else {
                                KTVPanelPresenter.this.shareToBBS(shareTxt, audioPath, ktvMusicInfo, currentSongInfo);
                            }
                        }
                    }
                });
            }

            public void onError(Integer error) {
                MLog.info((Object)KTVPanelPresenter.TAG, (String)("publishFile onError: " + error), (Object[])new Object[0]);
                KTVPanelPresenter.this.retryPublishTimes++;
                if (KTVPanelPresenter.this.retryPublishTimes > 3) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.publish_failed);
                } else {
                    KTVPanelPresenter.this.shareToBBS(shareTxt, audioPath, ktvMusicInfo, currentSongInfo);
                }
            }
        });
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20033151").put("function_id", "send_post_but_click").put("post_pg_source", "12"));
        BBSBaseTrack.INSTANCE.reportSendPostBtnClick("12", "");
    }

    void saveBtnClick() {
        if (this.mSavingAudioPathList != null && this.mSavingAudioPathList.contains(this.mCurrentAudioPath)) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.saving);
            MLog.info((Object)TAG, (String)"current audio file saving", (Object[])new Object[0]);
            return;
        }
        KTVWorksUtils.INSTANCE.checkLocalFileExists(this.mCurrentAudioPath, new KTVWorksUtils.OnCheckLocalFileListener(){

            @Override
            public void onChecked(boolean exists) {
                if (exists) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.ktv_save_drafted);
                    MLog.info((Object)KTVPanelPresenter.TAG, (String)"audio file already saved", (Object[])new Object[0]);
                } else {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.saving);
                    KTVPanelPresenter.this.retryPublishTimes = 0;
                    KTVPanelPresenter.this.singerSaveAudio();
                }
            }
        });
    }

    private void singerSaveAudio() {
        MLog.info((Object)TAG, (String)("audioPath: " + this.mCurrentAudioPath), (Object[])new Object[0]);
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentAudioPath) && this.mCurrentSongInfo != null) {
            if (this.mSavingAudioPathList == null) {
                this.mSavingAudioPathList = new ArrayList<String>();
            }
            this.mSavingAudioPathList.add(this.mCurrentAudioPath);
            this.getHandler().getKTVManager().getKTVMusicListProvider().getMusicInfo(this.mCurrentSongInfo.getResourceId(), new IKTVQueryCallback<KTVMusicInfo>(){

                @Override
                public void onSuccess(final KTVMusicInfo ktvMusicInfo, boolean isCache) {
                    if (null == ktvMusicInfo) {
                        MLog.error((Object)KTVPanelPresenter.TAG, (String)"singerSaveAudio KTVMusicInfo = null", (Object[])new Object[0]);
                        return;
                    }
                    KTVWorksUtils.INSTANCE.uploadWorksFile(KTVPanelPresenter.this.mCurrentAudioPath, new KTVWorksUtils.OnUploadFileListener(){

                        @Override
                        public void onError(@NotNull int error) {
                            MLog.info((Object)KTVPanelPresenter.TAG, (String)("singerSaveAudio onError: " + error), (Object[])new Object[0]);
                            KTVPanelPresenter.this.retryPublishTimes++;
                            if (KTVPanelPresenter.this.retryPublishTimes > 2) {
                                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tip_save_notice_failed);
                            } else {
                                KTVPanelPresenter.this.singerSaveAudio();
                            }
                        }

                        @Override
                        public void onSuccess(@NotNull String url, @NotNull String localPath) {
                            YYTaskExecutor.execute(() -> {
                                String digest = "";
                                try {
                                    digest = YYFileUtils.getFileMD5String((File)new File(localPath), (long)1000L).toLowerCase();
                                }
                                catch (Exception e) {
                                    MLog.error((Object)KTVPanelPresenter.TAG, (Throwable)e);
                                }
                                MLog.info((Object)KTVPanelPresenter.TAG, (String)("saveKtvWorks: " + digest), (Object[])new Object[0]);
                                KTVWorksUtils.INSTANCE.saveKtvWorks(digest, localPath, url, ktvMusicInfo.getLyricUrl(), KTVPanelPresenter.this.mCurrentSongInfo, new BiCallback<String, String>(){

                                    public void onSuccess(String audioLocalPath) {
                                        MLog.info((Object)KTVPanelPresenter.TAG, (String)"saveKtvWorks success", (Object[])new Object[0]);
                                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.toast_save_success);
                                        KTVPanelPresenter.this.mSavingAudioPathList.remove(audioLocalPath);
                                        KTVWorksUtils.INSTANCE.copyFile(audioLocalPath);
                                    }

                                    public void onError(String error) {
                                        MLog.info((Object)KTVPanelPresenter.TAG, (String)("saveKtvWorks error: " + error), (Object[])new Object[0]);
                                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tip_save_notice_failed);
                                    }
                                });
                            });
                        }
                    });
                }

                @Override
                public void onFail(String errorMessage) {
                    MLog.error((Object)KTVPanelPresenter.TAG, (String)"singerSaveAudio get KTVMusicInfo error", (Object[])new Object[0]);
                }
            });
        }
    }

    void showShareDialog() {
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentAudioPath) && this.mCurrentSongInfo != null) {
            this.showRecordComplete(this.mCurrentAudioPath, this.mCurrentSongInfo);
        } else {
            MLog.info((Object)TAG, (String)(" mCurrentAudioPath is  " + this.mCurrentAudioPath + (this.mCurrentSongInfo == null)), (Object[])new Object[0]);
        }
    }

    private Context getContext() {
        if (null != this.getRoomContext()) {
            return this.getRoomContext().getContext();
        }
        return null;
    }

    private IChannelPageContext getRoomContext() {
        if (null != this.getHandler() && null != this.getHandler().getKTVManager() && null != this.getHandler().getKTVManager().getContext() && null != this.getHandler().getKTVManager().getContext().getRoomContext()) {
            return this.getHandler().getKTVManager().getContext().getRoomContext();
        }
        return null;
    }

    private void sendPublicScreenMsg(BasePostInfo data) {
        if (data instanceof CommonPostItemInfo) {
            CommonPostItemInfo postInfo = (CommonPostItemInfo)data;
            IKTVHandler ktvHandler = this.getHandler();
            if (ktvHandler == null) {
                return;
            }
            IKTVManager ktvManager = ktvHandler.getKTVManager();
            if (ktvManager == null) {
                return;
            }
            KTVBaseContext ktvBaseContext = ktvManager.getContext();
            if (ktvBaseContext == null) {
                return;
            }
            IChannelPageContext<AbsPage> roomPageContext = ktvBaseContext.getRoomContext();
            if (roomPageContext == null) {
                return;
            }
            IPublicScreenPresenter publicScreenPresenter = ((IPublicScreenModulePresenter)roomPageContext.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter();
            IPublicScreenService service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
            if (publicScreenPresenter == null || service == null) {
                return;
            }
            IEnteredChannel channel = roomPageContext.getChannel();
            if (channel == null) {
                return;
            }
            IRoleService roleService = channel.getRoleService();
            if (roleService == null) {
                return;
            }
            if (postInfo.getKtvSection() == null) {
                return;
            }
            if (postInfo.getPostId() == null) {
                return;
            }
            String postId = postInfo.getPostId() == null ? "" : postInfo.getPostId();
            BaseImMsg ktvBbsMsg = service.getMsgItemFactory().generateKtvBbsMsg(channel.getChannelId(), roleService.getMyRoleCache(), postInfo.getKtvSection().getMSongName(), postId);
            publicScreenPresenter.appendLocalMsgAndSendToServer(ktvBbsMsg);
        }
    }

    private void sendPublicScreenByVideoMsg(BasePostInfo data, KTVMusicInfo musicInfo) {
        if (musicInfo == null || data == null) {
            return;
        }
        if (data instanceof IVideoSectionPost) {
            VideoSectionInfo videoSectionInfo = ((IVideoSectionPost)data).getVideoSectionInfo();
            if (videoSectionInfo == null) {
                return;
            }
            IKTVHandler ktvHandler = this.getHandler();
            if (ktvHandler == null) {
                return;
            }
            IKTVManager ktvManager = ktvHandler.getKTVManager();
            if (ktvManager == null) {
                return;
            }
            KTVBaseContext ktvBaseContext = ktvManager.getContext();
            if (ktvBaseContext == null) {
                return;
            }
            IChannelPageContext<AbsPage> roomPageContext = ktvBaseContext.getRoomContext();
            if (roomPageContext == null) {
                return;
            }
            IPublicScreenPresenter publicScreenPresenter = ((IPublicScreenModulePresenter)roomPageContext.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter();
            IPublicScreenService service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
            if (publicScreenPresenter == null) {
                return;
            }
            IEnteredChannel channel = roomPageContext.getChannel();
            if (channel == null || service == null) {
                return;
            }
            IRoleService roleService = channel.getRoleService();
            if (roleService == null) {
                return;
            }
            if (data.getPostId() == null) {
                return;
            }
            String postId = data.getPostId() == null ? "" : data.getPostId();
            BaseImMsg ktvBbsMsg = service.getMsgItemFactory().generateKtvBbsMsg(channel.getChannelId(), roleService.getMyRoleCache(), this.mKtvMusicInfo.getSongName(), postId);
            publicScreenPresenter.appendLocalMsgAndSendToServer(ktvBbsMsg);
        }
    }

    void headsetChanged(boolean hasHeadset) {
        if (this.mKtvSettingPanelView != null) {
            this.mKtvSettingPanelView.headsetChanged(hasHeadset, this.isSinging());
        }
    }

    @Override
    @Nullable
    public View getSongLibView() {
        if (this.mView == null) {
            return null;
        }
        if (this.mView.getSongLibView().getVisibility() == 0) {
            return this.mView.getSongLibView();
        }
        return null;
    }

    @Override
    public void checkShowGuideWindow() {
        if (this.getRoomContext() == null || this.getRoomContext().isDestroy()) {
            return;
        }
        ((KTVSeatPresenter)this.getRoomContext().getPresenter(KTVSeatPresenter.class)).checkShowGuideWindow(this.getRoomContext().getChannel().getSeatService().getSeatList());
    }

    private void registerSeatIntercepter() {
        if (this.getRoomContext() != null) {
            this.getRoomContext().getChannel().getMediaService().setSeatIntercepter((ISeatIntercepter)new MediaSeatIntercepter(this.getRoomContext().getChannel().getChannelId()));
        }
    }

    @Override
    public void onEndPanelShow() {
        if (this.mVirtualSeatHelper != null) {
            this.mVirtualSeatHelper.removeVirtualSeatRunnable();
        }
    }

    @Override
    public void onEndPanelHide(@Nullable KTVRoomSongInfo nextSongInfo) {
        if (this.mVirtualSeatHelper != null) {
            if (nextSongInfo != null && !StringUtils.isEmpty((String)nextSongInfo.getSongId())) {
                this.mVirtualSeatHelper.checkOpenVirtualSeat(nextSongInfo);
            } else {
                this.mVirtualSeatHelper.checkCloseVirtualSeat();
            }
        }
    }

    @Override
    public void updateSingerPoint(@Nullable Point point) {
        if (this.mVirtualSeatHelper != null) {
            this.mVirtualSeatHelper.updateSingerPoint(point);
        }
    }

    private class MediaSeatIntercepter
    implements ISeatIntercepter {
        private String channelId;

        MediaSeatIntercepter(String cid) {
            this.channelId = cid;
        }

        public boolean isSkipCheckMic(@NotNull String cid) {
            KTVRoomSongInfo songInfo = KTVPanelPresenter.this.getCurrentSongInfo();
            if (StringUtils.equal((String)this.channelId, (String)cid) && KTVPanelPresenter.this.getHandler().getKTVManager().getKTVRoomServices().hasWhiteRoomConfig() && songInfo != null && songInfo.isSinger() && KTVPanelPresenter.this.mVirtualSeatHelper != null) {
                KTVPanelPresenter.this.mVirtualSeatHelper.checkOpenVirtualSeat(songInfo);
                return true;
            }
            return false;
        }
    }

    public class KTVPanelOperater
    implements IKTVPanelOperater {
        @Override
        public void registerKTVPanelListener(IKTVPanelListener ktvPanelListener) {
            if (ktvPanelListener != null) {
                KTVPanelPresenter.this.iktvPanelListener = ktvPanelListener;
            }
        }

        @Override
        public void unRegisterKTVPanelListener(IKTVPanelListener ktvPanelListener) {
            if (ktvPanelListener == KTVPanelPresenter.this.iktvPanelListener) {
                KTVPanelPresenter.this.iktvPanelListener = null;
            }
        }

        @Override
        public void closePanel() {
            KTVPanelPresenter.this.closePanelInner();
        }
    }
}

